/*
 * adc.h
 *
 *  Created on: Mar 3, 2012
 *      Author: qwer1
 */

#ifndef ADC_H_
#define ADC_H_

#include "pt.h"
#include "ul_ptx.h"

//check in temperature is ok
#define t_is_ok(t) (!((t >= -32768)&&(t <= -32766)))

//number of thermocouple channels
#define T_TC_NUM 4
//thermocouple temperatures
extern  S16 t_tc[T_TC_NUM];

//number of ADC channels
#define ADC_CHANNELS (T_TC_NUM + 2)
//ADC data
extern  U16 adc_data[ADC_CHANNELS];
//cold junction temperature
extern  S16 t_cold;
//internal sensor temperature
extern  S16 t_int;

//setup ADC and ports
void setup_adc(void);
//ADC processing thread
PT_THREAD( pt_adc( struct pt *pt, struct ptx *ptx ) );

#endif /* ADC_H_ */
