/*
 * modbus.h
 *
 *  Created on: Mar 30, 2012
 *      Author: qwer1
 */

#ifndef MODBUS_H_
#define MODBUS_H_

//size of RX/TX buffer
#define MODBUS_BUF_SIZE 128

//delay before response
#define MODBUS_TX_DELAY 5

//min/max coil address
#define MODBUS_COILS_ADDR 0
#define MODBUS_COILS_NUM  0

//min/max holding address
#define MODBUS_REGS_ADDR  0
#define MODBUS_REGS_NUM   13

#include "ul_modbus.h"
extern struct modbus_struct modbus;

void setup_modbus(void);

#include "pt.h"
#include "ul_ptx.h"
PT_THREAD( pt_modbus( struct pt *pt, struct ptx *ptx ) );

//get contents of holding register
U16 modbus_reg_get(U16 reg_num);

//set value of holding register
void modbus_reg_set(U16 reg_num, S16 reg_val);

#endif /* MODBUS_H_ */
