/*
 * ul_config.h
 *
 *  Created on: May 15, 2012
 *      Author: qwer1
 */

#ifndef UL_CONFIG_H_
#define UL_CONFIG_H_

#ifdef __AVR
	#include <avr/eeprom.h>
	#define CONFIG_WORD_SIZE       1UL
	#define CONFIG_ERASED_STATE    0xFF
	#define CONFIG_START_ADDR      0UL
	#define CONFIG_PAGE_SIZE       (E2END + 1)
	#define CONFIG_ADDR_TYPE       U16
#endif

#ifdef __STM32
	#include "stm32f10x_flash.h"
	#define CONFIG_WORD_SIZE       4UL
	#define CONFIG_ERASED_STATE    0xFFFFFFFFUL
	#define CONFIG_ADDR_TYPE       U32
#endif

#define CONFIG_SIZE            (sizeof(config))
#define CONFIG_CRC_SIZE        (sizeof(config.crc))
#define CONFIG_WORDS           (CONFIG_RECORD_SIZE / CONFIG_WORD_SIZE)
#define CONFIG_RECORD_SIZE     ((CONFIG_SIZE + CONFIG_WORD_SIZE - 1) & (~(CONFIG_WORD_SIZE - 1)))
#define CONFIG_RECORDS         (CONFIG_PAGE_SIZE / CONFIG_RECORD_SIZE)
#define CONFIG_RECORD_ADDR(N)  ((CONFIG_ADDR_TYPE)(CONFIG_START_ADDR + ((N) * CONFIG_RECORD_SIZE)))
#define CONFIG_RECORD(N)       ((struct config_struct *)CONFIG_RECORD_ADDR(N))
#define CONFIG_END_ADDR        (CONFIG_PAGE_SIZE - 1)

//number of current configuration record
extern  U16 config_record;

//configuration update delay, ms
#ifndef CONFIG_UPDATE_DELAY
	#define CONFIG_UPDATE_DELAY 5000
#endif
//config update delay counter
extern  U8 config_update_cnt;
#define config_update_wait() config_update_cnt = (CONFIG_UPDATE_DELAY / 100)
#define config_update() config_update_cnt = 1
#define config_updates() (config_update_cnt != 0)

//configuration in RAM
extern struct config_struct config;

//setup config (find/check/read/init)
void setup_config(void);

//config update thread
#include "ul_ptx.h"
PT_THREAD( pt_config( struct pt *pt, struct ptx *ptx ) );

#endif /* UL_CONFIG_H_ */
