/*
 * ul_lcda.h
 *
 *  Created on: Oct 4, 2011
 *      Author: qwer1
 */

#ifndef UL_LCDA_H_
#define UL_LCDA_H_

#include "ul_other.h"
#include "pt.h"
#include "ul_ptx.h"

#define LCD_DELAY_STARTUP 17  //startup delay, ms
#define LCD_DELAY_SETUP   6   //setup delay, ms
#define LCD_DELAY_CMD     40  //cmd delay, us
#define LCD_DELAY_CLR     7   //display clear delay, ms

#define LCD_CMD_CLR        0x01 //clear display
#define LCD_CMD_HOME       0x02 //return home
#define LCD_CMD_ENTRY      0x04 //entry mode set, address decrement
#define LCD_CMD_ENTRY_INC  0x06 //entry mode set, address increment
#define LCD_CMD_DISPLAY    0x08 //display setup
#define LCD_CMD_DISPLAY_ON 0x04 //display on
#define LCD_CMD_CURSOR_ON  0x02 //cursor on
#define LCD_CMD_BLINK_ON   0x01 //cursor blink on
#define LCD_CMD_FUNC       0x20 //function set
#define LCD_CMD_FUNC4      LCD_CMD_FUNC //function set, 4-bit mode
#define LCD_CMD_FUNC8      (LCD_CMD_FUNC | 0x10) //function set, 8-bit mode
#define LCD_CMD_CGRAM      0x40 //CGRAM address set
#define LCD_CMD_DDRAM      0x80 //DDRAM address set

#define LCD_BUF_SIZE (LCD_ROWS * LCD_COLS)
extern  U8  lcd_buf[LCD_BUF_SIZE]; //LCD buffer
extern  U16 lcd_update_period;     //LCD update period, ms
extern  U8  lcd_led_state;         //LCD LED switch flag
extern  U8  lcd_2col_shift;        //LCD column shift for 2nd lines

#define LCD_VO_MAX 16                    //maximum LCD contrast voltage PWM level
extern  U8 lcd_vo;                       //LCD contrast voltage PWM level (0..LCD_VO_MAX-1)

/** setup LCD. led - LED light control, vo - VO line control */
void setup_lcd( U8 led, U8 vo );

/** write 8 bits to LCD, rs - RS line state */
void lcd_wr_U8( U8 data, U8 rs );

//extern struct pt _pt_lcd;
PT_THREAD( pt_lcd( struct pt *pt, struct ptx *ptx ) );

#endif /* UL_LCDA3W_H_ */
