/*
 * ul_snd.h
 *
 *  Created on: May 16, 2012
 *      Author: qwer1
 */

#ifndef UL_SND_H_
#define UL_SND_H_

#include "ul_rbuf.h"
RBUF_DECL(snd_buf, U16, SND_BUF_SIZE);

void setup_snd(void);

#include "pt.h"
#include "ul_ptx.h"
extern struct ptx *_pt_snd;
PT_THREAD(pt_snd( struct pt *pt, struct ptx *ptx ));

//add single sample to sound buffer
void snd_buf_add(U16 note);

//add zero-terminated buffer to sound buffer
void snd_buf_addz(U16 *note);

//add n zero-terminated buffers to sound buffer
void snd_buf_addzn(U16 *note, U8 n);

//reset sound buffer
#define snd_buf_reset() RBUF_RESET(&snd_buf)

#define SND_FREQ(freq1)      (freq1 >> 3)
#define SND_1MS(freq, len)   ( 0x0000 | ((len & 0xF) << 10) | SND_FREQ(freq) )
#define SND_10MS(freq, len)  ( 0x4000 | ((len & 0xF) << 10) | SND_FREQ(freq) )
#define SND_100MS(freq, len) ( 0x8000 | ((len & 0xF) << 10) | SND_FREQ(freq) )
#define SND_1S(freq, len)    ( 0xC000 | ((len & 0xF) << 10) | SND_FREQ(freq) )

//notes frequencies
#define SC4  262
#define SD4  294
#define SE4  330
#define SF4  349
#define SG4  392
#define SA4  440
#define SB4  494
#define SC4D 277
#define SD4D 311
#define SF4D 370
#define SG4D 415
#define SA4D 466

#define SC5  523
#define SD5  587
#define SE5  659
#define SF5  699
#define SG5  784
#define SA5  880
#define SB5  988
#define SC5D 554
#define SD5D 622
#define SF5D 740
#define SG5D 831
#define SA5D 932

#define SC6  1047
#define SD6  1175
#define SE6  1319
#define SF6  1397
#define SG6  1568
#define SA6  1760
#define SB6  1976
#define SC6D 1109
#define SD6D 1245
#define SF6D 1480
#define SG6D 1661
#define SA6D 1865

#define SC7  2093
#define SD7  2349
#define SE7  2637
#define SF7  2794
#define SG7  3136
#define SA7  3520
#define SB7  3951
#define SC7D 2217
#define SD7D 2489
#define SF7D 2960
#define SG7D 3322
#define SA7D 3729

#define SL1(freq)  SND_1S(freq, 2)
#define SL2(freq)  SND_1S(freq, 1)
#define SL4(freq)  SND_100MS(freq, 5)
#define SL8(freq)  SND_100MS(freq, 3)
#define SL16(freq) SND_10MS(freq, 12)

#endif /* UL_SND_H_ */
