/*
 * main.h
 *
 *  Created on: Feb 17, 2012
 *      Author: qwer1
 */

#ifndef MAIN_H_
#define MAIN_H_

//#define assert_param(param)

#define __STM32

// HSE frequency
#define HSE_VALUE 12000000UL
#define HSE_DIV 1
#define PLL_MUL 2

#include <stddef.h>
#include <stdint.h>
#include <stm32f10x.h>

#include "ul_other.h"

#define project_ver  "0.5"
#define project_date "05.07.12"

extern U16 project_signature;
extern U16 project_version;

#define __STM32

// main clock frequency
#define F_CPU (HSE_VALUE / HSE_DIV * PLL_MUL)

//use non-optimized BIN2BCD conversion
#define bin2bcd_U32 bin2bcd_U32_soft

//maximum number of protothreads
#define PTX_MAX 12

#define log_U8(data) RBUF_WR(&usart_tx_buf, (data))
#define log_buf(buf, size) RBUF_WR_BUF8(&usart_tx_buf, buf, size);
#define log_led1_flip() *BITP(&GPIOB->ODR, 6) ^= 1

#define debug_led1 *BITP(&GPIOB->ODR, 6)
#define debug_led2 *BITP(&GPIOB->ODR, 7)

//#include "ul_timing.h"
#include "ind.h"
#include "usart.h"
#include "pid.h"
#include "modbus.h"
#include "config.h"
#include "sound.h"

#endif /* MAIN_H_ */

