; User interface functions for the lanc programs

crlf_msg                byte 0Dh, 0Ah, 0

STDIN_HANDLE		EQU 0
STDOUT_HANDLE		EQU 1
STDERR_HANDLE		EQU 2

assume ds:PRG_DATA_SEGM

display_crlf proc far uses si

  mov   si, offset crlf_msg
  call  write_string_tty

  ret

display_crlf endp

display_word_dez proc far uses ax bx cx dx
local lz:byte
  
  mov   bx, ax

  mov   al, '<'
  call  write_char_tty

  mov   lz, 1
  
  mov   dx, 0
  mov   cx, 10000
  mov   ax, bx
  div   cx
  .if (ax != 0)
    add   ax, '0'
    call  write_char_tty
    sub   ax, '0'
    imul  cx
    sub   bx, ax
    mov   lz, 0
  .endif

  mov   dx, 0
  mov   cx, 1000
  mov   ax, bx
  div   cx
  .if !lz || (ax != 0)
    add   ax, '0'
    call  write_char_tty
    sub   ax, '0'
    imul  cx
    sub   bx, ax
    mov   lz, 0
  .endif

  mov   dx, 0
  mov   cx, 100
  mov   ax, bx
  div   cx
  .if !lz || (ax != 0)
    add   ax, '0'
    call  write_char_tty
    sub   ax, '0'
    imul  cx
    sub   bx, ax
    mov   lz, 0
  .endif

  mov   dx, 0
  mov   cx, 10
  mov   ax, bx
  div   cx
  .if !lz || (ax != 0)
    add   ax, '0'
    call  write_char_tty
    sub   ax, '0'
    imul  cx
    sub   bx, ax
    mov   lz, 0
  .endif

  mov   ax, bx
  add   ax, '0'
  call  write_char_tty
  
  mov   al, '>'
  call  write_char_tty

  ret

display_word_dez endp

display_byte_bin_verdreht proc far uses ax cx

  mov   ah, al
  mov   al, '<'
  call  write_char_tty

  mov   cx, 8
  .repeat
    .if (ah & 1)
      mov   al, '1'
    .else
      mov   al, '0'
    .endif
    call  write_char_tty
    shr   ah, 1
  .untilcxz

  mov   al, '>'
  call  write_char_tty

  ret

display_byte_bin_verdreht endp

display_dword_hex proc far

  rol   eax, 16
  call  display_word_hex
  
  rol   eax, 16
  call  display_word_hex

  ret

display_dword_hex endp

display_word_hex proc far uses ax

  xchg  al, ah
  call  display_byte_hex
  
  mov   al, ah
  call  display_byte_hex

  ret

display_word_hex endp

display_byte_hex proc far uses ax

  mov   ah, al
  shr   al, 4
  call  display_nibble_hex

  mov   al, ah
  and   al, 0Fh
  call  display_nibble_hex

  ret

display_byte_hex endp

display_nibble_hex proc far uses ax

  .if (al >= 10)
    sub   al, 10
    add   al, 'A'
    call  write_char_tty
  .else
    add   al, '0'
    call  write_char_tty
  .endif

  ret

display_nibble_hex endp

;=============================================================================
;FUNC:  WRITE_STRING_TTY
;
;DESC:  Write a string to TTY.
;
;IN:    CS:SI   Point to string to be displayed
;OUT:   None
;=============================================================================
xwrite_string_tty proc far uses ax bx si di ds es

  push  cs
  pop   ds
  
  mov  ah,0eh                       ; write char to tty function
  mov  bx,3                         ; page 0, attr in case of graph mode
  lodsb
  .repeat
    int  10h                        ; video interrupt
    lodsb
  .until al == 0

  ret

xwrite_string_tty endp

;=============================================================================
;FUNC:  WRITE_CHAR_TTY
;
;DESC:  Write a character to TTY.
;
;IN:    AL   Character to be displayed
;OUT:   None
;=============================================================================
xwrite_char_tty proc far uses ax bx si di es

  mov  ah,0eh                       ; write char to tty function
  mov  bx,3                         ; page 0, attr in case of graph mode
  int  10h                          ; video interrupt

  ret

xwrite_char_tty endp

;IN:    CS:SI   Point to string to be displayed
;OUT:   None
write_string_tty proc far uses ax bx cx dx ds
local pchar:byte

  .if (stdout_redir)
    call xwrite_string_tty
  .endif

 ; first get string length (string ends with 0)
  mov   al, cs:[si]
  .if (al == 0)
    jmp   done
  .endif

  push  si
  xor   cx, cx
  .repeat
    inc   si
    mov   al, cs:[si]
    inc   cx
  .until (al == 0)
  pop   si
  
  mov   ah, 40h
  mov   bx, STDOUT_HANDLE
  mov   dx, cs
  mov   ds, dx
  mov   dx, si
  int   21h

done:

  ret

write_string_tty endp

;IN:    AL   Character to be displayed
;OUT:   None
write_char_tty proc far uses ax bx cx dx ds

  .if (stdout_redir)
    call xwrite_char_tty
  .endif
  mov   pchar, al
  mov   ah, 40h
  mov   bx, STDOUT_HANDLE
  mov   cx, 1
  mov   dx, cs
  mov   ds, dx
  mov   dx, offset pchar
  int   21h

  ret
pchar byte ?
write_char_tty endp

;in:    al=row (x value, 0-based)
;       ah=col (y value, 0-based)
set_cursor proc far uses ax bx cx dx ds

  mov   dl, al
  mov   dh, ah
  mov   ah, 2
  mov   bh, 0
  int   10h

  ret

set_cursor endp

clear_screen proc far uses ax bx cx dx ds

  mov   ah, 0Fh
  int   10h
  mov   ah, 0
  int   10h

  ret

clear_screen endp

check_key proc far uses ax

  mov   ah, 1
  int   16h

  ret

check_key endp

check_break proc far
local get_break:byte
local last_key:byte

  push  ax
  mov   get_break, 0
  mov   last_key, 0
  call  check_key
  .if (zero?)
    jmp   done
  .endif
  
  .repeat
    mov   ah, 0
    int   16h
    mov   last_key, al
    .if (al == 01Bh)                ; ESC Key
      mov   get_break, 1
    .endif
    call  check_key
  .until (zero?)

done:
  pop   ax
  mov   al, last_key
  .if (get_break)
    stc
  .else
    clc
  .endif

  ret

check_break endp

get_key proc far
local last_key:byte

  push  ax
  mov   ah, 0
  int   16h
  mov   last_key, al
  pop   ax
  mov   al, last_key
  .if (al == 01Bh)                ; ESC Key
    stc
  .else
    clc
  .endif

  ret

get_key endp
