#=============================================================================
# (C) 1999 by Helge Wagner
#
# FILE: LANC.MAK
#
# DESC: Makefile for the Sony LANC Protocol reader/writer
#
# BY:   H.Wagner, mailto:<H.Wagner@sbs-or.de>
# DATE: 08.09.1999
#=============================================================================
# Rev  Date       Author   Description
#-----------------------------------------------------------------------------
#=============================================================================

MASM=ML                                 # use MASM 6.1 or higher
LINK=link                               # i used Microsoft linker V5.60.339

AFLAGS = /nologo /Fl /Sg /Sn /c
LFLAGS = /nologo /Map /OnError:NOEXE

all:            rm95emul.exe rm95dump.exe lowtest.exe

.asm.obj:
  $(MASM) $(AFLAGS) $*.asm >> proto

rm95emul.exe:   rm95emul.obj lanc_if.obj
  $(LINK) $(LFLAGS) rm95emul.obj+lanc_if.obj, rm95emul.exe, rm95emul.map; >> proto

rm95dump.exe:   rm95dump.obj lanc_if.obj
  $(LINK) $(LFLAGS) rm95dump.obj+lanc_if.obj, rm95dump.exe, rm95dump.map; >> proto

lowtest.exe:   lowtest.obj lanc_if.obj
  $(LINK) $(LFLAGS) lowtest.obj+lanc_if.obj, lowtest.exe, lowtest.map; >> proto

rm95emul.obj:   rm95emul.asm lanc_ui.asm lanc_if.inc

rm95dump.obj:   rm95dump.asm lanc_ui.asm lanc_if.inc

lowtest.obj:    lowtest.asm lanc_ui.asm lanc_if.inc

lanc_if.obj:    lanc_if.asm lanc_if.inc lanc_if.inp
