;=============================================================================
; (C) 1999 by Helge Wagner
;
; FILE: RM95DUMP.ASM
;
; DESC: Sony LANC service mode memory dumper
;
; BY:   H.Wagner, mailto:<H.Wagner@sbs-or.de>
; DATE: 04.03.1999
;
; NOTE: Tab width=4
;=============================================================================
; Rev  Date       Author   Description
;-----------------------------------------------------------------------------
;=============================================================================

.MODEL  SMALL,SYSCALL
 PAGE   60,132
 TITLE  RM95DUMP.ASM
 OPTION PROC:private

.nolist
  include lanc_if.inc
.list

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%                MAIN MODULE
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

PRG_DATA_SEGM SEGMENT PARA PUBLIC 'DATA' USE16

stdout_redir        byte 0          ; 0: stdout is not redirected

user_break          byte 0

current_page        byte ?
page_locked         byte ?          ; 1=address can't be incremented on current page
org 100h
eeprom_page_data    byte 256 dup (?)

PRG_DATA_SEGM ENDS

CODE SEGMENT PARA PUBLIC 'CODE' USE16
.586p

jmp   start

include lanc_ui.asm

start:
  mov   ax, seg PRG_DATA_SEGM
  mov   ds, ax
assume ds:PRG_DATA_SEGM
  mov   al, byte ptr es:[18h+1]
  .if (al != 1)
    mov   stdout_redir, 1
  .endif
  
  call  do_the_job                  ; this could set error code in al
  mov   ah, 4Ch
  int   21h


page_msg    byte "      Dump of Page ",0
page1_msg   byte " (=",0
page2_msg   byte "h)",13,10,0
page_locked_msg   byte "Page is locked (can't increment address)",13,10,0

print_page proc uses ax bx cx si

  mov   si, offset page_msg
  call  write_string_tty
  movzx ax, current_page
  call  display_word_dez
  mov   si, offset page1_msg
  call  write_string_tty
  call  display_byte_hex
  mov   si, offset page2_msg
  call  write_string_tty

  mov   al, page_locked
  .if (al)
    mov   si, offset page_locked_msg
    call  write_string_tty
    ret
  .endif

  mov   bx, offset eeprom_page_data
  mov   cx, 0
  .repeat
    .if !(cx & 0Fh)
      mov   ax, cx
      call  display_word_hex
      mov   al, ':'
      call  write_char_tty
      mov   al, ' '
      call  write_char_tty
    .endif
    mov   al, byte ptr [bx]
    inc   bx
    call  display_byte_hex
    inc   cx
    mov   al, cl
    and   al, 0Fh
    .if (al == 0)
      call  display_crlf
    .else
      .if (al == 8)
        mov   al, ' '
        call  write_char_tty
        mov   al, ' '
        call  write_char_tty
      .else
        mov   al, ' '
        call  write_char_tty
      .endif
    .endif
  .until (cx == 256)

  ret

print_page endp

;in:    al      command, where
;               0   = NOP (used for reading the eeprom)
;               67h = page+
;               65h = page-
;               38h = addr+
;               36h = addr-
;               34h = data+
;               30h = data-
;               32h = store data
;out:   carry set       error
;       carry clear     ok, then
;           es:bx   pointer to last received lanc telegram
rm95_command proc uses ax cx
local send_b1:byte, send_b2:byte

  .if (al == 0) || (al == 67h) || (al == 65h) || (al == 38h) || (al == 36h) || (al == 34h) || (al == 30h) || (al == 32h)
    jmp   ok
  .else
    stc
    ret
  .endif

ok:
  mov   send_b1, 0FFh
  mov   send_b2, al

  .if (send_b2 == 0)
    jmp   read_command
  .endif
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, send_b2
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
    inc   cx
  .until (al == 0F1h) || (cx > 6)

read_command:
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, 0
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
    inc   cx
  .until (al == 0F0h) || (cx > 100)

  .if (cx > 100)
    stc
    ret
  .endif

  clc

  ret

rm95_command endp

;in:    ah      page (0-15)
;out:   carry set       error
;       carry clear     ok, then
;           es:bx   pointer to last received lanc telegram
rm95_setpage proc uses ax cx
; new page (np), old page (op)
; pd=np-op
; wenn pd > 0 und pd <= 8 inc page
; wenn pd < 0 oder pd > 8 dec page

local pg:byte, curr_pg:byte
local command:byte

  .if (ah > 15)
    stc
    ret
  .endif

  mov   pg, ah

  mov   al, 0                       ; 0=read eeprom data
  call  rm95_command
  .if carry?
    ret
  .endif

  mov   ah, es:byte ptr [bx+4]
  shr   ah, 4
  mov   curr_pg, ah
  mov   al, pg
  .if (al < ah)
    add   al, 16
  .endif
  sub   al, ah
  .if (al == 0)
    jmp   pg_ok
  .elseif (al <= 8)        ; inc page
    mov   command, 67h
  .else
    mov   ah, al
    mov   al, 16
    sub   al, ah
    mov   command, 65h
  .endif
  movzx cx, al
  .repeat
    mov   al, command
    call  rm95_command
    .if carry?
      ret
    .endif
  .untilcxz

pg_ok:

  ret

rm95_setpage endp

;in:    ah      page (0-15)
;out:   carry set       error
;       carry clear     ok, then
dump_page proc uses ax bx cx es

  .if (ah > 15)
    stc
    ret
  .endif

  mov   current_page, ah
  xor   al, al
  mov   page_locked, al

  call  rm95_setpage
  .if (carry?)
    ret
  .endif
  mov   al, es:byte ptr [bx+4]
  shr   al, 4
  .if (al != ah)
    stc
    ret
  .endif

  mov   cx, 256
  .repeat

   ; store the data
    mov   al, es:byte ptr [bx+7]
    mov   ah, es:byte ptr [bx+6]
    movzx bx, ah
    add   bx, offset eeprom_page_data
    mov   byte ptr [bx], al

   ; switch to next address (if not the last address)
    .if (cx > 1)
      mov   al, 38h                  ; 38h=addr+
      call  rm95_command
      .if carry?
        ret
      .endif
      mov   al, es:byte ptr [bx+6]   ; get new address
     ; now AH holds the old address and AL the new one
      .if (ah != 255)
        inc   ah
        .if (al != ah)
          mov   al, 1               ; mark wrong address
        .else
          mov   al, 0
        .endif
      .elseif (al != 0)
        mov   al, 1                 ; mark wrong address
      .else
        mov   al, 0
      .endif
      .if (al == 1)
        mov   page_locked, al
        .break
      .endif
    .endif

  .untilcxz

  ret

dump_page endp

dump_all proc

  mov   ah, 0h
  .repeat
    cli
    call  lanc_if_telegram_syncronize
    .if (al != NOERROR)
      sti
      ret
    .endif
    call  dump_page
    sti
    .if (carry?)
      ret
    .endif
    call  print_page
    inc   ah
  .until (ah == 16)

  ret

dump_all endp

init_lanc_msg       byte "Initializing IRdeo, please wait...",0
calibrating_msg     byte "Now calibrating, please wait...",0
done_msg            byte 8,8," Done.", 13,10,0
press_anykey_msg    byte "press any key to continue...", 0
start_camcorder_msg byte "Please start your camcorder in Player mode now...", 13,10
                    byte "(press ESC to break)", 0
lanc_not_found_msg  byte 13,10,"Lanc device not found. Stopped.", 13,10,0
lanc_found_msg      byte 13,10,"OK. Lanc device found.", 13,10,0
break_accepted_msg  byte 13,10,"User break accepted.", 13,10,0
error1_msg          byte "Error1", 13,10,0
error2_msg          byte "Error2", 13,10,0
error3_msg          byte "Error3", 13,10,0
error4_msg          byte "Error4", 13,10,0
error5_msg          byte "Error5", 13,10,0
error6_msg          byte "Error6", 13,10,0

;=============================================================================
;FUNC:  DO_THE_JOB
;
;DESC:  Do whatever you want
;
;IN:    NONE
;OUT:   AL      error level
;NOTE:
;=============================================================================
do_the_job proc near

  mov   si, offset init_lanc_msg
  call  write_string_tty
  call  lanc_if_init
  mov   si, offset done_msg
  call  write_string_tty

  call  lanc_if_open
  mov   si, offset start_camcorder_msg
  call  write_string_tty
  .repeat
    call  check_break
    .break .if (carry?)
    call  lanc_if_check_active
  .until (bl == 0)
  .if (carry?)
    mov   si, offset break_accepted_msg
    call  write_string_tty
    ret
  .endif
  mov   si, offset crlf_msg
  call  write_string_tty

  mov   si, offset calibrating_msg
  call  write_string_tty
  call  lanc_if_calibrate
  .if (al != NOERROR)
    mov   si, offset error3_msg
    call  write_string_tty
    ret
  .endif
  mov   si, offset done_msg
  call  write_string_tty

  call dump_all

  ret

do_the_job endp

CODE ENDS

END start
