;=============================================================================
; (C) 1999 by Helge Wagner
;
; FILE: RM95EMUL.ASM
;
; DESC: Sony LANC service mode remote control RM95 emulation
;
; BY:   H.Wagner, mailto:<H.Wagner@sbs-or.de>
; DATE: 04.03.1999
;
; NOTE: Tab width=4
;=============================================================================
; Rev  Date       Author   Description
;-----------------------------------------------------------------------------
;=============================================================================

.MODEL  SMALL,SYSCALL
 PAGE   60,132
 TITLE  RM95EMUL.ASM
 OPTION PROC:private

.nolist
  include lanc_if.inc
.list

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%                MAIN MODULE
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

PRG_DATA_SEGM SEGMENT PARA PUBLIC 'DATA' USE16

stdout_redir        byte 0          ; 0: stdout is not redirected

user_break          byte 0

current_page        byte ?
page_locked         byte ?          ; 1=address can't be incremented on current page
org 100h
eeprom_page_data    byte 256 dup (?)

PRG_DATA_SEGM ENDS

CODE SEGMENT PARA PUBLIC 'CODE' USE16
.586p

jmp   start

include lanc_ui.asm

start:
  mov   ax, seg PRG_DATA_SEGM
  mov   ds, ax
assume ds:PRG_DATA_SEGM
  mov   al, byte ptr es:[18h+1]
  .if (al != 1)
    mov   stdout_redir, 1
  .endif
  
  call  do_the_job                  ; this could set error code in al
  mov   ah, 4Ch
  int   21h

;in:    al      command, where
;               0   = NOP (used for reading the eeprom)
;               67h = page+
;               65h = page-
;               38h = addr+
;               36h = addr-
;               34h = data+
;               30h = data-
;               32h = store data
;out:   carry set       error
;       carry clear     ok, then
;           es:bx   pointer to last received lanc telegram
rm95_command proc uses ax cx
local send_b1:byte, send_b2:byte

  .if (al == 0) || (al == 67h) || (al == 65h) || (al == 38h) || (al == 36h) || (al == 34h) || (al == 30h) || (al == 32h)
    jmp   ok
  .else
    stc
    ret
  .endif

ok:
  mov   send_b1, 0FFh
  mov   send_b2, al

  .if (send_b2 == 0)
    jmp   read_command
  .endif
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, send_b2
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
    inc   cx
  .until (al == 0F1h) || (cx > 6)

read_command:
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, 0
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
    inc   cx
  .until (al == 0F0h) || (cx > 100)

  .if (cx > 100)
    stc
    ret
  .endif

  clc

  ret

rm95_command endp

d1_msg byte "Page:",0
d2_msg byte " Addr:",0
d3_msg byte " Data:",0

display_rm95_data proc uses ax si

  mov   si, offset d1_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+4]
  shr   al, 4
  call  display_byte_hex

  mov   si, offset d2_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+6]
  call  display_byte_hex

  mov   si, offset d3_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+7]
  call  display_byte_hex

  ret

display_rm95_data endp

beschr1_msg byte "                <a>   page-",13,10
beschr2_msg byte "                <s>   page+",13,10
beschr3_msg byte "                <d>   address-",13,10
beschr4_msg byte "                <f>   address+",13,10
beschr5_msg byte "                <g>   data-",13,10
beschr6_msg byte "                <h>   data+",13,10
beschr7_msg byte "                <w>   write data",13,10
beschr8_msg byte "               <esc>  exit",13,10
beschr9_msg byte "      any other key   read data again",13,10,0

rm95_emul proc uses ax bx si
local rm95_cmd:byte

  mov   al, 0
  mov   ah, 4
  call  set_cursor
  mov   si, offset beschr1_msg
  call  write_string_tty

  mov   rm95_cmd, 0
  .repeat
    cli
    call  lanc_if_telegram_syncronize
    mov   al, rm95_cmd
    call  rm95_command
    sti
    .if carry?
      ret
    .endif
    mov   al, 10
    mov   ah, 2
    call  set_cursor

    call  display_rm95_data
    call  get_key
    .break .if (carry?)
    .if (al == 'a')
      mov   rm95_cmd, 65h
    .elseif (al == 's')
      mov   rm95_cmd, 67h
    .elseif (al == 'd')
      mov   rm95_cmd, 36h
    .elseif (al == 'f')
      mov   rm95_cmd, 38h
    .elseif (al == 'g')
      mov   rm95_cmd, 30h
    .elseif (al == 'h')
      mov   rm95_cmd, 34h
    .elseif (al == 'w')
      mov   rm95_cmd, 32h
    .else
      mov   rm95_cmd, 0
    .endif

  .until 0

  ret

rm95_emul endp

init_lanc_msg       byte "Initializing IRdeo, please wait...",0
calibrating_msg     byte "Now calibrating, please wait...",0
done_msg            byte 8,8," Done.", 13,10,0
press_anykey_msg    byte "press any key to continue...", 0
start_camcorder_msg byte "Please start your camcorder in Player mode now...", 13,10
                    byte "(press ESC to break)", 0
lanc_not_found_msg  byte 13,10,"Lanc device not found. Stopped.", 13,10,0
lanc_found_msg      byte 13,10,"OK. Lanc device found.", 13,10,0
break_accepted_msg  byte 13,10,"User break accepted.", 13,10,0
error1_msg          byte "Error1", 13,10,0
error2_msg          byte "Error2", 13,10,0
error3_msg          byte "Error3", 13,10,0
error4_msg          byte "Error4", 13,10,0
error5_msg          byte "Error5", 13,10,0
error6_msg          byte "Error6", 13,10,0

;=============================================================================
;FUNC:  DO_THE_JOB
;
;DESC:  Do whatever you want
;
;IN:    NONE
;OUT:   AL      error level
;NOTE:
;=============================================================================
do_the_job proc near

  mov   si, offset init_lanc_msg
  call  write_string_tty
  call  lanc_if_init
  mov   si, offset done_msg
  call  write_string_tty

  call  lanc_if_open
  mov   si, offset start_camcorder_msg
  call  write_string_tty
  .repeat
    call  check_break
    .break .if (carry?)
    call  lanc_if_check_active
  .until (bl == 0)
  .if (carry?)
    mov   si, offset break_accepted_msg
    call  write_string_tty
    ret
  .endif
  mov   si, offset crlf_msg
  call  write_string_tty

  mov   si, offset calibrating_msg
  call  write_string_tty
  call  lanc_if_calibrate
  .if (al != NOERROR)
    mov   si, offset error3_msg
    call  write_string_tty
    ret
  .endif
  mov   si, offset done_msg
  call  write_string_tty

  call clear_screen
  call rm95_emul

  ret

do_the_job endp

CODE ENDS

END start
