;=============================================================================
; (C) 1999 by Helge Wagner
;
; FILE: LANC_IF.INC
;
; DESC: Sony LANC Protocol low level interface include file
;
; BY:   H.Wagner, mailto:<H.Wagner@sbs-or.de>
; DATE: 31.10.1999
;
; NOTE: Tab width=4
;=============================================================================
; Rev  Date       Author   Description
;-----------------------------------------------------------------------------
;=============================================================================

LANC_ERRNO      EQU 99h
ifndef NOERROR
    NOERROR     EQU 0
endif

E__LANC_NOT_INITIALIZED  EQU LANC_ERRNO+0    ; call lanc_if_init first
E__LANC_NOT_OPENED       EQU LANC_ERRNO+1    ; call lanc_if_open first
E__LANC_NOT_CALIBRATED   EQU LANC_ERRNO+2    ; call lanc_if_calibrate first
E__LANC_TELEGRAMS        EQU LANC_ERRNO+3    ; luecke zw. 2 telegrammen nicht gefunden
E__LANC_WRONG_CHANNEL    EQU LANC_ERRNO+4
E__LANC_CALIBRATION_TG   EQU LANC_ERRNO+5    ; 
E__LANC_CALIBRATION_SEND EQU LANC_ERRNO+6
E__LANC_RECV             EQU LANC_ERRNO+7    ; 

; LANC Interface functions:
externdef syscall lanc_if_init                :far
externdef syscall lanc_if_deinit              :far
externdef syscall lanc_if_set_parameter       :far
externdef syscall lanc_if_open                :far
externdef syscall lanc_if_close               :far
externdef syscall lanc_if_set_channel         :far
externdef syscall lanc_if_check_active        :far
externdef syscall lanc_if_calibrate           :far
externdef syscall lanc_if_telegram_syncronize :far
externdef syscall lanc_if_receive_telegram    :far
externdef syscall lanc_if_send                :far

