;=============================================================================
;FILE: LANC.ASM
;
;DESC: Sony LANC Protocol reader (in the future: writer)
;NOTE: Tab width=4
;BY:   H.Wagner / or Industrial Computers GmbH
;DATE: 04.03.1999
;=============================================================================
;Rev  Date       Author   Description
;-----------------------------------------------------------------------------
;=============================================================================

.MODEL  SMALL,SYSCALL
 PAGE   60,132
 TITLE  LANC.ASM
 OPTION PROC:private

.nolist
;  include ???
  include lanc_if.inc
.list

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%                MAIN MODULE
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

PRG_DATA_SEGM SEGMENT PARA PUBLIC 'DATA' USE16

stdout_redir        byte 0          ; 0: stdout is not redirected

user_break          byte 0

current_page        byte ?
page_locked         byte ?          ; 1=address can't be incremented on current page
org 100h
eeprom_page_data    byte 256 dup (?)

PRG_DATA_SEGM ENDS

CODE SEGMENT PARA PUBLIC 'CODE' USE16
.586p

jmp   start

include lanc_ui.asm

start:
  mov   ax, seg PRG_DATA_SEGM
  mov   ds, ax
assume ds:PRG_DATA_SEGM
  mov   al, byte ptr es:[18h+1]
  .if (al != 1)
    mov   stdout_redir, 1
  .endif
  
  call  do_the_job                  ; this could set error code in al
  mov   ah, 4Ch
  int   21h


;in:    es:bx   pointer to start of telegram
;out:   nothing
display_telegram proc uses ax bx cx si

  mov   al, '<'
  call  write_char_tty

  mov   cx, 8
  .repeat
    mov   al, byte ptr es:[bx]
    call  display_byte_hex
    .if (cx > 1)
      mov   al, ' '
      call  write_char_tty
    .endif
    inc   bx
  .untilcxz

  mov   al, '>'
  call  write_char_tty

  mov   si, offset crlf_msg
  call  write_string_tty

  ret

display_telegram endp

fehler_msg byte "Telegram-Empfang-Fehler", 0
display_telegrams proc uses ax bx cx
;xxx
  mov   cx, 20
  .repeat
    call  lanc_if_receive_telegram
    .if carry?
mov si, offset fehler_msg
call write_string_tty
      ret
    .endif
    mov   ah, 0
    call  display_word_dez
    mov   al, ':'
    call  write_char_tty
;    movzx bx, al
;    sub   bx, 8
;    add   bx, offset recv_data
    call  display_telegram
  
  .untilcxz
ret
comment~  
  mov   bx, 5555h
  call  send_word

  mov   bx, 0AAAAh
  call  send_word
  mov   bx, 03333h
  call  send_word


  mov   bx, 08181h
  call  send_word
  mov   bx, 09999h
  call  send_word
  mov   bx, 01818h
  call  send_word
  
  mov   bx, 0101h
  call  send_word
  mov   bx, 0202h
  call  send_word
  mov   bx, 0404h
  call  send_word
  mov   bx, 0808h
  call  send_word
  
  call  lanc_if_receive_telegram
  call  display_telegram
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
  call  send_word
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
  call  send_word
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
  call  lanc_if_receive_telegram
  call  display_telegram
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
  call  send_word
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
  call  send_word
  mov   bx, 0000h
  call  send_word
  mov   bx, 0FFFFh
endcomment~  

  ret

display_telegrams endp

page_msg    byte "      Dump of Page ",0
page1_msg   byte " (=",0
page2_msg   byte "h)",13,10,0
page_locked_msg   byte "Page is locked (can't increment address)",13,10,0

print_page proc uses ax bx cx si

  mov   si, offset page_msg
  call  write_string_tty
  movzx ax, current_page
  call  display_word_dez
  mov   si, offset page1_msg
  call  write_string_tty
  call  display_byte_hex
  mov   si, offset page2_msg
  call  write_string_tty

  mov   al, page_locked
  .if (al)
    mov   si, offset page_locked_msg
    call  write_string_tty
    ret
  .endif

  mov   bx, offset eeprom_page_data
  mov   cx, 0
  .repeat
    .if !(cx & 0Fh)
      mov   ax, cx
      call  display_word_hex
      mov   al, ':'
      call  write_char_tty
      mov   al, ' '
      call  write_char_tty
    .endif
    mov   al, byte ptr [bx]
    inc   bx
    call  display_byte_hex
    inc   cx
    mov   al, cl
    and   al, 0Fh
    .if (al == 0)
      call  display_crlf
    .else
      .if (al == 8)
        mov   al, ' '
        call  write_char_tty
        mov   al, ' '
        call  write_char_tty
      .else
        mov   al, ' '
        call  write_char_tty
      .endif
    .endif
  .until (cx == 256)

  ret

print_page endp

;in:    al      command, where
;               0   = NOP (used for reading the eeprom)
;               67h = page+
;               65h = page-
;               38h = addr+
;               36h = addr-  (or 54h ???)
;               34h = data+
;               30h = data-
;               32h = store data
;out:   carry set       error
;       carry clear     ok, then
;           es:bx   pointer to last received lanc telegram
rm95_command proc uses ax cx
local send_b1:byte, send_b2:byte

  .if (al == 0) || (al == 67h) || (al == 65h) || (al == 38h) || (al == 36h) || (al == 34h) || (al == 30h) || (al == 32h)
    jmp   ok
  .else
    stc
    ret
  .endif

ok:
  mov   send_b1, 0FFh
  mov   send_b2, al

;  pushf
;  .if (ah == 1)
;    cli
;    call  lanc_if_telegram_syncronize
;  .endif
  .if (send_b2 == 0)
    jmp   read_command
  .endif
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, send_b2
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
;      popf
mov di, 1234h
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
    inc   cx
  .until (al == 0F1h) || (cx > 6)
COMMENT ~   ; page may be locked, so address or data commands did not work
  .if (cx > 6)
;    popf
mov di, 1235h
    stc
    ret
  .endif
ENDCOMMENT ~
read_command:
  xor   cx, cx
  .repeat
    mov   al, send_b1
    mov   ah, 0
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (al != NOERROR)
;      popf
mov di, 1236h
      stc
      ret
    .endif
    mov   al, byte ptr es:[bx+5]
xor   ah,ah
;call display_word_dez
    inc   cx
  .until (al == 0F0h) || (cx > 100)

  .if (cx > 100)
;    popf
mov di, 1237h
    stc
    ret
  .endif

;  popf
  clc

  ret

rm95_command endp

;in:    ah      page (0-15)
;out:   carry set       error
;       carry clear     ok, then
;           es:bx   pointer to last received lanc telegram
rm95_setpage proc uses ax cx
; new page (np), old page (op)
; pd=np-op
; wenn pd > 0 und pd <= 8 inc page
; wenn pd < 0 oder pd > 8 dec page

local pg:byte, curr_pg:byte
local command:byte

  .if (ah > 15)
    stc
    ret
  .endif

  mov   pg, ah

  mov   al, 0                       ; 0=read eeprom data
  call  rm95_command
  .if carry?
int 3
    ret
  .endif

  mov   ah, es:byte ptr [bx+4]
  shr   ah, 4
  mov   curr_pg, ah
  mov   al, pg
  .if (al < ah)
    add   al, 16
  .endif
  sub   al, ah
  .if (al == 0)
    jmp   pg_ok
  .elseif (al <= 8)        ; inc page
    mov   command, 67h
  .else
    mov   ah, al
    mov   al, 16
    sub   al, ah
    mov   command, 65h
  .endif
  movzx cx, al
  .repeat
    mov   al, command
    call  rm95_command
    .if carry?
int 3
      ret
    .endif
  .untilcxz

pg_ok:

  ret

rm95_setpage endp

;in:    ah      page (0-15)
;out:   carry set       error
;       carry clear     ok, then
rm95_read_page proc uses ax bx cx
local pg:byte, curr_pg:byte, adr:byte, curr_adr:byte, data:byte
local command:byte

  .if (ah > 15)
    stc
    ret
  .endif

  mov   pg, ah
  mov   adr, 0
;xxx
;;mov   ah, pg
  dec   ah
  .if (ah == -1)
    mov   ah, 15
  .endif
  call  rm95_setpage
  inc   ah
  .if (ah == 16)
    mov   ah, 0
  .endif
  call  rm95_setpage
 ; now by this two "rm95_setpage" the address is set to zero in all cases

  mov   cx, 100h
  .repeat
movzx ax, es:byte ptr [bx+4]
shr ax, 4
;call display_word_dez
movzx ax, byte ptr [bx+6]
;call display_word_dez

   ; check the page and address
    mov   al, es:byte ptr [bx+4]
    shr   al, 4
    .if (al != pg)
      stc
      ret
    .endif
    mov   al, es:byte ptr [bx+6]
    mov   ah, cl
    neg   ah
    .if (al != ah)
      stc
      ret
    .endif
   ; store the data
    mov   al, es:byte ptr [bx+7]
    movzx bx, ah
    add   bx, offset eeprom_page_data
    mov   byte ptr [bx], al

   ; switch to next address (if not the last address)
    .if (cx > 1)
      mov   al, 38h                  ; 38h=addr+
      call  rm95_command
      .if carry?
        ret
      .endif
    .endif

  .untilcxz

  mov   al, pg
  mov   current_page, al

  ret

rm95_read_page endp

;in:    ah      page (0-15)
;out:   carry set       error
;       carry clear     ok, then
dump_page proc uses ax bx cx es

  .if (ah > 15)
    stc
    ret
  .endif

  mov   current_page, ah
  xor   al, al
  mov   page_locked, al

  call  rm95_setpage
  .if (carry?)
    ret
  .endif
  mov   al, es:byte ptr [bx+4]
  shr   al, 4
  .if (al != ah)
    stc
    ret
  .endif

  mov   cx, 256
  .repeat

   ; store the data
    mov   al, es:byte ptr [bx+7]
    mov   ah, es:byte ptr [bx+6]
    movzx bx, ah
    add   bx, offset eeprom_page_data
    mov   byte ptr [bx], al

   ; switch to next address (if not the last address)
    .if (cx > 1)
      mov   al, 38h                  ; 38h=addr+
      call  rm95_command
      .if carry?
        ret
      .endif
      mov   al, es:byte ptr [bx+6]   ; get new address
     ; now AH holds the old address and AL the new one
      .if (ah != 255)
        inc   ah
        .if (al != ah)
          mov   al, 1               ; mark wrong address
        .else
          mov   al, 0
        .endif
      .elseif (al != 0)
        mov   al, 1                 ; mark wrong address
      .else
        mov   al, 0
      .endif
      .if (al == 1)
        mov   page_locked, al
        .break
      .endif
    .endif

  .untilcxz

  ret

dump_page endp

dump_all proc

  mov   ah, 0h
  .repeat
    cli
    call  lanc_if_telegram_syncronize
    .if (al != NOERROR)
      sti
      ret
    .endif
    call  dump_page
    sti
    .if (carry?)
      ret
    .endif
    call  print_page
    inc   ah
  .until (ah == 16)

  ret

dump_all endp

;in:    ah      page (0-15)
;       al      byte in page (0-255)
;out:   carry set       error
;       carry clear     ok, then
;           al = eeprom data
read_eeprom proc uses bx cx es
local pg:byte, curr_pg:byte, adr:byte, curr_adr:byte, data:byte
local command:byte

  .if (ah > 15)
    stc
    ret
  .endif

  mov   pg, ah
  mov   adr, al
  mov   al, 0                       ; 0=read eeprom data
  call  rm95_command
  .if carry?
    ret
  .endif
  mov   al, es:byte ptr [bx+4]
  shr   al, 4
  mov   curr_pg, al
  mov   al, es:byte ptr [bx+6]
  mov   curr_adr, al
movzx ax, curr_pg
;call display_word_dez
movzx ax, curr_adr
;call display_word_dez
movzx ax, byte ptr [bx+7]
;call display_word_dez
  mov   al, pg
  .if (curr_pg == al)
    jmp   pg_ok
  .endif
  mov   curr_adr, 0                ; pg changes will set adress to 0
;;mov   al, pg
  .if (curr_pg < al)
    mov   command, 67h
    mov   al, pg
    sub   al, curr_pg
  .else
    mov   command, 65h
    mov   al, curr_pg
    sub   al, pg
  .endif
  movzx cx, al
int 3
  .repeat
    mov   al, command
    call  rm95_command
    .if carry?
      ret
    .endif
  .untilcxz

pg_ok:

  mov   al, adr
  .if (curr_adr == al)
    jmp   adr_ok
  .endif
  .if (curr_adr < al)
    mov   command, 38h
    mov   al, adr
    sub   al, curr_adr
  .else
    mov   command, 36h
    mov   al, curr_adr
    sub   al, adr
  .endif
  movzx cx, al
  .repeat
    mov   al, command
    call  rm95_command
    .if carry?
      ret
    .endif
  .untilcxz

adr_ok:
  mov   al, es:byte ptr [bx+7]

  ret

read_eeprom endp

send_test proc uses ax bx cx dx

  call  lanc_if_telegram_syncronize
  xor   cx, cx
  .repeat
    call  check_break
    .break .if (carry?)
    mov   ax, cx
    call  read_eeprom
    .if carry?
      ret
    .endif
    push  ax
    .if !(cx & 0Fh)
      mov   ax, cx
      call  display_word_hex
      mov   al, ':'
      call  write_char_tty
    .endif
    pop   ax
    call  display_byte_hex
    mov   al, ' '
    call  write_char_tty
    mov   ax, cx
    and   ax, 0Fh
    .if (ax == 0Fh)
      call  display_crlf
    .endif
    inc   cx
  .until (cx == 1000h)

  ret

send_test endp

d1_msg byte "Page:",0
d2_msg byte " Addr:",0
d3_msg byte " Data:",0

display_rm95_data proc uses ax si

  mov   si, offset d1_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+4]
  shr   al, 4
  call  display_byte_hex

  mov   si, offset d2_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+6]
  call  display_byte_hex

  mov   si, offset d3_msg
  call  write_string_tty
  mov   al, byte ptr es:[bx+7]
  call  display_byte_hex

  ret

display_rm95_data endp

beschr1_msg byte "                <a>   page-",13,10
beschr2_msg byte "                <s>   page+",13,10
beschr3_msg byte "                <d>   address-",13,10
beschr4_msg byte "                <f>   address+",13,10
beschr5_msg byte "                <g>   data-",13,10
beschr6_msg byte "                <h>   data+",13,10
beschr7_msg byte "                <w>   write data",13,10
beschr8_msg byte "               <esc>  exit",13,10
beschr9_msg byte "      any other key   read data again",13,10,0
rm95_lowtest proc uses ax bx
local rm95_cmd:byte

  mov   al, 0
  mov   ah, 4
  call  set_cursor
  mov   si, offset beschr1_msg
  call  write_string_tty

  mov   rm95_cmd, 0
  .repeat
    cli
    call  lanc_if_telegram_syncronize
    mov   al, rm95_cmd
    call  rm95_command
    sti
    .if carry?
      ret
    .endif
    mov   al, 10
    mov   ah, 2
    call  set_cursor

    call  display_rm95_data
;    call  check_break
    call  get_key
    .break .if (carry?)
    .if (al == 'a')
      mov   rm95_cmd, 65h
    .elseif (al == 's')
      mov   rm95_cmd, 67h
    .elseif (al == 'd')
      mov   rm95_cmd, 36h
    .elseif (al == 'f')
      mov   rm95_cmd, 38h
    .elseif (al == 'g')
      mov   rm95_cmd, 30h
    .elseif (al == 'h')
      mov   rm95_cmd, 34h
    .elseif (al == 'w')
      mov   rm95_cmd, 32h
    .else
      mov   rm95_cmd, 0
    .endif

  .until 0

  ret
comment ~
  mov   all_errors, 0

  mov   send_b1, 0FFh
  mov   send_b2, 0
  .repeat
    mov   al, send_b1
    mov   ah, send_b2
    call  lanc_if_send
    call  lanc_if_receive_telegram
    .if (carry?)
      .break
    .endif
    mov   al, 10
    mov   ah, 2
    call  set_cursor
    call  display_telegram
    call  check_break
    .if (carry?)
      mov   user_break, 1
      .break
    .endif
    .if (al == 'a')
      mov   send_b2, 67h
    .elseif (al == 's')
      mov   send_b2, 65h
    .elseif (al == ' ')
      mov   send_b2, 0
    .endif
  .until 0

  ret
endcomment ~

rm95_lowtest endp

comment ~
string byte 128 dup (?)

commandline_auswerten proc

  mov   ax, psp_seg
  mov   ds, ax
  movzx ax, byte ptr ds:[80h]
  mov   si, 81
  mov   di, si
  add   di, ax
  .if (ax == 0)
    jmp   done
  .endif
  .repeat
   ; search for a non-space character
    mov   al, 20
    repne

  .until (si == di)
  
  ret

commandline_auswerten endp
endcomment ~

RECEIVE_AND_DISPLAY MACRO anzahl
  push  cx
  mov   cx, anzahl
  .repeat
;    cli
;    call  lanc_if_telegram_syncronize
    call  lanc_if_receive_telegram
    sti
    .if (al != NOERROR)
  call display_byte_hex
  mov   si, offset error1_msg
  call  write_string_tty
      pop   cx
      ret
    .endif
    call  display_telegram
  .untilcxz
  pop  cx
ENDM

SEND_AND_DISPLAY MACRO first, second

;  cli
  mov   al, first
  mov   ah, second
  call  lanc_if_send
  .if (al != NOERROR)
    sti
    call display_byte_hex
    mov   si, offset error2_msg
    call  write_string_tty
    ret
  .endif
  call  lanc_if_receive_telegram
  sti
  .if (al != NOERROR)
    ret
  .endif
  call  display_telegram
ENDM

inc_page_msg byte "new page:",0
RM95_INC_PAGE MACRO
  mov   si, offset inc_page_msg
  call  write_string_tty
  mov  al, 38h
  call rm95_command
  call display_telegram
ENDM

set_page_msg byte "set page:",0

test_loop proc uses ax bx es

  call  lanc_if_telegram_syncronize
  RECEIVE_AND_DISPLAY 20
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  RECEIVE_AND_DISPLAY 3
ret
cli
  call  lanc_if_telegram_syncronize
  mov ah, 0Ah
  call  rm95_setpage
sti
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  RECEIVE_AND_DISPLAY 4
ret
  RM95_INC_PAGE
  RECEIVE_AND_DISPLAY 4
  RM95_INC_PAGE
  RECEIVE_AND_DISPLAY 4
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  RECEIVE_AND_DISPLAY 3
ret
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 0
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  SEND_AND_DISPLAY 0FFh, 38h
  RECEIVE_AND_DISPLAY 3

  ret

test_loop endp

init_lanc_msg       byte "Initializing IRdeo, please wait...",0
calibrating_msg     byte "Now calibrating, please wait...",0
done_msg            byte 8,8," Done.", 13,10,0
press_anykey_msg    byte "press any key to continue...", 0
start_camcorder_msg byte "Please start your camcorder in Player mode now...", 13,10
                    byte "(press ESC to break)", 0
lanc_not_found_msg  byte 13,10,"Lanc device not found. Stopped.", 13,10,0
lanc_found_msg      byte 13,10,"OK. Lanc device found.", 13,10,0
break_accepted_msg  byte 13,10,"User break accepted.", 13,10,0
error1_msg          byte "Error1", 13,10,0
error2_msg          byte "Error2", 13,10,0
error3_msg          byte "Error3", 13,10,0
error4_msg          byte "Error4", 13,10,0
error5_msg          byte "Error5", 13,10,0
error6_msg          byte "Error6", 13,10,0

;=============================================================================
;FUNC:  DO_THE_JOB
;
;DESC:  Do whatever you want
;
;IN:    NONE
;OUT:   AL      error level
;NOTE:
;=============================================================================
do_the_job proc near

  mov   si, offset init_lanc_msg
  call  write_string_tty
  call  lanc_if_init
  mov   si, offset done_msg
  call  write_string_tty

  call  lanc_if_open
  mov   si, offset start_camcorder_msg
  call  write_string_tty
  .repeat
    call  check_break
    .break .if (carry?)
    call  lanc_if_check_active
  .until (bl == 0)
  .if (carry?)
    mov   si, offset break_accepted_msg
    call  write_string_tty
    ret
  .endif
  mov   si, offset crlf_msg
  call  write_string_tty

  mov   si, offset calibrating_msg
  call  write_string_tty
  call  lanc_if_calibrate
.if (al != NOERROR)
    mov   si, offset error3_msg
    call  write_string_tty
    ret
.endif
  mov   si, offset done_msg
  call  write_string_tty

  call  test_loop
ret
call clear_screen
call rm95_lowtest
ret
call dump_all
ret
  call  lanc_if_telegram_syncronize

  call  test_loop
  ret

  mov   si, offset start_camcorder_msg
  call  write_string_tty
  call  lanc_if_check_active
  .if (al != NOERROR)
    .if (user_break)
      mov   si, offset break_accepted_msg
    .else
      mov   si, offset lanc_not_found_msg
    .endif
    call  write_string_tty
    ret
  .else
    mov   si, offset lanc_found_msg
    call  write_string_tty
  .endif

  mov   si, offset calibrating_msg
  call  write_string_tty
  call  lanc_if_calibrate
  mov   si, offset done_msg
  call  write_string_tty

mov  ah, 2
call rm95_read_page
int 3
done:
ret

mov  ah, 3
call rm95_setpage
mov  ah, 8
call rm95_setpage
mov  ah, 1
call rm95_setpage
mov  ah, 15
call rm95_setpage
ret
  call  clear_screen
  call  send_test
;  call  rm95_lowtest
;  call  display_telegrams
;  call  deinit_lanc

  ret

do_the_job endp

CODE ENDS

END start
