*******************************************************************
*        MC68HC11E9 (Motorola).          *
*                                                                 *
*                       EEPROM.                      *
*******************************************************************


[Description]

Location = "Motorola\MC68HC11E9";
Info = " : MC68HC11E9.",
	"  EEPROM: 512 ",
	"  ROM: 12288 ",
	" ",
	"  : , , .",
	"  ",
	"  : fomalex@tut.by";

Buffer1 = "ROM",12288;
Buffer2 = "EEPROM",512
Picture = "MC68HC11E9.bmp";
UART = 1;

[Menu]

ReadEEPROM  = "& EEPROM",ReadEEPROMButton," EEPROM";
WriteEEPROM = "&",WriteEEPROMButton," EEPROM";
ReadROM	    = " ROM",ReadButton," ROM";
Compare     = "& ",CheckButton," ";
Init        = "& ",ChipInfoButton," ";
Info        = "&  ",ModuleInfoButton,"   ";

[Interface]

cb	= CheckBox,"  Bootloader-a",1;

[Code]

; ******************************************************
; *       C-          *
; *            "".   1.0                 *
; ******************************************************

;Proc ReadEEPROM {
READEEPROM:
;  var Error,Adress,Byte;
;     R100 = ERROR
;     R101 = ADRESS
;     R102 = BYTE
;  if(Interface0 = 1) {
		CMP	R8,1
		JNZ	IF0END
;    Error = Init;
		CALL	INIT
		MOV	R100,R990
;    if(Error = 0x8000) { return; }
		CMP	R100,$8000
		JNZ	IF1END
		RET
IF1END:
IF0END:
;  }
;  print("   EEPROM...");
		PRINT  "   EEPROM..."
;  Adress = EEPROM_BEGIN;
		MOV	R101,$B600
;  PBMax = EEPROM_SIZE;
		MOV	R2,512
;  PBPos = 0;
		MOV	R3,0
;  EDPTR = 0;
		MOV	R1019,0
;  while(PBPos != EEPROM_SIZE) {
WHILE0:
		CMP	R3,512
		JZ	WHILE0END
;    UART = 0x52;
		MOV	R1016,$52
;    Byte = Adress >> 8; UART = Byte; UART = Adress; 
		MOV	R102,R101
		SWAP	R102
		MOV	R1016,R102
		MOV	R1016,R101
;    Byte = UART;
		MOV	R102,R1016
;    if(Byte = 0x8000) {
		CMP	R102,$8000
		JNZ	IF2END
;      print("  !");
		PRINT  "  !"
;      break;
		JMP	WHILE0END
IF2END:
;    }
;    EDATA = Byte;
		MOV	R1020,R102
;    Adress++;PBPos++;EDPTR++;
		INC	R101
		INC	R3
		INC	R1019
		JMP	WHILE0
WHILE0END:
;  }
; if(Byte != 0x8000) {
		CMP	R102,$8000
		JZ	IF3END
;  print("");
		PRINT  ""
;  print("   . %d  .",PBPos);
		PRINT  "   . %d  .",R3
IF3END:
; } 
		RET

;}
;
WRITEEEPROM:
;Proc WriteEEPROM {
;  var Error,Adress,Byte,Data;
;     R103 = ERROR
;     R104 = ADRESS
;     R105 = BYTE
;     R106 = DATA
;  if(Interface0 = 1) {
		CMP	R8,1
		JNZ	IF4END
;    Error = Init;
		CALL	INIT
		MOV	R103,R990
;    if(Error = 0x8000) { return; }
		CMP	R103,$8000
		JNZ	IF5END
		RET
IF5END:
IF4END:
;  }
;  print("   EEPROM");
		PRINT  "   EEPROM"
;  Adress = EEPROM_BEGIN;
		MOV	R104,$B600
;  PBMax = EEPROM_SIZE;
		MOV	R2,512
;  PBPos = 0;
		MOV	R3,0
;  EDPTR = 0;
		MOV	R1019,0
;  while(PBPos != EEPROM_SIZE) {
WHILE1:
		CMP	R3,512
		JZ	WHILE1END
;    UART = 0x57;
		MOV	R1016,$57
;    Byte = Adress >> 8; UART = Byte; UART = Adress;
		MOV	R105,R104
		SWAP	R105
		MOV	R1016,R105
		MOV	R1016,R104
;    Data = EDATA; UART = Data;
		MOV	R106,R1020
		MOV	R1016,R106
;    Byte = UART;
		MOV	R105,R1016
;    if(Byte = 0x8000) {
		CMP	R105,$8000
		JNZ	IF6END
;      print("   . -.");
		PRINT  "   . -."
;      break;
		JMP	WHILE1END
IF6END:
;    }
;    if(Byte != Data) {
		CMP	R105,R106
		JZ	IF7END
;      print("   .  %h.   %b,  %b",Adress,Data,Byte);
		PRINT  "   .  %h.   %b,  %b",R104,R106,R105
;      Byte = 0x8000;
		MOV	R105,$8000
;      break;
		JMP	WHILE1END
IF7END:
;    }
;    Adress++;PBPos++;EDPTR++;
		INC	R104
		INC	R3
		INC	R1019
		JMP	WHILE1
WHILE1END:
;  }
; if(Byte != 0x8000) {
		CMP	R105,$8000
		JZ	IF8END
;  print("");
		PRINT  ""
;  print("   . %d  .",PBPos);
		PRINT  "   . %d  .",R3
IF8END:
; } 
		RET

;}
;
;//*       Compare  -                      **
;//***********************************************************
;Proc Compare {
COMPARE:
;  var Error,Adress,Byte;
;     R107 = ERROR
;     R108 = ADRESS
;     R109 = BYTE
;  if(Interface0 = 1) {
		CMP	R8,1
		JNZ	IF9END
;    Error = Init;
		CALL	INIT
		MOV	R107,R990
;    if(Error = 0x8000) { return; }
		CMP	R107,$8000
		JNZ	IF10END
		RET
IF10END:
IF9END:
;  }
;  print("   EEPROM");
		PRINT  "   EEPROM"
;  Adress = EEPROM_BEGIN; PBMax = EEPROM_SIZE;
		MOV	R108,$B600
		MOV	R2,512
;  PBPos = 0; EDPTR = 0; Error = 0;
		MOV	R3,0
		MOV	R1019,0
		MOV	R107,0
;  while(PBPos != EEPROM_SIZE) {
WHILE2:
		CMP	R3,512
		JZ	WHILE2END
;    UART = 0x52;
		MOV	R1016,$52
;    Byte = Adress >> 8;
		MOV	R109,R108
		SWAP	R109
;    UART = Byte;
		MOV	R1016,R109
;    UART = Adress;
		MOV	R1016,R108
;    Byte = UART;
		MOV	R109,R1016
;    if(Byte = 0x8000) {
		CMP	R109,$8000
		JNZ	IF11END
;      print("  !");
		PRINT  "  !"
;      break;
		JMP	WHILE2END
IF11END:
;    }
;    if(Byte != EDATA) {
		CMP	R109,R1020
		JZ	IF12END
;      Error++;
		INC	R107
;      ESEL = 0;
		MOV	R1021,0
		JMP	ELSE0END
IF12END:
;    }
;    else {ESEL = 1;}
		MOV	R1021,1
ELSE0END:
;    Adress++;PBPos++;EDPTR++;
		INC	R108
		INC	R3
		INC	R1019
		JMP	WHILE2
WHILE2END:
;  }
; if(Byte != 0x8000) {
		CMP	R109,$8000
		JZ	IF13END
;  print("");
		PRINT  ""
;  print("   . %d  . : %d",PBPos,Error);
		PRINT  "   . %d  . : %d",R3,R107
IF13END:
; } 
		RET

;}
;
;// *    Boot -             **
;// **********************************************************
;Proc Init {
INIT:
;   var Error,Adress,Counter,Byte;
;     R110 = ERROR
;     R111 = ADRESS
;     R112 = COUNTER
;     R113 = BYTE
;   print("   ...");
		PRINT  "   ..."
;   FDPTR = 0;EDPTR = 0;
		MOV	R0,0
		MOV	R1019,0
;   SetupComm(1200,8,0,0);
		SETUPCOMM  1200,8,0,0
;   RTS = 0;Delay(100);RTS = 1;Delay(100);RTS = 0;Delay(100);
		MOV	R1017,0
		DELAY	100
		MOV	R1017,1
		DELAY	100
		MOV	R1017,0
		DELAY	100
;   while {
WHILE3:
;     Byte = UART;
		MOV	R113,R1016
;     if(Byte = 0x8000) { break; }
		CMP	R113,$8000
		JNZ	IF14END
		JMP	WHILE3END
IF14END:
		JMP	WHILE3
WHILE3END:
;   }
;   print("   Bootloadera...");
		PRINT  "   Bootloadera..."
;   UART = 255;
		MOV	R1016,255
;   PBMax = 133; 
		MOV	R2,133
;   Adress = 0;
		MOV	R111,0
;   while(Adress != 133) {
WHILE4:
		CMP	R111,133
		JZ	WHILE4END
;     Byte = Bootloader[Adress];
		MOV	R1015,0	;  BOOTLOADER
		ADD	R1015,R111
		MOV	R113,R1014
;     UART = Byte;
		MOV	R1016,R113
;     Error = UART;
		MOV	R110,R1016
;     if(Error = 0x8000) {
		CMP	R110,$8000
		JNZ	IF15END
;      print("\;   .    .");
		PRINT  "\;   .    ."
;      return(0x8000);
		MOV	R990,$8000
		RET
IF15END:
;     }
;     if(Error != Byte) {
		CMP	R110,R113
		JZ	IF16END
;      print("\;   .    .");
		PRINT  "\;   .    ."
;      print("   %b,   %b",Byte,Error);
		PRINT  "   %b,   %b",R113,R110
;      Error = 0x8000;
		MOV	R110,$8000
;      return(0x8000);
		MOV	R990,$8000
		RET
IF16END:
;     }
;     Adress++;PBPos++;
		INC	R111
		INC	R3
		JMP	WHILE4
WHILE4END:
;   }
;   SetupComm(9600,8,0,0);
		SETUPCOMM  9600,8,0,0
;   Counter = 10;
		MOV	R112,10
;   while {
WHILE5:
;     Error = UART;
		MOV	R110,R1016
;     if(Error = 0x8000) { 
		CMP	R110,$8000
		JNZ	IF17END
;       Counter--;
		DEC	R112
;       if(Counter = 0) { 
		CMP	R112,0
		JNZ	IF18END
;        print("\;  py.    pp.",Error);
		PRINT  "\;  py.    pp.",R110
;        break; 
		JMP	WHILE5END
IF18END:
;       } 
		JMP	ELSE1END
IF17END:
;     }
;     else {
;      if (Error = 0xA5) {
		CMP	R110,$A5
		JNZ	IF19END
;       print("\;    .");
		PRINT  "\;    ."
;       interface0 = 0;
		MOV	R8,0
;       break;
		JMP	WHILE5END
		JMP	ELSE2END
IF19END:
;      }
;      else {print("   .   %d",Error); }
		PRINT  "   .   %d",R110
ELSE2END:
;     }
ELSE1END:
		JMP	WHILE5
WHILE5END:
;   }
;   return(Error);
		MOV	R990,R110
		RET
		RET

;}
READROM:
;Proc ReadROM {
;  var Error,Adress,Byte;
;     R114 = ERROR
;     R115 = ADRESS
;     R116 = BYTE
;  if(Interface0 = 1) {
		CMP	R8,1
		JNZ	IF20END
;    Error = Init;
		CALL	INIT
		MOV	R114,R990
;    if(Error = 0x8000) { return; }
		CMP	R114,$8000
		JNZ	IF21END
		RET
IF21END:
IF20END:
;  }
;  print("   ROM...");
		PRINT  "   ROM..."
;  Adress = ROM_BEGIN;
		MOV	R115,$D000
;  PBMax = ROM_SIZE;
		MOV	R2,12288
;  PBPos = 0;
		MOV	R3,0
;  FDPTR = 0;
		MOV	R0,0
;  while(PBPos != ROM_SIZE) {
WHILE6:
		CMP	R3,12288
		JZ	WHILE6END
;    UART = 0x52;
		MOV	R1016,$52
;    Byte = Adress >> 8; UART = Byte; UART = Adress; 
		MOV	R116,R115
		SWAP	R116
		MOV	R1016,R116
		MOV	R1016,R115
;    Byte = UART;
		MOV	R116,R1016
;    if(Byte = 0x8000) {
		CMP	R116,$8000
		JNZ	IF22END
;      print("  !");
		PRINT  "  !"
;      break;
		JMP	WHILE6END
IF22END:
;    }
;    FDATA = Byte;
		MOV	R1,R116
;    Adress++;PBPos++;FDPTR++;
		INC	R115
		INC	R3
		INC	R0
		JMP	WHILE6
WHILE6END:
;  }
; if(Byte != 0x8000) {
		CMP	R116,$8000
		JZ	IF23END
;  print("");
		PRINT  ""
;  print("   . %d  .",PBPos);
		PRINT  "   . %d  .",R3
IF23END:
; } 
		RET

;}
INFO:
;Proc Info {
;  print("");
		PRINT  ""
;  print("    /  EEPROM");
		PRINT  "    /  EEPROM"
;  print("   MC68HC11E9");
		PRINT  "   MC68HC11E9"
;  print("    MC68HC11E9.chl");
		PRINT  "    MC68HC11E9.chl"
;  print("");
		PRINT  ""
;  print("    :");
		PRINT  "    :"
;  print("      EEPROM");
		PRINT  "      EEPROM"
;  print("      EEPROM");
		PRINT  "      EEPROM"
;  print("      EEPROM");
		PRINT  "      EEPROM"
;  print("      ROM");
		PRINT  "      ROM"
;  print("");
		PRINT  ""
;  print("   : fomalex@tut.by");
		PRINT  "   : fomalex@tut.by"
		RET

;}
