/*
Выражаю огромную благодарность участнику форума Амперки Dmitrysh. 
Dmitrysh дал жизнь этому проекту, исправил ошибки, заменил 
громоздкие подключаемые библиотеки функциями, упорядочил скетч.
*/

//---ProMini_LCD1602_ANALOG KEYBOARD_04-03-19---//
#include <EEPROM.h>
#include <LiquidCrystal.h>
const int rs = 4, en = 5, d4 = 6, d5 = 7, d6 = 8, d7 = 9;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7);


#define UART_DOUBLESPEED
#define UART_TXREADY UDRE0
#define UART_RXREADY RXC0
#define UART_DOUBLE  U2X0
#define UDR  UDR0
#define UCRA UCSR0A
#define UCRB UCSR0B
#define UCRC UCSR0C
#define UCRC_VALUE ((1<<UCSZ01) | (1<<UCSZ00))
#define RXCIE RXCIE0
#define TXCIE TXCIE0
#define RXEN RXEN0
#define TXEN TXEN0
#define UBRRL UBRR0L
#define UBRRH UBRR0H
#define UART_CALC_BAUDRATE(baudRate) ((uint32_t)((F_CPU) + ((uint32_t)baudRate * 4UL)) / ((uint32_t)(baudRate) * 8UL) - 1)

//---секция ПИД---//
double  Input1; //текущая температура(измеренная max6675) ВИ
byte Output1; //выход ПИД регулятора ВИ
byte Setpoint1; //установленная температура(уставка) ВИ
byte kp1; //пропорциональный коэффициент ПИД для ВИ
byte ki1; //интегральный коэффициент ПИД для ВИ
byte kd1; //дифференциальный коэффициент ПИД для ВИ
#define i_min 0.0//минимум И составляющей
#define i_max 100.0//максимум И составляющей
float integra;
//---секция ПИД---//

//---MAX6675 functions---//
double max6675_read_temp (int CLK, int CS, int SO)
{ char i;
  int tmp = 0;
  digitalWrite(CS, LOW); //CS = 0;                            //Stop a conversion in progress
  asm volatile
  (
    " nop"        "\n\t"
  );
  for (i = 15; i >= 0; i--)
  { digitalWrite(CLK, HIGH);
    asm volatile
    (
      " nop"        "\n\t"
    );
    if ( digitalRead(SO))
      tmp |= (1 << i);


    digitalWrite(CLK, LOW);
    asm volatile
    (
      " nop"        "\n\t"
    );
  }
  digitalWrite(CS, HIGH);
  if (tmp & 0x4) {
    return NAN;
  } else
    return ((tmp >> 3)) * 0.25;
}
//---MAX6675 functions---//

byte buf[5]; //это для графиков на ПК

void make_buf(byte temp)
{ byte i, small, dig, ch;

  for (i = 0; i <= 2; i++)
  {
    small = temp / 10;
    dig = temp - small * 10 ; // получаем ASSCI код символа
    ch = dig + 48 ;
    buf[3 - i] = ch; // получается , что мы записываем целую часть начиная с младшего символа
    temp = temp / 10;
  }
}

//---секция алгоритма Брезенхема---//
int er1 = 1;  //переменная для расчета переполнения в алгоритме Брезенхема для ВИ
int reg1;     //промежуточная переменная для алгоритма Брезенхема для ВИ
boolean out1; //выход импульса управления ВИ алгоритма Брезенхема
//---секция алгоритма Брезенхема---//

//---секция нагревателей---//
//переменные для установки мощности нагревателей
byte pwr_TOP;     //максимальная мощность верхнего нагревателя
#define RelayPin1 3  //назначаем пин "ВЕРХНЕГО" нагревателя
//---секция нагревателей---//

//---секция кнопок---//
//---настройка аналоговых кнопок управления----//
//#define A_PINS_BASE 100 // номер с которого начинается нумерация наших "псевдо-кнопок".

#define PIN_RIGHT 100
#define PIN_UP 101
#define PIN_DOWN 102
#define PIN_LEFT 103
#define PIN_SELECT 104

struct A_PIN_DESC { // определяем  структуру которой будем описывать какое значение мы ожидаем для каждого псевдо-пина
  byte pinNo; // номер пина
  int expectedValue;// ожидаемое значение
};

A_PIN_DESC expected_values[] = { // ожидаемые значения для псевдо-кнопок
  { PIN_RIGHT, 152},
  { PIN_UP, 745},
  { PIN_DOWN, 510},
  { PIN_LEFT, 336},
  { PIN_SELECT, 8}
};

#define A_PINS_COUNT sizeof(expected_values)/sizeof(A_PIN_DESC) // вычисляем сколько у нас всего "псевдо-кнопок" заданно.
#define A_POSSIBLE_ABERRATION 50 // допустимое отклонение analogRead от ожидаемого значения, при котором псевдо кнопка считается нажатой

bool digitalReadA(byte pinNo) {

  for (byte i = 0; i < A_PINS_COUNT; i++) { // ищем описание нашего всевдо-пина
    A_PIN_DESC pinDesc = expected_values[i]; // берем очередное описание
    if (pinDesc.pinNo == pinNo) { // нашли описание пина?
      int value = analogRead(A6); // производим чтетине аналогово входа

      return (abs(value - pinDesc.expectedValue) < A_POSSIBLE_ABERRATION); // возвращаем HIGH если отклонение от ожидаемого не больше чем на A_POSSIBLE_ABERRATION
    }
  }

  return LOW; // если не нашли описания - считаем что пин у нас LOW

}
//---настройка аналоговых кнопок управления----//

//Назначаем пины кнопок управления
int upSwitchPin = PIN_UP;
int downSwitchPin = PIN_DOWN;
int cancelSwitchPin = PIN_LEFT;
int okSwitchPin = PIN_SELECT;

//состояние кнопок по умолчанию
boolean upSwitchState = 0;
boolean downSwitchState = 0;
boolean cancelSwitchState = 0;
boolean okSwitchState = 0;

//переменные для кнопок
long ms_button = 0;
boolean  button_state = false;
boolean  button_long_state = false;
//---секция кнопок---//

//---секция профиля---//
byte currentProfile = 1; //текущий профиль
byte currentStep = 1; //текущий шаг профиля
byte profileSteps; //количество шагов профиля
byte editStep = 0; //номер шага профиля который редактируется в данный момент
byte rampRateStep[9]; //скорость роста температуры
byte dwellTimerStep[9]; //установленное время перехода на следубщий шаг
byte startTemp; //стартовая температура для профиля, когда НИ вышел на уставку, используется для определения шага профиля с которого начинаем
byte setpointRamp; //заданная температура по определённому шагу профиля ВИ, связана с заданной скоростью роста температуры
byte temperatureStep[9]; //заданные температуры для шагов профиля ВИ
//---секция профиля---//

//---Секция флагов---//
boolean TopStart = false; //флаг включения ВИ
boolean flag = 0; //флаг для фиксации стартовой температуры и начала работы нагревателей
byte x = 1; //переменная для перехода на нужный шаг при горячей плате
boolean alarmOn = false; //признак предупреждения
boolean updateScreen = true; //признак обновления экрана
//---Секция флагов---//

//---Секция переменных общего назначения---//
byte curCount = 0; //знакоместо звездочек (они бегают по LCD в режиме RUN)
byte counter; //счётчик для рампы и счетчик для времени нахождения в шаге
unsigned long previousMillis; //это для счетчиков
#define SENSOR_SAMPLING_TIME 250 //частота обновления текущей температуры (1000=1 раз в секунду)
#define GRAPHICS_SAMPLING_TIME 500 //скорость движения "звёздочек" при пайке
unsigned long nextRead2; //переменная для обновления текущей температуры и расчёта ПИД
unsigned long nextRead1; //переменная для движения "звёздочек" при пайке и подготовки данных для передачи на ПК
int tc1; //переменная для хранения текущей температуры ВИ
byte Secs = 0; //это для графиков на ПК
int i = 0;
//---Секция переменных общего назначения---//

//---структура статусов событий---//
// ***** TYPE DEFINITIONS *****
typedef enum REFLOW_STATE : byte
{
  REFLOW_STATE_IDLE,
  REFLOW_STATE_MENU_STEPS,
  REFLOW_STATE_MENU_STEP_RAMP,
  REFLOW_STATE_MENU_STEP_TARGET,
  REFLOW_STATE_MENU_TOP_PWR,
  REFLOW_STATE_MENU_STEP_DWELL,
  REFLOW_STATE_MENU_TOP_P,
  REFLOW_STATE_MENU_TOP_I,
  REFLOW_STATE_MENU_TOP_D,
  REFLOW_STATE_STEP_RAMP,
  REFLOW_STATE_STEP,
  REFLOW_STATE_STEP_DWELL,
  REFLOW_STATE_COMPLETE
}
reflowState_t;

typedef enum REFLOW_STATUS : byte  //структура статуса пайки, запущен или нет
{
  REFLOW_STATUS_OFF,
  REFLOW_STATUS_ON
}
reflowStatus_t;
reflowStatus_t reflowStatus; //переменная статусов событий
reflowState_t reflowState; //переменная статуса пайки
//---структура статусов событий---//


#define buzzerPin A3 //назначаем пин пищалки
#define Int_Fan  A2  //назначаем пин охладителя симисторов и контроллера
//#define Ext_Fan  5  //назначаем пин охладителя платы

//---назначаем пины преобразователя сигнала термопары---//
#define thermoSO  10 //DO=(SO)
#define thermoCLK  11 //SCK=(CLK)
#define thermoCStop  12 //CS MAX6675 "ВЕРХНЕГО" нагревателя


void loadProfile() //чтение профиля из EEPROM
{
  profileSteps = EEPROM.read((currentProfile - 1) * 29);
  for (int i = 0; i < 9; i++) {
    rampRateStep[i] = EEPROM.read((currentProfile - 1) * 29 + i + 2);
    dwellTimerStep[i] = EEPROM.read((currentProfile - 1) * 29 + i + 11) * 5;
    temperatureStep[i] = EEPROM.read((currentProfile - 1) * 29 + i + 20);
  }
  kp1 = EEPROM.read((currentProfile - 1) * 4 + 122);
  ki1 = EEPROM.read((currentProfile - 1) * 4 + 123);
  kd1 = EEPROM.read((currentProfile - 1) * 4 + 124);
  pwr_TOP = EEPROM.read((currentProfile - 1) * 4 + 125);

  return;
}


void UART_SendByte(uint8_t data)
{
  while (!(UCRA & (1 << UART_TXREADY)));
  UDR = data;
}

void UART_SendArray(uint8_t *buffer, uint8_t bufferSize)
{
  for (uint8_t i = 0; i < bufferSize; i++)
    UART_SendByte(buffer[i]);
}

void UART_Init(uint32_t UART_BAUD_RATE)
{
  UBRRH = (UART_CALC_BAUDRATE(UART_BAUD_RATE) >> 8) & 0xFF;
  UBRRL = (UART_CALC_BAUDRATE(UART_BAUD_RATE) & 0xFF);
  UCSR0A = ( 1 << UART_DOUBLE );
  UCRB = ((1 << TXEN) | (1 << RXEN));
  UCRC = UCRC_VALUE;
}


void setup()
{

  UART_Init(9600);
  buf[0] = 36;
  buf[4] = 59;

  loadProfile(); //вызов функции loadProfile для загрузки данных профиля из eeprom

  attachInterrupt(0, Dimming, RISING); //настроить порт прерывания(0 или 1) 2й или 3й цифровой пин
  /* -------------------------------------------------------------------------------
    LOW вызывает прерывание, когда на порту LOW
    CHANGE прерывание вызывается при смене значения на порту, с LOW на HIGH и наоборот
    RISING прерывание вызывается только при смене значения на порту с LOW на HIGH
    FALLING прерывание вызывается только при смене значения на порту с HIGH на LOW
    ------------------------------------------------------------------------------- */

  //---задаём состояние пинов, к которым подключены MAX6675---//
  pinMode(thermoCStop, OUTPUT);
  pinMode(thermoCLK, OUTPUT);
  pinMode(thermoSO, INPUT);

  //---устанавливаем пин пищалки на ВЫХОД---//
  pinMode(buzzerPin, OUTPUT);

  //---устанавливаем пины охладителей на ВЫХОД---//
  pinMode (Int_Fan, OUTPUT);
  //pinMode (Ext_Fan, OUTPUT);

  //---задаём состояние пинов управления выходами---//
  pinMode(RelayPin1, OUTPUT);

    lcd.begin(16, 2);
    lcd.clear();
    lcd.setCursor(1, 0);
    lcd.print("ARDUINO REWORK");
    lcd.setCursor(0, 1);
    lcd.print("v1.4_Top Channel");

  /*  //Мелодия приветствия
    tone(buzzerPin, 523);
    delay(200);
    tone(buzzerPin, 659);
    delay(200);
    tone(buzzerPin, 784);
    delay(200);
    tone(buzzerPin, 1046);
    delay(200);
    noTone(buzzerPin); */
    
    //показываем заставку пока стабилизируются MAX6675
    delay(10000); 
  lcd.begin(16, 2);
}


//---основной цикл программы---//
void loop()
{
  //---Считываем состояние кнопок управления---//
  upSwitchState = digitalReadA(upSwitchPin);
  downSwitchState = digitalReadA(downSwitchPin);
  cancelSwitchState = digitalReadA(cancelSwitchPin);
  okSwitchState = digitalReadA(okSwitchPin);

  unsigned long currentMillis = millis();

  if (reflowState == REFLOW_STATE_COMPLETE || alarmOn) {
    if (i < 2 && cancelSwitchState == LOW) {
      alarmOn = true;
        tone(buzzerPin, 1046);
        delay(100);
        noTone(buzzerPin);
        delay(100);
        tone(buzzerPin, 1046);
        delay(100);
        noTone(buzzerPin);
        delay(100);
      i++;
    }
    else {
      i = 0;
      alarmOn = false;
    }
  }

  switch (reflowState)
  {
    case REFLOW_STATE_IDLE:
      TopStart = false;
      currentStep = 1;
      counter = 0;
      setpointRamp = 0;
      x = 1;             //устанавливаем переменную в исходное состояние
      flag = 0;         //после отановки профиля сбрасываем флаг
      Output1 = 0;

      if (millis() > nextRead2)
      {
        //---считываем информацию с преобразователя термопары---//
        nextRead2 = millis() + SENSOR_SAMPLING_TIME; //устраняем колебания датчиков температуры
        Input1  = Input1 * 0.6 + 0.4 * (max6675_read_temp(thermoCLK, thermoCStop, thermoSO)); //термопара "ВЕРХНЕГО" нагревателя
        tc1 = Input1;

        make_buf(byte(tc1));
        UART_SendArray(buf, 5);

        lcd.setCursor(13, 1);
        lcd.print("    ");
        lcd.setCursor(13, 1);
        if (isnan(Input1)) {
          lcd.print("Er");
        } else {
          lcd.print(tc1);
        }
      }

      //Обновляем экран один раз
      if (updateScreen) {

        //Настройка экрана в режиме ожидания
        lcd.clear();
        lcd.setCursor(0, 0);
        lcd.print("OFF");
        lcd.setCursor(4, 0);
        lcd.print("PTN:");
        lcd.print("  STEP:1");
        lcd.setCursor(0, 1);
        lcd.print("TH SP:");
        lcd.setCursor(10, 1);
        lcd.print("PV:");
        updateScreen = false;
      }
      lcd.setCursor(8, 0);
      lcd.print(currentProfile);
      lcd.print(" ");
      lcd.setCursor(6, 1);
      lcd.print(temperatureStep[0]);
      lcd.print("");

      if (upSwitchState == HIGH && ( millis() - ms_button) > 500) //if up switch is pressed go to next profile
      {
        ms_button =  millis();
        currentProfile = currentProfile + 1;
        if (currentProfile >= 5) //if currentProfile = 4 and up is pressed go back to profile 1
        {
          currentProfile = 1;
        }
        loadProfile(); //вызов функции loadProfile для загрузки данных профиля из eeprom
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 500) //same as above just go down one profile
      {
        ms_button =  millis();
        currentProfile = currentProfile - 1;
        if (currentProfile <= 0)
        {
          currentProfile = 4;
        }
        loadProfile(); //вызов функции loadProfile для загрузки данных профиля из eeprom
      }


      //---фиксируем момент нажатия кнопки "ОК" + защита от дребезга---//
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
        button_long_state = false;
      }


      //---держим "ОК" 3 секунды и заходим в меню настроек---//
      if (okSwitchState == HIGH && !button_long_state && ( millis() - ms_button) > 3000)
      {
        button_long_state = true;
        button_state = false;
        reflowState = REFLOW_STATE_MENU_STEPS;
        //---обновить экран---///
        updateScreen = true;
      }


      //---включаем пайку, кнопка сработает после отпускания "ОК" если нажатие меньше 3х секунд---//
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
           tone(buzzerPin, 1045, 500);  //звуковой сигнал при старте профиля

        //---обновить экран---//
        updateScreen = true;
        curCount = 0;
        nextRead1 = millis();
        nextRead2 = millis();
        reflowStatus = REFLOW_STATUS_ON;
        reflowState = REFLOW_STATE_STEP_RAMP;
      }
      break;


    //---устанавливаем количество шагов профиля---//
    case REFLOW_STATE_MENU_STEPS:
      if (updateScreen) {
        lcd.clear();
        lcd.setCursor(0, 0);        
        lcd.print("PTN ");        
        lcd.print(currentProfile);
        lcd.print(" Edit");
        lcd.setCursor(0, 1);
        lcd.print("PTN Steps:");       
        lcd.print(profileSteps);
        updateScreen = false;
      }
      lcd.setCursor(10, 1);
      lcd.print(profileSteps);

      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        profileSteps = profileSteps + 1;
        if (profileSteps >= 10) {
          profileSteps = 1;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        profileSteps = profileSteps - 1;
        if (profileSteps <= 0)
        {
          profileSteps = 9;
        }
      }
      if (okSwitchState == LOW && button_long_state) button_long_state = false; //чтобы после входа в меню кнопка "ОК" не считалась нажатой

      if (okSwitchState == HIGH && !button_state && !button_long_state && ( millis() - ms_button) > 100)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        reflowState = REFLOW_STATE_MENU_TOP_PWR;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---устанавливаем максимальную мощность "ВЕРХНЕГО НАГРЕВАТЕЛЯ"---//
    case REFLOW_STATE_MENU_TOP_PWR:

      if (updateScreen)
      {
        lcd.setCursor(0, 1);
        lcd.print("Top PWR:    ");
        updateScreen = false;
      }
      lcd.setCursor(8, 1);
      lcd.print(pwr_TOP);
      lcd.print("%  ");

      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        pwr_TOP = pwr_TOP + 1;
        if (pwr_TOP >= 100)
        {
          pwr_TOP = 100;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();

        if (pwr_TOP >= 1) pwr_TOP = pwr_TOP - 1;
        else (pwr_TOP = 0);
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        reflowState = REFLOW_STATE_MENU_STEP_RAMP;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---устанавливаем скорость нагрева "Верхним Нагревателем"---//
    case REFLOW_STATE_MENU_STEP_RAMP:

      if (updateScreen) {
        lcd.setCursor(0, 1);
        lcd.print("St ");
        lcd.print(editStep + 1);
        lcd.print(" Ramp:     ");
        updateScreen = false;
      }
      lcd.setCursor(10, 1);
      lcd.print(rampRateStep[editStep]);
      lcd.print(" ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        rampRateStep[editStep] = rampRateStep[editStep] + 1;
        if (rampRateStep[editStep] >= 30)  //(только целые числа) максимальная скорость роста температуры умноженная на 10
        {
          rampRateStep[editStep] = 30;  //(только целые числа) максимальная скорость роста температуры умноженная на 10
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        rampRateStep[editStep] = rampRateStep[editStep] - 1;
        if (rampRateStep[editStep] <= 1)  //(только целые числа) минимальная скорость роста температуры умноженная на 10
        {
          rampRateStep[editStep] = 1;  //(только целые числа) минимальная скорость роста температуры умноженная на 10
        }
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        if (editStep + 1 == profileSteps) {
          editStep = 0;
          reflowState = REFLOW_STATE_MENU_STEP_TARGET;
        }
        else {
          editStep++;
        }
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        editStep = 0;
        lcd.clear();
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---устанавливаем температуру "Верхнего Нагревателя"---//
    case REFLOW_STATE_MENU_STEP_TARGET:
      if (updateScreen) {
        lcd.setCursor(0, 1);
        lcd.print("St ");
        lcd.print(editStep + 1);
        lcd.print(" Target:  ");
        lcd.print(temperatureStep[editStep]);
        lcd.print("  ");
        updateScreen = false;
      }
      lcd.print(" ");
      lcd.setCursor(12, 1);
      lcd.print(temperatureStep[editStep]);
      lcd.print("  ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        temperatureStep[editStep] = temperatureStep[editStep] + 1;
        if (temperatureStep[editStep] >= 255)
        {
          temperatureStep[editStep] = 255;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        temperatureStep[editStep] = temperatureStep[editStep] - 1;
        if (temperatureStep[editStep] <= 0)
        {
          temperatureStep[editStep] = 0;
        }
      }

      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        if (editStep + 1 == profileSteps) {
          editStep = 0;
          reflowState = REFLOW_STATE_MENU_STEP_DWELL;
        }
        else {
          editStep++;
        }
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        editStep = 0;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---устанавливаем время перехода на следующий шаг---//
    case REFLOW_STATE_MENU_STEP_DWELL:
      if (updateScreen) {
        lcd.setCursor(0, 1);
        lcd.print("St ");
        lcd.print(editStep + 1);
        lcd.print(" Dwell:");
        lcd.print(dwellTimerStep[editStep]);
        lcd.print("  ");
      }
      lcd.print("  ");
      lcd.setCursor(11, 1);
      lcd.print(dwellTimerStep[editStep]);
      lcd.print("  ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        dwellTimerStep[editStep] = dwellTimerStep[editStep] + 5;
        if (dwellTimerStep[editStep] >= 180)
        {
          dwellTimerStep[editStep] = 180;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();

       if (dwellTimerStep[editStep] >= 5) dwellTimerStep[editStep] = dwellTimerStep[editStep] - 5;
       else dwellTimerStep[editStep] = 0;        
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        if (editStep + 1 == profileSteps) {

          editStep = 0;
          reflowState = REFLOW_STATE_MENU_TOP_P;
        }
        else {
          editStep++;
        }
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        editStep = 0;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---настройка "ПИД" верхнего нагревателя---//
    case REFLOW_STATE_MENU_TOP_P:
      if (updateScreen) {
        lcd.setCursor(0, 1);
        lcd.print("TH:            ");
        lcd.setCursor(4, 1);
        lcd.print("P=");
        lcd.print(kp1);
        lcd.print("  ");
        updateScreen = false;
      }
      lcd.setCursor(6, 1);
      lcd.print(kp1);
      lcd.print("  ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        kp1 = kp1 + 1;
        if (kp1 >= 255)
        {
          kp1 = 255;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        
      kp1 = kp1 - 1;
        if (kp1 <= 0)
        {
          kp1 = 0;
        }
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        updateScreen = true;
        reflowState = REFLOW_STATE_MENU_TOP_I;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;
    case REFLOW_STATE_MENU_TOP_I:
      lcd.setCursor(4, 1);
      lcd.print("I=");
      lcd.print(ki1);
      lcd.print("  ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        ki1 = ki1 + 1;
        if (ki1 >= 255)
        {
          ki1 = 255;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        ki1 = ki1 - 1;
        if (ki1 <= 0)
        {
          ki1 = 0;
        }
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;
        reflowState = REFLOW_STATE_MENU_TOP_D;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        reflowState = REFLOW_STATE_IDLE;
      }
      break;
    case REFLOW_STATE_MENU_TOP_D:
      lcd.setCursor(4, 1);
      lcd.print("D=");
      lcd.print(kd1);
      lcd.print("  ");
      if (upSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        kd1 = kd1 + 1;
        if (kd1 >= 255)
        {
          kd1 = 255;
        }
      }
      if (downSwitchState == HIGH && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        kd1 = kd1 - 1;
        if (kd1 <= 0)
        {
          kd1 = 0;
        }
      }
      if (okSwitchState == HIGH && !button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = true;
      }
      if (okSwitchState == LOW && button_state && ( millis() - ms_button) > 200)
      {
        ms_button =  millis();
        button_state = false;


        //---сохраняем текущие параметры в "Память"---//
        EEPROM.write((currentProfile - 1) * 29, profileSteps);
        for (int i = 0; i < 9; i++) {
          EEPROM.write(((currentProfile - 1) * 29 + i + 2), rampRateStep[i] );
          EEPROM.write(((currentProfile - 1) * 29 + i + 11), dwellTimerStep[i] / 5);
          EEPROM.write(((currentProfile - 1) * 29 + i + 20), temperatureStep[i]);
        }
        EEPROM.write(((currentProfile - 1) * 4 + 122), kp1);
        EEPROM.write(((currentProfile - 1) * 4 + 123), ki1);
        EEPROM.write(((currentProfile - 1) * 4 + 124), kd1);
        EEPROM.write(((currentProfile - 1) * 4 + 125), pwr_TOP);

        lcd.clear();
        reflowState = REFLOW_STATE_IDLE;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        lcd.clear();
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---"процесс пайки", рост температуры с заданной скоростью---//
    case REFLOW_STATE_STEP_RAMP:
      digitalWrite(Int_Fan, HIGH); //включить охладитель симисторов и контроллера
      if (updateScreen) {
        lcd.setCursor(0, 0);
        lcd.print("RUN");
        updateScreen = false;
      }

      //if (tc1 >= 35 && !TopStart) TopStart = true;
      if (tc1 >= 120 && !TopStart) TopStart = true; //если температура на датчике верха достигла 120*С включаем верхний нагреватель
      if (TopStart == true) //включаем верхний нагреватель
        //-------------------------------------------------------------------------------------------
      { //открываем скобку (чтоб не запутаться)


        //---фиксируем стартовую температуру---//
        if (flag == 0)
        {
          startTemp = tc1;
          flag = 1;
        }


        //---устанавливаем нужный шаг, до которой нагрета плата---//
        if (startTemp > temperatureStep[currentStep - 1]) {
          for (x = 1; startTemp > temperatureStep[currentStep - 1]; currentStep++) {
            x++;
          }
        }
        if (currentStep > x && flag == 1) {
          flag = 0;
          startTemp = temperatureStep[currentStep - 2];
          flag = 1;
        }
        lcd.setCursor(15, 0);
        lcd.print(currentStep);

        
        //---счётчик скорости роста температуры---//
        if ((currentMillis - previousMillis) > 1000 / (rampRateStep[currentStep - 1] * 0.1)) //скорость роста температуры от 0.1с. до 3с.
        {
          previousMillis = currentMillis;
          counter = counter + 1;
          setpointRamp = counter + startTemp;
          lcd.setCursor(6, 1);
          lcd.print(" ");
          lcd.setCursor(6, 1);
          lcd.print(setpointRamp);
          lcd.print(" ");
          Setpoint1 = setpointRamp;
        }
      } //закрывам скобку
      //----------------------------------------------------------------------------------------

      if (setpointRamp >= temperatureStep[currentStep - 1]) //если достигли нужной температуры
      {
        lcd.setCursor(6, 1);
        lcd.print(temperatureStep[currentStep - 1]);
        reflowState = REFLOW_STATE_STEP;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        digitalWrite(Int_Fan, LOW); //выключить охладитель симисторов и контроллера
        reflowStatus = REFLOW_STATUS_OFF;
        reflowState = REFLOW_STATE_IDLE;
        updateScreen = true;
      }
      break;
    case REFLOW_STATE_STEP:
      Setpoint1 = temperatureStep[currentStep - 1];
      if (Input1 >= temperatureStep[currentStep - 1])
      {
        counter = 0;
        reflowState = REFLOW_STATE_STEP_DWELL;
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;

        reflowStatus = REFLOW_STATUS_OFF;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---считаем время перехода на следующий шаг---//
    case REFLOW_STATE_STEP_DWELL:
      if (currentMillis - previousMillis > 1000)
      {
        previousMillis = currentMillis;
        counter = counter + 1;
      }
      if (counter == dwellTimerStep[currentStep - 1]) //если счётчик равен установленному времени
      {
        counter = 0;
        setpointRamp = 0;
        if (profileSteps == currentStep) //если достигли последнего шага
        {
          currentStep = 1;
          x = 1;      //устанавливаем переменную в исходное состояние
          flag = 0;   //после завершения профиля сбрасываем флаг
          reflowState = REFLOW_STATE_COMPLETE;
        }
        else //если шаг не последний
        {
          currentStep++; //переходим на следующий шаг
          reflowState = REFLOW_STATE_STEP_RAMP;
        }
      }
      if (cancelSwitchState == HIGH && ( millis() - ms_button) > 50)
      {
        ms_button =  millis();
        updateScreen = true;

        reflowStatus = REFLOW_STATUS_OFF;
        reflowState = REFLOW_STATE_IDLE;
      }
      break;


    //---завершение пайки---//
    case REFLOW_STATE_COMPLETE:
      //digitalWrite(Ext_Fan, HIGH); //включить охладитель платы
      digitalWrite(Int_Fan, LOW); //выключить охладитель симисторов и контроллера
      reflowStatus = REFLOW_STATUS_OFF;
      reflowState = REFLOW_STATE_IDLE;
      updateScreen = true;
      break;
  }


  //---включение нагревателей---//
  if (reflowStatus == REFLOW_STATUS_ON)
  {

    if (millis() > nextRead2)
    {
      //---считываем данные с термопар---//      
      Input1  = Input1 * 0.6 + 0.4 * (max6675_read_temp(thermoCLK, thermoCStop, thermoSO)); //термопара "ВЕРХНЕГО" нагревателя
      tc1 = Input1;
      if (TopStart) Output1 = Pid1(Input1, Setpoint1, kp1, ki1, kd1); else Output1 = 0;
      nextRead2 = millis() + SENSOR_SAMPLING_TIME;
      
      make_buf(byte(tc1));
      UART_SendArray(buf, 5);
      lcd.setCursor(13, 1);
      lcd.print("   ");
      lcd.setCursor(13, 1);
      if (isnan(Input1)) {
        lcd.print("Er");
      } else {
        lcd.print(tc1);
      }
    }
  }
  else
  {
    digitalWrite(RelayPin1, LOW);
  }
}


void Dimming()
{
  if (reflowStatus == REFLOW_STATUS_ON)
  {
    OutPWR_TOP();
  }
  if (Secs >= 100)
  {
    UART_SendByte(byte(Input1));
    Secs = 0;
  } else Secs++;
}


void OutPWR_TOP()
{
  reg1 = round(Output1 * (pwr_TOP * 0.01)) + er1; //pwr- задание выходной мощности в %, er- ошибка округления

  if (reg1 < 50)
  {
    out1 = LOW;

    er1 = reg1 ; //reg- переменная для расчетов
  }
  else
  {
    out1 = HIGH;

    er1 = reg1 - 100;
  }
  digitalWrite(RelayPin1, out1); //пин через который осуществляется дискретное управление
}


byte Pid1(double temp, byte ust, byte kP, byte kI, byte kd)
{
  byte out = 0;
  static float ed = 0;
  float e, p;
  float d;
  e = (ust - temp); //ошибка регулирования
  p =  (kP * e); //П составляющая
  integra = (integra < i_min) ? i_min : (integra > i_max) ? i_max : integra + (kI * e) / 100; //И составляющая
  d = kd * (e - ed) * 10; //Д составляющая
  ed = e;
  out = (p + integra + d < 0) ? 0 : (p + integra + d > pwr_TOP) ? pwr_TOP : p + integra + d;
  return out;
}

