#include <FileConstants.au3>
#include <MsgBoxConstants.au3>
#include <WinAPIFiles.au3>

Example()

Func Example()
        ; Create a constant variable in Local scope of the filepath that will be read/written to.
        Local $sFilePath = "C:\Backup\AutoIt Scripts\Symmetra SYBT5\firmware.bin" ;_WinAPI_GetTempFileName(@TempDir)
		Local $sFilePathOut = "C:\Backup\AutoIt Scripts\Symmetra SYBT5\firmware_out.bin" ;_WinAPI_GetTempFileName(@TempDir)
		if $CmdLine[0] = 0 then
		  MsgBox($MB_OK + $MB_ICONERROR,"No Filename in command line","Please choose file!")
		  Exit 1
		Else
		  If FileExists($CmdLine[1]) Then
			 $sFileName = $CmdLine[1]
		  Else
			  MsgBox($MB_OK + $MB_ICONERROR,"File not exist","File '" & $sFileName & "' not exist!")
			  Exit 2
		  EndIf
		EndIf
		if StringCompare(StringRight(StringLower($sFileName),4), ".bin") = 0 Then
			  $sFileName = StringLeft($sFileName, StringLen($sFileName)-4)
			  $sFilePath = $sFileName & ".bin"
			  $sFilePathOut = $sFileName & "_out.bin"
		Else
			  MsgBox($MB_OK + $MB_ICONERROR,StringRight(StringLower($sFileName),4), "Incorrect file asc, must be '.bin'")
			  Exit 3
		EndIf
		If FileExists($sFilePathOut) Then
			if MsgBox($MB_YESNO + $MB_ICONERROR,"Output file exist", "File '" & $sFilePathOut &"' already exist. Continue?") = $IDNO Then
				Exit 4
			EndIf
		EndIf
        ; Create a temporary file to read data from.
;        If Not FileWrite($sFilePath, "This is an example of using FileOpen.") Then
;                MsgBox($MB_SYSTEMMODAL, "", "An error occurred whilst writing the temporary file.")
;                Return False
;        EndIf

        ; Open the file for reading and store the handle to a variable.
        Local $hFileOpen = FileOpen($sFilePath, $FO_BINARY)
        If $hFileOpen = -1 Then
                MsgBox($MB_SYSTEMMODAL, "", "An error occurred when reading the file.")
                Return False
        EndIf

        ; Read the contents of the file using the handle returned by FileOpen.
        Local $sFileRead = FileRead($hFileOpen)

        ; Close the handle returned by FileOpen.
        FileClose($hFileOpen)
local $summ = 0
Local $out
if BinaryLen($sFileRead) <> 512 Then
	Msgbox($MB_OK + $MB_ICONERROR,"Incorrect File Size","Attention! FileSize not 512 bytes")
	Exit
Endif
Local $new_file = BinaryMid($sFileRead,1,1)
;$new_file = $new_file & Binary("0x00")
$summ = $summ + Number($new_file)
for $i = 2 to 144
	;msgbox(1,"BinaryMid($sFileRead,$i,1)",Number(BinaryMid($sFileRead,$i,1)))
	$summ = $summ + Number(BinaryMid($sFileRead,$i,1))
	$new_file = $new_file & BinaryMid($sFileRead,$i,1)
Next
$new_file = $new_file & Binary(StringMid(String(@MON),1,1)) & Binary("0x00") & Binary(StringMid(String(@MON),2,1))
$new_file = $new_file & Binary("0x00") & Binary("/") & Binary("0x00")
$new_file = $new_file & Binary(StringMid(String(@MDAY),1,1)) & Binary("0x00") & Binary(StringMid(String(@MDAY),2,1))
$new_file = $new_file & Binary("0x00") & Binary("/") & Binary("0x00")
$new_file = $new_file & Binary(StringMid(String(@YEAR),3,1)) & Binary("0x00") & Binary(StringMid(String(@YEAR),4,1)) & Binary("0x00")
for $i = 145 to 160
	;msgbox(1,"BinaryMid($sFileRead,$i,1)",Number(BinaryMid($sFileRead,$i,1)))
	$summ = $summ + Number(BinaryMid($new_file,$i,1))
Next
Local $CheckSumm = Hex($summ)
;msgbox(0,"",$CheckSumm)
$new_file = $new_file & Binary("0x" & StringMid(String($CheckSumm),7,2)) & Binary("0x00") & Binary("0x" & StringMid(String($CheckSumm),5,2)) & Binary("0x00")
for $i = 165 to 512
	$new_file = $new_file & Binary("0x00")
Next


        ; Display the contents of the file.
;        MsgBox($MB_SYSTEMMODAL, BinaryLen($new_file) & " " &$summ & " " & $CheckSumm, "Contents of the file:" & @CRLF & BinaryMid($sFileRead,163,1) & " " & BinaryMid($sFileRead,161,1) & @CRLF & $new_file)
$out=FileOpen($sFilePathOut,$FO_OVERWRITE + $FO_BINARY) ; 1+16=Write binary
FileWrite($out,$new_file)
FileClose($out)

        ; Delete the temporary file.
        ;FileDelete($sFilePath)
EndFunc   ;==>Example
