; Base Address:	0000h Range: 0000h - 4000h Loaded length: 4000h
; Processor	  : h8300   Byte sex	  : Big	endian

; ===========================================================================

; Segment type:	Pure code
		.text; ROM
RESET:		.word 0x170		; RESET
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Reserved for system use
		.word 0x3826		; NMI
		.word 0x38E4		; Trap instruction0
		.word 0x38E4		; Trap instruction1
		.word 0x38E4		; Trap instruction2
		.word 0x38E4		; Trap instruction3
		.word 0x38E4		; Break	conditions satisfied
		.word 0x38E4		; SLEEP
		.word 0x377C		; IRQ0
		.word 0x38E4		; IRQ1
		.word 0x38E4		; IRQ2
		.word 0x38E4		; IRQ3
		.word 0x38E4		; WKP
		.word 0x38E4		; Timer	A
		.word 0x38E4		; Reserved for system use
		.word 0x38E4		; Timer	W
		.word 0x3848		; Timer	V
		.word 0x3402		; SCI3
		.word 0x333E		; IIC
ADC:		.word 0x38E4		; ADC
A_0034:		.word 2
		.word 0x308
		.word 0xFE1E
		.word 0xFE1D
		.word 0xFE99
		.word 0xFE97
		.word 0xFE64
		.word 0xFE22
		.word 0xFE23
		.word 0xFE95
		.word 0xFE96
		.word 0xFE8B
		.word 0xFE13
		.word 0xFE80
		.word 0xFE81
		.word 0xFE83
		.word 0xFE67
		.word 0xFE20
		.word 0
		.word 0
		.word 0
		.word 0
off_60:		.word sub_2692		; DATA XREF: sub_C0E+5Er sub_F56+2CCr
off_62:		.word sub_268E		; DATA XREF: sub_56E+48r
off_64:		.word loc_26B6		; DATA XREF: sub_E12+4r ROM:14DEr
off_66:		.word sub_2694		; DATA XREF: ROM:14A0r	sub_F56+21E8r
off_68:		.word sub_2D28		; DATA XREF: ROM:01AEr	ROM:0350r ...
off_6A:		.word sub_2CE4		; DATA XREF: sub_668+4r sub_672r
off_6C:		.word sub_3DC8		; DATA XREF: sub_900+18r sub_3B8C+4r ...
off_6E:		.word sub_3E44		; DATA XREF: ROM:073Ar	ROM:3AD4r ...
off_70:		.word sub_24AA		; DATA XREF: sub_2BA8r
off_72:		.word loc_2D5C		; DATA XREF: sub_346A:loc_3590r
off_74:		.word mloc_2CCC		; DATA XREF: sub_346A+140r
off_76:		.word sub_2D50		; DATA XREF: ROM:17F2r	sub_26C4+Cr ...
off_78:		.word sub_2D54		; DATA XREF: ROM:0EA8r	sub_F56+18Ar ...
off_7A:		.word sub_FC0		; DATA XREF: sub_688:loc_6C6r sub_7AEr ...
off_7C:		.word loc_174E		; DATA XREF: ROM:18A4r	ROM:1F7Ar
off_7E:		.word loc_174A		; DATA XREF: ROM:loc_13CEr
					; ROM:loc_1F24r
		.word 0xFEA5
		.word 0xFEA6
		.word 0xFEA7
		.word 0xFE67
		.word 0xFED6
		.word 0xFED7
		.word 0
		.word 0
off_90:		.word sub_1E8C		; DATA XREF: ROM:loc_147Ar
					; ROM:loc_149Ar ...
off_92:		.word loc_1126		; DATA XREF: ROM:1424r	ROM:1978r
off_94:		.word sub_11EC		; DATA XREF: sub_DFA+Cr ROM:loc_1976r
off_96:		.word loc_1630		; DATA XREF: mloc_16b8+2r mloc_179e+2r
off_98:		.word sub_D7A		; DATA XREF: sub_DFA+Er
					; sub_F56:loc_1108r
off_9A:		.word sub_1310		; DATA XREF: sub_F56+EEr
off_9C:		.word sub_1316		; DATA XREF: sub_F56+1D6r
					; ROM:mloc_177er
off_9E:		.word sub_1520		; DATA XREF: msub_142Cr ROM:loc_14C4r
off_A0:		.word sub_2CB4		; DATA XREF: ROM:0194r	sub_56E+68r ...
off_A2:		.word sub_2D52		; DATA XREF: sub_F56:loc_FFEr
					; sub_F56+1FEr	...
off_A4:		.word sub_2178		; DATA XREF: sub_15FA+Ar sub_15FA+12r	...
off_A6:		.word sub_21E8		; DATA XREF: sub_13D0+2r sub_15FA+1Er	...
off_A8:		.word sub_2DCA		; DATA XREF: sub_13D0+24r ROM:1702r ...
off_AA:		.word sub_192E		; DATA XREF: sub_688:loc_6B6r
					; ROM:17C8r ...
off_AC:		.word sub_2EAE		; DATA XREF: ROM:0226r	ROM:0366r ...
off_AE:		.word sub_2D64		; DATA XREF: sub_EE6+6r ROM:2A62r
off_B0:		.word loc_16AE		; DATA XREF: ROM:1F5Ar	ROM:1F74r ...
off_B2:		.word sub_169C		; DATA XREF: sub_C0E+20r sub_F56+102r	...
off_B4:		.word sub_1698		; DATA XREF: ROM:loc_1896r ROM:1A4Ar ...
off_B6:		.word loc_1758		; DATA XREF: ROM:13AEr	ROM:142Ar ...
off_B8:		.word loc_1750		; DATA XREF: ROM:14DAr	ROM:loc_167Cr
off_BA:		.word sub_29A8		; DATA XREF: ROM:28DCr	sub_29B0+1Er ...
off_BC:		.word sub_2B2E		; DATA XREF: sub_29B0+32r ROM:2AB8r ...
off_BE:		.word sub_293A		; DATA XREF: ROM:2AC4r	sub_2C88+12r
off_C0:		.word sub_2DAE		; DATA XREF: sub_1594+6r sub_1F7C+78r
off_C2:		.word sub_26B4		; DATA XREF: sub_C0E+72r sub_F56+2F0r	...
off_C4:		.word loc_E3E		; DATA XREF: ROM:0DB2r	ROM:0DC0r
off_C6:		.word sub_49A		; DATA XREF: ROM:Mloc_0d9ar
					; sub_F56+F8r
off_C8:		.word sub_2DDA		; DATA XREF: sub_1506+10r sub_1E14+24r ...
off_CA:		.word loc_2DFA		; DATA XREF: ROM:076Cr	ROM:170Er ...
off_CC:		.word sub_1CA6		; DATA XREF: ROM:1ABAr	ROM:1B72r ...
off_CE:		.word sub_1CB8		; DATA XREF: ROM:1B58r	ROM:1BDCr ...
off_D0:		.word sub_2D30		; DATA XREF: sub_8CC+10r ROM:28F4r ...
off_D2:		.word sub_231A		; DATA XREF: ROM:02C6r	ROM:075Cr ...
off_D4:		.word loc_10E4		; DATA XREF: sub_F56:loc_FBEr
					; ROM:1398r ...
off_D6:		.word loc_1AD6		; DATA XREF: ROM:1B5Cr	ROM:loc_1BBAr ...
off_D8:		.word sub_4B6		; DATA XREF: ROM:0174r	ROM:loc_20Ar
off_DA:		.word loc_2FFA		; DATA XREF: sub_F56:loc_3228r
					; sub_346A+132r
off_DC:		.word sub_2CEC		; DATA XREF: sub_900+6r sub_900+26r
off_DE:		.word loc_3508		; DATA XREF: sub_346A:loc_35C8r
					; ROM:loc_36AAr ...
off_E0:		.word sub_D36		; DATA XREF: sub_4AA+Ar sub_23B6+1Ar
off_E2:		.word sub_275E		; DATA XREF: sub_980+2Cr sub_C0E+24r ...
off_E4:		.word sub_2774		; DATA XREF: sub_C0E+60r sub_CFEr ...
off_E6:		.word sub_276C		; DATA XREF: sub_2270+2r ROM:3B26r
off_E8:		.word sub_2FE0		; DATA XREF: ROM:02AAr	sub_934+40r
off_EA:		.word sub_3F50		; DATA XREF: ROM:3AAEr	ROM:3EA4r ...
		.word 0x807
		.word 0x5500
		.word 0x6800
		.word 0
		.word 0
		.word 0
		.word 2
		.word 0x19
		.word 1
		.word 0x19
		.word 0x34
		.word 0xEC
		.word 0x38
		.word 0x80
		.word 0xFD80
		.byte 0xFE ; 
		.byte	 0
		.byte 0xFE ; 
		.byte 0x10
		.byte 0xFE ; 
		.byte 0x22 ; "
		.byte 0xFE ; 
		.byte 0x50 ; P
		.byte 0xFF
		.byte	 0
		.byte 0xFF
		.byte 0x20
		.byte 0xFF
		.byte 0x2E ; .
		.byte 0xDB ; 
		.byte 0xF9 ; 
		.byte 0xEB ; 
		.byte 0x79 ; y
		.byte 0xDB ; 
		.byte 0xF9 ; 
		.byte 0xD8 ; 
		.byte	 2
		.byte 0xE8 ; 
		.byte 0x1E
		.byte 0xD8 ; 
		.byte	 2
		.byte 0xEA ; 
		.byte 0x70 ; p
		.byte 0xE4 ; 
		.byte 0x84 ; 
		.byte 0xE5 ; 
		.byte	 5
		.byte 0xE8 ; 
		.byte 0x1E
		.byte 0x1F
		.byte	 0
		.byte 0xC2 ; 
		.byte 0xF0 ; 
		.byte 0xA9 ; 
		.byte  0xF
		.byte 0xE0 ; 
		.byte 0x7E ; ~
		.byte 0xE1 ; 
		.byte	 0
		.byte 0xD1 ; 
		.byte	 0
		.byte 0x80 ; 
		.byte 0xF8 ; 
		.byte 0x81 ; 
		.byte 0x30 ; 0
		.byte 0x82 ; 
		.byte 0x70 ; p
		.byte 0x84 ; 
		.byte 0xCC ; 
		.byte 0x85 ; 
		.byte 0xCC ; 
		.byte 0xA8 ; 
		.byte	 8
		.byte 0xFC ; 
		.byte 0xFC ; 
		.byte 0xB9 ; 
		.byte 0x7E ; ~
		.byte 0xB8 ; 
		.byte	 0
		.byte 0xA2 ; 
		.byte 0x1E
		.byte 0xA5 ; 
		.byte 0xE3 ; 
		.byte 0xF0 ; 
		.byte	 0
		.byte 0xF1 ; 
		.byte 0x20
		.byte 0xF9 ; 
		.byte	 0
		.byte 0xC8 ; 
		.byte 0x80 ; 
		.byte 0xC9 ; 
		.byte 0x3F ; ?
		.byte 0xF4 ; 
		.byte 0x10
		.byte 0xFE ; 
		.byte 0xAA ; 
		.byte 0x30 ; 0
		.byte 0x3F ; ?
		.byte 0x3A ; :
		.byte 0x19
		.byte 0x1E
		.byte 0x3F ; ?
		.byte 0x9B ; 
		.byte 0xFF
		.byte 0x34 ; 4
		.byte 0xFF
		.byte 0x2B ; +
		.byte	 3
		.byte 0x38 ; 8
		.byte 0x96 ; 
		.byte 0x31 ; 1
		.byte 0x3C ; <
		.byte 0x36 ; 6
		.byte 0xFF
		.byte 0xD1 ; 
		.byte	 1
; ---------------------------------------------------------------------------

Main:
		mov.w	#0xFF80, sp
		jsr	@@off_D8:8
		mov.w	#0x118,	r0
		mov.b	#0, r4l
		mov.b	#6, r3l
		jsr	sub_9CC:16
		jsr	sub_980:16
		jsr	sub_46C:16
		beq	loc_1AA:8
		mov.w	#0xFD80, r0
		mov.w	#0xFF7E, r1
		jsr	@@off_A0:8
		mov.w	#0x15E,	r0
		mov.b	#0xFE, r1h ; ''
		mov.b	#9, r3l
		mov.b	#0, r4l
		jsr	sub_9CE:16
		mov.b	#0xE0, r0l ; ''
		mov.b	r0l, @0xFF0C:16

loc_1AA:				; CODE XREF: ROM:018Aj
		mov.w	#0xFE7A, r1
		jsr	@@off_68:8
		bild	#2, @2:8
		bor	#1, @2:8
		bcc	loc_1BE:8
		jsr	sub_4AA:16

loc_1BE:				; CODE XREF: ROM:01B8j
		jsr	sub_9F6:16
		bclr	#0, @0xA:8
		jsr	sub_302:16
		bclr	#0, @0xE:8

loc_1CE:				; CODE XREF: ROM:02C0j
		andc	#0x7B, ccr ; '{'
		jsr	sub_934:16
		btst	#6, @AMR:8
		bne	loc_20A:8
		orc	#0x80, ccr ; ''
		mov.b	@SCR3:8, r0l
		and.b	#0xC0, r0l
		bne	loc_1EE:8
		bld	#0, @0xE:8
		bist	#6, @SCR3:8
		bst	#7, @SCR3:8

loc_1EE:				; CODE XREF: ROM:01E0j
		btst	#7, @AMR:8
		bne	loc_204:8
		mov.b	#0, r0l
		btst	#2, @2:8
		beq	loc_1FE:8
		mov.b	#0x90, r0l ; ''

loc_1FE:				; CODE XREF: ROM:01FAj
		mov.b	r0l, @0xC7:8
		mov.b	#0xC, r0l
		mov.b	r0l, @ADSR:8

loc_204:				; CODE XREF: ROM:01F2j
		jsr	sub_55C:16
		andc	#0x7F, ccr ; ''

loc_20A:				; CODE XREF: ROM:01D8j
		jsr	@@off_D8:8
		jsr	sub_4DC:16
		btst	#3, @2:8
		bne	loc_256:8
		mov.b	@0xFEE0:16, r0l
		bne	loc_23A:8
		btst	#3, @0xE:8
		beq	loc_23A:8
		mov.w	@0xFEB0:16, e1
		jsr	@@off_AC:8
		bcs	loc_23A:8
		mov.w	e0, @0xFEDE:16
		jsr	sub_55C:16
		bclr	#3, @0xE:8
		bset	#7, @SCR3:8

loc_23A:				; CODE XREF: ROM:021Aj	ROM:0220j ...
		btst	#2, @2:8
		beq	loc_244:8
		jsr	sub_440:16

loc_244:				; CODE XREF: ROM:023Ej
		mov.w	@0xFE60:16, e0
		mov.w	@0xFF00:16, r0
		or.w	e0, r0
		bne	loc_262:8
		jsr	sub_56E:16
		bra	loc_2BC:8
; ---------------------------------------------------------------------------

loc_256:				; CODE XREF: ROM:0214j
		mov.b	@0xFEE0:16, r0l
		bne	loc_2B8:8
		jsr	loc_35C:16
		bra	loc_2BC:8
; ---------------------------------------------------------------------------

loc_262:				; CODE XREF: ROM:024Ej
		mov.b	@2:8, r0l
		btst	#7, r0l
		beq	loc_2BC:8
		bclr	#7, @2:8
		bld	#4, r0l
		btst	#5, r0l
		bne	loc_2C4:8
		bcc	loc_2D0:8
		jsr	sub_626:16
		btst	#6, @0x11:8
		beq	loc_28C:8
		mov.w	#0xF95,	r2
		jsr	sub_77A:16
		jsr	sub_608:16
		bra	loc_298:8
; ---------------------------------------------------------------------------

loc_28C:				; CODE XREF: ROM:027Cj
		jsr	loc_724:16
		jsr	sub_608:16
		jsr	sub_7AE:16

loc_298:				; CODE XREF: ROM:028Aj
		jsr	sub_7D4:16
		jsr	sub_824:16
		jsr	sub_8B6:16
		btst	#2, @2:8
		bne	loc_2CE:8
		jsr	@@off_E8:8
		bset	#2, @2:8
		bra	loc_2B8:8
; ---------------------------------------------------------------------------

loc_2B2:				; CODE XREF: ROM:loc_2C4j
		bsr	sub_302:8
		jsr	sub_F56:16

loc_2B8:				; CODE XREF: ROM:025Aj	ROM:02B0j ...
		jsr	sub_302C:16

loc_2BC:				; CODE XREF: ROM:0254j	ROM:0260j ...
		bclr	#7, @2:8
		jmp	loc_1CE:16
; ---------------------------------------------------------------------------

loc_2C4:				; CODE XREF: ROM:0270j
		bcc	loc_2B2:8
		jsr	@@off_D2:8
		bne	loc_2CE:8
		jsr	loc_3A30:16

loc_2CE:				; CODE XREF: ROM:02A8j	ROM:02C8j ...
		bra	loc_2B8:8
; ---------------------------------------------------------------------------

loc_2D0:				; CODE XREF: ROM:0272j
		jsr	sub_900:16
		btst	#6, @0x11:8
		beq	loc_2EC:8
		jsr	loc_724:16
		jsr	sub_5E4:16
		jsr	sub_7AE:16
		bset	#2, @IEGR1:8
		bra	loc_2FC:8
; ---------------------------------------------------------------------------

loc_2EC:				; CODE XREF: ROM:02D8j
		mov.w	#0x9C4,	r2
		jsr	sub_77A:16
		jsr	sub_5E4:16
		bclr	#2, @IEGR1:8

loc_2FC:				; CODE XREF: ROM:02EAj
		bclr	#2, @IENR3:8
		bra	loc_2CE:8

; =============== S U B	R O U T	I N E =======================================


sub_302:				; CODE XREF: ROM:01C6p	ROM:loc_2B2p
		mov.w	@0xFE80:16, r1
		mov.b	@PDR1:8, r0l
		bld	#1, r1h
		bst	#2, r0l
		bld	#2, r1h
		bst	#7, r0l
		mov.b	r0l, @PDR1:8
		mov.b	@PDR5:8, r0l
		mov.b	r0l, r2l
		and.b	#0xE3, r0l
		rotl.b	r1l
		and.b	#0x14, r1l
		bsr	sub_328:8
		or.b	r1l, r0l
		mov.b	r0l, @PDR5:8
		andc	#0xFE, ccr ; ''
		jmp	loc_D3C:16
; End of function sub_302


; =============== S U B	R O U T	I N E =======================================


sub_328:				; CODE XREF: sub_302+1Ap
		mov.b	@0xFE39:16, r0h
		bne	loc_33A:8
		bld	#2, r2l
		bxor	#2, r1l
		bcc	locret_344:8
		mov.b	#6, r0h
		mov.b	r0h, @0xFE39:16

loc_33A:				; CODE XREF: sub_328+4j
		bset	#3, r1l
		cmp.b	#4, r0h
		bcs	locret_344:8
		bld	#2, r2l
		bst	#2, r1l

locret_344:				; CODE XREF: sub_328+Aj sub_328+16j
		rts
; End of function sub_328

; ---------------------------------------------------------------------------

loc_346:				; CODE XREF: ROM:0370j
		jsr	sub_430:16
		beq	loc_376:8

loc_34C:				; CODE XREF: ROM:036Aj
		mov.w	#0xFE7B, r1
		jsr	@@off_68:8
		bclr	#2, @2:8
		bclr	#3, @2:8
		rts
; ---------------------------------------------------------------------------

loc_35C:				; CODE XREF: ROM:025Cp
		btst	#2, @2:8
		beq	loc_386:8
		mov.w	#8, e1
		jsr	@@off_AC:8
		mov.w	e0, e5
		ble	loc_34C:8
		jsr	sub_6FC:16
		bcc	loc_346:8
		jsr	sub_CFE:16

loc_376:				; CODE XREF: ROM:034Aj
		bclr	#2, @2:8
		mov.w	#0xFE27, e4
		mov.b	#0x10, r6l

loc_380:				; CODE XREF: ROM:0414j
		mov.w	#0xFE00, e6
		bra	loc_38C:8
; ---------------------------------------------------------------------------

loc_386:				; CODE XREF: ROM:0360j
		mov.b	#0x20, r0h ; ' '
		jsr	sub_2D70:16

loc_38C:				; CODE XREF: ROM:0384j
		mov.w	e5, e1

loc_38E:				; CODE XREF: ROM:03CAj
		mov.b	r6l, r2l
		jsr	sub_2EB0:16
		mov.w	e6, r1
		mov.w	#0xFF3E, r2
		sub.w	r3, r3

loc_39C:				; CODE XREF: ROM:03BCj
		mov.b	@r1+, r0l

loc_39E:				; CODE XREF: ROM:03ECj
		mov.b	@r2, r0h
		mov.b	r0l, @r2
		inc.w	#1, r2
		cmp.b	r0h, r0l
		beq	loc_3AA:8
		inc.b	r3l

loc_3AA:				; CODE XREF: ROM:03A6j
		add.b	r0l, r3h
		cmp.w	#0xFE26, r1
		beq	loc_3E0:8
		cmp.w	e4, r1
		beq	loc_3E6:8
		bcc	loc_3CC:8
		cmp.w	#0xFF5E, r2
		bcs	loc_39C:8
		cmp.b	#0, r3l
		bne	loc_3EE:8
		mov.w	e1, e5
		mov.w	r1, e6
		mov.b	#4, r6l
		mov.b	r3h, r6h
		bra	loc_38E:8
; ---------------------------------------------------------------------------

loc_3CC:				; CODE XREF: ROM:03B6j
		cmp.b	#0, r3l
		bne	loc_3EE:8
		cmp.w	#0xFE26, r1
		bcs	unk_3DA:8
		bsr	sub_430:8
		beq	loc_408:8
; ---------------------------------------------------------------------------
unk_3DA:	.byte 0x1A		; CODE XREF: ROM:03D4j
problem32_36:	.byte 0x80 ; 
; ---------------------------------------------------------------------------
		bsr	sub_422:8
		bra	loc_45A:8
; ---------------------------------------------------------------------------

loc_3E0:				; CODE XREF: ROM:03B0j
		mov.b	@0xA:8,	r0l
		and.b	#0xF0, r0l
		bra	loc_3EA:8
; ---------------------------------------------------------------------------

loc_3E6:				; CODE XREF: ROM:03B4j
		add.b	r6h, r3h
		mov.b	r3h, r0l

loc_3EA:				; CODE XREF: ROM:03E4j
		inc.w	#1, r1
		bra	loc_39E:8
; ---------------------------------------------------------------------------

loc_3EE:				; CODE XREF: ROM:03C0j	ROM:03CEj
		mov.b	r6l, r2l
		mov.w	#0xFF3E, r1
		mov.w	e5, e1
		mov.w	@r1+, e2
		jsr	sub_3012:16

loc_3FC:				; CODE XREF: ROM:0406j
		mov.w	@r1+, e2
		dec.b	r2l
		beq	locret_42E:8
		jsr	sub_301E:16
		bra	loc_3FC:8
; ---------------------------------------------------------------------------

loc_408:				; CODE XREF: ROM:03D8j
		mov.b	#0, r6h
		mov.w	#0xFE0E, e4
		add.w	#8, e5
		mov.b	#8, r6l
		jmp	loc_380:16
; ---------------------------------------------------------------------------

loc_418:				; CODE XREF: sub_440p
		bsr	sub_470:8
		beq	locret_42E:8
; ---------------------------------------------------------------------------
problem32_37:	.byte 0x7A ; z
		.byte	 0
		.byte 0x1A
		.byte 0xB2 ; 
		.byte	 0
		.byte 0xC6 ; 

; =============== S U B	R O U T	I N E =======================================


sub_422:				; CODE XREF: ROM:03DCp
		mov.w	#0xFE60, r1
		mov.w	e0, @r1
		mov.w	#0xFF00, r1
		mov.w	r0, @r1
; End of function sub_422

; START	OF FUNCTION CHUNK FOR sub_430

locret_42E:				; CODE XREF: ROM:0400j	ROM:041Aj ...
		rts
; END OF FUNCTION CHUNK	FOR sub_430

; =============== S U B	R O U T	I N E =======================================


sub_430:				; CODE XREF: ROM:loc_346p ROM:03D6p ...

; FUNCTION CHUNK AT 042E SIZE 00000002 BYTES

		mov.b	#0xC0, r0l ; ''
		bld	#1, @0:8
		bcc	locret_42E:8
; End of function sub_430


; =============== S U B	R O U T	I N E =======================================


sub_438:				; CODE XREF: sub_49A+2p
		mov.b	@0:8, r0h
		and.b	#0xFC, r0h
		cmp.b	r0l, r0h
		rts
; End of function sub_438


; =============== S U B	R O U T	I N E =======================================


sub_440:				; CODE XREF: ROM:0240p
		bsr	loc_418:8
		bsr	sub_430:8
		beq	loc_454:8
		bsr	sub_464:8
		bcs	loc_454:8
		mov.w	#0x1D4C, r2
		jsr	sub_780:16
		bcs	locret_46A:8

loc_454:				; CODE XREF: sub_440+4j sub_440+8j
		bset	#3, @2:8
		bsr	sub_4AA:8

loc_45A:				; CODE XREF: ROM:03DEj	ROM:38E8j
		bclr	#2, @0x11:8
		mov.b	#0xFF, r0h
		bsr	sub_4B8:8

loc_462:				; CODE XREF: sub_440:loc_462j
		bra	loc_462:8
; End of function sub_440


; =============== S U B	R O U T	I N E =======================================


sub_464:				; CODE XREF: sub_440+6p
		mov.b	@0xFE67:16, r0l
		cmp.b	#0x50, r0l ; 'P'

locret_46A:				; CODE XREF: sub_440+12j
		rts
; End of function sub_464


; =============== S U B	R O U T	I N E =======================================


sub_46C:				; CODE XREF: ROM:0186p
		mov.b	#2, r2l
		bra	loc_472:8
; End of function sub_46C


; =============== S U B	R O U T	I N E =======================================


sub_470:				; CODE XREF: ROM:loc_418p
		mov.b	#3, r2l

loc_472:				; CODE XREF: sub_46C+2j
		mov.w	@0xFE60:16, r0
		mov.w	#0x1AB2, r1
		cmp.w	r0, r1
		bne	locret_498:8
		mov.w	@0xFF00:16, r0
		mov.b	#0xC6, r1l ; ''
		cmp.b	r0l, r1l
		bne	locret_498:8
		mov.w	#0x9F2,	r1

loc_48C:				; CODE XREF: sub_470+26j
		mov.b	@r1+, r0l
		and.b	#0xFC, r0h
		cmp.b	r0l, r0h
		beq	locret_498:8
		dec.b	r2l
		bpl	loc_48C:8

locret_498:				; CODE XREF: sub_470+Cj sub_470+16j ...
		rts
; End of function sub_470


; =============== S U B	R O U T	I N E =======================================


sub_49A:				; CODE XREF: ROM:Mloc_0d9ap
					; sub_F56+F8p
					; DATA XREF: ...
		mov.b	#0x30, r0l ; '0'
		bsr	sub_438:8
		beq	locret_4A8:8
		mov.b	#0, r0l
		mov.b	r0l, @0xFE97:16
		andc	#0xFB, ccr ; ''

locret_4A8:				; CODE XREF: sub_49A+4j
		rts
; End of function sub_49A


; =============== S U B	R O U T	I N E =======================================


sub_4AA:				; CODE XREF: ROM:01BAp	sub_440+18p
		sub.w	r0, r0
		mov.w	r0, @0xFE80:16
		mov.b	r0l, @0xFEA5:16
		jmp	@@off_E0:8
; End of function sub_4AA


; =============== S U B	R O U T	I N E =======================================


sub_4B6:				; CODE XREF: ROM:0174p	ROM:loc_20Ap
					; DATA XREF: ...
		mov.b	#0, r0h
; End of function sub_4B6


; =============== S U B	R O U T	I N E =======================================


sub_4B8:				; CODE XREF: sub_440+20p
		btst	#2, @0xC0:8
		bne	loc_4C6:8
		mov.b	#0x9E, r0l ; ''
		mov.b	r0l, @0xC0:8
		mov.b	#0xB6, r0l ; ''
		mov.b	r0l, @0xC0:8

loc_4C6:				; CODE XREF: sub_4B8+4j
		mov.b	#0x4E, r0l ; 'N'
		mov.b	r0l, @0xC0:8
		mov.b	r0h, @0xC1:8
		mov.b	#0x2E, r0l ; '.'
		mov.b	r0l, @0xC0:8
		rts
; End of function sub_4B8


; =============== S U B	R O U T	I N E =======================================


sub_4D2:				; CODE XREF: sub_F56+12Cp sub_2526+B6p ...
		bld	#0, @0:8
		bst	#0, r0l
		mov.b	r0l, @0:8
		rts
; End of function sub_4D2


; =============== S U B	R O U T	I N E =======================================


sub_4DC:				; CODE XREF: ROM:020Cp

; FUNCTION CHUNK AT 0522 SIZE 00000014 BYTES

		mov.w	@0xFF86:16, r0
		mov.w	r0, r3
		bsr	sub_536:8
		bne	loc_4E8:8
		bcs	loc_4F0:8

loc_4E8:				; CODE XREF: sub_4DC+8j
		bclr	#1, @2:8
		and.b	#0xFC, r0h
		mov.b	r0h, r2l

loc_4F0:				; CODE XREF: sub_4DC+Aj
		sub.b	r2l, r3h
		cmp.b	#0x77, r3h ; 'w'
		or.b	r1l, r2l
		mov.b	r2l, @0xFE7D:16
		bcs	locret_520:8
		mov.w	#0xFE7C, r1
		jsr	@@off_68:8
		mov.w	#0x1F4,	r0

loc_506:				; CODE XREF: sub_4DC+30j
		bsr	sub_536:8
		bhi	locret_520:8
		dec.w	#1, r0
		bne	loc_506:8
		btst	#1, @2:8
		bne	loc_522:8
		bset	#1, @2:8
; End of function sub_4DC


; =============== S U B	R O U T	I N E =======================================


sub_518:				; CODE XREF: sub_2F1C+18p
		bset	#1, @PMR1:8
		bclr	#1, @PMR1:8

locret_520:				; CODE XREF: sub_4DC+1Ej sub_4DC+2Cj ...
		rts
; End of function sub_518

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_4DC

loc_522:				; CODE XREF: sub_4DC+36j sub_4DC+50j ...
		jsr	sub_2FE6:16
		bsr	sub_55C:8
		btst	#2, @AMR:8
		bne	loc_522:8
		mov.b	@0xFE36:16, r0l
		beq	loc_522:8
		rts
; END OF FUNCTION CHUNK	FOR sub_4DC

; =============== S U B	R O U T	I N E =======================================


sub_536:				; CODE XREF: sub_4DC+6p
					; sub_4DC:loc_506p
		orc	#1, ccr
		mov.b	@0xFE36:16, r1h
		beq	locret_520:8
		mov.b	@0xFE7D:16, r1h
		mov.b	r1h, r2l
		and.b	#0xFC, r2l
		and.b	#3, r1h
		mov.b	@PDR5:8, r1l
		rotl.b	r1l
		rotl.b	r1l
		and.b	#3, r1l
		cmp.b	r1h, r1l
		bld	#2, @AMR:8
		bior	#0, r1l
		bior	#1, r1l
		rts
; End of function sub_536


; =============== S U B	R O U T	I N E =======================================


sub_55C:				; CODE XREF: ROM:loc_204p ROM:022Ep ...
		mov.b	#0, r2l
		mov.b	r2l, @ADRR:8
		mov.b	#0x88, r2l ; ''
		mov.b	r2l, @AMR:8
		bset	#6, @AMR:8
		sub.w	r2, r2
		mov.b	r2l, @0xC7:8
		rts
; End of function sub_55C


; =============== S U B	R O U T	I N E =======================================


sub_56E:				; CODE XREF: ROM:0250p
		bset	#0, @0x25:8
		mov.w	#8, e1
		jsr	@@off_AC:8
		mov.w	e0, e1
		mov.b	#0x10, r2l
		jsr	sub_2EB0:16
		mov.w	#0xFE00, r2
		mov.w	#0xFF3E, r1
		mov.b	#0x20, r0l ; ' '
		jsr	sub_2CD8:16
		mov.b	#4, r2l
		jsr	sub_2EB0:16
		mov.w	#0xFE20, r2
		mov.w	#0xFF3E, r1
		mov.b	#6, r0l
		jsr	sub_2CD8:16
		mov.w	@r1, r3
		mov.w	#0xFE00, r1
		mov.b	#0x26, r2l ; '&'
		jsr	sub_2D64:16
		add.b	r3h, r0l
		mov.b	r0l, r2h
		mov.b	#8, r0l
		cmp.b	r3l, r2h
		jsr	@@off_62:8
		cmp.b	r3l, r2h
		bne	loc_5CE:8
		mov.b	r3h, @0xA:8

loc_5BE:				; CODE XREF: sub_56E+74j
		mov.b	@0xFE02:16, r0l
		bld	#5, r0l
		bst	#2, @6:8
		bset	#0, @1:8
		rts
; ---------------------------------------------------------------------------

loc_5CE:				; CODE XREF: sub_56E+4Cj
		mov.w	#0xFE00, r0
		mov.w	#0xFE10, r1
		jsr	@@off_A0:8
		mov.w	#0xFE15, r0
		mov.w	#0xFE26, r1
		jsr	@@off_A0:8
		bra	loc_5BE:8
; End of function sub_56E


; =============== S U B	R O U T	I N E =======================================


sub_5E4:				; CODE XREF: ROM:02DEp	ROM:02F4p
		btst	#2, @IENR3:8
		beq	loc_5EE:8
		bclr	#0, @0xA:8

loc_5EE:				; CODE XREF: sub_5E4+4j
		bclr	#6, @0xE0:8
		mov.w	#0xFE6E, r4
		mov.w	#0xFE6D, r5
		mov.w	#0xFE6F, r6
		mov.b	#0, r3l
		bsr	sub_622:8
		bset	#6, @0xE0:8
		rts
; End of function sub_5E4


; =============== S U B	R O U T	I N E =======================================


sub_608:				; CODE XREF: ROM:0286p	ROM:0290p
		bld	#1, @IENR3:8
		bst	#2, @0xA:8
		bclr	#1, @IENR3:8
		mov.w	#0xFE6B, r4
		mov.w	#0xFE63, r5
		mov.w	#0xFE6C, r6
		mov.b	#0, r3l
; End of function sub_608


; =============== S U B	R O U T	I N E =======================================


sub_622:				; CODE XREF: sub_5E4+1Cp
		mov.b	#0, r2l
		bra	loc_636:8
; End of function sub_622


; =============== S U B	R O U T	I N E =======================================


sub_626:				; CODE XREF: ROM:0274p
		mov.w	#0xFE67, r4
		mov.w	#0xFE67, r5
		mov.w	#0xFE73, r6
		mov.b	#3, r3l
		mov.b	#0xD, r2l

loc_636:				; CODE XREF: sub_622+2j sub_626+3Ej
		dec.w	#1, r4
		dec.w	#1, r5
		dec.w	#1, r6
		mov.b	#4, r2h
		mov.b	#8, r1h
		mov.b	#0, r1l
		mov.b	@r4, r0l

loc_644:				; CODE XREF: sub_626+28j
		dec.b	r1h
		beq	loc_662:8
		mov.b	r3l, r0h
		bsr	sub_688:8
		bsr	sub_672:8
		bcs	loc_644:8
		mov.b	@r6, r1l
		mov.b	@r4, r0l
		bsr	sub_668:8
		bcs	loc_65C:8
		mov.b	r0h, @r5
		bra	loc_660:8
; ---------------------------------------------------------------------------

loc_65C:				; CODE XREF: sub_626+30j
		bne	loc_660:8
		mov.b	r0h, @r4

loc_660:				; CODE XREF: sub_626+34j
					; sub_626:loc_65Cj
		mov.b	r1l, @r6

loc_662:				; CODE XREF: sub_626+20j
		dec.b	r3l
		bpl	loc_636:8
		rts
; End of function sub_626


; =============== S U B	R O U T	I N E =======================================


sub_668:				; CODE XREF: sub_626+2Ep
		cmp.b	#0, r2l
		beq	sub_672:8
		jsr	@@off_6A:8
		cmp.b	r2l, r0l
		bra	loc_676:8
; End of function sub_668


; =============== S U B	R O U T	I N E =======================================


sub_672:				; CODE XREF: sub_626+26p sub_668+2j
		jsr	@@off_6A:8
		cmp.b	r0l, r2l

loc_676:				; CODE XREF: sub_668+8j
		mov.b	r0h, r0l
		bcs	loc_684:8
		cmp.b	r2h, r1l
		bcs	loc_680:8
		rts
; ---------------------------------------------------------------------------

loc_680:				; CODE XREF: sub_672+Aj
		inc.b	r1l
		rts
; ---------------------------------------------------------------------------

loc_684:				; CODE XREF: sub_672+6j
		mov.b	#0, r1l
		rts
; End of function sub_672


; =============== S U B	R O U T	I N E =======================================


sub_688:				; CODE XREF: sub_626+24p

; FUNCTION CHUNK AT 06B6 SIZE 00000046 BYTES

		cmp.b	#0, r2l
		beq	loc_6C6:8
		mov.b	r0h, r0h
		beq	loc_692:8
		inc.b	r0h

loc_692:				; CODE XREF: sub_688+6j
		inc.b	r0h
; End of function sub_688


; =============== S U B	R O U T	I N E =======================================


sub_694:				; CODE XREF: sub_6FC+Ep ROM:072Cp
		mov.b	r0h, @TCRV0:8
		bset	#5, @TCRV0:8

loc_69A:				; CODE XREF: sub_694+Aj
		btst	#7, @TCRV0:8
		beq	loc_69A:8
		mov.w	r1, e0
		cmp.b	#4, r0h
		bcs	loc_6A8:8
		subx	#4, r0h

loc_6A8:				; CODE XREF: sub_694+10j
		add.b	r0h, r0h
		mov.w	#0xFFB0, r1
		add.b	r0h, r1l
		mov.b	@r1, r0h
		mov.w	e0, r1
		rts
; End of function sub_694

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_688

loc_6B6:				; CODE XREF: sub_688+40j
		jsr	@@off_AA:8
		cmp.b	#1, r0h
		mov.b	@PDR5:8, r0h
		and.b	#0x21, r0h
		bcs	loc_6CE:8
		bld	#6, r0l
		bst	#0, r0h
		bra	loc_6CE:8
; ---------------------------------------------------------------------------

loc_6C6:				; CODE XREF: sub_688+2j
		jsr	@@off_7A:8
		bcs	loc_6B6:8
		mov.b	@PDR5:8, r0h
		and.b	#0x20, r0h

loc_6CE:				; CODE XREF: sub_688+36j sub_688+3Cj
		rotr.b	r0h
		rotr.b	r0h
		mov.b	@PDR1:8, r3h
		bld	#6, r3h
		bst	#2, r3h
		bld	#5, @PDR7:8
		bst	#7, r3h
		mov.w	@0xFECC:16, e0
		beq	loc_6EA:8
		cmp.w	#0x4CA,	e0
		bcs	loc_6F0:8

loc_6EA:				; CODE XREF: sub_688+5Aj
		btst	#2, @0xA:8
		beq	loc_6F6:8

loc_6F0:				; CODE XREF: sub_688+60j
		bld	#6, @0x11:8
		bst	#5, r3h

loc_6F6:				; CODE XREF: sub_688+66j
		and.b	#0xB7, r3h
		or.b	r3h, r0h
		rts
; END OF FUNCTION CHUNK	FOR sub_688

; =============== S U B	R O U T	I N E =======================================


sub_6FC:				; CODE XREF: ROM:036Cp
		mov.w	#0x177,	r3
		mov.w	#0x19, r2

loc_704:				; CODE XREF: sub_6FC+16j
		mov.w	#0x1F4,	r1

loc_708:				; CODE XREF: sub_6FC+24j
		mov.b	#0, r0h
		bsr	sub_694:8
		cmp.b	#0x50, r0h ; 'P'
		bcs	loc_71C:8
		dec.w	#1, r3
		bne	loc_704:8
		bild	#7, r2h

loc_716:				; CODE XREF: sub_6FC+26j
		mov.b	r0h, @0xFE67:16
		rts
; ---------------------------------------------------------------------------

loc_71C:				; CODE XREF: sub_6FC+12j
		dec.w	#1, r2
		dec.w	#1, r1
		bne	loc_708:8
		bra	loc_716:8
; End of function sub_6FC

; ---------------------------------------------------------------------------

loc_724:				; CODE XREF: ROM:loc_28Cp ROM:02DAp
		bsr	sub_78E:8
		mov.b	#0, r0h

loc_728:				; CODE XREF: ROM:0732j
		mov.b	r0h, r3l

loc_72A:				; CODE XREF: ROM:0740j
		mov.b	#0, r0h
		jsr	sub_694:16
		cmp.b	r0h, r3l
		bcs	loc_728:8
; ---------------------------------------------------------------------------
problem32_38:	.byte 0x7A ; z
		.byte	 0
		.byte 0xE
		.byte 0x54 ; T
		.byte 0x11
		.byte 0x43 ; C
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	r0, r2
		bsr	sub_780:8
		bcs	loc_72A:8
		cmp.b	#0x50, r3l ; 'P'
		bxor	#4, @2:8
		bist	#6, @0x11:8
		mov.b	#0, r1h
		mov.b	@0xFE66:16, r1l
		cmp.b	#0x8A, r1l ; ''
		bcc	loc_75A:8
		cmp.b	#0x77, r1l ; 'w'
		bcc	loc_760:8

loc_75A:				; CODE XREF: ROM:0754j
		mov.b	#0x80, r1l ; ''
		jsr	@@off_D2:8
		beq	loc_772:8

loc_760:				; CODE XREF: ROM:0758j
		add.b	#0xFD, r3l ; ''
		bcs	loc_766:8
		mov.b	#0, r3l

loc_766:				; CODE XREF: ROM:0762j
		mov.b	#0x93, r2l ; ''
		mulxu.b	r3l, r2
		sub.w	e2, e2
		jsr	@@off_CA:8
		cmp.b	#0, r2h
		beq	loc_774:8

loc_772:				; CODE XREF: ROM:075Ej
		mov.b	#0xFF, r2l

loc_774:				; CODE XREF: ROM:0770j
		mov.b	r2l, @0xFE67:16
		rts

; =============== S U B	R O U T	I N E =======================================


sub_77A:				; CODE XREF: ROM:0282p	ROM:02F0p ...
		bsr	sub_780:8
		bcs	sub_77A:8
		rts
; End of function sub_77A


; =============== S U B	R O U T	I N E =======================================


sub_780:				; CODE XREF: sub_440+Ep ROM:073Ep ...
		mov.w	@0xFEB8:16, r0
		mov.w	@0xFF86:16, r1
		sub.w	r0, r1
		cmp.w	r2, r1
		rts
; End of function sub_780


; =============== S U B	R O U T	I N E =======================================


sub_78E:				; CODE XREF: ROM:loc_724p sub_78E+6j
		mov.w	#0x7AB,	r2
		bsr	sub_780:8
		bcs	sub_78E:8
		sub.w	e1, e1
; End of function sub_78E


; =============== S U B	R O U T	I N E =======================================


sub_798:				; CODE XREF: sub_798+8j sub_7AE+4p
		mov.b	#5, r0h
		bld	#0, r0l

loc_79C:				; CODE XREF: sub_798+Ej
		mov.b	@PDR5:8, r0l
		bxor	#0, r0l
		bcs	sub_798:8
		bor	#0, r0l
		dec.b	r0h
		bne	loc_79C:8
		bcc	locret_7AC:8
		dec.w	#1, e1

locret_7AC:				; CODE XREF: sub_798+10j sub_7AE+2j
		rts
; End of function sub_798


; =============== S U B	R O U T	I N E =======================================


sub_7AE:				; CODE XREF: ROM:0294p	ROM:02E2p
		jsr	@@off_7A:8
		bcs	locret_7AC:8
		bsr	sub_798:8
		shll.w	e1
		btst	#6, @0x11:8
		beq	loc_7C8:8
		mov.b	@0xFE6C:16, r0l
		bst	#6, r0l
		mov.b	r0l, @0xFE6C:16
		rts
; ---------------------------------------------------------------------------

loc_7C8:				; CODE XREF: sub_7AE+Cj
		mov.b	@0xFE62:16, r0l
		bst	#6, r0l
		mov.b	r0l, @0xFE62:16
		rts
; End of function sub_7AE


; =============== S U B	R O U T	I N E =======================================


sub_7D4:				; CODE XREF: ROM:loc_298p
		mov.b	@0xFE00:16, r1l
		mov.b	@0xFE65:16, r0l
		cmp.b	#0x40, r0l ; '@'
		band	#2, @9:8
		bcc	loc_7F4:8
		mov.b	#0x23, r1l ; '#'
		mov.b	r1l, @0xFE00:16
		mov.b	#0, r0l
		mov.b	r0l, @0xFE14:16
		jsr	sub_9FE:16

loc_7F4:				; CODE XREF: sub_7D4+Ej
		mov.b	@0xFE68:16, r0l
		mov.b	@0xFE69:16, r1h
		cmp.b	r0l, r1l
		beq	loc_802:8
		mov.b	#0, r1h

loc_802:				; CODE XREF: sub_7D4+2Aj
		cmp.b	#0xFF, r1h
		beq	loc_81E:8
		inc.b	r1h
		mov.w	#0x120F, r0
		cmp.b	r0l, r1h
		bne	loc_814:8
		bset	#4, @0xC:8

loc_814:				; CODE XREF: sub_7D4+3Aj sub_7D4+4Ej
		mov.b	r1h, @0xFE69:16
		mov.b	r1l, @0xFE68:16
		rts
; ---------------------------------------------------------------------------

loc_81E:				; CODE XREF: sub_7D4+30j
		bset	#2, @9:8
		bra	loc_814:8
; End of function sub_7D4


; =============== S U B	R O U T	I N E =======================================


sub_824:				; CODE XREF: ROM:029Cp
		mov.w	#0xFE92, r5
		mov.w	#0xFE78, r6
		mov.b	@0xFE73:16, r3l
		mov.b	#0, r3h
		bld	#1, @EBR2:8
		bcs	loc_83C:8
		bset	#2, r3l
		bra	loc_886:8
; ---------------------------------------------------------------------------

loc_83C:				; CODE XREF: sub_824+12j
		bclr	#1, @EBR2:8
		mov.w	#0xFF8A, r1
		jsr	sub_89E:16
		bior	#2, r3l
		btst	#7, @EBR2:8
		beq	loc_866:8
		mov.w	e2, e2
		bmi	loc_866:8
		bclr	#7, @EBR2:8
		btst	#0, r3l
		beq	loc_86A:8

loc_85C:				; CODE XREF: sub_824+40j
					; sub_824:loc_86Aj ...
		mov.w	#0xFFFF, e3
		bra	loc_870:8
; ---------------------------------------------------------------------------

loc_862:				; CODE XREF: sub_824+6Ej
		or.b	#7, r3h
		bra	loc_85C:8
; ---------------------------------------------------------------------------

loc_866:				; CODE XREF: sub_824+2Aj sub_824+2Ej
		btst	#0, r3l
		beq	loc_86C:8

loc_86A:				; CODE XREF: sub_824+36j
		bcc	loc_85C:8

loc_86C:				; CODE XREF: sub_824+44j
		btst	#1, r3l
		bne	loc_85C:8

loc_870:				; CODE XREF: sub_824+3Cj
		mov.w	@r6, r2
		cmp.w	r2, e3
		bcs	loc_878:8
		mov.w	e3, @r6

loc_878:				; CODE XREF: sub_824+50j
		and.b	#0xF0, r3l
		add.b	#0x10, r3l
		bcc	loc_886:8
		mov.w	@r6, r0
		mov.w	r0, @r5
		sub.w	r0, r0
		mov.w	r0, @r6

loc_886:				; CODE XREF: sub_824+16j sub_824+58j
		btst	#7, @EBR2:8
		beq	loc_896:8
		bclr	#7, @EBR2:8
		btst	#0, r3l
		bne	loc_862:8
		bset	#0, r3l

loc_896:				; CODE XREF: sub_824+66j
		or.b	r3h, r3l
		mov.b	r3l, @0xFE73:16
		rts
; End of function sub_824


; =============== S U B	R O U T	I N E =======================================


sub_89E:				; CODE XREF: sub_824+20p sub_89E+Ej ...
		mov.w	@r1, e2
		mov.w	@(4:16,r1), e1
		mov.w	@r1, e3
		mov.w	@(4:16,r1), e0
		cmp.w	e2, e3
		bne	sub_89E:8
		cmp.w	e1, e0
		bne	sub_89E:8
		sub.w	e0, e3
		rts
; End of function sub_89E


; =============== S U B	R O U T	I N E =======================================


sub_8B6:				; CODE XREF: ROM:02A0p
		mov.b	@0xFE63:16, r1l
		mov.w	#0xFE76, r2
		mov.w	#0xFE55, r3
		mov.w	#0xFE5B, r4
		bsr	sub_8CC:8
		mov.b	@0xFE64:16, r1l
; End of function sub_8B6


; =============== S U B	R O U T	I N E =======================================


sub_8CC:				; CODE XREF: sub_8B6+10p
		mov.b	#0, r1h
		mov.w	@r2, r0
		add.w	r1, r0
		add.b	#0x10, r0h
		bcc	loc_8F6:8
		mov.b	#0, r1l
		andc	#0xFE, ccr ; ''
		mov.b	#4, r1h
		jsr	@@off_D0:8
		mov.b	r0l, @r3
		mov.b	@r4, r1l
		inc.b	r1l
		beq	loc_8F4:8
		mov.b	r1l, @r4
		mov.w	@(-3:16,r4), r1
		mov.b	#0, r0h
		add.w	r0, r1
		mov.w	r1, @(-3:16,r4)

loc_8F4:				; CODE XREF: sub_8CC+18j
		sub.w	r0, r0

loc_8F6:				; CODE XREF: sub_8CC+8j
		mov.w	r0, @r2
		dec.w	#2, r2
		dec.w	#1, r3
		dec.w	#1, r4
		rts
; End of function sub_8CC


; =============== S U B	R O U T	I N E =======================================


sub_900:				; CODE XREF: ROM:loc_2D0p

; FUNCTION CHUNK AT 2CFC SIZE 00000012 BYTES

		mov.w	#0xFE37, r1
		mov.b	#4, r2l
		jsr	@@off_DC:8
		mov.b	@r1, r0h
		inc.b	r0h
		mov.b	r0h, @r1
		cmp.b	#0, r0l
		beq	loc_914:8
		rts
; ---------------------------------------------------------------------------

loc_914:				; CODE XREF: sub_900+10j
		mov.w	#0x1E19, r0
		jsr	@@off_6C:8
		mov.b	r0l, @-r1
		bset	#1, @7:8
		mov.w	#0xFE2A, r1
		mov.b	#0xD, r2l
		jsr	@@off_DC:8
		mov.w	#0xFE22, r1
		mov.b	#4, r2l
		jmp	loc_2CFC:16
; End of function sub_900

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_934

loc_932:				; CODE XREF: sub_934+Aj
		orc	#4, ccr
; END OF FUNCTION CHUNK	FOR sub_934

; =============== S U B	R O U T	I N E =======================================


sub_934:				; CODE XREF: ROM:01D0p

; FUNCTION CHUNK AT 0932 SIZE 00000002 BYTES

		bld	#7, @SCR1:8
		bor	#0, @IENR1:8
		bcs	loc_948:8
		bne	loc_932:8
		bclr	#0, @IENR3:8
		bset	#0, @IENR1:8

loc_948:				; CODE XREF: sub_934+8j
		mov.b	@0xFE3B:16, r0l
		bld	#5, r0l
		bcc	sub_980:8
		btst	#4, r0l
		bne	loc_978:8
		btst	#2, @0xE:8
		bne	loc_960:8
		bset	#2, @0xE:8
		bra	loc_96E:8
; ---------------------------------------------------------------------------

loc_960:				; CODE XREF: sub_934+24j
		jsr	@@off_D2:8
		beq	sub_980:8
		btst	#7, @0xF:8
		bne	sub_980:8
		bset	#7, @0xF:8

loc_96E:				; CODE XREF: sub_934+2Aj
		btst	#2, @2:8
		beq	sub_980:8
		jsr	@@off_E8:8
		bra	sub_980:8
; ---------------------------------------------------------------------------

loc_978:				; CODE XREF: sub_934+1Ej
		bclr	#7, @0xF:8
		bclr	#2, @0xE:8
; End of function sub_934


; =============== S U B	R O U T	I N E =======================================


sub_980:				; CODE XREF: ROM:0182p	sub_934+1Aj ...
		jsr	@@off_D2:8
		beq	loc_99E:8
		btst	#6, @2:8
		beq	loc_98E:8
		bset	#7, @0xF:8

loc_98E:				; CODE XREF: sub_980+8j
		bior	#7, @0xF:8
		biand	#6, @8:8
		bcs	loc_99E:8
		mov.b	#0x96, r0l ; ''
		mov.b	r0l, @0xFE38:16

loc_99E:				; CODE XREF: sub_980+2j sub_980+16j
		mov.w	#0x124,	r0
		mov.b	#2, r4l
		mov.b	#0x1C, r3l
		mov.b	#0x79, r1h ; 'y'
		mov.b	#8, r1l
		mov.w	r0, e0
		jsr	@@off_E2:8
		beq	loc_9C0:8
		bset	#4, r1l
		bld	#6, @0x10:8
		bst	#7, r1h
		mov.b	#0x50, r0l ; 'P'
		mov.b	r0l, @PCR7:8
		dec.b	r3l
		inc.w	#2, e0

loc_9C0:				; CODE XREF: sub_980+2Ej
		mov.w	e0, r0
		mov.b	r1h, @PCR8:8
		bld	#6, @0x11:8
		bst	#6, r1l
		mov.b	r1l, @PWCR:8
; End of function sub_980


; =============== S U B	R O U T	I N E =======================================


sub_9CC:				; CODE XREF: ROM:017Ep
		mov.b	#0xFF, r1h
; End of function sub_9CC


; =============== S U B	R O U T	I N E =======================================


sub_9CE:				; CODE XREF: ROM:01A0p	sub_9CE+18j
		mov.b	@r0+, r1l
		mov.b	@r0+, r2l
		mov.b	#0xFF, r2h
		cmp.b	r3l, r4l
		bcs	loc_9DA:8
		mov.b	@r0+, r2h

loc_9DA:				; CODE XREF: sub_9CE+8j
		mov.b	@r1, r3h
		and.b	r2h, r3h
		cmp.b	r2l, r3h
		beq	loc_9E4:8
		mov.b	r2l, @r1

loc_9E4:				; CODE XREF: sub_9CE+12j
		dec.b	r3l
		bgt	sub_9CE:8
; End of function sub_9CE


; =============== S U B	R O U T	I N E =======================================


sub_9E8:				; CODE XREF: sub_3012+4p
		bild	#0, @0:8
		bst	#1, @PDR5:8
		rts
; End of function sub_9E8

; ---------------------------------------------------------------------------
		.word 0xC0
		.word 0x30F0

; =============== S U B	R O U T	I N E =======================================


sub_9F6:				; CODE XREF: ROM:loc_1BEp
		mov.b	@0xE:8,	r0l
		bld	#6, r0l
		bst	#7, r0l
		bra	loc_A04:8
; End of function sub_9F6


; =============== S U B	R O U T	I N E =======================================


sub_9FE:				; CODE XREF: sub_7D4+1Cp
		mov.b	@0xE:8,	r0l
		bset	#7, r0l
		bclr	#6, r0l

loc_A04:				; CODE XREF: sub_9F6+6j
		mov.b	r0l, @0xE:8
		rts
; End of function sub_9FE

; ---------------------------------------------------------------------------
A_0A08:		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
A_0B00:		.byte 0x80, 0xA0, 0xA, 0xA0, 0xA8, 0xA,	0xA8, 0xBC, 0xA
		.byte 0xBC, 0xDC, 0xB, 0xBC, 0xCC, 0xC,	0xCC, 0xDC, 0xD
		.byte 0xDC, 0xEE, 0xE, 0xDC, 0xEE, 0xF,	0xEE, 0xF8, 0x10
		.byte 0xF8, 0xFA, 0xB, 0xF8, 0xFA, 0xC,	0x3E, 0x5C, 0x11
		.byte 0x3E, 0x5C, 0x1A,	0, 0xFD, 0x80, 0xFD, 0xBC, 0xFD
		.byte 0xBC, 0xFD, 0xDC,	0xFD, 0xDC, 0xFD, 0xF8,	0x13, 0x88
		.byte 0x14, 0x5E, 0x17,	0xA2, 0x16, 0x3C, 0x16,	0xBC, 0x19
		.byte 0xA8, 0x1F, 0x26,	0x20, 0x28, 0x17, 0x58,	0x13, 0x9A
		.byte 0x13, 0xB0, 0x17,	0x5C, 0x17, 0x7E, 0x17,	0x7E, 0x14
		.byte 0x1C, 0x14, 0x26,	0x20, 0x22, 0x20, 0x22,	0x21, 4
		.byte 0x21, 4, 0x20, 0x26, 0x20, 0x26, 0x20, 0x26, 0x20
		.byte 0x26, 0x20, 0xA2,	0x20, 0xE0, 0x21, 0x3A,	0x21, 0x36
		.byte 0x20, 0x94, 0x20,	0x94, 0x20, 0x94, 0x20,	0x94, 0x27
		.byte 0x78, 0x27, 0xF2,	0x28, 0x90, 0x2B, 0xD6,	0x29, 0x42
		.byte 0x28, 0x44, 0x27,	0xDC, 0x2A, 0x12, 0x27,	0x9A, 0
		.byte 0, 0, 0, 0, 0, 0xD, 0x9A,	0xE, 0x60, 0xE,	0x7C, 0xE
		.byte 0xF4, 9, 2, 0x7B,	0x34, 0x20, 0x3F, 0x41,	0x46, 0x67
		.byte 0x84, 0x87, 0x3F,	0x27, 0x57, 0x5B, 0x8A,	0x3F, 0x72
		.byte 0xD6, 0xC6, 0xC8,	0xD0, 0xD6, 0xBE, 0xC4,	0xC2, 0xC0
		.byte 0xD4, 0xD8, 0xD6,	0xD6, 0xD6, 0xCA, 0xCE,	0xFE, 0x98
		.byte 0xFE, 0x27, 0xFE,	0x91, 1, 0x10, 8, 0x11,	1, 0x10
		.byte 0x20, 8, 0x15, 0x4E, 0x82, 0xA0, 0xBE, 0xDC, 0xF5
		.byte 0xFF, 0x1B, 9, 8,	0
; ---------------------------------------------------------------------------

loc_BD0:				; CODE XREF: ROM:0EFAp
					; sub_F56:loc_10BAp
		mov.w	r4, r3
		beq	loc_BDC:8

loc_BD4:				; CODE XREF: ROM:0C04j
		inc.b	r6l
		mov.b	r6l, r0l
		and.b	#0xF, r0l
		beq	locret_C00:8

loc_BDC:				; CODE XREF: ROM:0BD2j
		sub.w	r0, r0
		mov.b	r6l, r0l
		and.b	#0xF, r0l
		mov.w	#0xFDCC, r1
		add.w	r0, r1
		mov.b	@r1, r4l
		mov.w	#0xFDBC, r1
		add.w	r0, r1
		mov.b	@r1, r4h
		mov.w	r3, r0
		beq	loc_C02:8
		bld	#7, r3h
		bxor	#7, r4h
		mov.w	r4, r0
		bne	locret_C00:8
		cmp.w	r3, r0

locret_C00:				; CODE XREF: ROM:0BDAj	ROM:0BFCj
		rts
; ---------------------------------------------------------------------------

loc_C02:				; CODE XREF: ROM:0BF4j
		mov.w	r4, r0
		beq	loc_BD4:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_C08:				; CODE XREF: sub_C0E+2Cp
					; sub_F56:loc_109Cp
		bld	#6, r5l
		bor	#2, r5l
		rts
; End of function sub_C08


; =============== S U B	R O U T	I N E =======================================


sub_C0E:				; CODE XREF: sub_F56+17Cp

; FUNCTION CHUNK AT 0D0E SIZE 00000028 BYTES

		push.w	r0
		mov.w	#0xFE1E, r3
		btst	#7, @r3
		bne	loc_C20:8
		add.b	#4, r7l
		jmp	loc_D0E:16
; ---------------------------------------------------------------------------

loc_C20:				; CODE XREF: sub_C0E+Aj
		mov.w	e6, r1
		bld	#6, r1h
		band	#2, r5l
		jsr	sub_251E:16
		mov.b	#0, r0h
		bst	#5, r0h
		jsr	@@off_B2:8
		mov.b	#0, r2h
		jsr	@@off_E2:8
		bhi	loc_C3C:8
		jsr	@@off_7A:8
		bcs	loc_C46:8
		bsr	sub_C08:8

loc_C3C:				; CODE XREF: sub_C0E+26j
		bist	#0, r2h
		bcc	loc_C88:8
		bld	#3, r1l
		bor	#3, r5l
		bcs	loc_C82:8

loc_C46:				; CODE XREF: sub_C0E+2Aj
		bild	#6, r1h
		bcs	loc_C82:8
		bld	#2, r5l
		bcs	loc_C7E:8
		btst	#1, @0xA:8
		beq	loc_C56:8
		bset	#0, r2h

loc_C56:				; CODE XREF: sub_C0E+44j
		btst	#0, @4:8
		bne	loc_C66:8
		mov.b	#0xFF, r1l
		bset	#0, @4:8
		mov.b	r1l, @0xFE2A:16

loc_C66:				; CODE XREF: sub_C0E+4Cj
		mov.b	#0x10, r0l
		mov.b	@0xFE2A:16, r3l
		jsr	@@off_60:8
		jsr	@@off_E4:8
		beq	loc_C8C:8
		mov.b	r3l, r3l
		bne	loc_C8C:8
		bset	#0, r2h
		bset	#2, @6:8
		bra	loc_C88:8
; ---------------------------------------------------------------------------

loc_C7E:				; CODE XREF: sub_C0E+3Ej
		mov.b	#0x10, r0l
		jsr	@@off_C2:8

loc_C82:				; CODE XREF: sub_C0E+36j sub_C0E+3Aj
		band	#7, r5h
		biand	#5, r5h
		bcs	loc_C92:8

loc_C88:				; CODE XREF: sub_C0E+30j sub_C0E+6Ej
		bclr	#0, @4:8

loc_C8C:				; CODE XREF: sub_C0E+62j sub_C0E+66j
		mov.b	#3, r0l
		mov.b	r0l, @0xFE2B:16

loc_C92:				; CODE XREF: sub_C0E+78j
		mov.w	#0xFE22, r3
		bxor	#2, @6:8
		bcc	loc_CD2:8
		btst	#2, @6:8
		bne	loc_CE0:8
		mov.b	@0xFE2B:16, r0l
		bne	loc_CD2:8
		bset	#1, @IENR3:8
		bset	#2, @6:8
		bclr	#0, @4:8
		mov.b	#2, r0l

loc_CB6:				; CODE XREF: sub_C0E+B6j
		btst	#6, @r3
		bne	loc_CC0:8
		bclr	#7, @r3

loc_CC0:				; CODE XREF: sub_C0E+ACj
		inc.w	#2, r3
		dec.b	r0l
		bne	loc_CB6:8
		mov.b	#0x3C, r0l ; '<'
		mov.b	r0l, @0xFE31:16
		sub.w	r0, r0
		mov.w	r0, @0xFE2A:16

loc_CD2:				; CODE XREF: sub_C0E+8Cj sub_C0E+98j ...
		bld	#2, @6:8
		mov.b	@0xFE1E:16, r0l
		biand	#6, r0l
		pop.w	r0
		rts
; ---------------------------------------------------------------------------

loc_CE0:				; CODE XREF: sub_C0E+92j
		bld	#0, r2h
		bcc	loc_CE6:8
		bsr	sub_CFE:8

loc_CE6:				; CODE XREF: sub_C0E+D4j
		bclr	#2, @6:8
		bclr	#0, @4:8
		jsr	sub_1328:16
		bset	#7, @r3
		inc.w	#2, r3
		bset	#7, @r3
		bra	loc_CD2:8
; End of function sub_C0E


; =============== S U B	R O U T	I N E =======================================


sub_CFE:				; CODE XREF: ROM:0372p	sub_C0E+D6p ...
		jsr	@@off_E4:8
		beq	locret_D0C:8
		mov.b	@0xFE02:16, r0l
		bst	#5, r0l
		mov.b	r0l, @0xFE02:16

locret_D0C:				; CODE XREF: sub_CFE+2j
		rts
; End of function sub_CFE

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_C0E

loc_D0E:				; CODE XREF: sub_C0E+Ej
		mov.b	#0xFF, r0l
		mov.b	r0l, @0xFE1A:16
		jsr	sub_13D0:16
		bld	#6, @r3

loc_D1C:				; CODE XREF: sub_1340+44j
		bsr	sub_D4E:8
		mov.b	r0l, r6h
		mov.w	#0xBFFF, r0
		mov.w	r0, @0xFE28:16
		bsr	sub_D46:8
		bset	#3, @4:8
		bset	#4, @7:8
		bset	#7, @r3
; END OF FUNCTION CHUNK	FOR sub_C0E

; =============== S U B	R O U T	I N E =======================================


sub_D36:				; CODE XREF: sub_4AA+Aj sub_23B6+1Ap
					; DATA XREF: ...
		bclr	#7, @6:8
		orc	#1, ccr

loc_D3C:				; CODE XREF: sub_302+22j
		jsr	@@off_D2:8
		beq	locret_D44:8
		bst	#0, @PDR2:8

locret_D44:				; CODE XREF: sub_D36+8j
		rts
; End of function sub_D36


; =============== S U B	R O U T	I N E =======================================


sub_D46:				; CODE XREF: sub_C0E+11Ap
					; ROM:loc_1BECp
		mov.b	#0, r0l
		mov.b	r0l, @0xFE9A:16
		rts
; End of function sub_D46


; =============== S U B	R O U T	I N E =======================================


sub_D4E:				; CODE XREF: sub_C0E:loc_D1Cp
		bcs	loc_D70:8
; End of function sub_D4E


; =============== S U B	R O U T	I N E =======================================


sub_D50:				; CODE XREF: sub_D88:loc_D8Ep
		mov.w	#0xFE2A, r0
		mov.w	#0xFE31, r1
		jsr	@@off_A0:8
		mov.w	#0xFE22, r0
		mov.w	#0xFE26, r1
		jsr	sub_2CB0:16
		mov.w	#0xFE86, r0
		mov.w	#0xFE90, r1
		jsr	@@off_A0:8

loc_D70:				; CODE XREF: sub_D4Ej
		mov.w	#0xFF09, r1
		mov.w	#0xFF04, r0
		jsr	@@off_A0:8
; End of function sub_D50


; =============== S U B	R O U T	I N E =======================================


sub_D7A:				; CODE XREF: sub_DFA+Ep
					; sub_F56:loc_1108p
					; DATA XREF: ...
		bclr	#7, @0x29:8
		sub.w	r0, r0
		mov.w	r0, @0xFE1A:16
		and.b	#0xF8, r6h
		rts
; End of function sub_D7A


; =============== S U B	R O U T	I N E =======================================


sub_D88:				; CODE XREF: sub_2526+BAp
		mov.b	#0xFF, r0l
		mov.b	r0l, @0xFE1D:16

loc_D8E:				; CODE XREF: ROM:0DDAj	ROM:loc_13A2p
		bsr	sub_D50:8
		jsr	sub_1168:16
		and.b	#0x3F, r0l
		mov.b	r0l, @r1
		rts
; End of function sub_D88

; ---------------------------------------------------------------------------

Mloc_0d9a:
		jsr	@@off_C6:8
		beq	loc_DEC:8
		mov.b	@0xFE00:16, r0l
		cmp.b	#0x23, r0l ; '#'
		bhi	loc_DEC:8
		mov.b	r0l, r3h
		mov.w	#0xB1B,	r4
		mov.b	#0xFF, r6h
		mov.b	@0xFD92:16, r6l
		jsr	@@off_C4:8
		mov.b	@r5, r3h
		dec.b	r3h
		mov.w	#0xB1E,	r4
		mov.b	@0xFD95:16, r6l
		jsr	@@off_C4:8
		mov.b	@r5, r2h
		and.b	#0x3F, r2h
		mov.b	@0xFE00:16, r0l
		mov.w	#0xFE1E, r3
		mov.b	@r3, r0h
		bld	#7, r0h
		biand	#1, @6:8
		bcc	loc_DDE:8
		cmp.b	#1, r2h
		beq	loc_D8E:8
		bra	loc_DEC:8
; ---------------------------------------------------------------------------

loc_DDE:				; CODE XREF: ROM:0DD6j
		mov.b	r0l, @0xFE20:16
		mov.b	@0xFE1C:16, r6h
		bsr	sub_DFA:8
		mov.b	r6h, @0xFE1C:16

loc_DEC:				; CODE XREF: ROM:0D9Cj	ROM:0DA4j ...
		bclr	#6, @0xA:8
		bset	#2, @9:8
		bclr	#4, @0xC:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_DFA:				; CODE XREF: ROM:0DE6p	ROM:1420p
		and.b	#0xC0, r0h
		bmi	loc_E04:8
		mov.b	r0l, r0l
		beq	loc_E04:8
		bsr	sub_E12:8

loc_E04:				; CODE XREF: sub_DFA+2j sub_DFA+6j
		or.b	r0l, r0h
		jsr	@@off_94:8
		jsr	@@off_98:8
		bclr	#7, r6h
		bclr	#1, @6:8
		rts
; End of function sub_DFA


; =============== S U B	R O U T	I N E =======================================


sub_E12:				; CODE XREF: sub_DFA+8p
		mov.w	r0, r4
		mov.b	#0x80, r0l ; ''
		jsr	@@off_64:8
		bclr	#0, @2:8
		mov.w	#0xFF20, r0
		mov.w	#0xFF38, r1
		jsr	@@off_A0:8
		mov.w	r4, r0
		mov.b	r0l, r1l
		inc.b	r1l
		mov.b	r1l, @0x20:8
; End of function sub_E12

; START	OF FUNCTION CHUNK FOR sub_E30

locret_E2E:				; CODE XREF: sub_E30+1Cj
		rts
; END OF FUNCTION CHUNK	FOR sub_E30

; =============== S U B	R O U T	I N E =======================================


sub_E30:				; CODE XREF: ROM:0E8Cp	sub_F56+5Ep

; FUNCTION CHUNK AT 0E2E SIZE 00000002 BYTES
; FUNCTION CHUNK AT 2E4E SIZE 00000060 BYTES

		mov.b	#0xFF, r0h
		mov.b	#0xFF, r6h
		mov.b	#0xFF, r6l
		bra	loc_E40:8
; ---------------------------------------------------------------------------

loc_E38:				; CODE XREF: ROM:0E6Cp	ROM:0E72p
		inc.b	r3h

loc_E3A:				; CODE XREF: ROM:0E66p	ROM:0F30p
		mov.b	#0xFF, r6h
		mov.b	#0xFF, r6l

loc_E3E:				; CODE XREF: ROM:0DB2p	ROM:0DC0p ...
		mov.b	#0xFD, r0h ; ''

loc_E40:				; CODE XREF: sub_E30+6j
		mov.b	r0h, r1h
		mov.b	@r4+, r0l
		mov.b	@r4, r1l
		jsr	@@off_A0:8
		mov.w	r0, r5
		cmp.b	#0xFF, r3h
		beq	locret_E2E:8
		mov.b	@r4+, r0l
		sub.w	r1, r0
		shlr.b	r0l
		mov.b	#0, r1h
		mov.b	@r4+, r1l
		mov.w	r1, e1
		mov.b	r0l, r4h
		jmp	loc_2E4E:16
; End of function sub_E30

; ---------------------------------------------------------------------------

mloc_0e60:
		mov.b	#0, r3h
		mov.w	#0xB00,	r4
		bsr	loc_E3A:8
		mov.w	#0xB03,	r4
		bsr	loc_E38:8
		mov.w	#0xB06,	r4
		bsr	loc_E38:8
		bclr	#5, @0xC:8
		mov.b	#0, r0l
		bra	loc_EDE:8
; ---------------------------------------------------------------------------

mloc_0e7c:
		mov.b	@0xFE1E:16, r0l
		and.b	#0x3F, r0l
		cmp.b	#0x23, r0l ; '#'
		bhi	locret_EF2:8
		mov.b	r0l, r3h
		mov.w	#0xB24,	r4
		bsr	sub_E30:8
		mov.b	@0xFF41:16, r0l
		mov.b	r0l, @0xFEAB:16
		mov.w	#0xB09,	r4
		mov.b	#0xFF, r6h
		mov.b	@0xFD92:16, r6l
		bsr	loc_E3E:8
		mov.b	@0xFE1D:16, r0l
		and.b	#0xF0, r0l
		jsr	@@off_78:8
		mov.b	#0, r0h
		mov.w	#0xFDBC, r1
		add.w	r0, r1
		mov.w	@r1, r0
		mov.w	r0, @0xFDFA:16
		mov.w	#0xB0C,	r4
		mov.b	@0xFD95:16, r6l
		mov.b	@0xFDFA:16, r3h
		bsr	sub_EE0:8
		mov.w	#0xB0F,	r4
		mov.b	@0xFD96:16, r6h
		mov.b	@0xFD93:16, r6l
		mov.b	@0xFDFB:16, r3h
		bsr	sub_EE0:8
		bclr	#6, @0xC:8
		mov.b	#1, r0l

loc_EDE:				; CODE XREF: ROM:0E7Aj
		bra	loc_F40:8

; =============== S U B	R O U T	I N E =======================================


sub_EE0:				; CODE XREF: ROM:0EC4p	ROM:0ED6p
		dec.b	r3h
		jmp	loc_E3E:16
; End of function sub_EE0


; =============== S U B	R O U T	I N E =======================================


sub_EE6:				; CODE XREF: ROM:0F50p	sub_F56+1Ap
		mov.w	@r5+, r1
		mov.w	@r5+, r2
		sub.w	r1, r2
		jsr	@@off_AE:8
		mov.b	@r3+, r0h
		cmp.b	r0h, r0l

locret_EF2:				; CODE XREF: ROM:0E84j
		rts
; End of function sub_EE6

; ---------------------------------------------------------------------------

mloc_0ef4:
		mov.b	@r6, r6h
		sub.w	r4, r4

loc_EF8:				; CODE XREF: ROM:0F12j	ROM:0F38j
		mov.b	r6h, r6l
		jsr	loc_BD0:16
		bls	loc_F3A:8
		mov.b	r6l, r6h
		and.b	#0x3C, r0h
		cmp.b	#0x30, r0h ; '0'
		beq	loc_F14:8
		and.b	#0x38, r0h
		cmp.b	#0x10, r0h
		beq	loc_F1C:8
		cmp.b	#0x28, r0h ; '('
		beq	loc_F24:8
		bra	loc_EF8:8
; ---------------------------------------------------------------------------

loc_F14:				; CODE XREF: ROM:0F06j
		push.w	r4
		mov.w	#0xB18,	r4
		bra	loc_F2A:8
; ---------------------------------------------------------------------------

loc_F1C:				; CODE XREF: ROM:0F0Cj
		push.w	r4
		mov.w	#0xB12,	r4
		bra	loc_F2A:8
; ---------------------------------------------------------------------------

loc_F24:				; CODE XREF: ROM:0F10j
		push.w	r4
		mov.w	#0xB15,	r4

loc_F2A:				; CODE XREF: ROM:0F1Aj	ROM:0F22j
		push.w	r6
		mov.b	r0l, r3h
		dec.b	r3h
		jsr	loc_E3A:16
		pop.w	r6
		pop.w	r4
		bra	loc_EF8:8
; ---------------------------------------------------------------------------

loc_F3A:				; CODE XREF: ROM:0EFEj
		bclr	#7, @0xC:8
		mov.b	#2, r0l

loc_F40:				; CODE XREF: ROM:loc_EDEj
		mov.w	#0xB28,	r5
		mov.w	#0xFEAC, r3
		add.b	r0l, r3l
		add.b	r0l, r0l
		add.b	r0l, r0l
		add.b	r0l, r5l
		bsr	sub_EE6:8
		mov.b	r0l, @-r3
		rts

; =============== S U B	R O U T	I N E =======================================


sub_F56:				; CODE XREF: ROM:02B4p

; FUNCTION CHUNK AT 0FC8 SIZE 0000019A BYTES
; FUNCTION CHUNK AT 117E SIZE 0000000E BYTES
; FUNCTION CHUNK AT 119A SIZE 00000052 BYTES
; FUNCTION CHUNK AT 11FE SIZE 0000004C BYTES
; FUNCTION CHUNK AT 313C SIZE 0000006A BYTES
; FUNCTION CHUNK AT 31E0 SIZE 00000004 BYTES
; FUNCTION CHUNK AT 320A SIZE 00000020 BYTES

		sub.w	e7, e7
		jsr	sub_22E2:16
		mov.w	#0xFE1D, r6
		mov.w	#0xB28,	r5
		mov.w	#0xB34,	r4
		mov.w	#0xFEAC, r3

loc_F6C:				; CODE XREF: sub_F56+1Ej
		cmp.w	r4, r5
		bcc	loc_F80:8
		jsr	sub_EE6:16
		beq	loc_F6C:8
		mov.w	r3, r0
		sub.w	#0xFEA8, r0
		bset	r0l, @0xC:8

loc_F80:				; CODE XREF: sub_F56+18j
		mov.b	@0xC:8,	r0h
		and.b	#0xF1, r0h
		mov.b	@0xB:8,	r0l
		btst	#7, @6:8
		bne	loc_F90:8
		and.w	#0xF000, r0

loc_F90:				; CODE XREF: sub_F56+34j
		mov.w	r0, r0
		beq	loc_FC8:8
		mov.b	#0, r3h

loc_F96:				; CODE XREF: sub_F56+48j
		shlr.b	r0h
		rotxr.b	r0l
		bcs	loc_FA0:8
		inc.b	r3h
		bra	loc_F96:8
; ---------------------------------------------------------------------------

loc_FA0:				; CODE XREF: sub_F56+44j
		mov.w	#0xB8C,	r1
		mov.b	r3h, r0l
		subx	#0xB, r0l
		bcc	loc_FBE:8
		btst	#7, @6:8
		beq	loc_FC8:8
		mov.w	#0xB21,	r4
		jsr	sub_E30:16
		mov.w	#0xB74,	r1
		mov.b	r3h, r0l

loc_FBE:				; CODE XREF: sub_F56+52j
		jmp	@@off_D4:8
; End of function sub_F56


; =============== S U B	R O U T	I N E =======================================


sub_FC0:				; CODE XREF: sub_688:loc_6C6p sub_7AEp ...
		mov.b	@0xFD94:16, r0h
		bild	#2, r0h
		rts
; End of function sub_FC0

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_F56

loc_FC8:				; CODE XREF: sub_F56+3Cj sub_F56+58j
		mov.b	#0x1E, r0l
		mov.b	r0l, @0xFE36:16
		btst	#6, @0x11:8
		beq	loc_FF0:8
		mov.b	@0xFE6C:16, r1l
		mov.b	r1l, r5l
		mov.b	@0xFE62:16, r0l
		mov.b	r0l, r0h
		xor.b	r1l, r0l
		xor.b	#0xFF, r0l
		and.b	#0xB, r0l
		xor.b	r0l, r5l
		and.b	#0xB, r5l
		xor.b	r0h, r0l
		and.b	#0xB, r0l
		bra	loc_FFE:8
; ---------------------------------------------------------------------------

loc_FF0:				; CODE XREF: sub_F56+7Cj
		mov.b	@0xFE6C:16, r5l
		and.b	#0xB, r5l
		mov.b	@0xFE62:16, r0l
		mov.b	r0l, r1l
		and.b	#0xB, r0l

loc_FFE:				; CODE XREF: sub_F56+98j
		jsr	@@off_A2:8
		or.b	r0l, r5l
		and.b	#0x40, r1l
		or.b	r1l, r5l
		jsr	@@off_7A:8
		bcc	loc_100E:8
		bld	#6, r5l
		bra	loc_1010:8
; ---------------------------------------------------------------------------

loc_100E:				; CODE XREF: sub_F56+B2j
		bld	#7, r5l

loc_1010:				; CODE XREF: sub_F56+B6j
		bst	#2, r5l
		mov.b	@0xFE02:16, r5h
		sub.w	r0, r0
		mov.b	@0xFE83:16, r0l
		mov.w	r0, e5
		mov.w	@0xFE80:16, e6
		mov.w	@0xFE1C:16, r6
		btst	#2, @9:8
		beq	loc_103C:8
		mov.b	@0xFE35:16, r0l
		beq	loc_1040:8
		cmp.b	#0x3C, r0l ; '<'
		bls	loc_103C:8
		mov.b	#0x3C, r0l ; '<'
		mov.b	r0l, @0xFE35:16

loc_103C:				; CODE XREF: sub_F56+D4j sub_F56+DEj ...
		jmp	loc_11B4:16
; ---------------------------------------------------------------------------

loc_1040:				; CODE XREF: sub_F56+DAj
		jsr	sub_124A:16
		jsr	@@off_9A:8
		jsr	sub_1544:16
		jsr	sub_2BA8:16
		jsr	@@off_C6:8
		bne	loc_10A6:8
		mov.b	@0xFE97:16, r4l
		mov.b	#2, r0h
		jsr	@@off_B2:8
		mov.w	@0xFE22:16, r0
		btst	#6, r0h
		bne	loc_1068:8
		jsr	sub_23DE:16
		bra	loc_108E:8
; ---------------------------------------------------------------------------

loc_1068:				; CODE XREF: sub_F56+10Aj
		btst	#7, r5h
		bne	loc_1074:8
		mov.b	#0, r0l
		mov.b	r0l, @0xFE97:16
		bra	loc_1086:8
; ---------------------------------------------------------------------------

loc_1074:				; CODE XREF: sub_F56+114j
		cmp.b	#0, r4l
		bne	loc_1092:8
		mov.b	@0xFE8E:16, r3h
		mov.b	@8:8, r3l
		jsr	sub_2606:16
		jsr	sub_4D2:16

loc_1086:				; CODE XREF: sub_F56+11Cj sub_F56+13Ej ...
		btst	#3, r5l
		beq	loc_108E:8
		and.w	#0xBFFF, e6

loc_108E:				; CODE XREF: sub_F56+110j sub_F56+132j
		jmp	loc_11A0:16
; ---------------------------------------------------------------------------

loc_1092:				; CODE XREF: sub_F56+120j
		cmp.b	#0xD, r4l
		bne	loc_1086:8
		or.w	#0x400,	e6
		bra	loc_1086:8
; ---------------------------------------------------------------------------

loc_109C:				; CODE XREF: sub_F56+180j
		jsr	sub_C08:16
		bcc	loc_103C:8
		jmp	loc_11A6:16
; ---------------------------------------------------------------------------

loc_10A6:				; CODE XREF: sub_F56+FAj
		mov.b	@6:8, r0l
		and.b	#0x87, r0l
		mov.b	r0l, @6:8
		sub.w	r4, r4
		mov.b	r4l, @0xFE88:16
		mov.b	r4l, @0xFE94:16
		mov.b	r4l, @0xFEF2:16

loc_10BA:				; CODE XREF: sub_F56+170j
					; ROM:loc_1758j
		jsr	loc_BD0:16
		beq	loc_10F0:8
		bcs	loc_1134:8
		btst	#3, @6:8
		bne	loc_10BA:8
		jsr	sub_1340:16
		and.b	#0x3F, r0h
		cmp.b	#3, r0h
		bcs	loc_10D8:8
		jsr	sub_C0E:16
		bcc	loc_109C:8

loc_10D8:				; CODE XREF: sub_F56+17Aj
		mov.w	#0xB34,	r1
		and.b	#0x38, r0h
		mov.b	r0h, r0l
		jsr	@@off_78:8
		mov.b	@4:8, r3h

loc_10E4:				; CODE XREF: sub_F56:loc_FBEj
					; ROM:1398j ...
		shll.b	r0l
		mov.b	#0, r0h
		add.w	r0, r1
		mov.w	@r1, r0
		bld	#7, r6h
		jmp	@r0
; ---------------------------------------------------------------------------

loc_10F0:				; CODE XREF: sub_F56+168j
		andc	#0xEF, ccr ; ''
		mov.w	r3, r0
		bne	loc_1136:8

loc_10F6:				; CODE XREF: sub_F56+1C6j ROM:13B6j
		bsr	sub_1168:8
		beq	loc_110A:8
		btst	#2, r6h
		bne	loc_1108:8
		mov.b	@0xFE1A:16, r0l
		beq	loc_1108:8

loc_1104:				; CODE XREF: sub_F56+1C2j
		and.b	#0xF0, r0l
		mov.b	r0l, r6l

loc_1108:				; CODE XREF: sub_F56+1A6j sub_F56+1ACj
		jsr	@@off_98:8

loc_110A:				; CODE XREF: sub_F56+1A2j
		mov.b	r6l, r0l
		beq	loc_117E:8
		bset	#6, @0xC:8
		bra	loc_111E:8
; ---------------------------------------------------------------------------

loc_1114:				; CODE XREF: sub_F56+1ECj
		bsr	sub_1162:8
		add.b	r6l, r0l
		bra	loc_1104:8
; ---------------------------------------------------------------------------

loc_111A:				; CODE XREF: sub_F56+1FCj
		bsr	sub_1162:8
		beq	loc_10F6:8

loc_111E:				; CODE XREF: sub_F56+1BCj sub_F56+20Aj
		bset	#7, @0xC:8
		mov.b	r6l, @0xFE1D:16

loc_1126:				; CODE XREF: sub_F56+234j ROM:1424j ...
		bclr	#7, r6h
		bclr	#1, @6:8
		jsr	@@off_9C:8
		jsr	sub_159C:16
		bra	loc_11A0:8
; ---------------------------------------------------------------------------

loc_1134:				; CODE XREF: sub_F56+16Aj
		orc	#0x10, ccr

loc_1136:				; CODE XREF: sub_F56+19Ej
		bsr	sub_118C:8
		beq	loc_113E:8
		jsr	sub_207A:16

loc_113E:				; CODE XREF: sub_F56+1E2j
		mov.b	@6:8, r0l
		bor	#4, r0l
		bcc	loc_1114:8
		bild	#4, r0l
		band	#5, r0l
		bcs	loc_114E:8
		btst	#6, r0l
		bne	loc_119A:8

loc_114E:				; CODE XREF: sub_F56+1F2j
		mov.b	@0xFE88:16, r0l
		beq	loc_111A:8
		jsr	@@off_A2:8
		and.b	#0xF, r0l
		mov.b	r6l, r0h
		and.b	#0xF0, r0h
		or.b	r0h, r0l
		mov.b	r0l, r6l
		bra	loc_111E:8
; END OF FUNCTION CHUNK	FOR sub_F56

; =============== S U B	R O U T	I N E =======================================


sub_1162:				; CODE XREF: sub_F56:loc_1114p
					; sub_F56:loc_111Ap
		stc.b	ccr, r0l
		and.b	#0x10, r0l
		rts
; End of function sub_1162


; =============== S U B	R O U T	I N E =======================================


sub_1168:				; CODE XREF: sub_D88+8p
					; sub_F56:loc_10F6p ...
		mov.w	#0xFE18, r2
		mov.w	#0xFE1E, r1
		mov.b	@r1, r0l
		bclr	#6, r0l
		cmp.b	#0xA1, r0l ; ''
		beq	loc_117A:8
		cmp.b	#0xA2, r0l ; ''

loc_117A:				; CODE XREF: sub_1168+Ej
		bld	#7, r0l
		rts
; End of function sub_1168

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_F56

loc_117E:				; CODE XREF: sub_F56+1B6j
		bsr	sub_1168:8
		bcc	loc_11FE:8
		mov.w	@r2, r0
		mov.b	r0l, @r1
		mov.b	r0h, @-r1
		bsr	sub_11F4:8
		bra	loc_1126:8
; END OF FUNCTION CHUNK	FOR sub_F56

; =============== S U B	R O U T	I N E =======================================


sub_118C:				; CODE XREF: sub_F56:loc_1136p
		bsr	sub_1168:8
		beq	locret_1198:8
		bcc	locret_1198:8
		mov.b	@0xFE1D:16, r0h
		mov.w	r0, @r2

locret_1198:				; CODE XREF: sub_118C+2j sub_118C+4j
		rts
; End of function sub_118C

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_F56

loc_119A:				; CODE XREF: sub_F56+1F6j
		bset	#7, r6h
		bset	#7, @6:8

loc_11A0:				; CODE XREF: sub_F56:loc_108Ej
					; sub_F56+1DCj	...
		bld	#1, r5l
		bst	#7, @0xA:8

loc_11A6:				; CODE XREF: sub_F56+14Cj
		jsr	sub_2270:16
		jsr	sub_2526:16
		bcc	loc_11B4:8
		jsr	sub_1328:16

loc_11B4:				; CODE XREF: sub_F56:loc_103Cj
					; sub_F56+258j
		jsr	sub_225A:16
		mov.b	r6h, @0xFE1C:16
		bclr	#1, @7:8
		mov.b	r5l, @0xFE82:16
		jsr	sub_26C4:16
		mov.w	e6, @0xFE80:16
		mov.w	e6, r2
		and.b	#0xF0, r2l
		mov.b	#0xF, r0h
		jsr	sub_23B6:16
		mov.w	e5, r0
		mov.b	r0h, @0xFEA7:16
		mov.b	r0l, @0xFEA6:16
		mov.b	@0xFE33:16, r0l
		bne	locret_11FC:8
		mov.b	#0, r6h
		jmp	sub_2BF0:16
; END OF FUNCTION CHUNK	FOR sub_F56

; =============== S U B	R O U T	I N E =======================================


sub_11EC:				; CODE XREF: sub_DFA+Cp ROM:loc_1976p
					; DATA XREF: ...
		mov.b	r0h, @r3
		mov.b	#0, r0l
		mov.b	r0l, @0xFE1D:16
; End of function sub_11EC


; =============== S U B	R O U T	I N E =======================================


sub_11F4:				; CODE XREF: sub_F56+232p
		bset	#6, @0xC:8
		bset	#7, @0xC:8

locret_11FC:				; CODE XREF: sub_F56+28Ej
		rts
; End of function sub_11F4

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_F56

loc_11FE:				; CODE XREF: sub_F56+22Aj
		bclr	#6, @r1
		btst	#0, @4:8
		bne	loc_1216:8
		mov.w	#0x258,	r0
		mov.w	r0, @0xFE22:16
		bset	#0, @4:8

loc_1214:				; CODE XREF: sub_F56+2D2j sub_F56+2E2j ...
		bra	loc_11A0:8
; ---------------------------------------------------------------------------

loc_1216:				; CODE XREF: sub_F56+2B0j
		mov.w	e6, r0
		btst	#6, r0h
		bne	loc_1224:8
		mov.b	#0x20, r0l ; ' '
		bld	#2, r5l
		bcs	loc_123E:8
		jsr	@@off_60:8

loc_1224:				; CODE XREF: sub_F56+2C4j sub_F56+2F2j
		btst	#0, @2:8
		beq	loc_1214:8
		mov.w	@0xFE24:16, r0
		btst	#6, r0h
		bne	loc_123A:8
		bclr	#7, r0h
		mov.w	r0, @0xFE24:16
		bra	loc_1214:8
; ---------------------------------------------------------------------------

loc_123A:				; CODE XREF: sub_F56+2DAj
		jmp	loc_3146:16
; ---------------------------------------------------------------------------

loc_123E:				; CODE XREF: sub_F56+2CAj
		mov.w	@0xFE22:16, r1
		bild	#6, r1h
		bcs	loc_1214:8
		jsr	@@off_C2:8
		bra	loc_1224:8
; END OF FUNCTION CHUNK	FOR sub_F56

; =============== S U B	R O U T	I N E =======================================


sub_124A:				; CODE XREF: sub_F56:loc_1040p
		mov.b	@0xFE3B:16, r1l
		bld	#5, r1l
		band	#4, r1l
		bcc	loc_126C:8
		btst	#3, r1l
		beq	loc_125E:8
		bset	#0, @0xA:8
		bra	loc_126C:8
; ---------------------------------------------------------------------------

loc_125E:				; CODE XREF: sub_124A+Cj
		btst	#0, @0xA:8
		beq	loc_126C:8
		bset	#0, @8:8
		bclr	#0, @0xA:8

loc_126C:				; CODE XREF: sub_124A+8j sub_124A+12j	...
		btst	#1, r5l
		beq	loc_1274:8
		bclr	#5, @0xA:8

loc_1274:				; CODE XREF: sub_124A+24j
		mov.b	@0xFE1E:16, r1l
		bld	#7, r1l
		biand	#6, r1l
		bcs	loc_1284:8
		bclr	#4, @0xA:8
		bra	loc_128C:8
; ---------------------------------------------------------------------------

loc_1284:				; CODE XREF: sub_124A+32j
		jsr	@@off_7A:8
		bcc	loc_128C:8
		bset	#4, @0xA:8

loc_128C:				; CODE XREF: sub_124A+38j sub_124A+3Cj
		mov.w	#0x12C,	e1
		jsr	@@off_E2:8
		beq	loc_1298:8
		mov.w	#1, e1

loc_1298:				; CODE XREF: sub_124A+48j
		btst	#4, @0x11:8
		bne	loc_12A6:8
		mov.w	@0xFED0:16, e0
		cmp.w	e1, e0
		bcc	loc_130A:8

loc_12A6:				; CODE XREF: sub_124A+52j
		btst	#7, r6h
		beq	loc_12BC:8
		jsr	sub_192C:16
		beq	loc_12BC:8
		cmp.b	#0x20, r0h ; ' '
		bne	loc_130A:8
		mov.b	@0xFE83:16, r0l
		cmp.b	#0x3C, r0l ; '<'
		bcc	loc_130A:8

loc_12BC:				; CODE XREF: sub_124A+5Ej sub_124A+64j
		mov.w	@0xFECC:16, r0
		beq	loc_12C8:8
		cmp.w	#0x730,	r0
		bcs	loc_130A:8

loc_12C8:				; CODE XREF: sub_124A+76j
		mov.b	@0xFE54:16, r0l
		mov.b	@0xFD84:16, r0h
		btst	#2, r5l
		beq	loc_12D6:8
		subx	#4, r0h

loc_12D6:				; CODE XREF: sub_124A+88j
		cmp.b	r0l, r0h
		bcc	loc_12E4:8
		mov.b	@0xFD86:16, r0h
		cmp.b	r0h, r0l
		biand	#1, r5l
		bcs	loc_130A:8

loc_12E4:				; CODE XREF: sub_124A+8Ej
		bld	#7, r5h
		biand	#5, r5h
		bcc	loc_12EE:8

loc_12EA:				; CODE XREF: sub_124A+C4j
		bld	#4, @0xA:8

loc_12EE:				; CODE XREF: sub_124A+9Ej
		bor	#5, @0xA:8
		bcs	loc_12F8:8
		bld	#3, r5l
		biand	#1, r5l

loc_12F8:				; CODE XREF: sub_124A+A8j
		mov.w	e6, r0
		bor	#3, r0l
		jsr	@@off_E4:8
		beq	loc_1302:8
		biand	#5, r5h

loc_1302:				; CODE XREF: sub_124A+B4j
		bcs	locret_1308:8
		bclr	#1, @0xA:8

locret_1308:				; CODE XREF: sub_124A:loc_1302j
		rts
; ---------------------------------------------------------------------------

loc_130A:				; CODE XREF: sub_124A+5Aj sub_124A+68j ...
		bset	#4, @0xA:8
		bra	loc_12EA:8
; End of function sub_124A


; =============== S U B	R O U T	I N E =======================================


sub_1310:				; CODE XREF: sub_F56+EEp
					; DATA XREF: ROM:off_9Ao
		mov.w	#0, r2
		bra	loc_1332:8
; End of function sub_1310


; =============== S U B	R O U T	I N E =======================================


sub_1316:				; CODE XREF: sub_F56+1D6p
					; ROM:mloc_177ep
					; DATA XREF: ...
		jsr	sub_23AC:16
		bne	locret_134C:8
		mov.w	#0xFFFF, r2
		mov.w	@0xFE80:16, r0
		andc	#0xFE, ccr ; ''
		bra	loc_1334:8
; End of function sub_1316


; =============== S U B	R O U T	I N E =======================================


sub_1328:				; CODE XREF: sub_C0E+E0p sub_F56+25Ap
		mov.w	#0x4000, r2
; End of function sub_1328


; =============== S U B	R O U T	I N E =======================================


sub_132C:				; CODE XREF: sub_2270+20p
		bclr	#7, @6:8

loc_1330:				; CODE XREF: ROM:loc_1EFEp
		andc	#0xFE, ccr ; ''

loc_1332:				; CODE XREF: sub_1310+4j
		mov.w	e6, r0

loc_1334:				; CODE XREF: sub_1316+10j
		and.b	r2h, r0h
		bor	#6, r0h
		bst	#6, r0h
		and.b	r2l, r0l
		mov.w	r0, e6
		rts
; End of function sub_132C


; =============== S U B	R O U T	I N E =======================================


sub_1340:				; CODE XREF: sub_F56+172p
		mov.w	#0xFE1E, r3
		mov.b	@r3, r2l
		bld	#6, r2l
		band	#7, r2l
		bcs	loc_134E:8

locret_134C:				; CODE XREF: sub_1316+4j sub_1340+38j
		rts
; ---------------------------------------------------------------------------

loc_134E:				; CODE XREF: sub_1340+Aj
		push.w	r0
		jsr	sub_13D0:16
		mov.w	#0xFE22, r2
		mov.b	@r2, r0h
		mov.b	@0xFE2D:16, r0l
		bne	loc_1374:8
		mov.b	#1, r0l
		btst	#7, r0h
		bne	loc_1368:8
		mov.b	#5, r0l

loc_1368:				; CODE XREF: sub_1340+24j
		mov.b	r0l, @0xFE2D:16
		bild	#7, r0h
		bior	#7, r5h
		bst	#7, r0h
		mov.b	r0h, @r2

loc_1374:				; CODE XREF: sub_1340+1Ej
		bld	#6, r0h
		pop.w	r0
		bcc	locret_134C:8
		bset	#0, @0x24:8
		bclr	#6, @r3
		subx	#0xFD, r7l ; ''
		jmp	loc_D1C:16
; End of function sub_1340

; ---------------------------------------------------------------------------

mloc_1388:
		mov.w	#0xB44,	r1
		mov.b	r4h, r0h
		and.b	#7, r0h
		mov.b	r0h, r0l
		mov.w	#0xFE1E, r3
		mov.b	@r3, r2l
		jmp	@@off_D4:8
; ---------------------------------------------------------------------------

mloc_139A:
		btst	#7, r2l
		beq	loc_13A2:8
		bset	#0, @2:8

loc_13A2:				; CODE XREF: ROM:139Cj
		jsr	loc_D8E:16
		mov.w	#0x8005, r0
		mov.w	r0, @0xFE24:16
		jmp	@@off_B6:8
; ---------------------------------------------------------------------------

mloc_13b0:
		bcs	loc_13C4:8
		btst	#7, r2l
		beq	loc_13BA:8
		jmp	loc_10F6:16
; ---------------------------------------------------------------------------

loc_13BA:				; CODE XREF: ROM:13B4j
		mov.b	#0x1E, r0l
		mov.b	r0l, @0xFE2A:16
		mov.b	r4l, r1l
		bsr	loc_13EC:8

loc_13C4:				; CODE XREF: ROM:mloc_13b0j
		mov.b	@0xFE2A:16, r0l
		bne	loc_13CE:8
		bclr	#6, @r3

loc_13CE:				; CODE XREF: ROM:13C8j
		jmp	@@off_7E:8

; =============== S U B	R O U T	I N E =======================================


sub_13D0:				; CODE XREF: sub_C0E+106p sub_1340+10p
		mov.b	#3, r0l
		jsr	@@off_A6:8
		bne	locret_13FC:8
		mov.b	@0xFE1A:16, r1l
		cmp.b	r0l, r1l
		beq	locret_13FC:8
		mov.b	r0l, @0xFE1A:16
		mov.b	r0l, r1l
		bne	loc_13EC:8
		mov.w	#0xFFFF, r0
		bra	loc_13F8:8
; ---------------------------------------------------------------------------

loc_13EC:				; CODE XREF: ROM:13C2p	sub_13D0+14j
		bset	#6, @r3
		mov.w	#0x258,	r0
		jsr	@@off_A8:8
		bset	#7, r0h

loc_13F8:				; CODE XREF: sub_13D0+1Aj
		mov.w	r0, @0xFE22:16

locret_13FC:				; CODE XREF: sub_13D0+4j sub_13D0+Cj ...
		rts
; End of function sub_13D0

; ---------------------------------------------------------------------------

mloc_13fe:
		mov.b	@0xFE00:16, r0l
		mov.b	@0xFE69:16, r2l
		cmp.b	r0l, r4l
		bne	loc_1414:8
		mov.b	#4, r0l
		jsr	sub_3DC4:16
		cmp.b	r0l, r2l
		bcc	locret_13FC:8

loc_1414:				; CODE XREF: ROM:1408j
		orc	#1, ccr
		bset	#6, @0xA:8
		jmp	@@off_B2:8
; ---------------------------------------------------------------------------

mloc_141c:
		mov.b	r2l, r0h
		mov.b	r4l, r0l
		jsr	sub_DFA:16
		jmp	@@off_92:8
; ---------------------------------------------------------------------------

mloc_1426:
		mov.b	r4l, @0xFE1B:16
		jmp	@@off_B6:8

; =============== S U B	R O U T	I N E =======================================


msub_142C:				; CODE XREF: ROM:1472p	ROM:1496p
		jsr	@@off_9E:8
		bne	loc_143C:8
		bild	#7, @7:8
		bcc	loc_143A:8
		jsr	sub_15FA:16

loc_143A:				; CODE XREF: msub_142C+8j msub_1446+6j
		bst	#5, r6h

loc_143C:				; CODE XREF: msub_142C+2j msub_1446j
		mov.w	#0x12C,	r0
		mov.w	r0, @0xFE24:16
		rts
; End of function msub_142C


; =============== S U B	R O U T	I N E =======================================


msub_1446:				; CODE XREF: ROM:loc_14AAp
		bcs	loc_143C:8
		bset	#7, @7:8
		bra	loc_143A:8
; End of function msub_1446


; =============== S U B	R O U T	I N E =======================================


sub_144E:				; CODE XREF: ROM:loc_1474p
		bld	#3, r5l
		biand	#2, r4h
		bcs	msub_1456:8
		rts
; End of function sub_144E


; =============== S U B	R O U T	I N E =======================================


msub_1456:				; CODE XREF: sub_144E+4j ROM:1460p
		mov.b	#0xFF, r0l
		mov.b	r0l, @0xFE24:16
		rts
; End of function msub_1456

; ---------------------------------------------------------------------------

msub_145e:
		bcs	loc_1474:8
		bsr	msub_1456:8
		bclr	#1, r3h
		btst	#2, r4h
		bne	loc_146E:8
		jsr	sub_1506:16
		bra	loc_1474:8
; ---------------------------------------------------------------------------

loc_146E:				; CODE XREF: ROM:1466j
		btst	#1, r5l
		beq	loc_1474:8
		bsr	msub_142C:8

loc_1474:				; CODE XREF: ROM:msub_145ej ROM:146Cj	...
		bsr	sub_144E:8
		btst	#2, r4h
		bne	loc_1488:8

loc_147A:				; CODE XREF: ROM:14E4j	ROM:14F8j
		jsr	@@off_90:8
		beq	loc_14B2:8
		bld	#1, r5l
		bor	#0, r5l
		bcc	loc_14B2:8

loc_1484:				; CODE XREF: ROM:1BFAj
		mov.b	r3h, @4:8
		jmp	@@off_B6:8
; ---------------------------------------------------------------------------

loc_1488:				; CODE XREF: ROM:1478j
		btst	#1, r5l
		beq	loc_14DC:8
		btst	#7, @0xA:8
		bne	loc_149A:8
		jsr	sub_1548:16
		jsr	msub_142C:16

loc_149A:				; CODE XREF: ROM:1490j
		jsr	@@off_90:8
		beq	loc_14AE:8
		mov.b	#1, r0l
		jsr	@@off_66:8
		bclr	#3, r3h
		bild	#5, r6h
		bcc	loc_14AA:8
		bnot	#1, r3h

loc_14AA:				; CODE XREF: ROM:14A6j
		jsr	msub_1446:16

loc_14AE:				; CODE XREF: ROM:149Cj
		btst	#1, r3h
		bne	loc_14D8:8

loc_14B2:				; CODE XREF: ROM:147Cj	ROM:1482j
		bild	#1, r5l
		bst	#5, @0xA:8
		mov.w	#0xBBC,	r1
		jsr	@@off_E2:8
		beq	loc_14C4:8
		mov.w	#0xBC0,	r1

loc_14C4:				; CODE XREF: ROM:14BEj
		jsr	@@off_9E:8
		bne	loc_14CE:8
		btst	#5, r6h
		bne	loc_14CE:8
		mov.b	#0, r0l

loc_14CE:				; CODE XREF: ROM:14C6j	ROM:14CAj
		mov.b	#0, r0h
		add.w	r0, r1
		mov.b	@r1, r0h
		jsr	@@off_B2:8
		bsr	sub_152A:8

loc_14D8:				; CODE XREF: ROM:14B0j	ROM:1AF8j
		mov.b	r3h, @4:8
		jmp	@@off_B8:8
; ---------------------------------------------------------------------------

loc_14DC:				; CODE XREF: ROM:148Aj
		mov.b	#1, r0l
		jsr	@@off_64:8
		btst	#7, @0xA:8
		beq	loc_147A:8
		bsr	sub_1548:8
		btst	#3, r3h
		beq	loc_14F6:8
		bsr	sub_1564:8
		bcs	loc_14F4:8
		mov.b	r1l, @0xFE1F:16

loc_14F4:				; CODE XREF: ROM:14EEj
		bclr	#3, r3h

loc_14F6:				; CODE XREF: ROM:14EAj
		bsr	sub_1506:8
		bra	loc_147A:8

; =============== S U B	R O U T	I N E =======================================


sub_14FA:				; CODE XREF: sub_1506+6p sub_1E14p
		mov.b	@0xFE1F:16, r1l
		bsr	sub_156E:8
		bcc	locret_1504:8
		mov.b	#0x28, r1l ; '('

locret_1504:				; CODE XREF: sub_14FA+6j
		rts
; End of function sub_14FA


; =============== S U B	R O U T	I N E =======================================


sub_1506:				; CODE XREF: ROM:1468p	ROM:loc_14F6p
		mov.b	#0, r1l
		bsr	sub_1520:8
		beq	loc_150E:8
		bsr	sub_14FA:8

loc_150E:				; CODE XREF: sub_1506+4j
		mov.b	r4l, r0l
		mulxu.b	r1l, r0
		mov.b	@0xFD83:16, r1l
		jsr	@@off_C8:8
		dec.w	#1, r2
		mov.w	r2, @0xFE24:16
		rts
; End of function sub_1506


; =============== S U B	R O U T	I N E =======================================


sub_1520:				; CODE XREF: msub_142Cp ROM:loc_14C4p	...
		mov.b	r4h, r0l
		and.b	#7, r0l
		cmp.b	#6, r0l
		bclr	#2, r0l
		rts
; End of function sub_1520


; =============== S U B	R O U T	I N E =======================================


sub_152A:				; CODE XREF: ROM:14D6p
		andc	#0xFE, ccr ; ''
; End of function sub_152A

; START	OF FUNCTION CHUNK FOR sub_1544

loc_152C:				; CODE XREF: sub_1544+2j
		mov.w	#0xFE28, r1
		bst	#7, @r1
		bcs	locret_1542:8
		mov.b	@0xFE9A:16, r0l
		bne	locret_1542:8
		mov.w	@r1, r0
		mov.b	r0l, @0xFE9A:16

locret_1542:				; CODE XREF: sub_1544-10j sub_1544-Aj
		rts
; END OF FUNCTION CHUNK	FOR sub_1544

; =============== S U B	R O U T	I N E =======================================


sub_1544:				; CODE XREF: sub_F56+F0p

; FUNCTION CHUNK AT 152C SIZE 00000018 BYTES

		orc	#1, ccr
		bra	loc_152C:8
; End of function sub_1544


; =============== S U B	R O U T	I N E =======================================


sub_1548:				; CODE XREF: ROM:1492p	ROM:14E6p

; FUNCTION CHUNK AT 1586 SIZE 00000008 BYTES

		bld	#4, @7:8
		bcc	locret_1562:8
		bld	#3, r3h
		bls	loc_1554:8
		bsr	sub_158E:8

loc_1554:				; CODE XREF: sub_1548+8j
		bne	loc_1558:8
		bcs	loc_1586:8

loc_1558:				; CODE XREF: sub_1548:loc_1554j
		bsr	sub_1594:8
		bsr	sub_1594:8
		mov.w	@0xFE22:16, r0
		mov.w	r0, @r1

locret_1562:				; CODE XREF: sub_1548+4j
		rts
; End of function sub_1548


; =============== S U B	R O U T	I N E =======================================


sub_1564:				; CODE XREF: ROM:14ECp
		mov.b	@0xFE29:16, r0l
		mov.b	@0xFE9A:16, r1l
		sub.b	r0l, r1l
; End of function sub_1564


; =============== S U B	R O U T	I N E =======================================


sub_156E:				; CODE XREF: sub_14FA+4p
		mov.b	@0xFD99:16, r0l
		bne	loc_1576:8
		mov.b	#0x28, r0l ; '('

loc_1576:				; CODE XREF: sub_156E+4j
		cmp.b	r0l, r1l
		bcs	locret_1584:8
		mov.b	@0xFD98:16, r0l
		bne	loc_1582:8
		mov.b	#0x3C, r0l ; '<'

loc_1582:				; CODE XREF: sub_156E+10j
		cmp.b	r1l, r0l

locret_1584:				; CODE XREF: sub_156E+Aj
		rts
; End of function sub_156E

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_1548

loc_1586:				; CODE XREF: sub_1548+Ej
		bclr	#3, r3h
		mov.b	#0, r0l
		mov.b	r0l, @0xFE1F:16
; END OF FUNCTION CHUNK	FOR sub_1548

; =============== S U B	R O U T	I N E =======================================


sub_158E:				; CODE XREF: sub_1548+Ap
		bclr	#4, @7:8
		rts
; End of function sub_158E


; =============== S U B	R O U T	I N E =======================================


sub_1594:				; CODE XREF: sub_1548:loc_1558p
					; sub_1548+12p

; FUNCTION CHUNK AT 2DAC SIZE 00000002 BYTES

		mov.w	#0xFF36, r1
		mov.b	#6, r0h
		jmp	@@off_C0:8
; End of function sub_1594


; =============== S U B	R O U T	I N E =======================================


sub_159C:				; CODE XREF: sub_F56+1D8p
		mov.b	@7:8, r2h
		bclr	#6, r2h
		btst	#3, r2h
		beq	loc_15A6:8
		bclr	#3, r2h

loc_15A6:				; CODE XREF: sub_159C+6j
		btst	#3, @4:8
		bne	loc_15BC:8
		btst	#4, r2h
		beq	loc_15BC:8
		bclr	#4, r2h
		mov.w	#0xFF32, r0
		mov.w	#0xFF38, r1
		jsr	@@off_A0:8

loc_15BC:				; CODE XREF: sub_159C+Ej sub_159C+12j
		mov.b	r2h, @7:8
		rts
; End of function sub_159C

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR msub_15F6

mloc_15C0:				; CODE XREF: msub_15F6+2j
		mov.b	@0xFDFF:16, r0l
		mov.b	r0l, r0h
		add.b	r4l, r0l
		bxor	#7, r0h
		bcc	loc_15D2:8
		mov.b	#0, r0l
		bild	#7, r0h
		subx	#0, r0l

loc_15D2:				; CODE XREF: msub_15F6-2Cj
		mov.b	@0xFE55:16, r0h
		mov.w	@0xFE9E:16, r2
		bne	loc_15E8:8
		cmp.b	r0l, r0h
		bcs	loc_15E8:8
		mov.w	@0xFE22:16, r0
		mov.w	r0, @0xFE9E:16

loc_15E8:				; CODE XREF: msub_15F6-1Cj
					; msub_15F6-18j
		mov.b	r4l, @0xFE94:16
		mov.b	@0xFE63:16, r0l
		cmp.b	r4l, r0l
		mov.b	#6, r2h
		rts
; END OF FUNCTION CHUNK	FOR msub_15F6

; =============== S U B	R O U T	I N E =======================================


msub_15F6:				; CODE XREF: ROM:loc_164Cp

; FUNCTION CHUNK AT 15C0 SIZE 00000036 BYTES

		btst	#2, r4h
		bne	mloc_15C0:8
; End of function msub_15F6


; =============== S U B	R O U T	I N E =======================================


sub_15FA:				; CODE XREF: msub_142C+Ap
		mov.b	r4l, r3l
		btst	#6, @7:8
		bne	loc_161E:8
		mov.b	#0x14, r0l
		jsr	@@off_A4:8
		bcc	loc_160A:8
		mov.b	#0, r3l

loc_160A:				; CODE XREF: sub_15FA+Cj
		mov.b	#5, r0l
		jsr	@@off_A4:8
		bcc	loc_1616:8
		mov.b	@0xFD84:16, r0l
		bsr	sub_1634:8

loc_1616:				; CODE XREF: sub_15FA+14j
		mov.b	#2, r0l
		jsr	@@off_A6:8
		bne	loc_161E:8
		bsr	sub_1634:8

loc_161E:				; CODE XREF: sub_15FA+6j sub_15FA+20j
		cmp.b	r3l, r4l
		beq	loc_1626:8
		bset	#1, @0x24:8

loc_1626:				; CODE XREF: sub_15FA+26j
		mov.b	@0xFE54:16, r0h
		cmp.b	r3l, r0h
		mov.b	#4, r2h
		rts
; End of function sub_15FA

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR mloc_16b8

loc_1630:				; CODE XREF: mloc_16b8+2j mloc_179e+2j
					; DATA XREF: ...
		cmp.b	r0l, r3l
		bra	loc_1636:8
; END OF FUNCTION CHUNK	FOR mloc_16b8

; =============== S U B	R O U T	I N E =======================================


sub_1634:				; CODE XREF: sub_15FA+1Ap sub_15FA+22p ...
		cmp.b	r3l, r0l

loc_1636:				; CODE XREF: mloc_16b8-86j
		bcc	locret_163A:8
		mov.b	r0l, r3l

locret_163A:				; CODE XREF: sub_1634:loc_1636j
		rts
; End of function sub_1634

; ---------------------------------------------------------------------------

loc_163C:
		bcs	loc_1644:8
		btst	#1, r4h
		bne	loc_1644:8
		bsr	sub_1688:8

loc_1644:				; CODE XREF: ROM:loc_163Cj ROM:1640j
		btst	#2, r4h
		beq	loc_164C:8
		mov.b	#2, r0h
		jsr	@@off_B2:8

loc_164C:				; CODE XREF: ROM:1646j
		bsr	msub_15F6:8
		bcc	loc_167E:8
		btst	#0, r4h
		beq	loc_1656:8
		bsr	sub_1688:8

loc_1656:				; CODE XREF: ROM:1652j
		btst	r2h, r6h
		bne	loc_1686:8
		bset	#1, @9:8
		btst	#5, @9:8
		bne	loc_1678:8
		mov.w	#0x400,	r0
		btst	#2, r4h
		beq	loc_1670:8
		mov.w	#2, r0

loc_1670:				; CODE XREF: ROM:166Aj
		btst	#6, @7:8
		bne	loc_1678:8
		bsr	loc_16AE:8

loc_1678:				; CODE XREF: ROM:1662j	ROM:1674j
		btst	#0, r4h
		bne	loc_1686:8

loc_167C:				; CODE XREF: ROM:1680j
		jmp	@@off_B8:8
; ---------------------------------------------------------------------------

loc_167E:				; CODE XREF: ROM:164Ej
		btst	#0, r4h
		bne	loc_167C:8
		orc	#1, ccr
		bsr	sub_168A:8

loc_1686:				; CODE XREF: ROM:1658j	ROM:167Aj
		jmp	@@off_B6:8

; =============== S U B	R O U T	I N E =======================================


sub_1688:				; CODE XREF: ROM:1642p	ROM:1654p
		andc	#0xFE, ccr ; ''
; End of function sub_1688


; =============== S U B	R O U T	I N E =======================================


sub_168A:				; CODE XREF: ROM:1684p
		btst	#2, r4h
		beq	loc_1692:8
		bst	#6, r6h
		rts
; ---------------------------------------------------------------------------

loc_1692:				; CODE XREF: sub_168A+2j
		bst	#4, r6h
		rts
; End of function sub_168A


; =============== S U B	R O U T	I N E =======================================


mloc_1696:				; CODE XREF: ROM:loc_1F12p
		bcc	sub_169C:8
; End of function mloc_1696


; =============== S U B	R O U T	I N E =======================================


sub_1698:				; CODE XREF: ROM:loc_1896p ROM:1A4Ap ...
		mov.b	#0, r0h
		bra	loc_16AE:8
; End of function sub_1698


; =============== S U B	R O U T	I N E =======================================


sub_169C:				; CODE XREF: sub_C0E+20p sub_F56+102p	...
		mov.b	#0x19, r0l
		and.b	r0h, r0l
		beq	loc_16AC:8
		mov.b	@0xFD82:16, r0l
		btst	#0, r0l
		beq	loc_16AC:8
		bset	#5, r0h

loc_16AC:				; CODE XREF: sub_169C+4j sub_169C+Cj
		mov.b	#0, r0l

loc_16AE:				; CODE XREF: ROM:1676p	sub_1698+2j ...
		mov.w	e6, r2
		or.b	r0l, r2l
		or.b	r0h, r2h
		mov.w	r2, e6
		rts
; End of function sub_169C


; =============== S U B	R O U T	I N E =======================================


mloc_16b8:				; CODE XREF: ROM:16D6p	ROM:16DEp ...

; FUNCTION CHUNK AT 1630 SIZE 00000004 BYTES

		and.b	#0x1F, r0l
		jmp	@@off_96:8
; End of function mloc_16b8

; ---------------------------------------------------------------------------

mloc_16bc:
		bcs	loc_171E:8
		mov.b	#0, r0h
		mov.b	r4l, r0l
		btst	#0, r4h
		beq	loc_171A:8
		mov.b	#0, r3l
		btst	#2, r4h
		bne	loc_16EE:8
		mov.b	#0xF, r0l
		jsr	@@off_A4:8
		bcc	loc_16D8:8
		mov.b	@0xFD8D:16, r0l
		bsr	mloc_16b8:8

loc_16D8:				; CODE XREF: ROM:16D0j
		mov.b	#5, r0l
		jsr	@@off_A6:8
		bne	loc_16E0:8
		bsr	mloc_16b8:8

loc_16E0:				; CODE XREF: ROM:16DCj
		mov.b	#4, r0l
		jsr	@@off_A6:8
		bne	loc_16EE:8
		btst	#6, @7:8
		beq	loc_16EE:8
		bsr	mloc_16b8:8

loc_16EE:				; CODE XREF: ROM:16CAj	ROM:16E4j ...
		mov.b	r4l, r0l
		mov.b	#0x3C, r1l ; '<'
		mulxu.b	r1l, r0
		mov.b	r3l, r1l
		beq	loc_171A:8
		push.w	r5
		push.w	r4
		push.w	r0
		mov.b	#3, r1h
		mulxu.b	r1h, r1
		jsr	@@off_A8:8
		mov.w	r0, r2
		mov.b	#0, r1h
		mov.w	r1, e2
		mov.b	#0x64, r1l ; 'd'
		mov.b	#0, r1h
		jsr	@@off_CA:8
		mov.w	r2, r1
		pop.w	r0
		pop.w	r4
		pop.w	r5
		sub.w	r1, r0

loc_171A:				; CODE XREF: ROM:16C4j	ROM:16F6j
		mov.w	r0, @0xFE22:16

loc_171E:				; CODE XREF: ROM:mloc_16bcj
		mov.w	#0xFE22, r1
		btst	#1, r4h
		beq	loc_1730:8
		btst	#1, r5l
		beq	loc_1730:8
		bset	#7, @r1
		bra	loc_173A:8
; ---------------------------------------------------------------------------

loc_1730:				; CODE XREF: ROM:1724j	ROM:1728j
		btst	#6, @r1
		bne	loc_173A:8
		bclr	#7, @r1

loc_173A:				; CODE XREF: ROM:172Ej	ROM:1734j
		bld	#6, r4h
		jsr	loc_1E90:16
		bcs	loc_174E:8
		beq	loc_1758:8

loc_1744:				; CODE XREF: ROM:177Aj	ROM:2048j
		bset	#5, @6:8
		bra	loc_1758:8
; ---------------------------------------------------------------------------

loc_174A:				; CODE XREF: ROM:loc_13CEj
					; ROM:loc_1F24j
					; DATA XREF: ...
		beq	loc_1758:8
		bne	loc_1750:8

loc_174E:				; CODE XREF: ROM:1740j	ROM:18A4j ...
		bne	loc_1758:8

loc_1750:				; CODE XREF: ROM:14DAj	ROM:loc_167Cj ...
		btst	#6, r4h
		beq	loc_1758:8

loc_1754:				; CODE XREF: ROM:178Cj
		bset	#6, @6:8

loc_1758:				; CODE XREF: ROM:13AEj	ROM:142Aj ...
		jmp	loc_10BA:16
; ---------------------------------------------------------------------------

mloc_175c:
		mov.b	r4l, r4l
		beq	loc_1798:8
		sub.w	r0, r0
		mov.b	r4l, r0l
		mov.b	#0x40, r0h ; '@'
		mulxu.b	r0h, r0
		mov.w	@0xFEC8:16, e0
		bpl	loc_1774:8
		xor.w	#0xFFFF, e0
		inc.w	#1, e0

loc_1774:				; CODE XREF: ROM:176Cj
		cmp.w	e0, r0
		bcc	loc_1750:8
		btst	#6, r4h
		beq	loc_1744:8
		bra	loc_1750:8
; ---------------------------------------------------------------------------

mloc_177e:
		jsr	@@off_9C:8
		mov.b	@0xFE00:16, r0l
		cmp.b	r0l, r4l
		beq	loc_1794:8
		bset	#6, @0xA:8
		bra	loc_1754:8
; ---------------------------------------------------------------------------

loc_178E:				; CODE XREF: ROM:1796j
		mov.b	r4l, @0xFE20:16
		bra	loc_1758:8
; ---------------------------------------------------------------------------

loc_1794:				; CODE XREF: ROM:1786j
		btst	#0, r4h
		beq	loc_178E:8

loc_1798:				; CODE XREF: ROM:175Ej
		bset	#1, @6:8
		bra	loc_1750:8

; =============== S U B	R O U T	I N E =======================================


mloc_179e:				; CODE XREF: ROM:17E2p	ROM:17EAp
		and.b	#0xE0, r0l
		jmp	@@off_96:8
; End of function mloc_179e

; ---------------------------------------------------------------------------

mloc_17a2:
		btst	#6, r4h
		beq	loc_17AA:8
		bset	#4, @6:8

loc_17AA:				; CODE XREF: ROM:17A4j
		bclr	#5, @5:8
		band	#7, @6:8
		bcs	loc_17C2:8
		and.b	#0x48, r3h
		sub.w	r0, r0
		mov.w	r0, @0xFE2A:16
		bld	#2, r4h
		bst	#3, @7:8

loc_17C2:				; CODE XREF: ROM:17B2j
		mov.b	@0xFE2B:16, r0l
		beq	loc_17D0:8
		jsr	@@off_AA:8
		mov.b	r0h, r2l
		jmp	loc_1878:16
; ---------------------------------------------------------------------------

loc_17D0:				; CODE XREF: ROM:17C6j
		mov.b	#0, r0l
		mov.b	r0l, @0xFE8A:16
		mov.b	#0, r3l
		mov.b	#0xB, r0l
		jsr	@@off_A4:8
		bcc	loc_17E4:8
		mov.b	@0xFD8D:16, r0l
		bsr	mloc_179e:8

loc_17E4:				; CODE XREF: ROM:17DCj
		mov.b	#5, r0l
		jsr	@@off_A6:8
		bne	loc_17EC:8
		bsr	mloc_179e:8

loc_17EC:				; CODE XREF: ROM:17E8j
		cmp.b	#0, r3l
		beq	loc_17F8:8
		mov.b	r3l, r0l
		jsr	@@off_76:8
		mov.b	r0l, @0xFE8A:16

loc_17F8:				; CODE XREF: ROM:17EEj
		mov.b	#0, r0h
		mov.b	#4, r3l

loc_17FC:				; CODE XREF: ROM:1868j
		btst	#0, r3h
		beq	loc_1832:8
		bclr	#0, r3h
		bnot	#4, r3h
		mov.b	#0, r2l
		mov.b	@0xFDDE:16, r1l
		btst	#4, r3h
		bne	loc_1814:8
		mov.b	@0xFDE1:16, r1l
		bset	#2, r3h

loc_1814:				; CODE XREF: ROM:180Cj
		jsr	sub_18A6:16
		bra	loc_185E:8
; ---------------------------------------------------------------------------

loc_181A:				; CODE XREF: ROM:1842j
		cmp.b	#0x80, r0h ; ''
		beq	loc_1822:8
		btst	#2, r3h
		beq	loc_1828:8

loc_1822:				; CODE XREF: ROM:181Cj
		bset	#5, @5:8
		bset	#5, r3h

loc_1828:				; CODE XREF: ROM:1820j
		mov.b	@0xFDE3:16, r1l
		beq	loc_1844:8
		mov.b	#0x80, r2l ; ''
		bra	loc_186E:8
; ---------------------------------------------------------------------------

loc_1832:				; CODE XREF: ROM:17FEj
		bclr	#4, @6:8
		bld	#5, r3h
		bst	#5, @5:8
		bset	#0, r3h
		mov.b	@0xFE2A:16, r0l
		beq	loc_181A:8

loc_1844:				; CODE XREF: ROM:182Cj
		mov.b	#0x20, r2l ; ' '
		mov.w	#0xFDDC, r0
		mov.b	@r0+, r1l
		mov.b	@r0+, r1h
		btst	#4, r3h
		beq	loc_1858:8
		mov.b	@r0+, r1l
		mov.b	@r0+, r1l
		mov.b	@r0+, r1h

loc_1858:				; CODE XREF: ROM:1850j
		mov.b	r1h, @0xFE83:16
		sub.w	e5, e5

loc_185E:				; CODE XREF: ROM:1818j
		cmp.b	#0, r1l
		beq	loc_1866:8
		bsr	sub_18CE:8
		bra	loc_186E:8
; ---------------------------------------------------------------------------

loc_1866:				; CODE XREF: ROM:1860j
		dec.b	r3l
		bne	loc_17FC:8
		mov.b	#0, r2l
		mov.b	#0, r1l

loc_186E:				; CODE XREF: ROM:1830j	ROM:1864j
		btst	#1, r3h
		beq	loc_1874:8
		mov.b	#0, r2l

loc_1874:				; CODE XREF: ROM:1870j
		mov.b	r1l, @0xFE2B:16

loc_1878:				; CODE XREF: ROM:17CCj
		btst	#0, r4h
		beq	loc_188A:8
		btst	#1, r5l
		beq	loc_188C:8
		mov.b	#0, r0l
		mov.b	r0l, @0xFE2B:16
		bclr	#0, r3h
		bra	loc_1898:8
; ---------------------------------------------------------------------------

loc_188A:				; CODE XREF: ROM:187Aj
		bclr	#3, r3h

loc_188C:				; CODE XREF: ROM:187Ej
		mov.b	r2l, r0l
		cmp.b	#0x80, r0l ; ''
		beq	loc_1896:8
		bld	#4, r3h
		bst	#4, r0l

loc_1896:				; CODE XREF: ROM:1890j
		jsr	@@off_B4:8

loc_1898:				; CODE XREF: ROM:1888j
		btst	#1, r4h
		beq	loc_189E:8
		bsr	sub_1900:8

loc_189E:				; CODE XREF: ROM:189Aj
		mov.b	r3h, @4:8
		btst	#5, @5:8
		jmp	@@off_7C:8

; =============== S U B	R O U T	I N E =======================================


sub_18A6:				; CODE XREF: ROM:loc_1814p
		mov.b	@0xFE2A:16, r0l
		bne	locret_18C6:8
		mov.b	@0xFDE3:16, r0l
		beq	loc_18C8:8
		jsr	sub_1DE6:16
		mov.b	#0x80, r0l ; ''
		bsr	sub_192E:8
		bne	locret_18C6:8
		bnot	#4, r3h

loc_18BE:				; CODE XREF: sub_18A6+24j
		mov.b	@0xFDE2:16, r0l
		mov.b	r0l, @0xFE2A:16

locret_18C6:				; CODE XREF: sub_18A6+4j sub_18A6+14j
		rts
; ---------------------------------------------------------------------------

loc_18C8:				; CODE XREF: sub_18A6+Aj
		btst	#2, r3h
		beq	loc_18BE:8
		rts
; End of function sub_18A6


; =============== S U B	R O U T	I N E =======================================


sub_18CE:				; CODE XREF: ROM:1862p
		btst	#0, r3h
		beq	loc_18F0:8
		btst	#7, r3h
		beq	loc_18DA:8
		mov.b	#6, r1l
		rts
; ---------------------------------------------------------------------------

loc_18DA:				; CODE XREF: sub_18CE+6j
		cmp.b	#4, r1l
		bls	locret_18EE:8
		mov.b	@0xFE8A:16, r0l
		beq	locret_18EE:8
		sub.b	r0l, r1l
		bmi	loc_18EC:8
		cmp.b	#4, r1l
		bcc	locret_18EE:8

loc_18EC:				; CODE XREF: sub_18CE+18j
		mov.b	#4, r1l

locret_18EE:				; CODE XREF: sub_18CE+Ej sub_18CE+14j	...
		rts
; ---------------------------------------------------------------------------

loc_18F0:				; CODE XREF: sub_18CE+2j
		btst	#7, r3h
		beq	loc_18F8:8
		mov.b	#9, r1l
		rts
; ---------------------------------------------------------------------------

loc_18F8:				; CODE XREF: sub_18CE+24j
		mov.b	@0xFE8A:16, r0l
		add.b	r0l, r1l
		rts
; End of function sub_18CE


; =============== S U B	R O U T	I N E =======================================


sub_1900:				; CODE XREF: ROM:189Cp
		btst	#0, r3h
		beq	loc_1914:8
		mov.w	@0xFEC8:16, r0
		bpl	loc_1910:8
		xor.w	#0xFFFF, r0
		inc.w	#1, r0

loc_1910:				; CODE XREF: sub_1900+8j
		mov.w	r0, @0xFEA0:16

loc_1914:				; CODE XREF: sub_1900+2j
		bsr	sub_191E:8
		bne	locret_191C:8
		bset	#0, @0xB:8

locret_191C:				; CODE XREF: sub_1900+16j
		rts
; End of function sub_1900


; =============== S U B	R O U T	I N E =======================================


sub_191E:				; CODE XREF: sub_1900:loc_1914p
		mov.b	#0x20, r0l ; ' '
		bsr	sub_192E:8
		bne	locret_192A:8
		mov.w	e6, r0
		and.b	#0xE0, r0l
		cmp.b	#0, r0l

locret_192A:				; CODE XREF: sub_191E+4j
		rts
; End of function sub_191E


; =============== S U B	R O U T	I N E =======================================


sub_192C:				; CODE XREF: sub_124A+60p
					; ROM:loc_1B1Cp
		mov.b	#0, r0l
; End of function sub_192C


; =============== S U B	R O U T	I N E =======================================


sub_192E:				; CODE XREF: sub_688:loc_6B6p
					; ROM:17C8p ...
		mov.b	@0xFE81:16, r0h
		and.b	#0xE0, r0h
		cmp.b	r0h, r0l
		rts
; End of function sub_192E

; ---------------------------------------------------------------------------

mloc_1938:				; CODE XREF: ROM:1A2Cj
		bset	#1, @0x21:8
		mov.b	#0xA2, r0h ; ''
		bra	loc_1962:8

; =============== S U B	R O U T	I N E =======================================


sub_1940:				; CODE XREF: ROM:mloc_19a8p ROM:1AEAp
		mov.b	@0xFEA7:16, r0h
		mov.b	@0xFEA6:16, r0l
		mov.w	r0, e5
		rts
; End of function sub_1940


; =============== S U B	R O U T	I N E =======================================


sub_194C:				; CODE XREF: ROM:19B8p	sub_23DE+Ap
		mov.b	@0xFE54:16, r0l
		mov.b	@0xFD84:16, r0h
		cmp.b	r0l, r0h
		rts
; End of function sub_194C

; ---------------------------------------------------------------------------

mloc_1958:				; CODE XREF: ROM:19C2j
		bset	#0, @0x21:8
		bset	#2, @7:8
		mov.b	#0xA1, r0h ; ''

loc_1962:				; CODE XREF: ROM:193Ej
		mov.w	#0xFE1E, r3
		jsr	sub_1168:16
		beq	loc_1976:8
		mov.b	@0xFE1D:16, r2h
		mov.b	r0l, r2l
		mov.w	r2, @0xFE18:16

loc_1976:				; CODE XREF: ROM:196Aj
		jsr	@@off_94:8
		jmp	@@off_92:8

; =============== S U B	R O U T	I N E =======================================


sub_197A:				; CODE XREF: ROM:19CAp	ROM:loc_19EEp ...
		jsr	sub_1A78:16
		mov.b	r0l, @0xFE85:16
		mov.b	#0xFF, r3l
		and.b	#8, r3h
		btst	#0, r4h
		beq	loc_199E:8
		cmp.b	#0, r2l
		bne	loc_199E:8
		mov.w	#0x1E0,	r0
		btst	#1, r5l
		beq	loc_199A:8
		mov.w	#0x28, r0 ; '('

loc_199A:				; CODE XREF: sub_197A+1Aj
		mov.w	r0, @0xFE24:16

loc_199E:				; CODE XREF: sub_197A+Ej sub_197A+12j	...
		mov.b	@0xFD81:16, r0l
		mov.b	r0l, @0xFEA4:16
		rts
; End of function sub_197A

; ---------------------------------------------------------------------------

mloc_19a8:
		bsr	sub_1940:8
		mov.b	@0xFE84:16, r3l
		band	#7, @6:8
		bcs	loc_19CC:8
		jsr	sub_1E02:16
		bsr	sub_194C:8
		band	#0, r4h
		biand	#2, @7:8
		biand	#1, r5l
		bcs	mloc_1958:8
		mov.b	#0, r2l
		mov.b	r2l, @0xFE8B:16
		bsr	sub_197A:8

loc_19CC:				; CODE XREF: ROM:19B2j
		btst	#0, r4h
		beq	loc_1A4C:8
		jsr	sub_1E56:16
		bcs	loc_1A04:8
		bld	#1, r5l
		bxor	#7, @0xA:8
		bcc	loc_1A30:8
		btst	#1, r5l
		beq	loc_1A08:8
		cmp.b	#0, r2l
		beq	loc_19F2:8
		mov.w	#0x1E, r0

loc_19EA:				; CODE XREF: ROM:19FEj
		mov.w	r0, @r1
		bra	loc_1A44:8
; ---------------------------------------------------------------------------

loc_19EE:				; CODE XREF: ROM:1A0Aj	ROM:1A28j ...
		bsr	sub_197A:8
		bra	loc_1A44:8
; ---------------------------------------------------------------------------

loc_19F2:				; CODE XREF: ROM:19E4j
		push.w	r1
		jsr	sub_26AC:16
		pop.w	r1
		mov.w	#0x28, r0 ; '('
		bra	loc_19EA:8
; ---------------------------------------------------------------------------

loc_1A00:				; CODE XREF: ROM:1A24j
		bsr	sub_1A78:8
		bra	loc_1A40:8
; ---------------------------------------------------------------------------

loc_1A04:				; CODE XREF: ROM:19D4j
		mov.b	#2, r2l

loc_1A06:				; CODE XREF: ROM:1A38j
		mov.b	#0, r0l

loc_1A08:				; CODE XREF: ROM:19E0j
		cmp.b	#0, r4l
		beq	loc_19EE:8
		cmp.b	#1, r2l
		bcs	loc_1A14:8
		inc.b	r0l
		cmp.b	#0x14, r0l

loc_1A14:				; CODE XREF: ROM:1A0Ej
		mov.w	#0x3C, r0 ; '<'
		mov.w	r0, @r1
		bcc	loc_1A44:8
		inc.b	r2l
		mov.b	r2l, @0xFE8B:16
		btst	#1, r4h
		bne	loc_1A00:8
		cmp.b	#2, r2l
		bcs	loc_19EE:8
		beq	loc_19EE:8
		jmp	mloc_1938:16
; ---------------------------------------------------------------------------

loc_1A30:				; CODE XREF: ROM:19DCj
		beq	loc_1A44:8
		btst	#1, r5l
		bne	loc_1A40:8
		cmp.b	#0, r2l
		bne	loc_1A06:8
		bset	#5, @8:8
		bra	loc_1A44:8
; ---------------------------------------------------------------------------

loc_1A40:				; CODE XREF: ROM:1A02j	ROM:1A34j
		bset	#7, @5:8

loc_1A44:				; CODE XREF: ROM:19ECj	ROM:19F0j ...
		cmp.b	#6, r3l
		beq	loc_1A4C:8
		mov.b	#8, r0l
		jsr	@@off_B4:8

loc_1A4C:				; CODE XREF: ROM:19CEj	ROM:1A46j
		mov.w	#0xFE2A, r1
		jsr	sub_1E96:16
		bior	#5, r3h
		bcs	loc_1A60:8
		sub.w	r0, r0
		mov.w	r0, @r1
		and.b	#0xDE, r3h
		dec.b	r3l

loc_1A60:				; CODE XREF: ROM:1A56j
		mov.b	@r1+, r0h
		mov.w	@0xFED0:16, e0
		beq	loc_1AA0:8
		mov.b	r0h, r0l
		beq	loc_1A96:8
		btst	#6, r3h
		beq	loc_1AA2:8
		mov.b	@0xFE8A:16, r0l
		mov.b	r0l, @r1
		bra	loc_1AD2:8

; =============== S U B	R O U T	I N E =======================================


sub_1A78:				; CODE XREF: sub_197Ap	ROM:loc_1A00p
		sub.w	r0, r0
		mov.w	r0, @0xFE2A:16
		mov.w	r0, @0xFEA0:16
		mov.w	r0, @0xFEA2:16
		bset	#0, @0xC:8
		bclr	#6, r3h
		bclr	#7, @5:8
		bclr	#1, @0x11:8
		rts
; End of function sub_1A78

; ---------------------------------------------------------------------------

loc_1A96:				; CODE XREF: ROM:1A6Aj
		btst	#0, r3h
		bne	loc_1AA0:8
		mov.b	#4, r0l
		mov.b	r0l, @0xFE2A:16

loc_1AA0:				; CODE XREF: ROM:1A66j	ROM:1A98j
		bclr	#6, r3h

loc_1AA2:				; CODE XREF: ROM:1A6Ej
		mov.b	@r1, r0l
		beq	loc_1B24:8
		bld	#0, r3h
		band	#1, @7:8
		bcc	loc_1AD2:8
		mov.b	r0h, r0l
		bne	loc_1AD2:8
		mov.b	@0xFE8A:16, r0l
		mov.b	r0l, @-r1
		mov.b	#2, r1l
		jsr	@@off_CC:8
		mov.b	@0xFE8C:16, r2l
		mov.b	@0xFE89:16, r0h
		add.b	r0h, r2l
		cmp.b	r2l, r0l
		bxor	#7, r0h
		bcc	loc_1ACE:8
		mov.b	r0l, r2l

loc_1ACE:				; CODE XREF: ROM:1ACAj
		jsr	sub_1CE6:16

loc_1AD2:				; CODE XREF: ROM:1A76j	ROM:1AACj ...
		jsr	@@off_AA:8
		mov.b	r0h, r0l

loc_1AD6:				; CODE XREF: ROM:1B20j	ROM:1B5Cj ...
		mov.b	r3l, @0xFE84:16
		jsr	sub_1D44:16
		jsr	@@off_B4:8
		jsr	sub_1DC4:16
		btst	#5, r3h
		beq	loc_1AF4:8
		mov.w	e5, r1
		jsr	sub_1940:16
		cmp.b	r1l, r0l
		bcs	loc_1AF4:8
		mov.w	r1, e5

loc_1AF4:				; CODE XREF: ROM:1AE6j	ROM:1AF0j
		bclr	#3, @0x12:8
		jmp	loc_14D8:16

; =============== S U B	R O U T	I N E =======================================


sub_1AFC:				; CODE XREF: ROM:1B38p
		bld	#1, r5l
		bcc	loc_1B0A:8
		jsr	@@off_90:8
		bne	locret_1B0C:8
		mov.b	@0xFE8B:16, r0l
		bne	locret_1B0C:8

loc_1B0A:				; CODE XREF: sub_1AFC+2j
		bst	#6, r0h

locret_1B0C:				; CODE XREF: sub_1AFC+6j sub_1AFC+Cj
		rts
; End of function sub_1AFC


; =============== S U B	R O U T	I N E =======================================


sub_1B0E:				; CODE XREF: ROM:1B3Ap	ROM:1B6Ap
		mov.b	@0xFE8B:16, r0l
		cmp.b	#3, r0l
		biand	#1, r3h
		bcs	locret_1B1A:8
		bclr	#0, r3h

locret_1B1A:				; CODE XREF: sub_1B0E+8j
		rts
; End of function sub_1B0E

; ---------------------------------------------------------------------------

loc_1B1C:				; CODE XREF: ROM:1B40j
		jsr	sub_192C:16
		beq	loc_1AD6:8
		bra	loc_1B5A:8
; ---------------------------------------------------------------------------

loc_1B24:				; CODE XREF: ROM:1AA4j	ROM:loc_1B6Cj ...
		and.w	#0xFF, e5
		mov.b	#0, r0l
		mov.b	r0l, @0xFE89:16
		mov.b	r0l, @0xFE2A:16
		mov.b	r0l, @0xFE8A:16
		and.b	#0x3F, r3h
		bsr	sub_1AFC:8
		bsr	sub_1B0E:8
		band	#0, r4h
		biand	#6, r0h
		bcs	loc_1B1C:8
		btst	#0, r3h
		beq	loc_1B5E:8
		jmp	loc_1C08:16
; ---------------------------------------------------------------------------

loc_1B4A:				; CODE XREF: ROM:loc_1C1Ej
		jsr	sub_1CFA:16
		bcc	loc_1B5A:8
		bra	loc_1B70:8
; ---------------------------------------------------------------------------

loc_1B52:				; CODE XREF: ROM:1B76j
		cmp.b	#0, r0l
		beq	loc_1B6C:8
		mov.b	#0, r0h
		jsr	@@off_CE:8

loc_1B5A:				; CODE XREF: ROM:1B22j	ROM:1B4Ej
		mov.b	#0x80, r0l ; ''
		jmp	@@off_D6:8
; ---------------------------------------------------------------------------

loc_1B5E:				; CODE XREF: ROM:1B44j
		cmp.b	#5, r3l
		bcs	loc_1B64:8
		bpl	loc_1BBC:8

loc_1B64:				; CODE XREF: ROM:1B60j
		inc.b	r3l
		jsr	sub_1D38:16
		bsr	sub_1B0E:8

loc_1B6C:				; CODE XREF: ROM:1B54j
		bcc	loc_1B24:8
		bset	#0, r3h

loc_1B70:				; CODE XREF: ROM:1B50j
		mov.b	#0, r1l
		jsr	@@off_CC:8
		btst	#7, r0l
		beq	loc_1B52:8
		bclr	#7, r0l
		jsr	sub_1CC8:16
		mov.b	r3l, r0h
		beq	loc_1BDA:8
		mov.b	@(-2:16,r1), r0h
		inc.w	#1, r1
		mov.b	@r1, r2l
		jsr	sub_1EA6:16
		cmp.b	r0h, r2l
		beq	loc_1BB2:8
		mov.b	#1, r1l
		bcc	loc_1B98:8
		neg.b	r1l

loc_1B98:				; CODE XREF: ROM:1B94j
		jsr	sub_2DB8:16
		mov.b	r2l, @0xFE89:16
		bne	loc_1BB2:8
		mov.b	#0, r0h
		divxu.b	r2h, r0
		mov.b	r0l, @0xFE8A:16
		mov.b	r0l, @0xFE2A:16
		mov.b	r1l, @0xFE89:16

loc_1BB2:				; CODE XREF: ROM:1B90j	ROM:1BA0j ...
		bset	#6, @0xB:8
		bset	#7, r3h
		mov.b	#0x40, r0l ; '@'

loc_1BBA:				; CODE XREF: ROM:1BE0j
		jmp	@@off_D6:8
; ---------------------------------------------------------------------------

loc_1BBC:				; CODE XREF: ROM:1B62j
		bclr	#5, r3h
		mov.b	#0x40, r0l ; '@'
		jsr	@@off_AA:8
		beq	loc_1BFE:8
		bld	#0, r4h
		biand	#7, @5:8
		bcs	loc_1C1A:8
		cmp.b	#5, r3l
		bne	loc_1BEC:8
		inc.b	r3l
		mov.b	#0xA, r0l
		mov.b	r0l, @0xFE2B:16
		bra	loc_1C04:8
; ---------------------------------------------------------------------------

loc_1BDA:				; CODE XREF: ROM:1B80j
		mov.b	#0x14, r0h
		jsr	@@off_CE:8
		mov.b	#0xA0, r0l ; ''
		bra	loc_1BBA:8

; =============== S U B	R O U T	I N E =======================================


sub_1BE2:				; CODE XREF: ROM:1BF6p	ROM:loc_1C04p
		mov.b	#0, r0l
		btst	#4, r3h
		beq	locret_1BEA:8
		mov.b	#0x80, r0l ; ''

locret_1BEA:				; CODE XREF: sub_1BE2+4j
		rts
; End of function sub_1BE2

; ---------------------------------------------------------------------------

loc_1BEC:				; CODE XREF: ROM:1BCEj
		jsr	sub_D46:16
		bset	#3, r3h
		bclr	#2, @7:8
		bsr	sub_1BE2:8
		jsr	@@off_B4:8
		jmp	loc_1484:16
; ---------------------------------------------------------------------------

loc_1BFE:				; CODE XREF: ROM:1BC2j
		mov.b	#3, r0l
		mov.b	#0x46, r0h ; 'F'
		jsr	@@off_CE:8

loc_1C04:				; CODE XREF: ROM:1BD8j
		bsr	sub_1BE2:8
		jmp	@@off_D6:8
; ---------------------------------------------------------------------------

loc_1C08:				; CODE XREF: ROM:1B46j
		mov.b	#1, r1l
		jsr	@@off_CC:8
		beq	loc_1C60:8
		mov.b	#0x60, r0l ; '`'
		jsr	@@off_AA:8
		bne	loc_1C22:8
		btst	#4, @0x12:8
		bne	loc_1C1E:8

loc_1C1A:				; CODE XREF: ROM:1BCAj	ROM:1C2Cj
		jmp	loc_1AD2:16
; ---------------------------------------------------------------------------

loc_1C1E:				; CODE XREF: ROM:1C18j
		jmp	loc_1B4A:16
; ---------------------------------------------------------------------------

loc_1C22:				; CODE XREF: ROM:1C12j
		and.b	#0xC0, r0h
		cmp.b	#0x80, r0h ; ''
		bne	loc_1C84:8
		btst	#3, @0x12:8
		beq	loc_1C1A:8
		jsr	loc_199E:16
		jsr	sub_1D00:16
		mov.b	@0xFED2:32, r1l
		mov.b	r1l, @0x2A:8
		cmp.b	r1l, r0l
		bcc	loc_1C5E:8
		jsr	sub_1D20:16
		mov.b	@0xFE85:16, r1h
		inc.b	r1h
		cmp.b	r0h, r1h
		bcc	loc_1C6C:8
		cmp.b	r0l, r1h
		bcs	loc_1C56:8
		bset	#2, r3h

loc_1C56:				; CODE XREF: ROM:1C52j
		mov.b	r1h, @0xFE85:16
		mov.b	#0x60, r0l ; '`'
		jmp	@@off_D6:8
; ---------------------------------------------------------------------------

loc_1C5E:				; CODE XREF: ROM:1C40j
		btst	#2, r3h

loc_1C60:				; CODE XREF: ROM:1C0Cj
		beq	loc_1C84:8
		cmp.b	r1l, r0h
		bcc	loc_1C84:8
		mov.b	@0xFD90:16, r0l
		bra	loc_1C74:8
; ---------------------------------------------------------------------------

loc_1C6C:				; CODE XREF: ROM:1C4Ej
		cmp.b	#0, r3l
		beq	loc_1C7C:8
		mov.b	@0xFD91:16, r0l

loc_1C74:				; CODE XREF: ROM:1C6Aj
		bsr	sub_1CCE:8
		mov.b	r0l, @0xFEA4:16
		bra	loc_1C84:8
; ---------------------------------------------------------------------------

loc_1C7C:				; CODE XREF: ROM:1C6Ej
		sub.w	e5, e5
		bset	#1, r3h
		bclr	#0, r3h
		bra	loc_1C92:8
; ---------------------------------------------------------------------------

loc_1C84:				; CODE XREF: ROM:1C26j	ROM:loc_1C60j ...
		bclr	#0, r3h
		mov.b	#1, r1l
		bsr	sub_1CA6:8
		mov.b	@r1, r2l
		bsr	sub_1CE6:8
		cmp.b	#0, r0l
		bne	loc_1C96:8

loc_1C92:				; CODE XREF: ROM:1C82j
		jmp	loc_1B24:16
; ---------------------------------------------------------------------------

loc_1C96:				; CODE XREF: ROM:1C90j
		mov.b	#0, r2h
		mov.w	r2, e5
		mov.b	#4, r0h
		bsr	sub_1CB8:8
		bset	#5, @0xB:8
		jmp	loc_1BB2:16

; =============== S U B	R O U T	I N E =======================================


sub_1CA6:				; CODE XREF: ROM:1ABAp	ROM:1B72p ...
		mov.b	r3l, r2l
		mov.b	#3, r0l
		mulxu.b	r2l, r0
		add.b	r1l, r0l
		mov.w	#0xFDDC, r1
		add.w	r0, r1
		mov.b	@r1+, r0l
		rts
; End of function sub_1CA6


; =============== S U B	R O U T	I N E =======================================


sub_1CB8:				; CODE XREF: ROM:1B58p	ROM:1BDCp ...
		mov.b	r0h, @0xFE8A:16
		mov.b	r0h, @0xFE2A:16
		beq	loc_1CC6:8
		mov.b	r0l, @0xFE8A:16

loc_1CC6:				; CODE XREF: sub_1CB8+8j
		bset	#6, r3h
; End of function sub_1CB8


; =============== S U B	R O U T	I N E =======================================


sub_1CC8:				; CODE XREF: ROM:1B7Ap
		mov.b	r0l, @0xFE2B:16
		rts
; End of function sub_1CC8


; =============== S U B	R O U T	I N E =======================================


sub_1CCE:				; CODE XREF: ROM:loc_1C74p
		bcs	loc_1CE0:8
		bsr	sub_1CFA:8
		bcc	loc_1CDA:8
		bset	#5, @0x24:8
		rts
; ---------------------------------------------------------------------------

loc_1CDA:				; CODE XREF: sub_1CCE+4j
		bset	#6, @0x24:8
		rts
; ---------------------------------------------------------------------------

loc_1CE0:				; CODE XREF: sub_1CCEj
		bset	#7, @0x24:8
		rts
; End of function sub_1CCE


; =============== S U B	R O U T	I N E =======================================


sub_1CE6:				; CODE XREF: ROM:loc_1ACEp ROM:1C8Cp
		mov.b	@0xFEA4:16, r0h
		cmp.b	r2l, r0h
		bcc	loc_1CF0:8
		mov.b	r0h, r2l

loc_1CF0:				; CODE XREF: sub_1CE6+6j
		mov.b	r2l, @0xFE83:16
		mov.b	r2l, @0xFE8C:16
		rts
; End of function sub_1CE6


; =============== S U B	R O U T	I N E =======================================


sub_1CFA:				; CODE XREF: ROM:loc_1B4Ap sub_1CCE+2p ...
		bld	#1, r4h
		biand	#2, r4h
		rts
; End of function sub_1CFA


; =============== S U B	R O U T	I N E =======================================


sub_1D00:				; CODE XREF: ROM:1C32p
		mov.w	#0xFD88, r1
		mov.b	@r1+, r0l
		mov.b	@r1+, r0h
		btst	#2, r3h
		beq	loc_1D12:8
		mov.b	r0l, r2l
		mov.b	r0h, r0l
		mov.b	r2l, r0h

loc_1D12:				; CODE XREF: sub_1D00+Aj
		bsr	sub_1CFA:8
		bcc	locret_1D1E:8
		mov.b	@r1, r0l
		mov.b	r0l, r0h
		mov.b	#0, r1l
		mov.b	r1l, @0x2C:8

locret_1D1E:				; CODE XREF: sub_1D00+14j sub_1D20+Cj	...
		rts
; End of function sub_1D00


; =============== S U B	R O U T	I N E =======================================


sub_1D20:				; CODE XREF: ROM:1C42p
		mov.w	#0xFD8E, r1
		mov.b	@r1+, r0h
		mov.b	@r1, r0l
		and.b	#0xF, r0l
		bsr	sub_1CFA:8
		bcc	locret_1D1E:8
		mov.b	@r1, r0l
		jsr	@@off_A2:8
		and.b	#0xF, r0l
		mov.b	r0l, r0h
		rts
; End of function sub_1D20


; =============== S U B	R O U T	I N E =======================================


sub_1D38:				; CODE XREF: ROM:1B66p
		mov.b	#2, r1l
		jsr	@@off_CC:8
		cmp.b	#0xFF, r0l
		bne	locret_1D1E:8
		bset	#4, r3h
		rts
; End of function sub_1D38


; =============== S U B	R O U T	I N E =======================================


sub_1D44:				; CODE XREF: ROM:1ADAp
		mov.w	r4, e0
		btst	#7, r3h
		beq	loc_1DB4:8
		mov.b	#0xFF, r4l
		mov.b	@0xFE8C:16, r3l
		mov.b	#1, r0l
		jsr	@@off_A6:8
		bne	loc_1D58:8
		bsr	sub_1DB8:8

loc_1D58:				; CODE XREF: sub_1D44+10j
		mov.b	#4, r0l
		jsr	@@off_A4:8
		bcc	loc_1D6E:8
		mov.b	@0xFE8C:16, r0l
		shlr.b	r0l
		mov.b	#0x28, r0h ; '('
		cmp.b	r0h, r0l
		bcc	loc_1D6C:8
		mov.b	r0h, r0l

loc_1D6C:				; CODE XREF: sub_1D44+24j
		bsr	sub_1DB8:8

loc_1D6E:				; CODE XREF: sub_1D44+18j
		mov.b	#2, r0l
		jsr	@@off_A4:8
		bcc	loc_1D76:8
		mov.b	#0, r3l

loc_1D76:				; CODE XREF: sub_1D44+2Ej
		cmp.b	#0, r3l
		bne	loc_1D82:8
		bset	#3, @0x24:8
		mov.b	#0x80, r0l ; ''
		bra	loc_1DB4:8
; ---------------------------------------------------------------------------

loc_1D82:				; CODE XREF: sub_1D44+34j
		mov.b	@0xFE83:16, r0l
		cmp.b	r0l, r3l
		bcc	loc_1D8E:8
		bset	#2, @0x24:8

loc_1D8E:				; CODE XREF: sub_1D44+44j
		bls	loc_1DA4:8
		jsr	@@off_D2:8
		beq	loc_1DA4:8
		btst	#1, @8:8
		beq	loc_1DA4:8
		jsr	sub_197A:16
		mov.b	r3l, @0xFE84:16
		bra	loc_1DB2:8
; ---------------------------------------------------------------------------

loc_1DA4:				; CODE XREF: sub_1D44:loc_1D8Ej
					; sub_1D44+4Ej	...
		mov.b	r3l, @0xFE83:16
		mov.w	e5, r0
		cmp.b	r0l, r4l
		bcc	loc_1DB2:8
		mov.b	r4l, r0l
		mov.w	r0, e5

loc_1DB2:				; CODE XREF: sub_1D44+5Ej sub_1D44+68j
		mov.b	#0x40, r0l ; '@'

loc_1DB4:				; CODE XREF: sub_1D44+4j sub_1D44+3Cj
		mov.w	e0, r4
		rts
; End of function sub_1D44


; =============== S U B	R O U T	I N E =======================================


sub_1DB8:				; CODE XREF: sub_1D44+12p
					; sub_1D44:loc_1D6Cp
		jsr	sub_1634:16
		cmp.b	r4l, r0l
		bcc	locret_1DC2:8
		mov.b	r0l, r4l

locret_1DC2:				; CODE XREF: sub_1DB8+6j
		rts
; End of function sub_1DB8


; =============== S U B	R O U T	I N E =======================================


sub_1DC4:				; CODE XREF: ROM:1AE0p
		cmp.b	#0x40, r0l ; '@'
		bne	locret_1DE4:8
		mov.b	@0xFD81:16, r0l
		mov.b	@0xFE83:16, r0h
		cmp.b	r0l, r0h
		bcs	locret_1DE4:8
		mov.w	@0xFED0:16, r0
		mov.b	#0xA, r1l
		divxu.b	r1l, r0
		mov.b	@0x2B:8, r0h
		cmp.b	r0l, r0h
		bcc	locret_1DE4:8
		mov.b	r0l, @0x2B:8

locret_1DE4:				; CODE XREF: sub_1DC4+2j sub_1DC4+Ej ...
		rts
; End of function sub_1DC4


; =============== S U B	R O U T	I N E =======================================


sub_1DE6:				; CODE XREF: sub_18A6+Cp
		mov.b	@0x2C:8, r0l
		mov.b	@0x29:8, r0h
		or.b	r0l, r0h
		bne	locret_1DE4:8
		push.w	r2
		push.w	r1
		bsr	sub_1E14:8
		pop.w	r1
		cmp.b	#0, r2h
		beq	loc_1DFC:8
		mov.b	#0xFF, r2l

loc_1DFC:				; CODE XREF: sub_1DE6+12j
		mov.b	r2l, @0x2C:8
		pop.w	r2
		rts
; End of function sub_1DE6


; =============== S U B	R O U T	I N E =======================================


sub_1E02:				; CODE XREF: ROM:19B4p
		mov.w	@0xFE28:16, r2
		mov.w	#0xFF2E, r1
		mov.w	@r1, r0
		beq	loc_1E10:8
		inc.w	#2, r1

loc_1E10:				; CODE XREF: sub_1E02+Aj
		mov.w	r2, @r1
		rts
; End of function sub_1E02


; =============== S U B	R O U T	I N E =======================================


sub_1E14:				; CODE XREF: sub_1DE6+Cp
		jsr	sub_14FA:16
		mov.b	r1l, r2l
		mov.w	@0xFE28:16, r1
		and.b	#0x7F, r1h
		mov.w	#0x3FFF, r0
		sub.w	r1, r0
		beq	locret_1E3A:8
		mov.b	@0xFD83:16, r1l
		jsr	@@off_A8:8
		cmp.b	#0, r1l
		beq	loc_1E36:8
		mov.w	#0xFFFF, r0

loc_1E36:				; CODE XREF: sub_1E14+1Cj
		mov.b	r2l, r1l
		jsr	@@off_C8:8

locret_1E3A:				; CODE XREF: sub_1E14+12j
		rts
; End of function sub_1E14

; ---------------------------------------------------------------------------

loc_1E3C:				; CODE XREF: sub_1E56+Cp ROM:2780p
		bpl	loc_1E40:8
		sub.w	r1, r1

loc_1E40:				; CODE XREF: ROM:loc_1E3Cj
		beq	locret_1E54:8
		jsr	@@off_D2:8
		beq	loc_1E52:8
		bld	#1, @0x11:8
		bcs	locret_1E54:8
; ---------------------------------------------------------------------------
Problem32_39:	.byte 0x7A ; z
		.byte 0x51 ; Q
		.byte 0xFF
		.byte 0xFF
		.byte 0xFF
		.byte 0xFF
; ---------------------------------------------------------------------------

loc_1E52:				; CODE XREF: ROM:1E44j
		andc	#0xFA, ccr ; ''

locret_1E54:				; CODE XREF: ROM:loc_1E40j ROM:1E4Aj
		rts

; =============== S U B	R O U T	I N E =======================================


sub_1E56:				; CODE XREF: ROM:19D0p
		mov.b	@0xFE8B:16, r2l
		mov.w	@0xFEA0:16, e1
		mov.w	@0xFEC8:16, r1
		bsr	loc_1E3C:8
		beq	loc_1E76:8
		bcs	sub_1E8C:8
		mov.b	@0xFE83:16, r0l
		cmp.b	#0x42, r0l ; 'B'
		bcc	loc_1E76:8
		mov.b	@0xFE2A:16, r0l
		beq	loc_1E78:8

loc_1E76:				; CODE XREF: sub_1E56+Ej sub_1E56+18j
		mov.w	r1, e1

loc_1E78:				; CODE XREF: sub_1E56+1Ej
		cmp.w	e1, r1
		biand	#6, r3h
		biand	#0, r3h
		bcc	sub_1E8C:8
		mov.b	@0xFE89:16, r0l
		inc.b	r0l
		mov.b	r0l, @0xFE89:16
		addx	#0xFC, r0l ; ''
; End of function sub_1E56


; =============== S U B	R O U T	I N E =======================================


sub_1E8C:				; CODE XREF: ROM:loc_147Ap
					; ROM:loc_149Ap ...
		mov.w	#0xFE24, r1

loc_1E90:				; CODE XREF: ROM:173Cp
		mov.w	@r1, r0
		btst	#6, r0h
		rts
; End of function sub_1E8C


; =============== S U B	R O U T	I N E =======================================


sub_1E96:				; CODE XREF: ROM:1A50p	sub_1EA6+4p
		mov.w	@0xFEC8:16, e1
		mov.w	@0xFEA2:16, e0
		bne	loc_1EA2:8
		mov.w	e0, e1

loc_1EA2:				; CODE XREF: sub_1E96+8j
		cmp.w	e1, e0
		rts
; End of function sub_1E96


; =============== S U B	R O U T	I N E =======================================


sub_1EA6:				; CODE XREF: ROM:1B8Ap
		mov.b	@0xFEA4:16, r1l
		bsr	sub_1E96:8
		bcc	loc_1EC4:8
		cmp.b	r2l, r0h
		bcc	loc_1EC4:8
		cmp.b	r1l, r0h
		bcc	loc_1EC4:8
		mov.b	r0h, r1l
		btst	#5, r3h
		bnot	#5, r3h
		beq	loc_1EC4:8
		mov.w	e5, r1
		mov.b	r1l, @0xFEA4:16

loc_1EC4:				; CODE XREF: sub_1EA6+6j sub_1EA6+Aj ...
		mov.b	r0l, r1h
		cmp.b	r2l, r1l
		bcs	loc_1ECC:8
		mov.b	r2l, r1l

loc_1ECC:				; CODE XREF: sub_1EA6+22j
		mov.w	r1, e5
		rts
; End of function sub_1EA6

; ---------------------------------------------------------------------------

mloc_1ed0:				; CODE XREF: ROM:1F28j
		mov.w	r4, r0
		and.w	#0x140,	r0
		cmp.w	#0x40, r0 ; '@'
		bne	loc_1EE2:8
		bild	#1, r4h
		bst	#4, @0xA:8

loc_1EE2:				; CODE XREF: ROM:1EDAj
		mov.w	@0xFE80:16, r1
		mov.b	r4l, r0l
		mov.b	r4l, r0h
		bld	#0, r4h
		btst	#1, r4h
		beq	loc_1F12:8
		mov.w	#0xFFFF, r2
		xor.b	#0xFF, r0l
		bcc	loc_1EFC:8
		mov.b	r0l, r2l
		bra	loc_1EFE:8
; ---------------------------------------------------------------------------

loc_1EFC:				; CODE XREF: ROM:1EF6j
		mov.b	r0l, r2h

loc_1EFE:				; CODE XREF: ROM:1EFAj
		jsr	loc_1330:16
		xor.w	#0xFFFF, r2
		bld	#6, r2h
		and.w	r1, r2
		bne	loc_1F24:8
		bcc	loc_1F24:8
		btst	#2, r5l
		bra	loc_1F24:8
; ---------------------------------------------------------------------------

loc_1F12:				; CODE XREF: ROM:1EEEj
		jsr	mloc_1696:16
		and.w	r0, r1
		cmp.w	r0, r1
		bne	loc_1F24:8
		btst	#6, r2h
		beq	loc_1F24:8
		btst	#2, r5l
		xorc	#4, ccr

loc_1F24:				; CODE XREF: ROM:1F0Aj	ROM:1F0Cj ...
		jmp	@@off_7E:8
; ---------------------------------------------------------------------------

mloc_1f26:
		btst	#2, r4h
		bne	mloc_1ed0:8
		mov.b	@5:8, r3h
		band	#7, @6:8
		bcs	loc_1F42:8
		sub.w	r0, r0
		mov.w	r0, @0xFE2C:16
		and.b	#0xE5, r3h
		bld	#0, r4h
		bst	#0, r3h
		bld	#1, r4h
		bst	#2, r3h

loc_1F42:				; CODE XREF: ROM:1F30j
		mov.w	#0xFDEE, r2
		mov.w	#0xFE2C, r1
		bld	#1, r3h
		rotxl.b	r3l
		bld	#0, r3h
		bsr	sub_1F7C:8
		bst	#0, r3h
		rotxr.b	r3l
		bst	#1, r3h
		bcc	loc_1F5C:8
		jsr	@@off_B0:8

loc_1F5C:				; CODE XREF: ROM:1F58j
		mov.w	#0xFDF3, r2
		mov.w	#0xFE2D, r1
		bld	#3, r3h
		rotxl.b	r3l
		bld	#2, r3h
		bsr	sub_1F7C:8
		bst	#2, r3h
		rotxr.b	r3l
		bst	#3, r3h
		bcc	loc_1F76:8
		jsr	@@off_B0:8

loc_1F76:				; CODE XREF: ROM:1F72j
		mov.b	r3h, @5:8
		btst	#4, r3h
		jmp	@@off_7C:8

; =============== S U B	R O U T	I N E =======================================


sub_1F7C:				; CODE XREF: ROM:1F50p	ROM:1F6Ap
		rotxl.b	r3l
		and.b	#3, r3l
		mov.b	@r1, r0l
		bne	loc_1FFC:8
		mov.b	#3, r0h

loc_1F86:				; CODE XREF: sub_1F7C+20j
		push.w	r2
		add.b	r3l, r2l
		inc.b	r3l
		cmp.b	#3, r3l
		bcs	loc_1F92:8
		mov.b	#0, r3l

loc_1F92:				; CODE XREF: sub_1F7C+12j
		mov.b	@r2, r0l
		pop.w	r2
		mov.b	r0l, @r1
		bne	loc_1F9E:8
		dec.b	r0h
		bne	loc_1F86:8

loc_1F9E:				; CODE XREF: sub_1F7C+1Cj
		cmp.b	#0xF3, r2l ; ''
		bcc	loc_1FFC:8
		cmp.b	#2, r3l
		bne	loc_1FFC:8
		bset	#7, @0xB:8
		btst	#7, r6h
		beq	loc_1FFC:8
		bset	#4, r3h
		push.w	r2
		mov.w	#0xFE5A, r2
		bsr	sub_2008:8
		mov.w	@0xFE5C:16, r2
		mov.w	r0, @0xFE5C:16
		mov.w	@0xFE9C:16, r1
		cmp.w	r0, r1
		bcc	loc_1FCC:8
		mov.w	r0, @0xFE9C:16

loc_1FCC:				; CODE XREF: sub_1F7C+4Aj
		btst	#5, @7:8
		beq	loc_1FD8:8
		mov.w	r0, r1
		mov.w	r2, r0
		mov.w	r1, r2

loc_1FD8:				; CODE XREF: sub_1F7C+54j
		sub.w	r2, r0
		mov.b	#0, r2l
		bcs	loc_1FEE:8
		mov.b	#5, r1h
		jsr	sub_2B48:16
		mov.w	#0x3F, r2 ; '?'
		cmp.w	r0, r2
		bcs	loc_1FEE:8
		mov.b	r0l, r2l

loc_1FEE:				; CODE XREF: sub_1F7C+60j sub_1F7C+6Ej
		mov.w	#0xFE52, r1
		mov.b	#4, r0h
		jsr	@@off_C0:8
		mov.b	r2l, r0l
		mov.b	r0l, @r1
		pop.w	r2

loc_1FFC:				; CODE XREF: sub_1F7C+6j sub_1F7C+24j	...
		rotxr.b	r3l
		mov.b	@(3:16,r2), r0h
		mov.b	@(4:16,r2), r0l
		rts
; End of function sub_1F7C


; =============== S U B	R O U T	I N E =======================================


sub_2008:				; CODE XREF: sub_1F7C+3Ap ROM:2946p
		mov.w	@(-3:16,r2), r0
		mov.b	@r2, r1h
		divxu.b	r1h, r0
		mov.b	r0l, r1l
		mov.b	#0, r0l
		divxu.b	r1h, r0
		mov.b	r1l, r0h
		sub.w	r1, r1
		mov.w	r1, @(-3:16,r2)
		mov.b	r1l, @r2
		rts
; End of function sub_2008

; ---------------------------------------------------------------------------

msub_2022:
		bclr	#0, @7:8
		rts
; ---------------------------------------------------------------------------

mloc_2028:
		bcs	loc_2038:8
		bild	#0, r4h
		band	#3, r4l
		bcc	loc_2038:8
		mov.b	r4l, r0l
		mov.w	#0xB54,	r1
		bsr	loc_209E:8

loc_2038:				; CODE XREF: ROM:mloc_2028j ROM:202Ej
		btst	#2, r4h
		beq	loc_2058:8
		mov.b	r4h, r3h
		mov.b	r4l, r1l
		bsr	loc_2080:8
		bcs	loc_2052:8
		btst	#7, r6h
		beq	loc_204C:8
		jmp	loc_1744:16
; ---------------------------------------------------------------------------

loc_204C:				; CODE XREF: ROM:2046j
		bset	#3, @6:8
		jmp	@@off_B6:8
; ---------------------------------------------------------------------------

loc_2052:				; CODE XREF: ROM:2042j
		mov.b	r4l, @0xFE88:16
		jmp	@@off_B6:8
; ---------------------------------------------------------------------------

loc_2058:				; CODE XREF: ROM:203Aj
		mov.b	r4h, r0l
		and.b	#7, r0l
		and.b	#0xF8, r6h
		or.b	r0l, r6h
		mov.b	r4l, @0xFE1A:16
		jmp	@@off_B6:8
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_207A

loc_2066:				; CODE XREF: sub_207A+Aj
		bild	#3, r1l
		jsr	sub_223A:16
		and.b	#7, r1l
		cmp.b	r1l, r0l
		beq	loc_2076:8
		andc	#0xFE, ccr ; ''
		bra	loc_2090:8
; ---------------------------------------------------------------------------

loc_2076:				; CODE XREF: sub_207A-Aj
		orc	#1, ccr
		bra	loc_2090:8
; END OF FUNCTION CHUNK	FOR sub_207A

; =============== S U B	R O U T	I N E =======================================


sub_207A:				; CODE XREF: sub_F56+1E4p

; FUNCTION CHUNK AT 2066 SIZE 00000014 BYTES

		mov.b	r6h, r3h
		mov.b	@0xFE1A:16, r1l

loc_2080:				; CODE XREF: ROM:2040p
		beq	loc_2094:8
		bild	#0, r3h
		bcc	loc_2066:8
		band	#3, r1l
		bcs	loc_2098:8
		jsr	sub_21A2:16
		bne	loc_2094:8

loc_2090:				; CODE XREF: sub_207A-6j sub_207A-2j ...
		bxor	#1, r3h
		rts
; ---------------------------------------------------------------------------

loc_2094:				; CODE XREF: sub_207A:loc_2080j
					; sub_207A+14j	...
		orc	#1, ccr
		bra	loc_2090:8
; ---------------------------------------------------------------------------

loc_2098:				; CODE XREF: sub_207A+Ej
		mov.b	r1l, r0l
		mov.w	#0xB64,	r1

loc_209E:				; CODE XREF: ROM:2036p
		and.b	#7, r0l
		jmp	@@off_D4:8
; End of function sub_207A

; ---------------------------------------------------------------------------

mloc_20a2:
		btst	#0, @7:8
		bne	loc_2094:8
		mov.b	@0xFE14:16, r0l
		bne	loc_20BE:8
		bsr	sub_20D2:8
		bsr	sub_20FE:8
		bcc	loc_2094:8
		bset	#1, @0xB:8
		bset	#0, @7:8
		bra	loc_20C6:8
; ---------------------------------------------------------------------------

loc_20BE:				; CODE XREF: ROM:20ACj
		dec.b	r0l
		mov.b	r0l, @0xFE14:16
		andc	#0xFE, ccr ; ''

loc_20C6:				; CODE XREF: ROM:20BCj	ROM:20FCj
		bra	loc_2090:8

; =============== S U B	R O U T	I N E =======================================


mloc_20c8:				; CODE XREF: ROM:mloc_20e0p
		btst	#3, r6h
		beq	sub_20D2:8
		mov.b	@0xFE14:16, r0l
		bne	locret_20DE:8
; End of function mloc_20c8


; =============== S U B	R O U T	I N E =======================================


sub_20D2:				; CODE XREF: ROM:20AEp	mloc_20c8+2j
		mov.b	@0x29:8, r0l
		inc.b	r0l
		cmp.b	#4, r0l
		bhi	locret_20DE:8
		bset	#7, r0l
		mov.b	r0l, @0x29:8

locret_20DE:				; CODE XREF: mloc_20c8+8j sub_20D2+6j
		rts
; End of function sub_20D2

; ---------------------------------------------------------------------------

mloc_20e0:
		bsr	mloc_20c8:8
		mov.b	@0xFE14:16, r0l
		beq	loc_2094:8
		btst	#0, @7:8
		bne	loc_20FA:8
		bsr	sub_20FE:8
		bcc	loc_20FA:8
		bset	#2, @0xB:8
		bset	#0, @7:8

loc_20FA:				; CODE XREF: ROM:20ECj	ROM:20F0j
		bild	#3, r6h
		bra	loc_20C6:8

; =============== S U B	R O U T	I N E =======================================


sub_20FE:				; CODE XREF: ROM:20B0p	ROM:20EEp
		mov.w	e6, r0
		bld	#7, r0h
		rts
; End of function sub_20FE

; ---------------------------------------------------------------------------

mloc_2104:
		mov.w	#0xFE56, r0
		mov.w	#0xFE5D, r1
		jsr	@@off_A0:8
		sub.w	r0, r0
		mov.w	r0, @0xFE9C:16
		mov.w	r0, @0xFE9E:16
		mov.b	@0xFE54:16, r0h
		mov.w	r0, @0xFE5C:16
		mov.w	r0, @0xFEF0:16
		mov.b	@0xFE55:16, r0h
		mov.w	r0, @0xFE5E:16
		bclr	#6, @5:8
		bclr	#5, @7:8
		bra	loc_2170:8
; ---------------------------------------------------------------------------

mloc_2136:
		bclr	#6, @5:8
		mov.w	@0xFE80:16, r0
		mov.b	@0xFE30:16, r0h
		bne	loc_215E:8
		btst	#0, @6:8
		beq	loc_2150:8

loc_214A:				; CODE XREF: ROM:2154j
		bset	#4, @0xB:8
		bra	loc_215E:8
; ---------------------------------------------------------------------------

loc_2150:				; CODE XREF: ROM:2148j
		mov.b	@0xFE86:16, r0h
		beq	loc_214A:8
		mov.b	r0h, @0xFE30:16
		bset	#0, @6:8

loc_215E:				; CODE XREF: ROM:2142j	ROM:214Ej
		mov.b	#0, r0l
		bld	#0, @6:8
		bst	#1, r0l
		jsr	@@off_B4:8
		bld	#3, @9:8
		biand	#6, @5:8

loc_2170:				; CODE XREF: ROM:2134j
		bset	#6, @7:8
		jmp	loc_2090:16

; =============== S U B	R O U T	I N E =======================================


sub_2178:				; CODE XREF: sub_15FA+Ap sub_15FA+12p	...
		mov.b	#8, r2h
		mov.w	#0xFDA8, r1

loc_217E:				; CODE XREF: sub_2178+Ej
		dec.w	#1, r1
		bsr	sub_21CE:8
		beq	loc_2188:8
		dec.b	r2h
		bne	loc_217E:8

loc_2188:				; CODE XREF: sub_2178+Aj
		bld	#7, @r1
		mov.b	r2h, r1l
		beq	loc_219E:8
		dec.b	r2h
		mov.b	@0xFE1B:16, r0l
		bcc	loc_219A:8
		not.b	r0l

loc_219A:				; CODE XREF: sub_2178+1Ej
		btst	r2h, r0l
		beq	sub_21A2:8

loc_219E:				; CODE XREF: sub_2178+16j sub_21A2+2j
		andc	#0xFA, ccr ; ''
		rts
; End of function sub_2178


; =============== S U B	R O U T	I N E =======================================


sub_21A2:				; CODE XREF: sub_207A+10p sub_2178+24j
		and.b	#7, r1l
		beq	loc_219E:8
		push.w	r1
		mov.b	#1, r2h
		bsr	sub_21D8:8
		mov.b	@0xFD94:16, r0h
		bld	#0, r0h
		bcc	loc_21BC:8
		mov.b	@0xFE63:16, r0h
		bld	#7, r0h
		bst	#0, r0l

loc_21BC:				; CODE XREF: sub_21A2+10j
		pop.w	r1
		mov.b	r1l, r0h

loc_21C0:				; CODE XREF: sub_21A2+22j
		shlr.b	r0l
		dec.b	r1l
		bne	loc_21C0:8
		bcc	locret_21CC:8
		bset	r0h, @0x22:8

locret_21CC:				; CODE XREF: sub_21A2+24j
		rts
; End of function sub_21A2


; =============== S U B	R O U T	I N E =======================================


sub_21CE:				; CODE XREF: sub_2178+8p sub_21E8+6p ...
		mov.b	@r1, r0h
		and.b	#0x7F, r0h
		cmp.b	r0l, r0h
		rts
; End of function sub_21CE


; =============== S U B	R O U T	I N E =======================================


sub_21D6:				; CODE XREF: sub_21E8-4p sub_223A+Ep
		add.b	#2, r2h
; End of function sub_21D6


; =============== S U B	R O U T	I N E =======================================


sub_21D8:				; CODE XREF: sub_21A2+8p
		mov.w	#0xFE00, r1
		add.b	r2h, r1l
		mov.b	@r1, r0l
		rts
; End of function sub_21D8

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_21E8

loc_21E2:				; CODE XREF: sub_21E8+12j
		mov.b	r0l, r2h
		bsr	sub_21D6:8
		bra	loc_222E:8
; END OF FUNCTION CHUNK	FOR sub_21E8

; =============== S U B	R O U T	I N E =======================================


sub_21E8:				; CODE XREF: sub_13D0+2p sub_15FA+1Ep	...

; FUNCTION CHUNK AT 21E2 SIZE 00000006 BYTES

		mov.b	#5, r2h
		mov.w	#0xFDA8, r1
		bsr	sub_21CE:8
		beq	loc_21FC:8
		inc.b	r2h
		mov.w	#0xFDB2, r1
		bsr	sub_21CE:8
		bne	loc_21E2:8

loc_21FC:				; CODE XREF: sub_21E8+8j
		mov.b	@0xFE1B:16, r0l
		bld	#7, @r1
		bcc	loc_2208:8
		not.b	r0l

loc_2208:				; CODE XREF: sub_21E8+1Cj
		btst	r2h, r0l
		bne	locret_2258:8
		bsr	sub_2232:8
		bsr	sub_223A:8
		push.w	r0
		bsr	sub_2232:8
		mov.b	@0x23:8, r0h
		inc.b	r0l
		bcc	loc_221E:8
		and.b	#0xF0, r0h
		bra	loc_2222:8
; ---------------------------------------------------------------------------

loc_221E:				; CODE XREF: sub_21E8+30j
		jsr	@@off_A2:8
		and.b	#0xF, r0h

loc_2222:				; CODE XREF: sub_21E8+34j
		or.b	r0l, r0h
		mov.b	r0h, @0x23:8
		pop.w	r0
		inc.w	#2, r1
		add.w	r0, r1
		mov.b	@r1, r0l

loc_222E:				; CODE XREF: sub_21E8-2j
		orc	#4, ccr
		rts
; End of function sub_21E8


; =============== S U B	R O U T	I N E =======================================


sub_2232:				; CODE XREF: sub_21E8+24p sub_21E8+2Ap
		mov.w	#0xFDB2, r2
		cmp.w	r2, r1
		rts
; End of function sub_2232


; =============== S U B	R O U T	I N E =======================================


sub_223A:				; CODE XREF: sub_207A-12p sub_21E8+26p
		push.w	r1
		mov.b	@0xFDA8:16, r2h
		bcs	loc_2246:8
		mov.b	@0xFDB2:16, r2h

loc_2246:				; CODE XREF: sub_223A+6j
		and.b	#0x7F, r2h
		jsr	sub_21D6:16
		mov.b	r0l, r2l
		mov.w	#0xBC4,	r1
		jsr	sub_325E:16
		pop.w	r1

locret_2258:				; CODE XREF: sub_21E8+22j
		rts
; End of function sub_223A


; =============== S U B	R O U T	I N E =======================================


sub_225A:				; CODE XREF: sub_F56:loc_11B4p
					; sub_2270+6p
		mov.b	@0xFE63:16, r0l
		bld	#7, r0l
		mov.w	e6, r0
		bcs	loc_2268:8
		btst	#5, r0h
		bne	locret_226E:8

loc_2268:				; CODE XREF: sub_225A+8j
		mov.b	#0xFF, r2l
		mov.b	r2l, @0xFE32:16

locret_226E:				; CODE XREF: sub_225A+Cj
		rts
; End of function sub_225A


; =============== S U B	R O U T	I N E =======================================


sub_2270:				; CODE XREF: sub_F56:loc_11A6p
		mov.b	#0, r0h
		jsr	@@off_E6:8
		beq	loc_2294:8
		bsr	sub_225A:8
		bcs	loc_2282:8
		mov.b	#0xF, r2l
		mov.b	r2l, @0xFE31:16
		bra	loc_2288:8
; ---------------------------------------------------------------------------

loc_2282:				; CODE XREF: sub_2270+8j
		mov.b	@0xFE31:16, r2l
		beq	loc_2294:8

loc_2288:				; CODE XREF: sub_2270+10j
		and.b	#0xE0, r0l
		beq	loc_2294:8
		mov.w	#0xFF1F, r2
		jsr	sub_132C:16

loc_2294:				; CODE XREF: sub_2270+4j sub_2270+16j	...
		mov.b	@0xFE81:16, r0l
		bld	#3, r0l
		mov.b	@0xFE2E:16, r2l
		bne	loc_22C6:8
		mov.w	e6, r2
		biand	#3, r2l
		bcs	loc_22CA:8
		bild	#3, r2l
		band	#3, r5l
		bcs	loc_22AE:8
		rts
; ---------------------------------------------------------------------------

loc_22AE:				; CODE XREF: sub_2270+3Aj
		bset	#1, @0x25:8
		bset	#5, @0xA:8
		btst	#2, r5l
		beq	locret_22D0:8
		mov.b	#0xA, r2l
		mov.b	r2l, @0xFE2E:16
		mov.b	#0, r1h
		jmp	loc_23FE:16
; ---------------------------------------------------------------------------

loc_22C6:				; CODE XREF: sub_2270+2Ej
		and.b	#8, r0l
		jmp	@@off_B4:8
; ---------------------------------------------------------------------------

loc_22CA:				; CODE XREF: sub_2270+34j
		mov.b	#3, r2l
		mov.b	r2l, @0xFE2E:16

locret_22D0:				; CODE XREF: sub_2270+48j
		rts
; End of function sub_2270


; =============== S U B	R O U T	I N E =======================================


sub_22D2:				; CODE XREF: sub_22E2+30p ROM:3AB4p
		mov.b	@0xFD97:16, r1l
		bne	loc_22DA:8
		mov.b	#6, r1l

loc_22DA:				; CODE XREF: sub_22D2+4j
		divxu.b	r1l, r0
		mov.b	r0l, @0xFED2:16

locret_22E0:				; CODE XREF: sub_22E2+2j sub_22E2+Aj ...
		rts
; End of function sub_22D2


; =============== S U B	R O U T	I N E =======================================


sub_22E2:				; CODE XREF: sub_F56+2p

; FUNCTION CHUNK AT 2322 SIZE 00000052 BYTES

		jsr	@@off_D2:8
		beq	locret_22E0:8
		mov.b	@0xFEB5:16, r0l
		cmp.b	#0x60, r0l ; '`'
		bne	locret_22E0:8
		btst	#1, @0xE:8
		beq	locret_22E0:8
		mov.w	#0xFEA8, r3
		mov.w	@r3, e0
		mov.b	@0xFEAA:16, r2h
		and.b	#0xF, r2h
		cmp.b	#0xF, r2h
		beq	loc_232C:8
		cmp.b	#4, r2h
		beq	loc_2322:8
		cmp.b	#1, r2h
		bne	loc_2362:8
		bclr	#4, @0x12:8
		mov.w	e0, r0
		bsr	sub_22D2:8
		bset	#3, @0x12:8
		bra	loc_2362:8
; End of function sub_22E2


; =============== S U B	R O U T	I N E =======================================


sub_231A:				; CODE XREF: ROM:02C6p	ROM:075Cp ...
		mov.b	@0xFD94:16, r0l
		btst	#1, r0l
		rts
; End of function sub_231A

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_22E2

loc_2322:				; CODE XREF: sub_22E2+24j
		bclr	#6, @4:8
		bset	#4, @0x12:8
		bra	loc_236E:8
; ---------------------------------------------------------------------------

loc_232C:				; CODE XREF: sub_22E2+20j
		mov.b	@r3+, r0l
		beq	loc_2352:8
		cmp.b	#1, r0l
		beq	loc_2340:8
		cmp.b	#2, r0l
		beq	loc_2346:8
		cmp.b	#9, r0l
		bne	loc_2362:8
		inc.w	#1, e7
		bra	loc_235A:8
; ---------------------------------------------------------------------------

loc_2340:				; CODE XREF: sub_22E2+50j
		bset	#0, @8:8
		bra	loc_235A:8
; ---------------------------------------------------------------------------

loc_2346:				; CODE XREF: sub_22E2+54j
		bset	#0, @0x11:8
		bra	loc_235A:8
; ---------------------------------------------------------------------------

loc_234C:				; CODE XREF: sub_22E2+76j
		bset	#1, @0x11:8
		bra	loc_2362:8
; ---------------------------------------------------------------------------

loc_2352:				; CODE XREF: sub_22E2+4Cj
		mov.b	@r3, r0l
		beq	loc_2362:8
		cmp.b	#2, r0l
		beq	loc_234C:8

loc_235A:				; CODE XREF: sub_22E2+5Cj sub_22E2+62j ...
		bset	#0, @PDR2:8
		bclr	#7, @6:8

loc_2362:				; CODE XREF: sub_22E2+28j sub_22E2+36j ...
		mov.w	#0xBA6,	r1
		add.b	r2h, r1l
		mov.b	@r1, r1l
		mov.b	#0xFE, r1h ; ''
		mov.w	e0, @r1

loc_236E:				; CODE XREF: sub_22E2+48j
		bclr	#1, @0xE:8
		rts
; END OF FUNCTION CHUNK	FOR sub_22E2

; =============== S U B	R O U T	I N E =======================================


mloc_2374:				; CODE XREF: sub_346A+B2p
		mov.b	#0xE, r2l
		mov.w	@0xFECA:16, r0
		beq	loc_23A2:8
		mov.b	#0xD, r2l
		btst	#6, @2:8
		bne	loc_23A2:8
		mov.b	@0xFEA5:16, r2l
		and.b	#0xF, r2l

loc_238A:				; CODE XREF: mloc_2374+2Cj
		cmp.b	#0xA, r2l
		bcs	loc_2390:8
		mov.b	#0, r2l

loc_2390:				; CODE XREF: mloc_2374+18j
		inc.b	r2l
		cmp.b	#4, r2l
		bne	loc_23A2:8
		mov.b	#0x60, r0l ; '`'
		jsr	@@off_AA:8
		beq	loc_23A2:8
		btst	#6, @4:8
		beq	loc_238A:8

loc_23A2:				; CODE XREF: mloc_2374+6j mloc_2374+Ej ...
		mov.b	#0xF0, r0h ; ''
; End of function mloc_2374

; START	OF FUNCTION CHUNK FOR sub_23B6

loc_23A4:				; CODE XREF: sub_23B6:loc_23DCj
		mov.w	#0xFEA5, r1
		jmp	loc_2D10:16
; END OF FUNCTION CHUNK	FOR sub_23B6

; =============== S U B	R O U T	I N E =======================================


sub_23AC:				; CODE XREF: sub_1316p	sub_23B6+6p
		mov.b	@0xFE1E:16, r0l
		and.b	#0xC0, r0l
		cmp.b	#0x80, r0l ; ''
		rts
; End of function sub_23AC


; =============== S U B	R O U T	I N E =======================================


sub_23B6:				; CODE XREF: sub_F56+27Cp

; FUNCTION CHUNK AT 23A4 SIZE 00000008 BYTES

		mov.b	@0xFE35:16, r0l
		bne	loc_23CA:8
		bsr	sub_23AC:8
		bne	loc_23C4:8
		btst	#7, r5h
		bne	loc_23CA:8

loc_23C4:				; CODE XREF: sub_23B6+8j
		mov.w	@0xFED0:16, r1
		beq	loc_23D8:8

loc_23CA:				; CODE XREF: sub_23B6+4j sub_23B6+Cj
		btst	#6, @2:8
		beq	loc_23DC:8
		jsr	@@off_E0:8
		bclr	#6, @2:8
		bra	loc_23DC:8
; ---------------------------------------------------------------------------

loc_23D8:				; CODE XREF: sub_23B6+12j
		bset	#6, @2:8

loc_23DC:				; CODE XREF: sub_23B6+18j sub_23B6+20j
		bra	loc_23A4:8
; End of function sub_23B6


; =============== S U B	R O U T	I N E =======================================


sub_23DE:				; CODE XREF: sub_F56+10Cp
		mov.b	@0xFE97:16, r1l
		mov.b	#0x42, r1h ; 'B'
		cmp.b	#3, r1l
		beq	loc_23EE:8
		jsr	sub_194C:16
		bcc	loc_23F0:8

loc_23EE:				; CODE XREF: sub_23DE+8j
		mov.b	#0x53, r1h ; 'S'

loc_23F0:				; CODE XREF: sub_23DE+Ej
		mov.b	#0, r0l
		cmp.b	#5, r1l
		beq	loc_2400:8
		bsr	sub_2436:8
		bior	#2, @IENR3:8
		bcs	loc_2400:8

loc_23FE:				; CODE XREF: sub_2270+52j
		mov.b	#8, r0l

loc_2400:				; CODE XREF: sub_23DE+16j sub_23DE+1Ej
		mov.b	r1h, r0h
		jmp	@@off_B0:8
; End of function sub_23DE

; ---------------------------------------------------------------------------

mloc_2404:				; CODE XREF: ROM:240Aj
		bset	#2, r3l
		bra	loc_2410:8
; ---------------------------------------------------------------------------

mloc_2408:
		bld	#3, r3l
		bcs	mloc_2404:8
		bld	#0, @0x11:8

loc_2410:				; CODE XREF: ROM:2406j
		bclr	#0, @0x11:8
		rts
; ---------------------------------------------------------------------------

mloc_2416:
		bsr	sub_2436:8
		mov.w	e6, r0
		band	#6, r0h
		bcs	loc_2450:8
		bld	#0, r3l
		bclr	#0, r3l
		bcs	locret_2434:8
		jsr	@@off_D2:8
		bld	#3, r0l
		bhi	locret_2434:8
		mov.b	@0xFE62:16, r0l
		bld	#5, r0l
		bxor	#6, @0x11:8

locret_2434:				; CODE XREF: ROM:2422j	ROM:2428j
		rts

; =============== S U B	R O U T	I N E =======================================


sub_2436:				; CODE XREF: sub_23DE+18p
					; ROM:mloc_2416p
		mov.b	@0xFE62:16, r0h
		bld	#2, r0h
		mov.b	@0xFE6C:16, r0h
		bxor	#2, r0h
		rts
; End of function sub_2436

; ---------------------------------------------------------------------------

mloc_2444:
		bld	#5, r3l
		bclr	#5, r3l
		bcs	locret_24A4:8
		bld	#6, @7:8
		biand	#1, r5l

loc_2450:				; CODE XREF: ROM:241Cj
		bra	loc_249E:8
; ---------------------------------------------------------------------------

mloc_2452:
		bsr	sub_24AA:8
		beq	loc_2482:8
		mov.b	@0xFE55:16, r0l
		mov.b	@0xFD8C:16, r0h
		cmp.b	r0l, r0h
		bcs	loc_2466:8
		cmp.b	#2, r0l
		rts
; ---------------------------------------------------------------------------

loc_2466:				; CODE XREF: ROM:2460j
		or.w	#0x200,	e6
		rts
; ---------------------------------------------------------------------------

mloc_246c:
		mov.w	e6, r0
		bild	#3, r0l
		band	#3, r5l
		bcc	locret_24A4:8
		mov.b	@0xFE2E:16, r0l
		dec.b	r0l
		beq	locret_24A4:8
		band	#1, r5l
		band	#6, r5l
		bra	loc_2498:8
; ---------------------------------------------------------------------------

loc_2482:				; CODE XREF: ROM:2454j	ROM:24C4j ...
		andc	#0xFE, ccr ; ''
		rts
; ---------------------------------------------------------------------------

mloc_2486:
		mov.b	@PDR1:8, r0l
		bld	#7, r0l
		biand	#4, r5l
		band	#1, r5l
		bra	loc_249E:8
; ---------------------------------------------------------------------------

mloc_2490:
		mov.b	@PDR1:8, r0l
		bild	#7, r0l
		band	#4, r5l
		band	#1, r5l

loc_2498:				; CODE XREF: ROM:2480j	ROM:24D0j
		bcc	locret_24A4:8
		bild	#2, r5l
		bor	#3, r5l

loc_249E:				; CODE XREF: ROM:loc_2450j ROM:248Ej ...
		bcc	locret_24A4:8
		band	#5, r3h
		bcc	loc_24A6:8

locret_24A4:				; CODE XREF: ROM:2448j	ROM:2472j ...
		rts
; ---------------------------------------------------------------------------

loc_24A6:				; CODE XREF: ROM:24A2j
		inc.b	r3h
		rts

; =============== S U B	R O U T	I N E =======================================


sub_24AA:				; CODE XREF: ROM:mloc_2452p ROM:24C2p	...
		mov.b	@0xFD82:16, r0l
		btst	#3, r0l
		rts
; End of function sub_24AA

; ---------------------------------------------------------------------------

mloc_24b2:
		mov.b	@PDR5:8, r0l
		bld	#2, r0l
		biand	#5, r5l
		bra	loc_24C0:8
; ---------------------------------------------------------------------------

mloc_24ba:
		mov.b	@PDR5:8, r0l
		bild	#2, r0l
		band	#5, r5l

loc_24C0:				; CODE XREF: ROM:24B8j
		biand	#1, r5l
		bsr	sub_24AA:8
		beq	loc_2482:8
		mov.b	@0xFE39:16, r0l
		bne	loc_2482:8
		btst	#5, r5l
		beq	loc_249E:8
		bra	loc_2498:8
; ---------------------------------------------------------------------------

mloc_24d2:
		mov.w	e7, e7
		bne	loc_24F6:8
		mov.b	@0xFD85:16, r0l
		beq	loc_24E2:8
		mov.b	#1, r0h
		cmp.b	r0l, r0h
		rts
; ---------------------------------------------------------------------------

loc_24E2:				; CODE XREF: ROM:24DAj
		or.w	#0x4000, e6
		bra	loc_24F6:8
; ---------------------------------------------------------------------------

mloc_24e8:
		jsr	@@off_D2:8

loc_24EA:				; CODE XREF: ROM:2502j
		beq	loc_2482:8
		mov.b	@0xFE38:16, r0l
		bne	loc_2482:8
		bset	#0, @PDR2:8

loc_24F6:				; CODE XREF: ROM:24D4j	ROM:24E6j
		orc	#1, ccr
		rts
; ---------------------------------------------------------------------------

mloc_24fa:
		mov.b	@0xFE54:16, r0l
		mov.b	@0xFD86:16, r0h
		beq	loc_24EA:8
		cmp.b	r0l, r0h
		bcs	locret_250A:8
		cmp.b	#0xA, r0l

locret_250A:				; CODE XREF: ROM:2506j
		rts
; ---------------------------------------------------------------------------

mloc_250c:
		bild	#0, r5l
		biand	#1, r5l
		bra	loc_249E:8
; ---------------------------------------------------------------------------

mloc_2512:
		bld	#2, r5l
		biand	#7, r5l
		bra	loc_249E:8
; ---------------------------------------------------------------------------

mloc_2518:
		mov.b	@0xFE32:16, r0l
		cmp.b	#1, r0l

; =============== S U B	R O U T	I N E =======================================


sub_251E:				; CODE XREF: sub_C0E+18p
		mov.b	@0xFD94:16, r0l
		band	#0, r0l
		rts
; End of function sub_251E


; =============== S U B	R O U T	I N E =======================================


sub_2526:				; CODE XREF: sub_F56+254p

; FUNCTION CHUNK AT 25A8 SIZE 0000005E BYTES

		mov.w	#0xB94,	r1
		mov.b	#0, r2l
		mov.b	@0xFE8F:16, r2h
		mov.b	@8:8, r3l
		mov.b	@0xFE8E:16, r3h
		mov.b	r3h, r4l
		jsr	@@off_E4:8
		bld	#2, r5l
		bhi	loc_258C:8

loc_253E:				; CODE XREF: sub_2526+44j
		inc.b	r2l
		sub.w	r0, r0
		mov.b	@r1, r0l
		shll.w	r0
		add.w	#0x2404, r0
		btst	#7, r3l
		bne	loc_2562:8
		mov.w	r0, e0
		cmp.b	r2l, r2h
		bne	loc_2558:8
		jsr	@r0
		bra	loc_25AC:8
; ---------------------------------------------------------------------------

loc_2558:				; CODE XREF: sub_2526+2Cj
		bsr	sub_2590:8
		bcc	loc_2562:8
		mov.w	e0, r0
		jsr	@r0
		bcs	loc_25A8:8

loc_2562:				; CODE XREF: sub_2526+26j sub_2526+34j ...
		inc.w	#1, r1
		mov.w	#0xBA6,	r0
		cmp.w	r0, r1
		bcs	loc_253E:8
		mov.b	@0xFE21:16, r2l
		beq	loc_2586:8
		cmp.b	#0x13, r2l
		bcc	loc_2586:8
		mov.b	@0xFE1E:16, r0l
		cmp.b	#0xA3, r0l ; ''
		bne	loc_2586:8
		mov.b	#0, r0l
		mov.b	r0l, @0xFE21:16
		bra	loc_25D6:8
; ---------------------------------------------------------------------------

loc_2586:				; CODE XREF: sub_2526+4Aj sub_2526+4Ej ...
		cmp.b	r3h, r4l
		bne	loc_258C:8
		mov.b	#0, r3h

loc_258C:				; CODE XREF: sub_2526+16j sub_2526+62j
		andc	#0xFE, ccr ; ''
		bra	loc_260C:8
; End of function sub_2526


; =============== S U B	R O U T	I N E =======================================


sub_2590:				; CODE XREF: sub_2526:loc_2558p
					; sub_2526:loc_25C8p
		mov.b	@0xFE2F:16, r0l
		cmp.b	#0xFA, r0l ; ''
		biand	#6, r3l
		rts
; End of function sub_2590


; =============== S U B	R O U T	I N E =======================================


sub_259A:				; CODE XREF: sub_2526+84p
		mov.b	r2l, @0xFE8F:16
; End of function sub_259A


; =============== S U B	R O U T	I N E =======================================


sub_259E:				; CODE XREF: sub_2606p
		and.b	#0x3F, r3l
		mov.b	#0, r0l
		mov.b	r0l, @0xFE8D:16
		rts
; End of function sub_259E

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2526

loc_25A8:				; CODE XREF: sub_2526+3Aj
		mov.b	#0, r3h
		bsr	sub_259A:8

loc_25AC:				; CODE XREF: sub_2526+30j
		btst	#6, r3l
		bne	loc_260E:8
		bcc	loc_2600:8
		mov.b	@0xFE8D:16, r0l
		cmp.b	#0x20, r0l ; ' '
		bcc	loc_25CE:8
		add.b	#0x10, r0l
		mov.b	r0l, @0xFE8D:16
		bsr	sub_2632:8
		mov.b	#0xA, r0l

loc_25C4:				; CODE XREF: sub_2526+AAj
		bset	#6, r3l
		bra	loc_2618:8
; ---------------------------------------------------------------------------

loc_25C8:				; CODE XREF: sub_2526+DEj
		bsr	sub_2590:8
		bcc	loc_262A:8
		bra	loc_2562:8
; ---------------------------------------------------------------------------

loc_25CE:				; CODE XREF: sub_2526+92j
		bsr	sub_264A:8
		beq	loc_25C4:8
		mov.b	r2l, @0xFE21:16

loc_25D6:				; CODE XREF: sub_2526+5Ej
		mov.b	r2l, @0xFE97:16
		mov.b	#0x30, r0l ; '0'
		jsr	sub_4D2:16
		jsr	sub_D88:16
		mov.b	@0xFE97:16, r0l
		mov.b	r0l, @0xFE8F:16
		mov.b	r0l, @0xFE8A:16
		bset	#7, r3l
		mov.w	#0x12C,	r0
		mov.w	r0, @0xFE22:16
		bsr	sub_266E:8
		orc	#1, ccr
		bra	loc_2626:8
; ---------------------------------------------------------------------------

loc_2600:				; CODE XREF: sub_2526+8Aj
		mov.b	@0xFE2F:16, r0l
		bne	loc_25C8:8
; END OF FUNCTION CHUNK	FOR sub_2526

; =============== S U B	R O U T	I N E =======================================


sub_2606:				; CODE XREF: sub_F56+128p
		bsr	sub_259E:8
		mov.b	r0l, @0xFE8F:16

loc_260C:				; CODE XREF: sub_2526+68j
		bra	loc_262A:8
; ---------------------------------------------------------------------------

loc_260E:				; CODE XREF: sub_2526+88j
		mov.b	@0xFE2F:16, r0l
		bne	loc_261C:8
		bclr	#6, r3l
		mov.b	#0xFF, r0l

loc_2618:				; CODE XREF: sub_2526+A0j
		mov.b	r0l, @0xFE2F:16

loc_261C:				; CODE XREF: sub_2606+Cj
		cmp.b	#2, r2l
		bne	loc_2626:8
		bsr	sub_2676:8
		bne	loc_262A:8
		bld	#6, r3l

loc_2626:				; CODE XREF: sub_2526+D8j sub_2606+18j
		bset	#4, @0xA:8

loc_262A:				; CODE XREF: sub_2526+A4j
					; sub_2606:loc_260Cj ...
		mov.b	r3l, @8:8
		mov.b	r3h, @0xFE8E:16
		rts
; End of function sub_2606


; =============== S U B	R O U T	I N E =======================================


sub_2632:				; CODE XREF: sub_2526+9Ap

; FUNCTION CHUNK AT 2668 SIZE 00000006 BYTES

		mov.w	#0xFF26, r1
		mov.b	r2l, r0l
		cmp.b	#0x10, r0l
		bcs	loc_263E:8
		mov.b	#0x10, r0l

loc_263E:				; CODE XREF: sub_2632+8j
		dec.b	r0l

loc_2640:				; CODE XREF: sub_2632+16j
		cmp.b	#8, r0l
		bcs	loc_2668:8
		subx	#8, r0l
		inc.w	#1, r1
		bra	loc_2640:8
; End of function sub_2632


; =============== S U B	R O U T	I N E =======================================


sub_264A:				; CODE XREF: sub_2526:loc_25CEp
		cmp.b	#2, r2l
		bne	locret_2662:8
		btst	#3, r3l
		beq	loc_2664:8
		and.b	#0xF, r0l
		inc.b	r0l
		cmp.b	#8, r0l
		mov.b	r0l, @0xFE8D:16
		bcc	locret_2662:8
		mov.b	#0xF0, r0l ; ''

loc_2660:				; CODE XREF: sub_2676:loc_268Cj
		orc	#4, ccr

locret_2662:				; CODE XREF: sub_264A+2j sub_264A+12j	...
		rts
; ---------------------------------------------------------------------------

loc_2664:				; CODE XREF: sub_264A+6j
		andc	#0xFB, ccr ; ''
		rts
; End of function sub_264A

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2632

loc_2668:				; CODE XREF: sub_2632+10j
		bset	r0l, @r1
		rts
; END OF FUNCTION CHUNK	FOR sub_2632

; =============== S U B	R O U T	I N E =======================================


sub_266E:				; CODE XREF: sub_2526+D4p sub_2694+14j
		mov.b	@0xE:8,	r0l
		bclr	#5, r0l
		mov.b	r0l, @0xE:8
		rts
; End of function sub_266E


; =============== S U B	R O U T	I N E =======================================


sub_2676:				; CODE XREF: sub_2606+1Ap
		btst	#3, r3l
		bld	#6, r5l
		bxor	#3, r3l
		bcs	locret_2662:8
		beq	loc_268A:8
		bclr	#3, r3l
		mov.b	#0xA, r0l
		mov.b	r0l, @0xFE2F:16
		bra	loc_268C:8
; ---------------------------------------------------------------------------

loc_268A:				; CODE XREF: sub_2676+8j
		bset	#3, r3l

loc_268C:				; CODE XREF: sub_2676+12j
		bra	loc_2660:8
; End of function sub_2676


; =============== S U B	R O U T	I N E =======================================


sub_268E:				; CODE XREF: sub_56E+48p
					; DATA XREF: ROM:off_62o
		beq	loc_26B6:8
		bra	sub_2694:8
; End of function sub_268E


; =============== S U B	R O U T	I N E =======================================


sub_2692:				; CODE XREF: sub_C0E+5Ep sub_F56+2CCp
					; DATA XREF: ...
		bne	loc_26B6:8
; End of function sub_2692


; =============== S U B	R O U T	I N E =======================================


sub_2694:				; CODE XREF: ROM:14A0p	sub_268E+2j ...
		mov.w	#0xFE95, r1
		mov.b	@r1, r0h
		mov.b	r0h, r2l
		or.b	r0l, r0h
		mov.b	r0h, @r1
		mov.b	@0x28:8, r1l
		or.b	r0l, r1l
		mov.b	r1l, @0x28:8
		and.b	r0l, r2l
		beq	sub_266E:8
		rts
; End of function sub_2694


; =============== S U B	R O U T	I N E =======================================


sub_26AC:				; CODE XREF: ROM:19F4p
		mov.w	#0xB4, r1 ; ''
		cmp.w	r0, r1
		mov.b	#0x40, r0l ; '@'
; End of function sub_26AC


; =============== S U B	R O U T	I N E =======================================


sub_26B4:				; CODE XREF: sub_C0E+72p sub_F56+2F0p	...
		bcc	sub_2694:8

loc_26B6:				; CODE XREF: sub_E12+4p ROM:14DEp ...
		mov.w	#0xFE95, r1
		mov.b	@r1, r0h
		xor.b	#0xFF, r0l
		and.b	r0l, r0h
		mov.b	r0h, @r1
		rts
; End of function sub_26B4


; =============== S U B	R O U T	I N E =======================================


sub_26C4:				; CODE XREF: sub_F56+26Ep
		mov.b	r5l, r1l
		jsr	@@off_E2:8
		beq	loc_26CC:8
		bst	#6, r1l

loc_26CC:				; CODE XREF: sub_26C4+4j
		mov.b	r1l, r0l
		and.b	#0x44, r0l
		jsr	@@off_76:8
		bld	#0, @2:8
		bst	#6, r0l
		bld	#1, @6:8
		bst	#7, r0l
		bld	#5, r5h
		bst	#2, r0l
		mov.b	@0xFE99:16, r0h
		and.b	#1, r0h
		or.b	r0h, r0l
		mov.b	r0l, @0xFE99:16
		jsr	@@off_E2:8
		beq	locret_2748:8
		mov.w	e6, r0
		mov.b	@0xFE80:16, r1h
		bild	#6, r1h
		band	#6, r0h
		bcc	loc_2704:8

loc_26FE:				; CODE XREF: sub_26C4+62j
		mov.b	#9, r0l
		mov.b	r0l, @0xFE2A:16

loc_2704:				; CODE XREF: sub_26C4+38j
		btst	#2, @9:8
		beq	loc_274A:8
		btst	#5, r5h
		bne	locret_2748:8
		btst	#6, r1l
		beq	locret_2748:8
		bld	#2, r5l
		bxor	#6, r0h
		mov.b	#0, r0l
		bcc	loc_2752:8
		mov.b	@0xFF0C:16, r1h
		bne	loc_2746:8
		mov.b	@0xFE2A:16, r1h
		cmp.b	#9, r1h
		bhi	loc_26FE:8
		cmp.b	#3, r1h
		bior	#6, r0h
		bcc	loc_2746:8
		mov.b	@0x10:8, r0l
		add.b	#0xE0, r0l ; ''
		bne	loc_2742:8
		mov.b	@0xFEAF:16, r1l
		cmp.b	#5, r1l
		bcc	locret_2748:8
		inc.b	r1l

loc_273E:				; CODE XREF: sub_26C4+92j sub_26C4+98j
		mov.b	r1l, @0xFEAF:16

loc_2742:				; CODE XREF: sub_26C4+6Ej
		cmp.b	#0xE0, r0l ; ''
		bist	#0, r0l

loc_2746:				; CODE XREF: sub_26C4+5Aj sub_26C4+68j
		mov.b	r0l, @0x10:8

locret_2748:				; CODE XREF: sub_26C4+2Cj sub_26C4+48j ...
		rts
; ---------------------------------------------------------------------------

loc_274A:				; CODE XREF: sub_26C4+44j
		bild	#6, r5l
		bcs	locret_2748:8
		jmp	sub_CFE:16
; ---------------------------------------------------------------------------

loc_2752:				; CODE XREF: sub_26C4+54j
		mov.b	#0, r1l
		btst	#2, r5l
		beq	loc_273E:8
		bset	#1, @0xA:8
		bra	loc_273E:8
; End of function sub_26C4


; =============== S U B	R O U T	I N E =======================================


sub_275E:				; CODE XREF: sub_980+2Cp sub_C0E+24p ...
		mov.b	@0xFE62:16, r0l
		bld	#7, r0l
		mov.b	@0xFE6C:16, r0l
		biand	#7, r0l
		mov.b	#3, r0h
; End of function sub_275E


; =============== S U B	R O U T	I N E =======================================


sub_276C:				; CODE XREF: sub_2270+2p sub_2774+2j ...
		mov.b	@0xFD94:16, r0l
		btst	r0h, r0l
		rts
; End of function sub_276C


; =============== S U B	R O U T	I N E =======================================


sub_2774:				; CODE XREF: sub_C0E+60p sub_CFEp ...
		mov.b	#4, r0h
		bra	sub_276C:8
; End of function sub_2774

; ---------------------------------------------------------------------------

mloc_2778:
		bsr	sub_27B4:8
		mov.w	r2, e1
		mov.w	@0xFEA0:16, r1
		jsr	loc_1E3C:16
		bhi	loc_278A:8
		bne	loc_278C:8
		mov.w	r1, e1

loc_278A:				; CODE XREF: ROM:2784j
		cmp.w	e1, r1

loc_278C:				; CODE XREF: ROM:2786j
		bor	#2, @8:8
		bst	#7, @4:8
		bclr	#0, @0xB:8
		rts
; ---------------------------------------------------------------------------

mloc_279a:
		jsr	@@off_D2:8
		bne	loc_27AA:8
		bsr	sub_27B4:8

loc_27A0:				; CODE XREF: ROM:27AEj	ROM:27B2j
		mov.w	r2, @0xFEA0:16
		bclr	#0, @0xC:8
		rts
; ---------------------------------------------------------------------------

loc_27AA:				; CODE XREF: ROM:279Cj
		mov.w	@0xFF3E:16, r2
		bne	loc_27A0:8
		dec.w	#1, r2
		bra	loc_27A0:8

; =============== S U B	R O U T	I N E =======================================


sub_27B4:				; CODE XREF: ROM:mloc_2778p ROM:279Ep	...
		mov.b	@0xFE67:16, r0l
		mov.w	#0xFF3E, r4

loc_27BC:				; CODE XREF: sub_27B4+1Ej
		mov.w	#0xFF5C, r5
		cmp.w	r5, r4
		bcc	loc_27D4:8
		mov.b	@r4+, r0h
		mov.b	@r4+, r1l
		mov.b	@r4+, r3h
		mov.b	@r4+, r3l
		mov.b	@r4+, r1h
		beq	loc_27D4:8
		cmp.b	r1h, r0l
		bcc	loc_27BC:8

loc_27D4:				; CODE XREF: sub_27B4+Ej sub_27B4+1Aj
		mulxu.b	r0h, r0
		jsr	@@off_C8:8
		add.w	r3, r2
		rts
; End of function sub_27B4

; ---------------------------------------------------------------------------

mloc_27dc:
		bsr	sub_27B4:8
		beq	loc_27E4:8
		cmp.b	#0, r2h
		beq	loc_27E8:8

loc_27E4:				; CODE XREF: ROM:27DEj
		mov.b	@0xFD87:16, r2l

loc_27E8:				; CODE XREF: ROM:27E2j
		mov.b	r2l, @0xFE9B:16
		bclr	#6, @0xB:8
		rts
; ---------------------------------------------------------------------------

mloc_27f2:
		bsr	loc_282E:8
		mov.w	r2, @0xFE10:16
		mov.b	@0xFE54:16, r0l
		mov.b	r0l, @0xFE12:16
		mov.b	@0x3E:8, r0l
		mov.b	r0l, @0xFE14:16
		mov.w	#0xFF40, r6
		jsr	sub_2C7C:16

loc_280E:				; CODE XREF: ROM:2822j
		mov.b	@r6+, r1l
		beq	loc_2824:8
		mov.w	#0xFF5C, r5
		cmp.w	r5, r6
		bcc	loc_2824:8
		cmp.b	r1l, r0l
		bls	loc_2824:8
		jsr	sub_2C88:16
		bra	loc_280E:8
; ---------------------------------------------------------------------------

loc_2824:				; CODE XREF: ROM:2810j	ROM:2818j ...
		mov.b	r0l, @0xFE13:16
		bclr	#1, @0xB:8
		rts
; ---------------------------------------------------------------------------

loc_282E:				; CODE XREF: ROM:mloc_27f2p
					; ROM:mloc_2890p
		mov.w	@0xFE92:16, r1
; ---------------------------------------------------------------------------
Problem32_40:	.byte 0x7A ; z
		.byte	 2
		.byte	 0
		.byte	 9
		.byte 0x5D
		.byte 0x76 ; v
; ---------------------------------------------------------------------------
		jsr	@@off_CA:8
		mov.w	#9, r0
		cmp.w	r2, r0
		mov.b	#2, r0l
		jmp	@@off_C2:8
; ---------------------------------------------------------------------------

mloc_2844:
		mov.b	@0xFF40:32, r0l
		beq	loc_2850:8
		bset	#1, @8:8

loc_2850:				; CODE XREF: ROM:284Aj
		btst	#5, @4:8
		bne	loc_2872:8
		mov.b	@0xFE84:16, r3l
		mov.b	#5, r1l
		jsr	@@off_CC:8
		mov.b	r0l, r0h
		mov.w	#0xFF3E, r6
		mov.w	#3, r2
		bsr	sub_2878:8
		mov.b	@r6+, r0h
		mov.b	@r6+, r0l
		mov.w	r0, @0xFEA2:16

loc_2872:				; CODE XREF: ROM:2854j
		bclr	#5, @0xB:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_2878:				; CODE XREF: ROM:2868p	sub_2878+12j ...
		add.w	r2, r6
		mov.b	@(-1:16,r6), r0l
		beq	loc_288C:8
		mov.w	#0xFF5C, r1
		cmp.w	r1, r6
		bcc	loc_288C:8
		cmp.b	r0l, r0h
		bcc	sub_2878:8

loc_288C:				; CODE XREF: sub_2878+6j sub_2878+Ej
		sub.w	r2, r6
		rts
; End of function sub_2878

; ---------------------------------------------------------------------------

mloc_2890:
		bsr	loc_282E:8
		mov.w	r2, @0xFF38:16
		bcs	loc_28A2:8
		mov.b	@0x29:8, r0l
		mov.b	#0x81, r0h ; ''
		cmp.b	r0l, r0h
		jmp	loc_2910:16
; ---------------------------------------------------------------------------

loc_28A2:				; CODE XREF: ROM:2896j
		mov.b	@0xFE13:16, r0h
		mov.w	#0xFF41, r6
		mov.w	#3, r2
		bsr	sub_2878:8
		mov.b	@0x40:8, r0l
		mov.b	r0l, r4l
		and.b	#0xF, r4l
		jsr	@@off_A2:8
		mov.b	r0l, r4h
		and.b	#0xF, r4h
		mov.b	@0xFE12:16, r0h
		mov.b	@0xFE54:16, r0l
		mov.b	r0l, @0x3A:8
		sub.b	r0h, r0l
		bsr	sub_2920:8
		mov.b	r0l, r1l
		mov.b	@(1:16,r6), r0l
		mov.b	@0xFE13:16, r0h
		mulxu.b	r0h, r0
		bsr	sub_2924:8
		jsr	loc_2CAC:16
		jsr	@@off_BA:8
		mov.w	@0xFF38:16, r0
		mov.w	@0xFE10:16, r5
		beq	loc_291A:8
		sub.w	r5, r0
		bsr	sub_2920:8
		mov.b	@r6, r1l
		bsr	sub_2924:8
		bsr	sub_293A:8
		mov.b	r4h, r1h
		jsr	@@off_D0:8
		btst	#7, r1l
		bne	loc_2904:8
		or.b	r1l, r0h
		cmp.b	#0, r0h
		beq	loc_2906:8
		mov.b	#0xFF, r0l
		bra	loc_2906:8
; ---------------------------------------------------------------------------

loc_2904:				; CODE XREF: ROM:28F8j
		mov.b	#0, r0l

loc_2906:				; CODE XREF: ROM:28FEj	ROM:2902j
		mov.b	r0l, @0x3B:8
		mov.b	r0l, r3h
		jsr	sub_2C60:16
		cmp.b	r3l, r3h

loc_2910:				; CODE XREF: ROM:289Ej
		mov.b	@0xFE1C:16, r0l
		bst	#3, r0l
		mov.b	r0l, @0xFE1C:16

loc_291A:				; CODE XREF: ROM:28E6j
		bclr	#2, @0xB:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_2920:				; CODE XREF: ROM:28C8p	ROM:28EAp
		bst	#0, r3h
		bra	loc_2928:8
; End of function sub_2920


; =============== S U B	R O U T	I N E =======================================


sub_2924:				; CODE XREF: ROM:28D6p	ROM:28EEp
		jsr	@@off_A8:8
		bld	#0, r3h

loc_2928:				; CODE XREF: sub_2920+2j
		bcc	locret_2936:8
		xor.b	#0xFF, r1l
		xor.b	#0xFF, r0h
		xor.b	#0xFF, r0l
		addx	#0, r0l
		addx	#0, r0h
		addx	#0, r1l

locret_2936:				; CODE XREF: sub_2924:loc_2928j
		rts
; End of function sub_2924


; =============== S U B	R O U T	I N E =======================================


mloc_2938:				; CODE XREF: sub_29B0+1Ap
		jsr	@@off_A8:8
; End of function mloc_2938


; =============== S U B	R O U T	I N E =======================================


sub_293A:				; CODE XREF: ROM:28F0p	ROM:2AC4p ...
		sub.b	r2l, r0l
		subx	r2h, r0h
		subx	r3l, r1l
		rts
; End of function sub_293A

; ---------------------------------------------------------------------------

mloc_2942:
		mov.w	#0xFE5B, r2
		jsr	sub_2008:16
		mov.w	@0xFE5E:16, e2
		mov.w	r0, @0xFE5E:16
		mov.w	#0xFF3E, r6
		sub.w	e3, e3
		mov.w	@0xFE86:16, e1
		mov.b	@0xFE94:16, r3h
		beq	loc_296A:8
		mov.b	@0xFE55:16, r4h
		bsr	sub_29B0:8
		mov.w	r0, e3

loc_296A:				; CODE XREF: ROM:2960j
		add.b	#5, r6l
		sub.w	r0, r0
		mov.w	@0xFEF0:16, e2
		mov.b	@0xFEF2:16, r3h
		beq	loc_2990:8
		mov.b	@0xFE54:16, r4h
		mov.b	r4h, r0h
		mov.b	#0, r0l
		mov.w	r0, @0xFEF0:16
		bsr	sub_29B0:8
		mov.w	e3, e3
		bne	loc_298C:8
		dec.w	#1, e3

loc_298C:				; CODE XREF: ROM:2988j
		cmp.w	e3, r0
		bcs	loc_2992:8

loc_2990:				; CODE XREF: ROM:2976j
		mov.w	e3, r0

loc_2992:				; CODE XREF: ROM:298Ej
		mov.w	r0, @0xFE86:16
		sub.b	r0h, r4l
		mov.b	r4l, @0xFE30:16
		bclr	#0, @6:8
		bclr	#4, @0xB:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_29A6:				; CODE XREF: sub_29B0+8p
		jsr	@@off_A8:8
; End of function sub_29A6


; =============== S U B	R O U T	I N E =======================================


sub_29A8:				; CODE XREF: ROM:28DCp	sub_29B0+1Ep ...
		mov.b	r0l, r2l
		mov.b	r0h, r2h
		mov.b	r1l, r3l
		rts
; End of function sub_29A8


; =============== S U B	R O U T	I N E =======================================


sub_29B0:				; CODE XREF: ROM:2966p	ROM:2984p
		mov.w	r0, e0
		mov.b	@(3:16,r6), r4l
		mov.b	r4l, r1l
		bsr	sub_29A6:8
		mov.w	e0, r0
		mov.b	@(2:16,r6), r5h
		mov.b	r5h, r1l
		jsr	sub_2B28:16
		mov.w	e2, r0
		mov.b	r4l, r1l
		jsr	mloc_2938:16
		jsr	@@off_BA:8
		mov.b	r3h, r0h
		mov.b	#0, r0l
		mov.b	r5h, r1l
		jsr	sub_2B2C:16
		jsr	sub_2B20:16
		mov.w	e1, r2
		mov.b	#0, r3l
		jsr	@@off_BC:8
		mov.b	@0x42:8, r4l
		mov.b	r3h, r2h
		mov.b	@(1:16,r6), r2l
		add.b	r2h, r2l
		cmp.b	r2l, r4h
		bcc	loc_2A04:8
		mov.b	@r6, r2l
		add.b	r2h, r2l
		cmp.b	r2l, r4h
		bcs	loc_2A00:8
		cmp.b	r4l, r0h
		bcs	locret_2A06:8
		bmi	loc_2A04:8

loc_2A00:				; CODE XREF: sub_29B0+48j
		mov.b	r4l, r0h
		bra	locret_2A06:8
; ---------------------------------------------------------------------------

loc_2A04:				; CODE XREF: sub_29B0+40j sub_29B0+4Ej
		mov.b	#0, r0h

locret_2A06:				; CODE XREF: sub_29B0+4Cj sub_29B0+52j
		rts
; End of function sub_29B0


; =============== S U B	R O U T	I N E =======================================


mloc_2a08:				; CODE XREF: ROM:2A4Ep	ROM:loc_2A54p
		mov.b	@r4+, r2l
		mov.b	#0x3C, r1l ; '<'
		mulxu.b	r1l, r2
		cmp.w	r0, r2
		rts
; End of function mloc_2a08

; ---------------------------------------------------------------------------

mloc_2a12:
		andc	#0xAF, ccr ; ''
		mov.b	@0xFE94:16, r0h
		mov.w	#0xFF47, r6
		mov.w	#4, r2
		jsr	sub_2878:16
		jsr	sub_2B64:16
		bne	loc_2A2E:8
		jmp	loc_2B14:16
; ---------------------------------------------------------------------------

loc_2A2E:				; CODE XREF: ROM:2A28j
		mov.b	r3l, r6h
		mov.b	r3l, @0x3C:8
		mov.w	#0xFF3E, r4
		mov.b	@r4+, r0l
		mov.b	r0l, @0xFDFF:16
		mov.w	@0xFE22:16, r2
		mov.w	@0xFE9E:16, r0
		bne	loc_2A48:8
		mov.w	r2, r0

loc_2A48:				; CODE XREF: ROM:2A44j
		and.b	#0x3F, r0h
		and.b	#0x3F, r2h
		sub.w	r2, r0
		bsr	mloc_2a08:8
		bcs	loc_2A54:8
		orc	#0x10, ccr

loc_2A54:				; CODE XREF: ROM:2A50j
		bsr	mloc_2a08:8
		biand	#5, @7:8
		bcc	loc_2A7E:8
		mov.w	#0xFE50, r1
		mov.b	#4, r2l
		jsr	@@off_AE:8
		mov.b	r0l, @0xFDFE:16
		mov.w	@0xFE5C:16, r0
		mov.w	r0, @0xFDFC:16
		mov.w	@0xFE9C:16, r2
		cmp.w	r2, r0
		bst	#2, @7:8
		bset	#5, @7:8

loc_2A7E:				; CODE XREF: ROM:2A5Aj
		mov.w	@0xFE9C:16, r0
		mov.w	@0xFDFC:16, r2
		sub.w	r2, r0
		mov.b	r0h, r2l
		mov.b	#0, r2h
		mov.w	r2, e2
		mov.b	r0l, r2h
		mov.b	#0, r2l
		mov.b	@0xFDFE:16, r1l
		jsr	sub_2B4E:16
		mov.w	#0xFF41, r4
		mov.b	@r4+, r0l
		add.b	r0h, r0l
		bcc	loc_2AA6:8
		mov.b	#0xFF, r0l

loc_2AA6:				; CODE XREF: ROM:2AA2j
		mov.b	r0l, r5l
		mov.b	#0, r3l
		mov.b	@r4+, r2h
		mov.b	#0, r2l
		mov.b	@0xFE94:16, r0h
		mov.b	@r4+, r0l
		mulxu.b	r0h, r0
		mov.b	#0, r1l
		jsr	@@off_BC:8
		jsr	@@off_BA:8
		mov.w	@0xFE9C:16, r0
		mov.b	@r4+, r1l
		bsr	sub_2B1E:8
		jsr	@@off_BE:8
		jsr	sub_2B58:16
		mov.b	r5l, r1l
		bsr	sub_2B1E:8
		jsr	sub_2B46:16
		btst	#2, @7:8
		beq	loc_2ADA:8
		mov.b	#0x20, r0l ; ' '

loc_2ADA:				; CODE XREF: ROM:2AD6j
		mov.b	r0l, r6l
		mov.b	r0l, @0x3B:8
		mov.b	@0xFE94:16, r0l
		mov.b	@r4+, r0h
		sub.b	r0h, r0l
		mov.b	@r4+, r0h
		mulxu.b	r0h, r0
		bsr	sub_2B46:8
		mov.b	r6l, r1l
		jsr	@@off_A8:8
		mov.w	r0, r2
		mov.w	r1, e2
		mov.b	r6h, r1l
		bsr	sub_2B4E:8
		bsr	sub_2B3A:8
		mov.b	r0l, r5h
		mov.b	r0l, @0x3A:8
		stc.b	ccr, r0h
		btst	#4, r0h
		bne	loc_2B18:8
		mov.w	@0xFE9C:16, r0
		mov.w	@0xFE5C:16, r1
		sub.w	r1, r0
		bsr	sub_2B3A:8
		cmp.b	r0l, r5h
		bcc	loc_2B18:8

loc_2B14:				; CODE XREF: ROM:2A2Aj
		bset	#6, @5:8

loc_2B18:				; CODE XREF: ROM:2B02j	ROM:2B12j
		bclr	#7, @0xB:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_2B1E:				; CODE XREF: ROM:2AC2p	ROM:2ACCp
		jsr	@@off_A8:8
; End of function sub_2B1E


; =============== S U B	R O U T	I N E =======================================


sub_2B20:				; CODE XREF: sub_29B0+2Ap
		mov.b	r0h, r0l
		mov.b	r1l, r0h
		mov.b	#0, r1l
		rts
; End of function sub_2B20


; =============== S U B	R O U T	I N E =======================================


sub_2B28:				; CODE XREF: sub_29B0+12p
		bsr	sub_2B2C:8
		jmp	@@off_BA:8
; End of function sub_2B28


; =============== S U B	R O U T	I N E =======================================


sub_2B2C:				; CODE XREF: sub_29B0+26p sub_2B28p
		jsr	@@off_A8:8
; End of function sub_2B2C


; =============== S U B	R O U T	I N E =======================================


sub_2B2E:				; CODE XREF: sub_29B0+32p ROM:2AB8p ...
		add.b	r2l, r0l
		addx	r2h, r0h
		addx	r3l, r1l
		rts
; End of function sub_2B2E

; ---------------------------------------------------------------------------

mloc_2b36:
		bsr	sub_2B46:8
		bra	sub_2B2E:8

; =============== S U B	R O U T	I N E =======================================


sub_2B3A:				; CODE XREF: ROM:2AF8p	ROM:2B0Ep
		bsr	sub_2B46:8
		cmp.b	#0, r0h
		beq	locret_2B44:8
		mov.b	#0, r0h
		mov.b	#0xFF, r0l

locret_2B44:				; CODE XREF: sub_2B3A+4j
		rts
; End of function sub_2B3A


; =============== S U B	R O U T	I N E =======================================


sub_2B46:				; CODE XREF: ROM:2ACEp	ROM:2AEAp ...
		mov.b	#4, r1h
; End of function sub_2B46


; =============== S U B	R O U T	I N E =======================================


sub_2B48:				; CODE XREF: sub_1F7C+64p
		mov.b	#0, r1l
		jmp	loc_2D32:16
; End of function sub_2B48


; =============== S U B	R O U T	I N E =======================================


sub_2B4E:				; CODE XREF: ROM:2A96p	ROM:2AF6p
		mov.b	#0, r1h
		jsr	@@off_CA:8
		mov.w	r2, r0
		mov.w	e2, r1
		bne	loc_2B5C:8
; End of function sub_2B4E


; =============== S U B	R O U T	I N E =======================================


sub_2B58:				; CODE XREF: ROM:2AC6p
		cmp.b	#0, r1l
		beq	locret_2B62:8

loc_2B5C:				; CODE XREF: sub_2B4E+8j
		mov.w	#0xFFFF, r0
		mov.b	#0, r1l

locret_2B62:				; CODE XREF: sub_2B58+2j
		rts
; End of function sub_2B58


; =============== S U B	R O U T	I N E =======================================


sub_2B64:				; CODE XREF: ROM:2A24p
		bsr	sub_2B7E:8
		beq	locret_2B7C:8
		dec.b	r3l
		bmi	loc_2B72:8
		mov.w	r6, r1
		add.b	r3l, r1l
		mov.b	@r1, r3l

loc_2B72:				; CODE XREF: sub_2B64+6j
		dec.b	r3h
		bmi	locret_2B7C:8
		mov.w	r6, r1
		add.b	r3h, r1l
		mov.b	@r1, r3l

locret_2B7C:				; CODE XREF: sub_2B64+2j sub_2B64+10j
		rts
; End of function sub_2B64


; =============== S U B	R O U T	I N E =======================================


sub_2B7E:				; CODE XREF: sub_2B64p	sub_2BA8+4p
		sub.w	r3, r3
		mov.b	#4, r0l
		jsr	@@off_A6:8
		bne	loc_2B8E:8
		jsr	@@off_76:8
		and.b	#7, r0l
		beq	loc_2B8E:8
		mov.b	r0l, r3l

loc_2B8E:				; CODE XREF: sub_2B7E+6j sub_2B7E+Cj
		push.w	r5
		mov.w	#0xBCC,	r4
		mov.b	#3, r5l

loc_2B96:				; CODE XREF: sub_2B7E+22j
		mov.b	@r4+, r0l
		jsr	@@off_A4:8
		bcc	loc_2B9E:8
		mov.b	r5l, r3h

loc_2B9E:				; CODE XREF: sub_2B7E+1Cj
		dec.b	r5l
		bne	loc_2B96:8
		pop.w	r5
		mov.w	r3, r0
		rts
; End of function sub_2B7E


; =============== S U B	R O U T	I N E =======================================


sub_2BA8:				; CODE XREF: sub_F56+F4p
		jsr	@@off_70:8
		beq	loc_2BB6:8
		bsr	sub_2B7E:8
		beq	loc_2BB6:8
		bset	#3, @9:8
		rts
; ---------------------------------------------------------------------------

loc_2BB6:				; CODE XREF: sub_2BA8+2j sub_2BA8+6j
		bclr	#3, @9:8
		rts
; End of function sub_2BA8


; =============== S U B	R O U T	I N E =======================================


mloc_2bbc:				; CODE XREF: ROM:2BDCp	ROM:2BE2p
		mov.w	@0xFE90:16, r0
		mov.w	@0xFE16:16, r2
		beq	loc_2BD0:8
		sub.w	r0, r2
		mov.w	@r1+, r4
		bxor	#7, r4h
		bcc	loc_2BD2:8
		bpl	locret_2BD4:8

loc_2BD0:				; CODE XREF: mloc_2bbc+8j
		mov.w	r2, r4

loc_2BD2:				; CODE XREF: mloc_2bbc+10j
		cmp.w	r4, r2

locret_2BD4:				; CODE XREF: mloc_2bbc+12j
		rts
; End of function mloc_2bbc

; ---------------------------------------------------------------------------

mloc_2bd6:
		mov.b	#2, r6h
		mov.w	#0xFF3E, r1
		bsr	mloc_2bbc:8
		bcs	loc_2BE8:8
		dec.b	r6h
		bsr	mloc_2bbc:8
		bcs	loc_2BE8:8
		dec.b	r6h

loc_2BE8:				; CODE XREF: ROM:2BDEj	ROM:2BE4j
		bsr	sub_2BF0:8
		bclr	#3, @0xB:8
		rts

; =============== S U B	R O U T	I N E =======================================


sub_2BF0:				; CODE XREF: sub_F56+292j
					; ROM:loc_2BE8p
		mov.b	@9:8, r6l
		mov.b	r6l, r5h
		mov.b	@0xFE1E:16, r2l
		bld	#7, r2l
		biand	#6, r2l
		band	#1, r6l
		bcc	loc_2C34:8
		btst	#5, r6l
		bne	loc_2C30:8
		cmp.b	#1, r6h
		bcs	loc_2C2C:8
		bhi	loc_2C12:8
		btst	#4, r6l
		beq	loc_2C20:8
		bsr	sub_2C58:8
		beq	loc_2C36:8

loc_2C12:				; CODE XREF: sub_2BF0+18j
		bset	#4, @0x24:8
		bset	#5, r6l
		bclr	#4, r6l
		mov.w	@0xFF42:16, r0
		bra	loc_2C26:8
; ---------------------------------------------------------------------------

loc_2C20:				; CODE XREF: sub_2BF0+1Cj
		bset	#4, r6l
		mov.w	@0xFF44:16, r0

loc_2C26:				; CODE XREF: sub_2BF0+2Ej
		mov.w	r0, @0xFE26:16
		bra	loc_2C36:8
; ---------------------------------------------------------------------------

loc_2C2C:				; CODE XREF: sub_2BF0+16j
		bclr	#4, r6l
		bra	loc_2C36:8
; ---------------------------------------------------------------------------

loc_2C30:				; CODE XREF: sub_2BF0+12j
		bsr	sub_2C58:8
		beq	loc_2C36:8

loc_2C34:				; CODE XREF: sub_2BF0+Ej
		and.b	#0xCF, r6l

loc_2C36:				; CODE XREF: sub_2BF0+20j sub_2BF0+3Aj ...
		and.b	#0x3D, r6l
		and.b	#0xC0, r2l
		or.b	r2l, r6l
		mov.b	r6l, @9:8
		and.b	#0xF0, r6l
		and.b	#0xF0, r5h
		cmp.b	r5h, r6l
		beq	loc_2C4A:8
		bset	#0, @9:8

loc_2C4A:				; CODE XREF: sub_2BF0+54j
		mov.b	@0xFE26:16, r0l
		and.b	#0xF, r0l
		or.b	r6l, r0l
		mov.b	r0l, @0xFE98:16
		rts
; End of function sub_2BF0


; =============== S U B	R O U T	I N E =======================================


sub_2C58:				; CODE XREF: sub_2BF0+1Ep
					; sub_2BF0:loc_2C30p
		mov.w	@0xFE26:16, r0
		btst	#6, r0h
		rts
; End of function sub_2C58


; =============== S U B	R O U T	I N E =======================================


sub_2C60:				; CODE XREF: ROM:290Ap
		mov.b	#6, r0l
		jsr	@@off_A6:8
		bne	loc_2C6A:8
		mov.b	r0l, r3l
		bne	loc_2C6C:8

loc_2C6A:				; CODE XREF: sub_2C60+4j
		mov.b	@0x3E:8, r3l

loc_2C6C:				; CODE XREF: sub_2C60+8j
		mov.b	#7, r0l
		jsr	@@off_A4:8
		bcs	loc_2C78:8
		mov.b	#6, r0l
		jsr	@@off_A4:8
		bcc	locret_2C7A:8

loc_2C78:				; CODE XREF: sub_2C60+10j
		mov.b	@0x3F:8, r3l

locret_2C7A:				; CODE XREF: sub_2C60+16j
		rts
; End of function sub_2C60


; =============== S U B	R O U T	I N E =======================================


sub_2C7C:				; CODE XREF: ROM:280Ap
		mov.b	@0x3F:8, r0l
		mov.b	r0l, r4l
		and.b	#0xF, r4l
		jsr	@@off_A2:8
		mov.b	r0l, r4h
		and.b	#0xF, r4h
; End of function sub_2C7C


; =============== S U B	R O U T	I N E =======================================


sub_2C88:				; CODE XREF: ROM:281Ep
		mov.b	@r6+, r1l
		mov.w	@0xFE10:16, r0
		jsr	@@off_A8:8
		mov.b	@r6+, r2l
		mov.b	@0xFE12:16, r2h
		mulxu.b	r2h, r2
		mov.b	#0, r3l
		jsr	@@off_BE:8
		jsr	@@off_BA:8
		mov.b	#0, r0h
		mov.b	#0, r1l
		mov.b	@r6+, r0l
		mov.b	r4h, r1h
		jsr	sub_2D40:16
		jsr	@@off_BC:8

loc_2CAC:				; CODE XREF: ROM:28D8p
		mov.b	r4l, r1h
		jmp	@@off_D0:8
; End of function sub_2C88


; =============== S U B	R O U T	I N E =======================================


sub_2CB0:				; CODE XREF: sub_D50+12p
		mov.b	#0xFF, r2l
		bra	loc_2CB6:8
; End of function sub_2CB0


; =============== S U B	R O U T	I N E =======================================


sub_2CB4:				; CODE XREF: ROM:0194p	sub_56E+68p ...
		mov.b	#0, r2l

loc_2CB6:				; CODE XREF: sub_2CB0+2j sub_2CB4+8j
		cmp.w	r0, r1
		bls	locret_2CCA:8
		mov.b	r2l, @-r1
		bra	loc_2CB6:8
; ---------------------------------------------------------------------------

mloc_2CBE:				; CODE XREF: sub_2CB4+14j
		mov.w	@r3+, r0
		mov.b	@r0, r2h
		mov.b	r2h, @r1
		inc.w	#1, r1
		dec.b	r2l
		bgt	mloc_2CBE:8

locret_2CCA:				; CODE XREF: sub_2CB4+4j
		rts
; End of function sub_2CB4


; =============== S U B	R O U T	I N E =======================================


mloc_2CCC:				; CODE XREF: mloc_2CCC+8j
					; sub_346A+140p
					; DATA XREF: ...
		mov.w	@r3+, r0
		mov.b	@r1+, r2h
		mov.b	r2h, @r0
		dec.b	r2l
		bgt	mloc_2CCC:8
		rts
; End of function mloc_2CCC


; =============== S U B	R O U T	I N E =======================================


sub_2CD8:				; CODE XREF: sub_56E+1Cp sub_56E+30p ...
		mov.b	@r1+, r0h
		mov.b	r0h, @r2
		inc.w	#1, r2
		dec.b	r0l
		bne	sub_2CD8:8
		rts
; End of function sub_2CD8


; =============== S U B	R O U T	I N E =======================================


sub_2CE4:				; CODE XREF: sub_668+4p sub_672p
					; DATA XREF: ...
		sub.b	r0h, r0l
		bcc	locret_2CEA:8
		neg.b	r0l

locret_2CEA:				; CODE XREF: sub_2CE4+2j
		rts
; End of function sub_2CE4


; =============== S U B	R O U T	I N E =======================================


sub_2CEC:				; CODE XREF: sub_900+6p sub_900+26p ...
		mov.b	@r1, r0l
		beq	loc_2CF4:8
		dec.b	r0l
		mov.b	r0l, @r1

loc_2CF4:				; CODE XREF: sub_2CEC+2j
		inc.w	#1, r1
		dec.b	r2l
		bne	sub_2CEC:8
		rts
; End of function sub_2CEC

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_900

loc_2CFC:				; CODE XREF: sub_900+2Ej sub_900+240Aj
		mov.w	@r1, r0
		btst	#7, r0h
		bne	loc_2D06:8
		dec.w	#1, r0
		mov.w	r0, @r1

loc_2D06:				; CODE XREF: sub_900+2400j
		inc.w	#2, r1
		dec.b	r2l
		bne	loc_2CFC:8
		rts
; END OF FUNCTION CHUNK	FOR sub_900

; =============== S U B	R O U T	I N E =======================================


sub_2D0E:				; CODE XREF: ROM:3A40p
		mov.b	#0, r2l

loc_2D10:				; CODE XREF: sub_23B6-Ej
		mov.b	@r1, r0l

loc_2D12:				; CODE XREF: sub_39F6-CD0j
		and.b	r0h, r0l
		or.b	r2l, r0l

loc_2D16:				; CODE XREF: sub_2D28+6j
		mov.b	r0l, @r1

locret_2D18:				; CODE XREF: sub_39F6-CD4j
		rts
; End of function sub_2D0E

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_39F6

loc_2D1A:				; CODE XREF: sub_39F6+2j
		mov.b	#1, r2l
		mov.b	@r1, r0l
		add.b	r0l, r2l
		and.b	r0h, r2l
		beq	locret_2D18:8
		xor.b	#0xFF, r0h
		bra	loc_2D12:8
; END OF FUNCTION CHUNK	FOR sub_39F6

; =============== S U B	R O U T	I N E =======================================


sub_2D28:				; CODE XREF: ROM:01AEp	ROM:0350p ...
		mov.b	@r1, r0l
		inc.b	r0l
		beq	locret_2D3E:8
		bra	loc_2D16:8
; End of function sub_2D28


; =============== S U B	R O U T	I N E =======================================


sub_2D30:				; CODE XREF: sub_8CC+10p ROM:28F4p ...
		beq	locret_2D3E:8

loc_2D32:				; CODE XREF: sub_2B48+2j sub_2D30+Cj
		bld	#7, r1l
		rotxr.b	r1l
		rotxr.b	r0h
		rotxr.b	r0l
		dec.b	r1h
		bne	loc_2D32:8

locret_2D3E:				; CODE XREF: sub_2D28+4j sub_2D30j ...
		rts
; End of function sub_2D30


; =============== S U B	R O U T	I N E =======================================


sub_2D40:				; CODE XREF: sub_2C88+1Ep
		beq	locret_2D3E:8

loc_2D42:				; CODE XREF: sub_2D40+Aj
		shll.b	r0l
		rotxl.b	r0h
		rotxl.b	r1l
		dec.b	r1h
		bne	loc_2D42:8
		rts
; End of function sub_2D40

; ---------------------------------------------------------------------------

mloc_2d4e:
		and.b	#0xF0, r0l

; =============== S U B	R O U T	I N E =======================================


sub_2D50:				; CODE XREF: ROM:17F2p	sub_26C4+Cp ...
		rotr.b	r0l
; End of function sub_2D50


; =============== S U B	R O U T	I N E =======================================


sub_2D52:				; CODE XREF: sub_F56:loc_FFEp
					; sub_F56+1FEp	...
		rotr.b	r0l
; End of function sub_2D52


; =============== S U B	R O U T	I N E =======================================


sub_2D54:				; CODE XREF: ROM:0EA8p	sub_F56+18Ap ...
		rotr.b	r0l
		rotr.b	r0l
		rotr.b	r0l
		rts
; End of function sub_2D54

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_346A

loc_2D5C:				; CODE XREF: sub_346A:loc_3590j
					; DATA XREF: ROM:off_72o
		mov.b	r0h, r1l
		mov.b	r0l, r0h
		mov.b	r1l, r0l
		rts
; END OF FUNCTION CHUNK	FOR sub_346A

; =============== S U B	R O U T	I N E =======================================


sub_2D64:				; CODE XREF: sub_56E+3Cp sub_EE6+6p ...
		mov.b	#0, r0l

loc_2D66:				; CODE XREF: sub_2D64+8j sub_346A+20p
		mov.b	@r1+, r0h
		add.b	r0h, r0l
		dec.b	r2l
		bne	loc_2D66:8
		rts
; End of function sub_2D64


; =============== S U B	R O U T	I N E =======================================


sub_2D70:				; CODE XREF: ROM:0388p	sub_2D70+8j
		mov.b	#0, r0l

loc_2D72:				; CODE XREF: sub_2D70+4j
		dec.b	r0l
		bne	loc_2D72:8
		dec.b	r0h
		bne	sub_2D70:8
		rts
; End of function sub_2D70

; ---------------------------------------------------------------------------
unk_2D7C:	.byte	 1		; CODE XREF: ROM:3AA8p	ROM:3AF6p
problem32_32:	.byte	 0
		.byte 0x69 ; i
		.byte 0x31 ; 1
; ---------------------------------------------------------------------------
		mov.w	#0x10, e0
; ---------------------------------------------------------------------------
problem32_33:	.byte  0xA
		.byte 0x81 ; 
; ---------------------------------------------------------------------------
		mov.w	e1, r0
		and.b	#0xF0, r0l
		cmp.b	r2l, r0l
		orc	#1, ccr
		bne	loc_2DA2:8
		bsr	sub_2D52:8
		bne	loc_2D96:8
		mov.b	#0x10, r0l

loc_2D96:				; CODE XREF: ROM:2D92j
		mov.b	#0, r0h
		and.w	#0xF, e1
; ---------------------------------------------------------------------------
problem32_34:	.byte 0x53 ; S
		.byte	 1
; ---------------------------------------------------------------------------
		mov.w	r1, r0
; ---------------------------------------------------------------------------
unk_2DA0:	.byte 0x1A		; CODE XREF: ROM:3A90p
problem32_35:	.byte 0x91 ; 
; ---------------------------------------------------------------------------

loc_2DA2:				; CODE XREF: ROM:2D8Ej
		mov.w	r1, @(1:16,r3)
		mov.w	e1, r1
		mov.b	r1l, @r3
		rts
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_1594

loc_2DAC:				; CODE XREF: sub_2DAE+6j
		dec.w	#2, r1
; END OF FUNCTION CHUNK	FOR sub_1594

; =============== S U B	R O U T	I N E =======================================


sub_2DAE:				; CODE XREF: sub_1594+6j sub_1F7C+78p
					; DATA XREF: ...
		mov.b	@r1+, r0l
		mov.b	r0l, @r1
		dec.b	r0h
		bne	loc_2DAC:8
		rts
; End of function sub_2DAE


; =============== S U B	R O U T	I N E =======================================


sub_2DB8:				; CODE XREF: ROM:loc_1B98p
		sub.b	r2h, r2h
		sub.b	r0h, r2l
		bcs	loc_2DC2:8
		divxu.b	r0l, r2
		rts
; ---------------------------------------------------------------------------

loc_2DC2:				; CODE XREF: sub_2DB8+4j
		neg.b	r2l
		divxu.b	r0l, r2
		neg.b	r2l
		rts
; End of function sub_2DB8


; =============== S U B	R O U T	I N E =======================================


sub_2DCA:				; CODE XREF: sub_13D0+24p ROM:1702p ...
		mov.b	r0h, r1h
		mulxu.b	r1l, r0
		mulxu.b	r1h, r1
		add.b	r0h, r1l
		mov.b	r1l, r0h
		addx	#0, r1h
		mov.b	r1h, r1l
		rts
; End of function sub_2DCA


; =============== S U B	R O U T	I N E =======================================


sub_2DDA:				; CODE XREF: sub_1506+10p sub_1E14+24p ...
		sub.b	r2h, r2h
		mov.b	r0h, r2l
		divxu.b	r1l, r2
		mov.b	r2h, r0h
		divxu.b	r1l, r0
		mov.b	r2l, r2h
		mov.b	r0l, r2l
		rts
; End of function sub_2DDA

; ---------------------------------------------------------------------------
unk_2DEA:	.byte 0x1A		; CODE XREF: ROM:2E02j
Problem32_29:	.byte 0x80 ; 
; ---------------------------------------------------------------------------
		mov.w	e2, r0
; ---------------------------------------------------------------------------
problem32_30:	.byte 0x53 ; S
		.byte 0x10
; ---------------------------------------------------------------------------
		mov.w	e0, e2
; ---------------------------------------------------------------------------
problem32_31:	.byte 0x53 ; S
		.byte 0x12
; ---------------------------------------------------------------------------
		mov.w	e2, r1
		mov.w	r0, e2
		rts
; ---------------------------------------------------------------------------

loc_2DFA:				; CODE XREF: ROM:076Cp	ROM:170Ep ...
		sub.w	e1, e1
		and.w	#0xFF, e2

loc_2E00:				; CODE XREF: ROM:3A62p
		mov.w	e1, e1
		beq	unk_2DEA:8
; ---------------------------------------------------------------------------
problem32_21:	.byte  0xF
		.byte 0x90 ; 
; ---------------------------------------------------------------------------
		mov.w	e2, r1
		mov.b	#0x10, r3l
		sub.w	e1, e1

loc_2E0C:				; CODE XREF: ROM:2E18j
		rotxl.w	r2
; ---------------------------------------------------------------------------
problem32_22:	.byte 0x12
		.byte 0x31 ; 1
		.byte 0x1A
		.byte 0x81 ; 
; ---------------------------------------------------------------------------
		bcc	loc_2E16:8
; ---------------------------------------------------------------------------
problem32_23:	.byte  0xA
		.byte 0x81 ; 
; ---------------------------------------------------------------------------

loc_2E16:				; CODE XREF: ROM:2E12j
		dec.b	r3l
		bne	loc_2E0C:8
		rotxl.w	r2
		not.w	r2
		sub.w	e2, e2
		rts
; ---------------------------------------------------------------------------
unk_2E22:	.byte 0x1A		; CODE XREF: ROM:3EB0p	ROM:3EC6p
problem32_20:	.byte 0xA2 ; 
; ---------------------------------------------------------------------------

loc_2E24:				; CODE XREF: ROM:3EEEp
		mov.w	r3, r1
; ---------------------------------------------------------------------------
problem32_24:	.byte 0x52 ; R
		.byte 0xC1 ; 
; ---------------------------------------------------------------------------
		mov.w	e3, r0
; ---------------------------------------------------------------------------
problem32_25:	.byte 0x52 ; R
		.byte 0xC0 ; 
; ---------------------------------------------------------------------------
		add.w	r0, e1
		mov.w	e0, r0
		bcc	loc_2E34:8
		inc.w	#1, r0

loc_2E34:				; CODE XREF: ROM:2E30j
		sub.w	e0, e0
		mov.w	e2, r3
; ---------------------------------------------------------------------------
problem32_26:	.byte 0x52 ; R
		.byte 0xC2 ; 
		.byte  0xA
		.byte 0xA0 ; 
; ---------------------------------------------------------------------------
		bcs	unk_2E44:8
; ---------------------------------------------------------------------------
problem32_27:	.byte 0x52 ; R
		.byte 0xC3 ; 
; ---------------------------------------------------------------------------
		add.w	r3, e0
		bcc	locret_2E4C:8
; ---------------------------------------------------------------------------
unk_2E44:	.byte 0x7A ; z		; CODE XREF: ROM:2E3Cj
problem32_28:	.byte	 0
		.byte	 0
		.byte	 0
		.byte 0xFF
		.byte 0xFF
		.byte  0xF
		.byte 0x81 ; 
; ---------------------------------------------------------------------------

locret_2E4C:				; CODE XREF: ROM:2E42j
		rts
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_E30

loc_2E4E:				; CODE XREF: sub_E30+2Cj
		mov.w	r5, e3
		jsr	@@off_AC:8
		mov.w	e0, e2
		bmi	loc_2EA4:8
		mov.w	e0, e1
		jsr	@@off_AC:8
		mov.b	r3h, r2l
		shlr.b	r2l
		addx	#0, r2l
		cmp.b	r0h, r2l
		bcc	loc_2EA4:8
		mov.w	e2, e1
		mov.b	r3h, r0l
		shlr.b	r0l
		mov.b	#1, r2l
		addx	#0, r2l
		mov.b	#0, r0h
		add.w	r0, e1
		bsr	sub_2EB0:8
		cmp.b	#2, r4l
		bne	loc_2E80:8
		mov.b	r0h, r0l
		mov.b	@0x3F:8, r0h
		mov.b	r2l, @0x40:8
		mov.b	r2l, @0x41:8

loc_2E80:				; CODE XREF: sub_E30+2046j
		sub.b	r0h, r0l
		cmp.b	r4h, r0l
		bcs	loc_2E88:8
		mov.b	r4h, r0l

loc_2E88:				; CODE XREF: sub_E30+2054j
		mov.b	r0l, r2l
		beq	loc_2EA4:8
		mov.w	e2, e1
		mov.b	r0h, r0l
		mov.b	#0, r0h
		cmp.b	r3h, r6l
		bhi	loc_2E98:8
		inc.b	r0h

loc_2E98:				; CODE XREF: sub_E30+2064j
		cmp.b	r3h, r6h
		bhi	loc_2E9E:8
		inc.b	r0h

loc_2E9E:				; CODE XREF: sub_E30+206Aj
		add.w	r0, e1
		mov.w	e3, r5
		bra	loc_2EB4:8
; ---------------------------------------------------------------------------

loc_2EA4:				; CODE XREF: sub_E30+2024j
					; sub_E30+2032j ...
		mov.w	#0xFF3E, r0
		mov.w	#0xFF5E, r1
		jmp	@@off_A0:8
; END OF FUNCTION CHUNK	FOR sub_E30

; =============== S U B	R O U T	I N E =======================================


sub_2EAE:				; CODE XREF: ROM:0226p	ROM:0366p ...
		mov.b	#1, r2l
; End of function sub_2EAE


; =============== S U B	R O U T	I N E =======================================


sub_2EB0:				; CODE XREF: ROM:0390p	sub_56E+Ep ...

; FUNCTION CHUNK AT 2EE6 SIZE 00000008 BYTES

		mov.w	#0xFF3E, r5

loc_2EB4:				; CODE XREF: sub_E30+2072j
		bset	#7, r3l

loc_2EB6:				; CODE XREF: sub_2EB0+2Aj
		mov.w	r5, r1
		mov.b	r2l, r4l
		bsr	sub_2EEE:8
		bra	loc_2EC0:8
; ---------------------------------------------------------------------------

loc_2EBE:				; CODE XREF: sub_2EB0+20j
		bsr	sub_2F14:8

loc_2EC0:				; CODE XREF: sub_2EB0+Cj
		mov.w	@r1, e0
		cmp.w	r0, e0
		beq	loc_2ECA:8
		bset	#7, r3l
		mov.w	r0, @r1

loc_2ECA:				; CODE XREF: sub_2EB0+14j
		inc.w	#1, e1
		inc.w	#2, r1
		dec.b	r2l
		bne	loc_2EBE:8
		bld	#7, r3l
		bcc	loc_2EE6:8
		bsr	sub_2EDC:8
		bclr	#7, r3l
		bra	loc_2EB6:8
; End of function sub_2EB0


; =============== S U B	R O U T	I N E =======================================


sub_2EDC:				; CODE XREF: sub_2EB0+26p
		mov.b	r4l, r2l
		sub.w	r0, r0
		mov.b	r2l, r0l
		sub.w	r0, e1
		rts
; End of function sub_2EDC

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2EB0

loc_2EE6:				; CODE XREF: sub_2EB0+24j sub_302C+2Cj
		bcc	locret_2EEC:8
		mov.w	#0xFF7E, sp

locret_2EEC:				; CODE XREF: sub_2EB0:loc_2EE6j
		rts
; END OF FUNCTION CHUNK	FOR sub_2EB0

; =============== S U B	R O U T	I N E =======================================


sub_2EEE:				; CODE XREF: sub_2EB0+Ap
		bsr	sub_2F1C:8
		bclr	#1, @AMR:8
		mov.b	#0x3C, r0l ; '<'

loc_2EF6:				; CODE XREF: sub_2EEE+10j
		btst	#7, @PDR5:8
		beq	loc_2F02:8
		dec.b	r0l
		bne	loc_2EF6:8
		bra	loc_2F26:8
; ---------------------------------------------------------------------------

loc_2F02:				; CODE XREF: sub_2EEE+Cj
		jsr	sub_2F94:16
		mov.b	#0xA1, r0l ; ''
		bsr	sub_2F58:8
		bclr	#4, @AMR:8
		bclr	#0, @ADRR:8
		bsr	sub_2F58:8
; End of function sub_2EEE


; =============== S U B	R O U T	I N E =======================================


sub_2F14:				; CODE XREF: sub_2EB0:loc_2EBEp
		bsr	sub_2F18:8
		mov.b	r0l, r0h
; End of function sub_2F14


; =============== S U B	R O U T	I N E =======================================


sub_2F18:				; CODE XREF: sub_2F14p	sub_301E+Aj
		cmp.b	#2, r2l
		bra	loc_2F5A:8
; End of function sub_2F18


; =============== S U B	R O U T	I N E =======================================


sub_2F1C:				; CODE XREF: sub_2EEEp	sub_3012+8p
		bld	#2, @AMR:8
		bcs	loc_2F8A:8
		btst	#7, @AMR:8

loc_2F26:				; CODE XREF: sub_2EEE+12j
		beq	loc_2F8A:8
		btst	#5, @AMR:8
		bne	loc_2F3E:8
		orc	#0x80, ccr ; ''
		jsr	sub_3328:16
		jsr	sub_518:16
		bset	#5, @AMR:8
		andc	#0x7E, ccr ; '~'

loc_2F3E:				; CODE XREF: sub_2F1C+10j
		bset	#4, @AMR:8
		bclr	#1, @AMR:8
		bsr	sub_2F94:8
		mov.b	#0xA0, r0l ; ''
		bsr	sub_2F58:8
		mov.w	e1, r0
		shll.w	r0
		mov.b	r0h, r0l
		bsr	sub_2F58:8
		mov.w	e1, r0
		shll.w	r0
; End of function sub_2F1C


; =============== S U B	R O U T	I N E =======================================


sub_2F58:				; CODE XREF: sub_2EEE+1Ap sub_2EEE+24p ...

; FUNCTION CHUNK AT 2FC0 SIZE 00000016 BYTES
; FUNCTION CHUNK AT 2FDC SIZE 00000004 BYTES

		andc	#0xFE, ccr ; ''

loc_2F5A:				; CODE XREF: sub_2F18+2j
		btst	#4, @AMR:8
		beq	loc_2F68:8
		btst	#3, @ADRR:8
		bne	loc_2F8A:8
		bsr	sub_2FD6:8

loc_2F68:				; CODE XREF: sub_2F58+6j
		bsr	sub_2FA4:8
		btst	#4, @AMR:8
		beq	loc_2FC0:8
		bcc	loc_2F74:8
		bsr	sub_2F7A:8

loc_2F74:				; CODE XREF: sub_2F58+18j
		bld	#0, @ADRR:8
		bcc	locret_2F92:8
; End of function sub_2F58


; =============== S U B	R O U T	I N E =======================================


sub_2F7A:				; CODE XREF: sub_2F58+1Ap
					; sub_2F58:loc_2FDCp
		bsr	sub_2F94:8
		mov.b	#0xA, r0l

loc_2F7E:				; CODE XREF: sub_2F7A+Cj
		btst	#6, @PDR5:8
		bne	locret_2F92:8
		dec.b	r0l
		bne	loc_2F7E:8
		bsr	sub_2FE6:8

loc_2F8A:				; CODE XREF: sub_2F1C+4j
					; sub_2F1C:loc_2F26j ...
		orc	#1, ccr
		mov.w	#0x2EE6, r0
		mov.w	r0, @sp

locret_2F92:				; CODE XREF: sub_2F58+20j sub_2F7A+8j
		rts
; End of function sub_2F7A


; =============== S U B	R O U T	I N E =======================================


sub_2F94:				; CODE XREF: sub_2EEE:loc_2F02p
					; sub_2F1C+2Ap	...
		mov.b	@AMR:8,	r0l
		bist	#2, r0l
		bclr	#0, r0l
		mov.b	r0l, @AMR:8
		bsr	sub_2FA4:8
		bclr	#1, @AMR:8
		rts
; End of function sub_2F94


; =============== S U B	R O U T	I N E =======================================


sub_2FA4:				; CODE XREF: sub_2F58:loc_2F68p
					; sub_2F94+8p
		mov.b	#0x32, r0l ; '2'

loc_2FA6:				; CODE XREF: sub_2FA4+Aj
		btst	#1, @AMR:8
		bne	loc_2FB2:8
		dec.b	r0l
		bne	loc_2FA6:8
		bra	loc_2F8A:8
; ---------------------------------------------------------------------------

loc_2FB2:				; CODE XREF: sub_2FA4+6j
		btst	#3, @ADRR:8
		bne	loc_2F8A:8
		btst	#5, @AMR:8
		beq	loc_2F8A:8
		rts
; End of function sub_2FA4

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2F58

loc_2FC0:				; CODE XREF: sub_2F58+16j
		btst	#0, @ADRR:8
		bne	loc_2FDC:8
		bst	#0, @ADRR:8

loc_2FCA:				; CODE XREF: sub_2F58+86j
		orc	#0x80, ccr ; ''
		mov.b	@ADSR:8, r0l

loc_2FCE:				; CODE XREF: sub_2FD6+4j
		bclr	#1, @AMR:8
		andc	#0x7F, ccr ; ''
		rts
; END OF FUNCTION CHUNK	FOR sub_2F58

; =============== S U B	R O U T	I N E =======================================


sub_2FD6:				; CODE XREF: sub_2F58+Ep
		orc	#0x80, ccr ; ''
		mov.b	r0l, @ADSR:8
		bra	loc_2FCE:8
; End of function sub_2FD6

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2F58

loc_2FDC:				; CODE XREF: sub_2F58+6Cj
		bsr	sub_2F7A:8
		bra	loc_2FCA:8
; END OF FUNCTION CHUNK	FOR sub_2F58

; =============== S U B	R O U T	I N E =======================================


sub_2FE0:				; CODE XREF: ROM:02AAp	sub_934+40p ...
		mov.b	#0, r0l
		mov.b	r0l, @AMR:8
		rts
; End of function sub_2FE0


; =============== S U B	R O U T	I N E =======================================


sub_2FE6:				; CODE XREF: sub_4DC:loc_522p
					; sub_2F7A+Ep
		bsr	sub_2FE0:8
		bclr	#7, @PDR5:8
		mov.b	#0x1E, r0l

loc_2FEE:				; CODE XREF: sub_2FE6+12j
		btst	#6, @PDR5:8
		bne	locret_3010:8
		bnot	#7, r0l
		mov.b	r0l, @PCR5:8
		bra	loc_2FEE:8
; ---------------------------------------------------------------------------

loc_2FFA:				; CODE XREF: sub_F56:loc_3228j
					; sub_346A+132p
					; DATA XREF: ...
		mov.b	#1, r0l
		cmp.w	#0x1000, r3
		bcc	locret_3010:8
		mov.w	#0xFEE2, r1
		mov.b	r0l, @-r1
		mov.b	#5, r0l
		mov.b	r0l, @-r1
		mov.w	r2, @-r1
		mov.w	r3, @-r1

locret_3010:				; CODE XREF: sub_2FE6+Cj sub_2FE6+1Aj	...
		rts
; End of function sub_2FE6


; =============== S U B	R O U T	I N E =======================================


sub_3012:				; CODE XREF: ROM:03F8p	sub_302C+1Cp
		bset	#0, @0:8
		jsr	sub_9E8:16
		jsr	sub_2F1C:16
; End of function sub_3012


; =============== S U B	R O U T	I N E =======================================


sub_301E:				; CODE XREF: ROM:0402p
		mov.w	e2, r0
		mov.b	r0h, r0l
		jsr	sub_2F58:16
		mov.w	e2, r0
		jmp	sub_2F18:16
; End of function sub_301E


; =============== S U B	R O U T	I N E =======================================


sub_302C:				; CODE XREF: ROM:loc_2B8p
		mov.b	@0xFEE0:16, r6h
		beq	locret_3010:8
		cmp.b	#5, r6h
		bhi	loc_304E:8
		mov.w	@0xFEDC:16, e1
		jsr	@@off_AC:8
		mov.w	@0xFEDE:16, e2
		cmp.w	e2, e0
		beq	loc_304E:8
		mov.b	#1, r2l
		dec.w	#1, e1
		bsr	sub_3012:8
		dec.b	r6h
		bne	loc_3054:8

loc_304E:				; CODE XREF: sub_302C+8j sub_302C+16j
		bclr	#0, @0:8
		mov.b	#0, r6h

loc_3054:				; CODE XREF: sub_302C+20j
		mov.b	r6h, @0xFEE0:16
		jmp	loc_2EE6:16
; End of function sub_302C

; ---------------------------------------------------------------------------
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0x32,	2, 0x31, 0xCE, 0x31, 0xCE, 0x31
		.byte 0xA6, 0x31, 0xCE,	0x31, 0xCE, 0x31, 0xCE,	0x31, 0xCE
		.byte 0x31, 0xCE, 0x32,	0x2A, 0x32, 0x3C, 0x32,	0x48, 0x32
		.byte 0x6C, 0x31, 0xCA,	0, 0x21, 0x29, 0x31, 0x41, 0x49
		.byte 0x51, 0x59, 0x61,	0x69, 0x6D, 0x75, 0x79,	0x7D, 0x7D
		.byte 0x64, 0x96, 0xC8,	0xFF, 0xA, 0x14, 0x1E, 0x28, 0x32
		.byte 0x3C, 0x50, 0xFF,	0, 5, 0xA, 0xFF, 0
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_F56

loc_313C:				; CODE XREF: sub_F56+21FEj
		mov.b	#0x80, r0l ; ''
		jsr	@@off_66:8
		bclr	#0, @2:8
		rts
; ---------------------------------------------------------------------------

loc_3146:				; CODE XREF: sub_F56:loc_123Aj
		mov.w	#7, e1
		jsr	@@off_AC:8
		mov.w	e0, r3

loc_314E:				; CODE XREF: sub_F56:loc_31E0j
		mov.b	@0xFE8A:16, r0l
		cmp.b	#0x14, r0l
		bcc	loc_313C:8
		mov.b	#0, r0h
		cmp.b	#0xE, r0l
		bcc	loc_3178:8
		mov.w	#0x311C, r1
		add.w	r0, r1
		mov.b	@r1+, r6h
		mov.b	@r1, r6l
		mov.w	#0xFF20, r4
		add.w	r0, r4
		mov.w	#0x3100, r1
		add.w	r0, r0
		add.w	r0, r1
		mov.w	@r1, r0
		jmp	@r0
; ---------------------------------------------------------------------------

loc_3178:				; CODE XREF: sub_F56+2204j
		mov.w	#0x312A, r1
		mov.b	@r1, r6h
		subx	#0xE, r0l
		add.b	r0l, r6h
		mov.b	r6h, r6l
		inc.b	r6l
		cmp.b	#0, r0l
		beq	loc_319A:8
		dec.b	r0l
		mov.w	#0xFF2E, r1
		add.w	r0, r0
		add.w	r0, r1
		mov.w	@r1, r2

loc_3196:				; CODE XREF: sub_F56+224Ej
		mov.b	#0, r0l
		bra	loc_320A:8
; ---------------------------------------------------------------------------

loc_319A:				; CODE XREF: sub_F56+2232j
		mov.b	@0xFE1F:16, r0h
		mov.b	@0xFE13:16, r0l
		mov.w	r0, r2
		bra	loc_3196:8
; END OF FUNCTION CHUNK	FOR sub_F56
; ---------------------------------------------------------------------------

loc_31A6:				; CODE XREF: ROM:31B6j
		mov.b	@r4, r0l
		mov.b	@0xFE89:16, r0h
		bne	loc_31C0:8
		inc.b	r0h
		mov.b	r0h, @0xFE89:16
		bsr	sub_31BA:8
		bmi	loc_31A6:8
		bra	loc_31EC:8

; =============== S U B	R O U T	I N E =======================================


sub_31BA:				; CODE XREF: ROM:31B4p	ROM:31C2p
		and.b	#0xF, r0l
		dec.b	r0l
		rts
; End of function sub_31BA

; ---------------------------------------------------------------------------

loc_31C0:				; CODE XREF: ROM:31ACj
		jsr	@@off_A2:8
		bsr	sub_31BA:8
		bmi	loc_31CA:8
		add.b	#8, r0l
		bra	loc_320A:8
; ---------------------------------------------------------------------------

loc_31CA:				; CODE XREF: ROM:31C4j	ROM:loc_3206j ...
		bsr	sub_31F0:8
		bra	loc_31E0:8
; ---------------------------------------------------------------------------
		mov.b	@r4, r0h
		mov.b	@0xFE89:16, r0l

loc_31D4:				; CODE XREF: ROM:31DCj
		btst	r0l, r0h
		bne	loc_31E4:8
		inc.b	r0l
		cmp.b	#8, r0l
		bcs	loc_31D4:8
		bsr	sub_31F0:8
; START	OF FUNCTION CHUNK FOR sub_F56

loc_31E0:				; CODE XREF: ROM:31CCj	sub_F56+22BCj
		jmp	loc_314E:16
; END OF FUNCTION CHUNK	FOR sub_F56
; ---------------------------------------------------------------------------

loc_31E4:				; CODE XREF: ROM:31D6j
		inc.b	r0l
		mov.b	r0l, @0xFE89:16
		dec.b	r0l

loc_31EC:				; CODE XREF: ROM:31B8j
		mov.b	#0, r1l
		bra	loc_320C:8

; =============== S U B	R O U T	I N E =======================================


sub_31F0:				; CODE XREF: ROM:loc_31CAp ROM:31DEp ...
		mov.b	@0xFE8A:16, r1l
		inc.b	r1l
		mov.b	r1l, @0xFE8A:16
		mov.b	#0, r1h
		mov.b	r1h, @0xFE89:16
		rts
; End of function sub_31F0

; ---------------------------------------------------------------------------
		mov.b	@r4, r0l
		add.b	#3, r6l

loc_3206:				; CODE XREF: ROM:324Aj
		beq	loc_31CA:8
		dec.b	r0l
; START	OF FUNCTION CHUNK FOR sub_F56

loc_320A:				; CODE XREF: sub_F56+2242j ROM:31C8j ...
		bsr	sub_31F0:8

loc_320C:				; CODE XREF: ROM:31EEj
		mov.b	#0, r0h
		add.b	r6h, r0l
		cmp.b	r6l, r0l
		bcc	loc_31E0:8
		add.w	r0, r3
		cmp.b	#0xF, r1l
		bcc	loc_3228:8
		mov.w	r3, e1
		jsr	@@off_AC:8
		mov.w	e0, r2
		beq	loc_3224:8
		dec.w	#1, r2

loc_3224:				; CODE XREF: sub_F56+22CAj
		mov.w	e1, r3
		dec.w	#1, r3

loc_3228:				; CODE XREF: sub_F56+22C2j
		jmp	@@off_DA:8
; END OF FUNCTION CHUNK	FOR sub_F56
; ---------------------------------------------------------------------------
		mov.b	@0x20:8, r0l
		beq	loc_31CA:8
		mov.b	@r4, r0l
		and.b	#0x7F, r0l
		beq	loc_31CA:8
		cmp.b	#4, r0l
		bhi	loc_31CA:8
		dec.b	r0l
		bra	loc_320A:8
; ---------------------------------------------------------------------------
		mov.b	@r4, r2l
		beq	loc_31CA:8
		mov.w	#0x312F, r1
		bsr	sub_325E:8
		bra	loc_320A:8
; ---------------------------------------------------------------------------
		mov.b	@r4, r0l
		beq	loc_3206:8
		mov.b	@0xFD81:16, r2l
		sub.b	r0l, r2l
		bcc	loc_3256:8
		mov.b	#0, r2l

loc_3256:				; CODE XREF: ROM:3252j
		mov.w	#0x3137, r1
		bsr	sub_325E:8
		bra	loc_320A:8

; =============== S U B	R O U T	I N E =======================================


sub_325E:				; CODE XREF: sub_223A+18p ROM:3244p ...
		mov.w	r1, r0

loc_3260:				; CODE XREF: sub_325E+6j
		mov.b	@r0+, r2h
		cmp.b	r2l, r2h
		bcs	loc_3260:8
		sub.w	r1, r0
		dec.b	r0l
		rts
; End of function sub_325E

; ---------------------------------------------------------------------------
		.byte 0x28, 0x20, 0x47,	0x96, 0x68, 0x4A, 0x47,	0x92, 0x79
		.byte 1, 0x31, 0x2B, 0x55, 0xE4, 0x40, 0x8E, 0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0x36, 0xAC, 0x35,	0x20, 0x35
		.byte 0x3E, 0x35, 0xE, 0x35, 0x92, 0x35, 0xA0, 0x35, 0x1A
		.byte 0x35, 8, 0x35, 8,	0x35, 8, 0x35, 8, 0x35,	8, 0x35
		.byte 8, 0x35, 8, 0x36,	0x52, 0x35, 0xB4, 0xFE,	0x83, 0xFE
		.byte 0x81, 0xFE, 0x80,	1, 0

; =============== S U B	R O U T	I N E =======================================


sub_3328:				; CODE XREF: sub_2F1C+14p ROM:333Ep
		bclr	#6, @AMR:8
		bld	#7, @SCR3:8
		bst	#0, @0xE:8
		bclr	#7, @SCR3:8
		bclr	#6, @SCR3:8
		rts
; End of function sub_3328

; ---------------------------------------------------------------------------
		bsr	sub_3328:8
		andc	#0x7F, ccr ; ''
		bclr	#5, @ADRR:8
		push.w	r0
		push.w	r1
		push.w	r2
		push.w	r3
		push.w	r5
		push.w	r6
		mov.w	#0xFF3E, r6
		mov.b	@0x45:8, r5l
		mov.b	@ADRR:8, r0l
		mov.b	r0l, r0h
		mov.b	r0l, r1l
		and.b	#0xC0, r1l
		bne	loc_33D4:8
		and.b	#0x16, r0l
		bld	#4, @AMR:8
		beq	loc_337E:8
		mov.b	r0h, r0l
		and.b	#0xE8, r0h
		mov.b	r0h, @ADRR:8
		bcs	loc_3386:8
		sub.w	r5, r5
		mov.w	r5, @r6
		bld	#2, r0l
		bst	#7, r5l
		bsr	sub_33E2:8
		bra	loc_33A8:8
; ---------------------------------------------------------------------------

loc_337E:				; CODE XREF: ROM:3368j
		bcc	loc_3386:8
		btst	#0, @ADRR:8
		bne	loc_33D4:8

loc_3386:				; CODE XREF: ROM:3370j	ROM:loc_337Ej
		mov.b	@0xE:8,	r5h
		mov.b	#0, r2h
		bcc	loc_3398:8
		btst	#5, r5l
		bne	loc_33CE:8
		btst	#3, r5l
		beq	loc_3398:8
		jsr	sub_36D4:16

loc_3398:				; CODE XREF: ROM:338Aj	ROM:3392j ...
		bld	#6, r5l
		bsr	sub_33E2:8
		btst	#4, @AMR:8
		bne	loc_33A6:8
		jsr	sub_346A:16

loc_33A6:				; CODE XREF: ROM:33A0j
		mov.b	r5h, @0xE:8

loc_33A8:				; CODE XREF: ROM:337Cj	ROM:33E0j
		mov.b	r5l, @0x45:8
		bld	#0, @0xE:8

loc_33AE:				; CODE XREF: ROM:345Aj
		pop.w	r6
		pop.w	r5
		pop.w	r3
		pop.w	r2
		pop.w	r1
		pop.w	r0
		bset	#6, @AMR:8
		btst	#3, @0xE:8
		bne	locret_33CC:8
		bist	#6, @SCR3:8
		bst	#7, @SCR3:8

locret_33CC:				; CODE XREF: ROM:33C2j
		rte
; ---------------------------------------------------------------------------

loc_33CE:				; CODE XREF: ROM:338Ej
		mov.b	#0x5A, r2h ; 'Z'
		bclr	#5, r5l
		bra	loc_3398:8
; ---------------------------------------------------------------------------

loc_33D4:				; CODE XREF: ROM:3360j	ROM:3384j
		and.b	#0x3E, r0l
		mov.b	r0l, @ADRR:8
		bclr	#4, @AMR:8
		sub.w	r0, r0
		mov.w	r0, @r6
		bra	loc_33A8:8

; =============== S U B	R O U T	I N E =======================================


sub_33E2:				; CODE XREF: ROM:337Ap	ROM:339Ap
		andc	#0xFE, ccr ; ''
		btst	#4, @AMR:8
		beq	loc_33F0:8
		mov.b	r2h, @ADSR:8
		bclr	#1, @AMR:8

loc_33F0:				; CODE XREF: sub_33E2+6j
		btst	#4, @AMR:8
		bne	locret_3400:8
		bst	#0, @ADRR:8
		mov.b	@ADSR:8, r2h
		bclr	#1, @AMR:8

locret_3400:				; CODE XREF: sub_33E2+12j
		rts
; End of function sub_33E2

; ---------------------------------------------------------------------------
		bclr	#6, @AMR:8
		bclr	#7, @SCR3:8
		bclr	#6, @SCR3:8
		andc	#0x7F, ccr ; ''
		push.w	r0
		push.w	r1
		push.w	r2
		push.w	r3
		push.w	r5
		push.w	r6
		mov.w	#0xFEB0, r6
		mov.b	@0xE:8,	r5h
		mov.b	@0xF:8,	r5l
		bld	#6, @SSR:8
		bcc	loc_342C:8
		mov.b	@RDR:8,	r2h

loc_342C:				; CODE XREF: ROM:3428j
		mov.b	@SSR:8,	r0l
		mov.b	r0l, r0h
		and.b	#0x38, r0l
		bne	loc_345E:8
		btst	#3, r5l
		beq	loc_3446:8
		btst	#7, @SSR:8
		beq	loc_3454:8
		jsr	sub_36D4:16
		mov.b	r2h, @TDR:8
		bra	loc_3454:8
; ---------------------------------------------------------------------------

loc_3446:				; CODE XREF: ROM:3436j
		bcc	loc_3466:8
		bsr	sub_346A:8
		btst	#5, r5l
		beq	loc_3466:8
		mov.b	#0x5A, r0l ; 'Z'
		mov.b	r0l, @TDR:8
		bclr	#5, r5l

loc_3454:				; CODE XREF: ROM:343Cj	ROM:3444j
		orc	#1, ccr

loc_3456:				; CODE XREF: ROM:3468j
		mov.b	r5l, @0xF:8
		mov.b	r5h, @0xE:8
		jmp	loc_33AE:16
; ---------------------------------------------------------------------------

loc_345E:				; CODE XREF: ROM:3432j
		and.b	#0xC7, r0h
		mov.b	r0h, @SSR:8
		jsr	sub_373E:16

loc_3466:				; CODE XREF: ROM:loc_3446j ROM:344Cj
		andc	#0xFE, ccr ; ''
		bra	loc_3456:8

; =============== S U B	R O U T	I N E =======================================


sub_346A:				; CODE XREF: ROM:33A2p	ROM:3448p

; FUNCTION CHUNK AT 2D5C SIZE 00000008 BYTES
; FUNCTION CHUNK AT 366E SIZE 0000003C BYTES

		mov.w	@r6, r1
		beq	loc_347C:8
		mov.w	r6, r0
		inc.w	#2, r0
		cmp.w	r0, r1
		bls	loc_3486:8
		mov.b	r2h, @-r1

loc_3478:				; CODE XREF: sub_346A+1Aj
					; sub_346A:loc_34A6j
		mov.w	r1, @r6
		rts
; ---------------------------------------------------------------------------

loc_347C:				; CODE XREF: sub_346A+2j
		cmp.b	#0xA5, r2h ; ''
		bne	loc_34A4:8
		mov.w	r6, r1
		add.b	#6, r1l
		bra	loc_3478:8
; ---------------------------------------------------------------------------

loc_3486:				; CODE XREF: sub_346A+Aj
		mov.b	#0xA5, r0l ; ''
		mov.b	#4, r2l
		jsr	loc_2D66:16
		cmp.b	r0l, r2h
		bne	loc_34FE:8
		bclr	#0, r2l
		cmp.b	#0xFF, r6h
		mov.b	@(5:16,r6), r0h
		mov.b	r0h, r1l
		and.b	#0xF0, r1l
		bcs	loc_34A8:8
		bset	#2, r5h
		bra	loc_34B8:8
; ---------------------------------------------------------------------------

loc_34A4:				; CODE XREF: sub_346A+14j
		bset	#6, r5l

loc_34A6:				; CODE XREF: sub_346A+A2j
		bra	loc_3478:8
; ---------------------------------------------------------------------------

loc_34A8:				; CODE XREF: sub_346A+34j
		jsr	@@off_D2:8
		beq	loc_34CE:8
		cmp.b	#0x23, r0h ; '#'
		beq	loc_34E0:8
		cmp.b	#0x30, r1l ; '0'
		bne	loc_34CA:8
		bset	#7, r5l
		bra	loc_34CE:8
; ---------------------------------------------------------------------------

loc_34B8:				; CODE XREF: sub_346A+38j
		btst	#7, r5l
		beq	loc_34CE:8
		bclr	#1, @0:8
		bset	#0, r2l
		cmp.b	#0x10, r1l
		beq	loc_34CE:8
		cmp.b	#0x20, r1l ; ' '
		beq	loc_34CE:8

loc_34CA:				; CODE XREF: sub_346A+48j
		cmp.b	#0x60, r0h ; '`'
		bne	loc_3508:8

loc_34CE:				; CODE XREF: sub_346A+40j sub_346A+4Cj ...
		mov.b	r1l, r0l
		jsr	@@off_78:8
		mov.b	#0, r0h
		mov.w	#0x3300, r1
		add.w	r0, r1
		mov.w	@r1, r0
		cmp.b	#0xFF, r6h
		jmp	@r0
; ---------------------------------------------------------------------------

loc_34E0:				; CODE XREF: sub_346A+44j
		mov.w	#0xFEB2, r1
		mov.w	#0xFEA8, r2
		mov.b	#3, r0l
		jsr	sub_2CD8:16
		bset	#1, r5h
		bset	#7, r5l
		mov.w	#0xFEA8, r0
		mov.b	r0l, r2l
		add.b	#2, r2l
		jmp	loc_3634:16
; ---------------------------------------------------------------------------

loc_34FE:				; CODE XREF: sub_346A+26j
		mov.w	#0xFEE3, r1
		cmp.b	#0xFF, r6h
		addx	#0, r1l
		jsr	@@off_68:8

loc_3508:				; CODE XREF: sub_346A+62j
					; sub_346A:loc_3572p ...
		mov.w	#0, r1
		bra	loc_34A6:8
; ---------------------------------------------------------------------------

mloc_350e:
		bsr	loc_3576:8
		bset	#3, r5h
		bra	loc_3522:8
; ---------------------------------------------------------------------------

mloc_3514:				; CODE XREF: sub_346A:mloc_351aj
		bset	#1, @0:8
		bra	loc_3520:8
; ---------------------------------------------------------------------------

mloc_351a:
		beq	mloc_3514:8
		jsr	mloc_2374:16

loc_3520:				; CODE XREF: sub_346A+AEj
		bsr	loc_357E:8

loc_3522:				; CODE XREF: sub_346A+A8j
					; sub_346A+1D2j
		mov.w	r0, @r6
		mov.b	#0, r0l
		mov.b	r0l, @(6:16,r6)
		bset	#3, r5l

loc_352C:				; CODE XREF: sub_346A+10Aj
		bset	#5, r5l
		rts
; ---------------------------------------------------------------------------

mloc_3530:				; CODE XREF: sub_346A+E8j
		cmp.b	#0xDB, r1l ; ''
		andc	#0xFE, ccr ; ''
		bne	loc_3538:8
		orc	#1, ccr

loc_3538:				; CODE XREF: sub_346A+CAj
		bst	#0, @0:8
		bra	loc_3572:8
; ---------------------------------------------------------------------------

mloc_353e:
		bsr	loc_357E:8
		mov.b	@(3:16,r6), r1l
		btst	#0, r2l
		beq	loc_3550:8
		cmp.b	#0x10, r0l
		bcc	loc_3572:8
		cmp.b	#0xFE, r0h ; ''
		bne	loc_3572:8

loc_3550:				; CODE XREF: sub_346A+DCj
		mov.w	r0, r0
		beq	mloc_3530:8
		mov.b	r1l, @r0
		mov.b	@0xFE99:16, r1l
		mov.b	@0xFE02:16, r0l
		btst	#6, r0l
		beq	loc_356C:8
		btst	#0, r1l
		beq	loc_3572:8
		mov.b	#0xC0, r0l ; ''
		jsr	sub_4D2:16

loc_356C:				; CODE XREF: sub_346A+F6j
		bset	#0, r1l
		mov.b	r1l, @0xFE99:16

loc_3572:				; CODE XREF: sub_346A+D2j sub_346A+E0j ...
		bsr	loc_3508:8
		bra	loc_352C:8
; ---------------------------------------------------------------------------

loc_3576:				; CODE XREF: sub_346A:mloc_350ep
					; sub_346A+12Ap
		mov.w	@(4:16,r6), r0
		and.b	#0xF, r0l
		bra	loc_3590:8
; ---------------------------------------------------------------------------

loc_357E:				; CODE XREF: sub_346A:loc_3520p
					; sub_346A:mloc_353ep
		mov.b	#0, r0h
		mov.b	@(2:16,r6), r0l
		and.b	#0xF, r0l
		jsr	@@off_A2:8
		mov.w	@(4:16,r6), r1
		and.b	#0xF, r1l
		add.w	r1, r0

loc_3590:				; CODE XREF: sub_346A+112j
		jmp	@@off_72:8
; ---------------------------------------------------------------------------

mloc_3592:
		beq	loc_35C8:8
		bsr	loc_3576:8
		mov.w	r0, r3
		mov.w	@(2:16,r6), r2
		jsr	@@off_DA:8

loc_359E:				; CODE XREF: sub_346A:loc_35B2j
					; ROM:loc_366Aj
		bra	loc_3572:8
; ---------------------------------------------------------------------------

mloc_35a0:
		mov.w	r6, r1
		inc.w	#2, r1
		mov.w	#0x3320, r3
		mov.b	#3, r2l
		jsr	@@off_74:8
		mov.b	#0x3C, r0l ; '<'
		mov.b	r0l, @0xFE35:16

loc_35B2:				; CODE XREF: sub_346A+194j
					; sub_346A+1B8j ...
		bra	loc_359E:8
; ---------------------------------------------------------------------------

mloc_35b4:
		mov.b	@(5:16,r6), r0l
		and.b	#0xF, r0l
		beq	loc_35CA:8
		cmp.b	#1, r0l
		beq	loc_35DA:8
		cmp.b	#2, r0l
		beq	loc_3572:8
		cmp.b	#0xE, r0l
		beq	loc_3612:8

loc_35C8:				; CODE XREF: sub_346A:mloc_3592j
		jmp	@@off_DE:8
; ---------------------------------------------------------------------------

loc_35CA:				; CODE XREF: sub_346A+150j
		bset	#3, @0xB:8
		mov.w	#0xFE90, r2
		mov.b	#0x96, r0l ; ''
		mov.b	r0l, @0xFE33:16
		bra	loc_35F4:8
; ---------------------------------------------------------------------------

loc_35DA:				; CODE XREF: sub_346A+154j
		mov.b	@(2:16,r6), r0l
		btst	#0, r0l
		beq	loc_35F0:8
		mov.b	#0x71, r0h ; 'q'
		mov.b	#4, r0l
		mov.w	r0, @0xFE80:16
		mov.b	#5, r0l
		mov.b	r0l, @0xFE35:16

loc_35F0:				; CODE XREF: sub_346A+176j
		mov.w	#0xFE16, r2

loc_35F4:				; CODE XREF: sub_346A+16Ej
		mov.b	@(4:16,r6), r0h
		mov.b	@(3:16,r6), r0l
		mov.w	r0, @r2
		bra	loc_35B2:8
; ---------------------------------------------------------------------------

loc_3600:				; CODE XREF: sub_346A+1B4j
		bclr	#0, @9:8
		mov.b	#0xFF, r0l
		mov.b	r0l, @(5:16,r6)
		mov.b	#0xBA, r2l ; ''
		mov.w	#0xBB6,	r0
		bra	loc_3634:8
; ---------------------------------------------------------------------------

loc_3612:				; CODE XREF: sub_346A+15Cj
		btst	#7, r5h
		bne	loc_368E:8
		btst	#6, r5h
		beq	loc_366E:8
		btst	#0, @9:8
		bne	loc_3600:8
		bsr	sub_3640:8
		beq	loc_35B2:8
		btst	#5, r5h
		bne	loc_35B2:8
		mov.b	#0xD0, r0l ; ''
		mov.b	r0l, @(5:16,r6)
		mov.b	r1l, r2l
		dec.w	#2, r1
		mov.w	r1, r0

loc_3634:				; CODE XREF: sub_346A+90j
					; sub_346A+1A6j ...
		mov.b	r2l, @(3:16,r6)
		mov.b	r0l, @(4:16,r6)
		jmp	loc_3522:16
; End of function sub_346A


; =============== S U B	R O U T	I N E =======================================


sub_3640:				; CODE XREF: sub_346A+1B6p
					; ROM:mloc_3652p
		mov.w	#0xFE95, r1
		mov.b	@r1+, r2h
		mov.b	r2h, r0l
		mov.b	@r1+, r2l
		or.b	r2l, r0l
		mov.b	@r1, r3l
		or.b	r3l, r0l
		rts
; End of function sub_3640

; ---------------------------------------------------------------------------

mloc_3652:
		bsr	sub_3640:8
		beq	loc_366A:8
		mov.w	r6, r1
		inc.w	#2, r1
		mov.b	@r1+, r3h
		mov.b	@r1+, r0l
		mov.b	@r1+, r0h
		cmp.w	r2, r0
		bne	loc_366A:8
		cmp.b	r3h, r3l
		bne	loc_366A:8
		bset	#5, r5h

loc_366A:				; CODE XREF: ROM:3654j	ROM:3662j ...
		jmp	loc_359E:16
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_346A

loc_366E:				; CODE XREF: sub_346A+1AEj
		mov.b	#0xF3, r0l ; ''
		mov.b	r0l, @(5:16,r6)
		mov.b	@0xFD82:16, r0l
		btst	#3, r7l
		beq	loc_3684:8
		mov.b	#0xFF, r2l
		mov.w	#0xFD, r0 ; ''
		bra	loc_368A:8
; ---------------------------------------------------------------------------

loc_3684:				; CODE XREF: sub_346A+210j
		mov.b	#0xFB, r2l ; ''
		mov.w	#0xF9, r0 ; ''

loc_368A:				; CODE XREF: sub_346A+218j
		bset	#6, r5h
		bra	loc_3634:8
; ---------------------------------------------------------------------------

loc_368E:				; CODE XREF: sub_346A+1AAj
		mov.b	#0xFD, r0l ; ''
		mov.b	r0l, @(5:16,r6)
		btst	#6, r5h
		beq	loc_36A2:8
		mov.b	#0x26, r2l ; '&'
		mov.w	#0x3326, r0
		bclr	#7, r5h
		bra	loc_3634:8
; ---------------------------------------------------------------------------

loc_36A2:				; CODE XREF: sub_346A+22Cj
		mov.b	#0x27, r2l ; '''
		mov.w	#0x3327, r0

loc_36A8:				; CODE XREF: ROM:36D2j
		bra	loc_3634:8
; END OF FUNCTION CHUNK	FOR sub_346A
; ---------------------------------------------------------------------------

loc_36AA:				; CODE XREF: ROM:36B2j	ROM:36BAj
		jmp	@@off_DE:8
; ---------------------------------------------------------------------------

mloc_36ac:
		mov.b	@(5:16,r6), r0l
		cmp.b	#1, r0l
		bne	loc_36AA:8
		mov.b	@0xFE1E:16, r0l
		btst	#6, r0l
		beq	loc_36AA:8
		mov.b	@(4:16,r6), r1l
		mov.w	#0x258,	r0
		jsr	@@off_A8:8
		mov.w	r0, @0xFE22:16
		mov.w	#0xFE22, r0
		mov.b	r0l, r2l
		inc.b	r2l
		bra	loc_36A8:8

; =============== S U B	R O U T	I N E =======================================


sub_36D4:				; CODE XREF: ROM:3394p	ROM:343Ep

; FUNCTION CHUNK AT 3738 SIZE 00000006 BYTES
; FUNCTION CHUNK AT 3742 SIZE 0000002E BYTES

		mov.w	@r6, r0
		mov.b	@(5:16,r6), r1h
		and.b	#0xF0, r1h
		bild	#4, r5l
		biand	#2, r5l
		bcs	loc_3722:8
		mov.b	@(3:16,r6), r2h
		cmp.b	r0l, r2h
		bne	loc_36EC:8
		bclr	#2, r5l

loc_36EC:				; CODE XREF: sub_36D4+14j
		cmp.b	#0x30, r1h ; '0'
		beq	loc_3708:8
		jsr	sub_3770:16
		beq	loc_376A:8
		mov.b	@r0, r2h
		inc.w	#1, r0

loc_36FA:				; CODE XREF: sub_36D4+42j sub_36D4+4Cj ...
		mov.w	r0, @r6

loc_36FC:				; CODE XREF: sub_36D4+5Aj sub_36D4+62j ...
		mov.b	@(6:16,r6), r2l
		add.b	r2h, r2l
		mov.b	r2l, @(6:16,r6)
		rts
; ---------------------------------------------------------------------------

loc_3708:				; CODE XREF: sub_36D4+1Aj
		mov.w	@0xFEDE:16, r2
		mov.w	@r6, r0
		bnot	#4, r5l
		btst	#4, r5l
		beq	loc_3718:8
		mov.b	r2l, r2h
		bra	loc_36FA:8
; ---------------------------------------------------------------------------

loc_3718:				; CODE XREF: sub_36D4+3Ej
		btst	#2, r5l
		beq	loc_371E:8
		bset	#3, r5h

loc_371E:				; CODE XREF: sub_36D4+46j
		inc.w	#1, r0
		bra	loc_36FA:8
; ---------------------------------------------------------------------------

loc_3722:				; CODE XREF: sub_36D4+Cj
		btst	#1, r5l
		bne	loc_3742:8
		btst	#0, r5l
		bne	loc_3730:8
		bset	#0, r5l
		mov.b	#0xA5, r2h ; ''
		bra	loc_36FC:8
; ---------------------------------------------------------------------------

loc_3730:				; CODE XREF: sub_36D4+54j
		bset	#1, r5l
		mov.b	@(5:16,r6), r2h
		bra	loc_36FC:8
; End of function sub_36D4

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_36D4

loc_3738:				; CODE XREF: sub_36D4+70j
		bclr	#1, r5l
		mov.b	@(6:16,r6), r2h
; END OF FUNCTION CHUNK	FOR sub_36D4

; =============== S U B	R O U T	I N E =======================================


sub_373E:				; CODE XREF: ROM:3462p
		bclr	#3, r5l
		jmp	@@off_DE:8
; End of function sub_373E

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_36D4

loc_3742:				; CODE XREF: sub_36D4+50j
		btst	#0, r5l
		beq	loc_3738:8
		bclr	#0, r5l
		bset	#2, r5l
		mov.b	@(4:16,r6), r2h
		mov.b	@(3:16,r6), r2l
		sub.b	r2h, r2l
		inc.b	r2l
		bsr	sub_3770:8
		beq	loc_3762:8
		cmp.b	#0x30, r1h ; '0'
		bne	loc_3766:8
		shll.b	r2l
		bra	loc_3766:8
; ---------------------------------------------------------------------------

loc_3762:				; CODE XREF: sub_36D4+84j
		inc.b	r2l
		shlr.b	r2l

loc_3766:				; CODE XREF: sub_36D4+88j sub_36D4+8Cj
		mov.b	r2l, r2h
		bra	loc_36FC:8
; ---------------------------------------------------------------------------

loc_376A:				; CODE XREF: sub_36D4+20j
		mov.w	@r0+, r1
		mov.b	@r1, r2h
		bra	loc_36FA:8
; END OF FUNCTION CHUNK	FOR sub_36D4

; =============== S U B	R O U T	I N E =======================================


sub_3770:				; CODE XREF: sub_36D4+1Cp sub_36D4+82p
		cmp.b	#0x60, r1h ; '`'
		beq	locret_377A:8
		mov.b	@(5:16,r6), r2h
		cmp.b	#0xFF, r2h

locret_377A:				; CODE XREF: sub_3770+2j
		rts
; End of function sub_3770

; ---------------------------------------------------------------------------
		bclr	#0, @IENR3:8
		push.w	r0
		push.w	r1
		mov.b	#6, r0l
		mov.b	#3, r0h

loc_3788:				; CODE XREF: ROM:3798j
		bld	#0, @IEGR1:8
		mov.b	@PDR1:8, r1l
		bxor	#4, r1l
		subx	#0, r0h
		bmi	loc_3822:16
		dec.b	r0l
		bne	loc_3788:8
		mov.b	#0x1C, r0l
		mov.b	r0l, @0xA4:8
		mov.b	#0x15, r0l
		mov.b	r0l, @SCSR1:8
		mov.w	@0xFF86:16, r1
		mov.w	@0xFEB8:16, r0
		mov.w	r1, @0xFEB8:16
		sub.w	r0, r1
		mov.b	#0x91, r0l ; ''
		mov.b	r0l, @SCR1:8
		mov.b	#0x3B, r0l ; ';'
		mov.b	r0l, @SDRL:8
		inc.w	#2, r0
		btst	#0, @IEGR1:8
		beq	loc_37C8:8
		cmp.w	#0x1594, r1
		bist	#2, @0x11:8

loc_37C8:				; CODE XREF: ROM:37BEj
		mov.b	#0x58, r0h ; 'X'
		btst	#2, @0x11:8
		bne	loc_37D2:8
		mov.b	#0x49, r0h ; 'I'

loc_37D2:				; CODE XREF: ROM:37CEj
		btst	#6, @0x12:8
		bne	loc_3828:8
		mov.w	@0xFECC:16, r1
		beq	loc_382A:8
		divxu.b	r0l, r1
		mov.b	r0h, r0l
		dec.b	r1l
		bpl	loc_37EC:8
		cmp.b	#0, r1h
		beq	loc_37FE:8
		sub.w	r1, r1

loc_37EC:				; CODE XREF: ROM:37E4j
		sub.b	r1l, r0l
		mov.b	r0l, @0xFEBB:16
		add.b	#0x3D, r1h ; '='
		cmp.b	#0, r1l
		bne	loc_37FE:8
		mov.b	r1h, @SDRL:8
		mov.b	#0x19, r0l
		mov.b	r0l, @SCSR1:8

loc_37FE:				; CODE XREF: ROM:37E8j	ROM:37F6j ...
		mov.b	r1h, @0xFEBC:16
		mov.b	r0h, @0xFEBA:16
		bld	#0, @IEGR1:8
		mov.b	@2:8, r0l
		bst	#4, r0l
		bcs	loc_3812:8
		bnot	#5, r0l

loc_3812:				; CODE XREF: ROM:380Ej
		bset	#7, r0l
		mov.b	r0l, @2:8
		bnot	#0, @IEGR1:8
		bclr	#0, @IENR1:8
		bclr	#0, @IENR3:8

loc_3822:				; CODE XREF: ROM:3792j
		pop.w	r1
		pop.w	r0
		rte
; ---------------------------------------------------------------------------

loc_3828:				; CODE XREF: ROM:37D6j
		sub.w	r1, r1

loc_382A:				; CODE XREF: ROM:37DCj
		mov.b	r1l, @0xFEBB:16
		bra	loc_37FE:8
; ---------------------------------------------------------------------------

loc_3830:				; CODE XREF: ROM:385Ej
		cmp.b	#0x47, r0l ; 'G'
		bcc	loc_383A:8
		cmp.b	#0x15, r0l
		bcs	loc_383A:8
		bra	loc_3868:8
; ---------------------------------------------------------------------------

loc_383A:				; CODE XREF: ROM:3832j	ROM:3836j ...
		bld	#3, r0h
		bcc	loc_3878:8
		mov.b	#6, r0h
		bld	#7, @PDR8:8
		bist	#7, r0h
		bra	loc_387A:8
; ---------------------------------------------------------------------------
		push.w	r0
		mov.b	@0xFEBA:16, r0l
		dec.b	r0l
		mov.b	r0l, @0xFEBA:16
		beq	loc_38C4:8
		mov.b	@0xFD94:16, r0h
		btst	#2, @0x11:8
		beq	loc_3830:8
		cmp.b	#0x56, r0l ; 'V'
		bcc	loc_383A:8
		cmp.b	#0x1A, r0l
		bcs	loc_383A:8

loc_3868:				; CODE XREF: ROM:3838j
		bld	#3, r0h
		mov.b	@0xFE80:16, r0h
		bcc	loc_387A:8
		bld	#0, @0x10:8
		bst	#7, r0h
		bra	loc_387A:8
; ---------------------------------------------------------------------------

loc_3878:				; CODE XREF: ROM:383Cj
		mov.b	#6, r0h

loc_387A:				; CODE XREF: ROM:3846j	ROM:386Ej ...
		btst	#2, @IENR3:8
		bne	loc_3888:8
		btst	#7, @8:8
		bne	loc_3888:8
		and.b	#0xBF, r0h

loc_3888:				; CODE XREF: ROM:387Ej	ROM:3884j
		not.b	r0h
		mov.b	r0h, @PDR8:8
		mov.b	@0xFEBB:16, r0h
		cmp.b	r0h, r0l
		beq	loc_38B2:8
		bcc	loc_38BC:8
		btst	#2, @0x11:8
		beq	loc_38D6:8
		cmp.b	#0x2D, r0h ; '-'
		bcs	loc_38A8:8
		subx	#8, r0h
		cmp.b	#0x44, r0h ; 'D'
		bcs	loc_38A8:8
		mov.b	#0x44, r0h ; 'D'

loc_38A8:				; CODE XREF: ROM:389Ej	ROM:38A4j ...
		subx	#1, r0h
		cmp.b	r0h, r0l
		bne	loc_38D0:8

loc_38AE:				; CODE XREF: ROM:38CEj
		mov.b	#0x15, r0l
		bra	loc_38BA:8
; ---------------------------------------------------------------------------

loc_38B2:				; CODE XREF: ROM:3892j
		mov.b	@0xFEBC:16, r0l
		mov.b	r0l, @SDRL:8
		mov.b	#0x19, r0l

loc_38BA:				; CODE XREF: ROM:38B0j
		mov.b	r0l, @SCSR1:8

loc_38BC:				; CODE XREF: ROM:3894j	ROM:38D4j
		bclr	#7, @SCSR1:8
		pop.w	r0
		rte
; ---------------------------------------------------------------------------

loc_38C4:				; CODE XREF: ROM:3854j
		mov.b	r0l, @SCR1:8
		bclr	#0, @IENR3:8
		bset	#0, @IENR1:8
		bra	loc_38AE:8
; ---------------------------------------------------------------------------

loc_38D0:				; CODE XREF: ROM:38ACj
		mov.b	#0x3D, r0l ; '='
		mov.b	r0l, @SDRL:8
		bra	loc_38BC:8
; ---------------------------------------------------------------------------

loc_38D6:				; CODE XREF: ROM:389Aj
		cmp.b	#0x26, r0h ; '&'
		bcs	loc_38A8:8
		subx	#8, r0h
		cmp.b	#0x35, r0h ; '5'
		bcs	loc_38A8:8
		mov.b	#0x35, r0h ; '5'
		bra	loc_38A8:8
; ---------------------------------------------------------------------------
		jsr	sub_980:16
		jmp	loc_45A:16
; ---------------------------------------------------------------------------
Data_38ec:	.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0xFF,	0xFF, 0xFF, 0xFF, 0xFF,	0xFF, 0xFF
		.byte 0xFF, 0xFF, 0, 0x45, 0, 0x63, 1, 0x8F, 2,	0xBB, 3
		.byte 0xE7, 0xFF, 0xFF,	8, 0x66, 9, 0x3D, 0, 1,	4, 0x9B
		.byte 0xA5, 0xE3, 0x15,	0x3A, 0x17, 0x60, 0, 1,	0xB, 0xC6
		.byte 0xA7, 0xF0, 0x37,	0xD, 0x40, 0xC1, 0, 1, 0x35, 0x3F
		.byte 0x7C, 0xEE, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0xB, 0xE6, 0xE, 0xB, 0, 1, 0xB, 0xC6
		.byte 0xA7, 0xF0, 0xD, 0x4C, 0xD, 0xBE,	0, 1, 2, 0x6E
		.byte 0x97, 0x8D, 0x15,	0x3A, 0x17, 0x60, 0, 1,	0xB, 0xC6
		.byte 0xA7, 0xF0, 0x37,	0xD, 0x3C, 0x17, 0, 1, 0x1B, 0xA5
		.byte 0xE3, 0x54, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0x78,	0x5D, 0x82, 0x89, 0, 1,	0x37, 0xCE
		.byte 0xD9, 0x17, 0xB, 0xE6, 0xE, 0xB, 0, 1, 0xB, 0xC6
		.byte 0xA7, 0xF0, 0, 0x64, 0x4A, 0x50, 0, 0x64,	1, 0x90
		.byte 0x4A, 0x1B, 4, 0x64, 2, 0xBC, 0x2E, 0xF, 0x10, 0xC8
		.byte 0xFF, 0xFE, 0x2E,	0xF, 0xF, 0xFA,	0xFF, 0xFF, 0x4A
		.byte 0x46, 4, 0x64, 0,	0x64, 0x40, 0x20, 0, 0x64, 1, 0x90
		.byte 0x30, 0xC, 4, 0x64, 2, 0xBC, 0x2E, 0xF, 0x10, 0xC8
		.byte 0xFF, 0xFE, 0x2E,	0xF, 0xF, 0xFA,	0xFF, 0xFF, 0x4A
		.byte 0x46, 4, 0x64, 0x3B, 0xA6, 0x3C, 0x16, 0x3C, 0x42
		.byte 0x3D, 0x36, 0x3D,	0x36, 0x3D, 0x90, 0x3C,	0xD6, 0x3D
		.byte 0x10, 0x3C, 0x62,	0x3C, 0xAA, 0x3C, 0x74,	0x3C, 0x90
		.byte 0x3D, 0x36, 0x3D,	0x36, 0x3B, 0x5E, 0x3B,	0xC2, 0x3B
		.byte 0x7E

; =============== S U B	R O U T	I N E =======================================


sub_39F6:				; CODE XREF: ROM:3A10p

; FUNCTION CHUNK AT 2D1A SIZE 0000000E BYTES

		mov.b	#0x1F, r0h
		jmp	loc_2D1A:16
; End of function sub_39F6

; ---------------------------------------------------------------------------

loc_39FC:				; CODE XREF: ROM:3A3Aj
		btst	#5, r4l
		bne	loc_3A08:8
		mov.w	#0x73E3, r0
		mov.w	r0, @0xFEC0:16

loc_3A08:				; CODE XREF: ROM:39FEj
		bclr	#5, r4l
		bset	#1, r4l
		btst	#0, r4l
		beq	loc_3A24:8
		bsr	sub_39F6:8
		bne	loc_3A2C:8
		mov.b	@0xFED6:16, r0l
		cmp.b	#1, r0l
		bls	loc_3A24:8
		jsr	sub_3C0C:16
		mov.b	r6l, @0xFED6:16

loc_3A24:				; CODE XREF: ROM:3A0Ej	ROM:3A1Aj
		bclr	#0, r4l
		sub.w	r2, r2
		mov.w	r2, @0xFED0:16

loc_3A2C:				; CODE XREF: ROM:3A12j
		jmp	loc_3AEC:16
; ---------------------------------------------------------------------------

loc_3A30:				; CODE XREF: ROM:02CAp
		mov.b	@0x12:8, r4l
		mov.w	#0xFEDB, r1
		btst	#0, @EBR2:8
		beq	loc_39FC:8
		or.b	#0x21, r4l
		mov.b	#0xE0, r0h ; ''
		jsr	sub_2D0E:16
		mov.w	#0xFF88, r1
		jsr	sub_89E:16
		mov.w	e3, @0xFEC0:16
		bclr	#0, @EBR2:8
		sub.w	r1, r1
		mov.b	@0xFD80:16, r1l
; ---------------------------------------------------------------------------
Problem32_1:	.byte 0x52 ; R
		.byte 0xB1 ; 
		.byte 0x7A ; z
		.byte	 2
		.byte	 2
		.byte 0xBE ; 
		.byte 0x61
		.byte 0x92 ; 
; ---------------------------------------------------------------------------
		jsr	loc_2E00:16
		mov.w	r2, @0xFED0:16
		mov.w	#0xFEC4, r5
		mov.w	#0xFEC2, r6
		mov.w	@r5, e0
		cmp.w	e3, e0
		bcc	loc_3A7A:8
		mov.w	e3, @r5

loc_3A7A:				; CODE XREF: ROM:3A76j
		mov.w	@r6, e0
		cmp.w	e0, e3
		bcc	loc_3A82:8
		mov.w	e3, @r6

loc_3A82:				; CODE XREF: ROM:3A7Ej
		mov.w	#0xFED3, r3
		mov.b	@0xFEDA:16, r4h
		bld	#1, r4l
		bcc	loc_3A96:8
		and.b	#0xF3, r4l
		jsr	unk_2DA0:16
		bra	loc_3ABA:8
; ---------------------------------------------------------------------------

loc_3A96:				; CODE XREF: ROM:3A8Cj
		bne	loc_3AE4:8
		mov.w	@r5, r0
		mov.w	@r6, e0
		sub.w	e0, r0
		btst	#2, r4l
		bne	loc_3AA6:8
		bset	#2, r4l
		bra	loc_3ABA:8
; ---------------------------------------------------------------------------

loc_3AA6:				; CODE XREF: ROM:3AA0j
		mov.b	#0x40, r2l ; '@'
		jsr	unk_2D7C:16
		bcs	loc_3ABA:8
		jsr	@@off_EA:8
		mov.w	r0, @0xFEC6:16
		jsr	sub_22D2:16
		bset	#3, r4l

loc_3ABA:				; CODE XREF: ROM:3A94j	ROM:3AA4j ...
		sub.w	r0, r0
		mov.w	r0, @r5
		dec.w	#1, r0
		mov.w	r0, @r6
; ---------------------------------------------------------------------------
problem32_2:	.byte 0x7A ; z
		.byte	 1
		.byte	 0
		.byte	 0
		.byte	 0
		.byte 0x10
; ---------------------------------------------------------------------------
		mov.w	@0xFED0:16, r2
; ---------------------------------------------------------------------------
problem32_3:	.byte 0x52 ; R
		.byte 0x21 ; !
		.byte 0x7A ; z
		.byte	 0
		.byte 0x71 ; q
		.byte 0xA2 ; 
		.byte 0x5D ; ]
		.byte 0xC0 ; 
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		sub.w	e0, e0
; ---------------------------------------------------------------------------
problem32_4:	.byte 0x53 ; S
		.byte 0x10
; ---------------------------------------------------------------------------
		cmp.b	#0, r0h
		beq	loc_3AE0:8
		mov.b	#0xFD, r0l ; ''

loc_3AE0:				; CODE XREF: ROM:3ADCj
		mov.b	r0l, r4h
		add.b	#2, r4h

loc_3AE4:				; CODE XREF: ROM:loc_3A96j
		bclr	#1, r4l
		dec.b	r4h
		mov.b	r4h, @0xFEDA:16

loc_3AEC:				; CODE XREF: ROM:loc_3A2Cj
		mov.w	@0xFECC:16, r0
		mov.w	#0xFED7, r3
		mov.b	#0, r2l
		jsr	unk_2D7C:16
		bcs	loc_3B00:8
		mov.w	r0, @0xFEC8:16

loc_3B00:				; CODE XREF: ROM:3AFAj
		bclr	#1, @0x11:8
		bclr	#6, r4l
		mov.b	@0xFE81:16, r0l
		mov.b	r0l, r6h
		mov.b	@0xFE83:16, r0h
		mov.w	#1, e6
		and.b	#0xE0, r0l
		cmp.b	#0x40, r0l ; '@'
		bne	loc_3B1E:8
		mov.w	#0xA, e6

loc_3B1E:				; CODE XREF: ROM:3B18j
		mulxu.b	r0h, e6
		jsr	@@off_A2:8
		mov.b	r0l, r4h
		mov.b	#6, r0h
		jsr	@@off_E6:8
		beq	loc_3B2C:8
		bnot	#4, r6h

loc_3B2C:				; CODE XREF: ROM:3B28j
		mov.b	@0xFE37:16, r3l
		mov.w	@0xFED0:16, e4
		mov.w	#0xFECC, r5
		mov.w	@0xFECE:16, e5
		sub.w	r0, r0
		mov.b	@0xFD8B:16, r0l
		mov.w	r0, e3
		mov.w	#0x5D, e7 ; ']'
		mov.b	@0xFED6:16, r6l
		cmp.b	#0x11, r6l
		bcs	loc_3B52:8
		mov.b	#0xE, r6l

loc_3B52:				; CODE XREF: ROM:3B4Ej
		mov.b	r6l, r0l
		add.b	r0l, r0l
		add.w	#0x39D4, r0
		mov.w	@r0, r0
		jmp	@r0
; ---------------------------------------------------------------------------

mloc_3b5e:
		mov.b	#0x10, r6l
		bsr	sub_3B8C:8

; =============== S U B	R O U T	I N E =======================================


sub_3B62:				; CODE XREF: ROM:loc_3BBCp
		mov.b	#0xFF, r0l
		mov.b	r0l, @0xFE34:16
		rts
; End of function sub_3B62

; ---------------------------------------------------------------------------

mloc_3b6a:				; CODE XREF: ROM:3BB2j	ROM:3BB6j
		andc	#0xFE, ccr ; ''
		mov.b	@0xFE34:16, r0l
		bne	loc_3BBE:8
		bset	#0, @8:8
		orc	#1, ccr
		bra	loc_3BBC:8
; ---------------------------------------------------------------------------

mloc_3b7a:				; CODE XREF: ROM:3BBAj
		mov.b	#0xF, r6l
		bra	sub_3B8C:8
; ---------------------------------------------------------------------------

mloc_3b7e:
		mov.b	@0xFE38:16, r0l
		bne	loc_3B96:8
		mov.b	#0, r6l
		bld	#5, @PDR7:8
		bsr	sub_3BFC:8

; =============== S U B	R O U T	I N E =======================================


sub_3B8C:				; CODE XREF: ROM:3B60p	ROM:3B7Cj ...
		mov.w	#0xC0A,	r0
		jsr	@@off_6C:8
		mov.b	r0l, @0xFE38:16

loc_3B96:				; CODE XREF: ROM:3B82j	ROM:3BACj ...
		sub.w	r0, r0
		mov.w	r0, @r5
		mov.w	r0, @0xFECE:16

loc_3B9E:				; CODE XREF: sub_3BC8+24j
		mov.b	r6l, @0xFED6:16
		mov.b	r4l, @0x12:8
		rts
; End of function sub_3B8C

; ---------------------------------------------------------------------------

mloc_3ba6:
		and.b	#0xDE, r4l
		mov.b	@0xFE38:16, r0l
		bne	loc_3B96:8
		btst	#2, @0xA:8
		bne	mloc_3b6a:8
		mov.w	e4, e4
		bne	mloc_3b6a:8
		cmp.b	r4h, r6l
		bne	mloc_3b7a:8

loc_3BBC:				; CODE XREF: ROM:3B78j
		bsr	sub_3B62:8

loc_3BBE:				; CODE XREF: ROM:3B70j
		bsr	sub_3BFC:8
		bra	loc_3B96:8
; ---------------------------------------------------------------------------

mloc_3bc2:
		mov.b	@0xFE38:16, r0l
		beq	unk_3BEE:8

; =============== S U B	R O U T	I N E =======================================


sub_3BC8:				; CODE XREF: ROM:3BFAj	ROM:loc_3C58p ...
		cmp.b	#0, r4h
		beq	loc_3BD6:8
		bld	#4, r6h
		bcs	loc_3BDA:8
		bxor	#5, @PDR7:8
		bcc	loc_3BE0:8

loc_3BD6:				; CODE XREF: sub_3BC8+2j sub_3BC8+16j
		mov.b	#0xE, r6l
		bra	sub_3B8C:8
; ---------------------------------------------------------------------------

loc_3BDA:				; CODE XREF: sub_3BC8+6j
		bxor	#4, @PDR7:8
		bcc	loc_3BD6:8

loc_3BE0:				; CODE XREF: sub_3BC8+Cj
		bld	#4, r6h
		bst	#5, @PDR7:8
		bist	#4, @PDR7:8
		orc	#1, ccr
		bra	loc_3B9E:8
; End of function sub_3BC8

; ---------------------------------------------------------------------------
unk_3BEE:	.byte 0x7A ; z		; CODE XREF: ROM:3BC6j
problem32_5:	.byte	 0
		.byte 0x11
		.byte	 6
		.byte 0x12
		.byte 0xB3 ; 
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	r0, @r5
		bsr	sub_3C0C:8
		bra	sub_3BC8:8

; =============== S U B	R O U T	I N E =======================================


sub_3BFC:				; CODE XREF: ROM:3B8Ap	ROM:loc_3BBEp
		mov.b	@PDR7:8, r0l
		bxor	#5, r0l
		bst	#5, r0l
		bst	#4, r0l
		mov.b	r0l, @PDR7:8
		bclr	#0, @PDR2:8

locret_3C0A:				; CODE XREF: ROM:3C5Cj
		rts
; End of function sub_3BFC


; =============== S U B	R O U T	I N E =======================================


sub_3C0C:				; CODE XREF: ROM:3A1Cp	ROM:3BF8p
		mov.b	#1, r6l
		mov.b	#0x32, r0l ; '2'
		mov.b	r0l, @0xFE37:16
		rts
; End of function sub_3C0C

; ---------------------------------------------------------------------------

mloc_3c16:
		bset	#4, @0x11:8
		btst	#5, r4l
		bne	loc_3C2A:8
; ---------------------------------------------------------------------------
problem32_6:	.byte 0x7A ; z
		.byte	 0
		.byte	 9
		.byte 0x5A ; Z
		.byte  0xC
		.byte 0x77 ; w
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	r0, e7
		bra	loc_3C54:8
; ---------------------------------------------------------------------------

loc_3C2A:				; CODE XREF: ROM:3C1Cj
		mov.b	r4h, r2l
		cmp.b	#2, r4h
		beq	loc_3C38:8
		mov.w	e3, e6
		cmp.b	#0xA, r4h
		beq	loc_3C38:8
		mov.b	#8, r2l

loc_3C38:				; CODE XREF: ROM:3C2Ej	ROM:3C34j
		mov.w	#0x73E3, r0
		mov.w	r0, @0xFEBE:16
		bra	loc_3C52:8
; ---------------------------------------------------------------------------

mloc_3c42:
		cmp.b	r4h, r6l
		bcc	loc_3C54:8
		mov.w	#0x32, e6 ; '2'
		cmp.b	#0xA, r4h
		beq	loc_3C50:8
		mov.w	e3, e6

loc_3C50:				; CODE XREF: ROM:3C4Cj	ROM:loc_3C72j
		mov.b	r4h, r2l

loc_3C52:				; CODE XREF: ROM:3C40j
		mov.b	r2l, r6l

loc_3C54:				; CODE XREF: ROM:3C28j	ROM:3C44j ...
		jsr	sub_3DA8:16

loc_3C58:				; CODE XREF: ROM:loc_3D2Cj
		jsr	sub_3BC8:16
		bcc	locret_3C0A:8
		jmp	loc_3DD2:16
; ---------------------------------------------------------------------------

mloc_3c62:
		inc.w	#1, e4
		cmp.w	e3, e4
		bcc	loc_3CA0:8

loc_3C68:				; CODE XREF: ROM:3C78j
		mov.w	e3, e6

loc_3C6A:				; CODE XREF: ROM:3C94j	ROM:3C9Ej
		cmp.b	r4h, r6l
		beq	loc_3C54:8
		cmp.b	#2, r4h
		bne	loc_3C54:8

loc_3C72:				; CODE XREF: ROM:3CB6j	ROM:3CBEj
		bra	loc_3C50:8
; ---------------------------------------------------------------------------

mloc_3c74:
		cmp.w	#0x32, e4 ; '2'
		bcs	loc_3C68:8
		bsr	sub_3C84:8
		mov.w	#0x33, e6 ; '3'
		mov.b	#0xB, r6l
		bra	loc_3C54:8

; =============== S U B	R O U T	I N E =======================================


sub_3C84:				; CODE XREF: ROM:3C7Ap	ROM:3C96p
		mov.w	#0x110F, r0
		jsr	@@off_6C:8
		mov.b	r0l, @0xFE37:16
		rts
; End of function sub_3C84

; ---------------------------------------------------------------------------

mloc_3c90:
		mov.w	e5, e6
		cmp.b	#0, r3l
		bne	loc_3C6A:8
		bsr	sub_3C84:8
		add.w	#3, e6
		cmp.w	e3, e6
		bcs	loc_3C6A:8

loc_3CA0:				; CODE XREF: ROM:3C66j	ROM:3D32j
		mov.b	#9, r6l
		bset	#1, r4l
		bclr	#3, r4l

loc_3CA6:				; CODE XREF: ROM:loc_3CB8j ROM:3CC2j
		mov.w	e3, e6

loc_3CA8:				; CODE XREF: ROM:3CD4j
		bra	loc_3C54:8
; ---------------------------------------------------------------------------

mloc_3caa:
		cmp.b	#6, r4h
		beq	loc_3CC0:8
		bclr	#4, r4l
		cmp.b	#4, r4h
		beq	loc_3CBA:8
		cmp.b	#2, r4h
		beq	loc_3C72:8

loc_3CB8:				; CODE XREF: ROM:loc_3D0Ej
		bra	loc_3CA6:8
; ---------------------------------------------------------------------------

loc_3CBA:				; CODE XREF: ROM:3CB2j
		jsr	sub_3DB8:16
		bra	loc_3C72:8
; ---------------------------------------------------------------------------

loc_3CC0:				; CODE XREF: ROM:3CACj
		btst	#4, r4l
		bne	loc_3CA6:8
		mov.w	#0x5B4C, r0
		jsr	@@off_6C:8
		mov.b	r0l, @0xFE37:16

loc_3CCE:				; CODE XREF: ROM:3CE6j	ROM:3D00j
		mov.w	#0x32, e6 ; '2'
		mov.b	#6, r6l
		bra	loc_3CA8:8
; ---------------------------------------------------------------------------

mloc_3cd6:
		mov.w	#0x3C32, r0
		jsr	@@off_6C:8
		cmp.b	r0l, r3l
		beq	unk_3CEC:8
		bcs	loc_3CFE:8
		cmp.w	#0x34, e4 ; '4'
		bhi	loc_3CCE:8
		mov.b	r0l, @0xFE37:16
; ---------------------------------------------------------------------------
unk_3CEC:	.byte 0x7A ; z		; CODE XREF: ROM:3CDEj
problem32_7:	.byte	 0
		.byte	 0
		.byte 0x6A ; j
		.byte	 0
		.byte 0x99 ; 
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	@r5, r2
		add.w	r0, r2
		mov.w	r2, @r5
		jmp	sub_3BC8:16
; ---------------------------------------------------------------------------

loc_3CFE:				; CODE XREF: ROM:3CE0j
		cmp.b	#1, r3l
		bhi	loc_3CCE:8
		mov.w	#0x5B4C, r0
		jsr	@@off_6C:8
		mov.b	r0l, @0xFE37:16
		mov.b	#7, r6l

loc_3D0E:				; CODE XREF: ROM:3D40j
		bra	loc_3CB8:8
; ---------------------------------------------------------------------------

mloc_3d10:
		cmp.b	#0, r3l
		beq	loc_3D30:8
		bset	#1, @0x11:8
		mov.w	#0x1E19, r0
		jsr	@@off_6C:8
		cmp.b	r0l, r3l
		bcs	loc_3D2C:8
		dec.w	#2, e3
		cmp.w	e3, e4
		bls	loc_3D2C:8
		mov.b	r0l, @0xFE37:16

loc_3D2C:				; CODE XREF: ROM:3D20j	ROM:3D26j ...
		jmp	loc_3C58:16
; ---------------------------------------------------------------------------

loc_3D30:				; CODE XREF: ROM:3D12j
		bset	#4, r4l
		jmp	loc_3CA0:16
; ---------------------------------------------------------------------------

mloc_3d36:
		cmp.b	#4, r4h
		beq	loc_3D42:8
		cmp.b	#8, r4h
		bne	loc_3D2C:8
		mov.b	#5, r6l
		bra	loc_3D0E:8
; ---------------------------------------------------------------------------

loc_3D42:				; CODE XREF: ROM:3D38j
		mov.b	@0xFE9B:16, r0l
		mov.b	#0xA, r0h
		mulxu.b	r0h, r0
		cmp.b	#0xD, r6l
		beq	loc_3D8A:8
		cmp.b	#0xC, r6l
		bne	loc_3D62:8
		cmp.b	#0, r3l
		bne	loc_3D88:8
		mov.b	#0xD, r6l
		mov.w	@r5, r0
		add.w	#0x189,	r0
		mov.w	r0, @r5
		bra	loc_3D8A:8
; ---------------------------------------------------------------------------

loc_3D62:				; CODE XREF: ROM:3D50j
		cmp.b	#3, r6l
		bne	loc_3D72:8
		cmp.b	#0, r3l
		bne	loc_3D88:8
		bset	#0, @PDR2:8
		mov.b	#0xC, r6l
		bra	loc_3D7E:8
; ---------------------------------------------------------------------------

loc_3D72:				; CODE XREF: ROM:3D64j
		mov.b	#4, r6l
		cmp.w	e6, r0
		bcc	loc_3D8A:8
		cmp.w	e4, r0
		bcc	loc_3D8A:8
		mov.b	#3, r6l

loc_3D7E:				; CODE XREF: ROM:3D70j
		mov.w	#0x101,	r0
		jsr	@@off_6C:8
		mov.b	r0l, @0xFE37:16

loc_3D88:				; CODE XREF: ROM:3D54j	ROM:3D68j
		bset	#6, r4l

loc_3D8A:				; CODE XREF: ROM:3D4Cj	ROM:3D60j ...
		bsr	sub_3DB8:8
		jmp	loc_3C54:16
; ---------------------------------------------------------------------------

mloc_3d90:
		inc.w	#1, e3
		cmp.w	e3, e4
		bhi	loc_3DA2:8
; ---------------------------------------------------------------------------
problem32_8:	.byte 0x7A ; z
		.byte	 0
		.byte  0xD
		.byte 0xAB ; 
		.byte 0x10
		.byte 0xA9 ; 
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	r0, @r5
		mov.b	#9, r6l

loc_3DA2:				; CODE XREF: ROM:3D94j
		or.b	#0x42, r4l
		jmp	sub_3BC8:16

; =============== S U B	R O U T	I N E =======================================


sub_3DA8:				; CODE XREF: ROM:loc_3C54p
		cmp.w	e5, e6
		beq	loc_3DB0:8
		bst	#3, @0x11:8

loc_3DB0:				; CODE XREF: sub_3DA8+2j
		mov.w	e6, @0xFECE:16
		mov.w	e6, e5
		rts
; End of function sub_3DA8


; =============== S U B	R O U T	I N E =======================================


sub_3DB8:				; CODE XREF: ROM:loc_3CBAp
					; ROM:loc_3D8Ap
		cmp.w	#0x15F,	e4
		bcc	locret_3DC2:8
		mov.w	#0x190,	e6

locret_3DC2:				; CODE XREF: sub_3DB8+4j
		rts
; End of function sub_3DB8


; =============== S U B	R O U T	I N E =======================================


sub_3DC4:				; CODE XREF: ROM:140Cp
		mov.b	r0l, r0h
		inc.b	r0h
; End of function sub_3DC4


; =============== S U B	R O U T	I N E =======================================


sub_3DC8:				; CODE XREF: sub_900+18p sub_3B8C+4p ...
		btst	#2, @0x11:8
		bne	locret_3DD0:8
		mov.b	r0h, r0l

locret_3DD0:				; CODE XREF: sub_3DC8+4j sub_3E44+4j
		rts
; End of function sub_3DC8

; ---------------------------------------------------------------------------

loc_3DD2:				; CODE XREF: ROM:3C5Ej
		sub.w	r2, r2
		mov.w	e5, e1
		btst	#4, @0x11:8
		beq	loc_3DEA:8
		mov.b	@0xFEAB:16, r0l
		and.b	#0xF0, r0l
		cmp.b	#0x40, r0l ; '@'
		bne	loc_3DEA:8
		mov.w	#0xFFFF, e1

loc_3DEA:				; CODE XREF: ROM:3DDAj	ROM:3DE4j
		mov.w	#0x3994, r0
		btst	#2, @0x11:8
		beq	loc_3DF8:8
		add.w	#0x1E, r0

loc_3DF8:				; CODE XREF: ROM:3DF2j	ROM:3E00j
		add.w	#4, r0
		mov.w	@r0+, e0
		cmp.w	e0, e1
		bhi	loc_3DF8:8
		mov.b	@r0+, r2l
		mov.w	r2, e1
		mov.b	@r0+, r2l
		mov.w	r2, e2
		mov.b	@r0+, r3h
		btst	#5, r4l
		bne	loc_3E2C:8
		bclr	#3, @0x11:8
		mov.w	e1, r0
		bra	loc_3E1A:8
; ---------------------------------------------------------------------------

loc_3E18:				; CODE XREF: ROM:3E40j	ROM:3E52j
		mov.w	e2, r0

loc_3E1A:				; CODE XREF: ROM:3E16j
		mov.w	@r5, r2
		bld	#3, @0x11:8
		bcc	loc_3E26:8
		add.w	r0, r2
		bra	loc_3E28:8
; ---------------------------------------------------------------------------

loc_3E26:				; CODE XREF: ROM:3E20j
		sub.w	r0, r2

loc_3E28:				; CODE XREF: ROM:3E24j
		jmp	unk_3F12:16
; ---------------------------------------------------------------------------

loc_3E2C:				; CODE XREF: ROM:3E0Ej
		mov.b	r3h, r1l
		beq	loc_3E54:8
		mov.w	e5, r0
		jsr	@@off_C8:8
		mov.w	e5, r0
		bld	#3, @0x11:8
		bcs	loc_3E4E:8
		sub.w	r2, r0
		cmp.w	r0, e4
		bcs	loc_3E18:8
		bra	loc_3E54:8

; =============== S U B	R O U T	I N E =======================================


sub_3E44:				; CODE XREF: ROM:073Ap	ROM:3AD4p ...
		btst	#2, @0x11:8
		bne	locret_3DD0:8
		mov.w	e0, r0
		rts
; End of function sub_3E44

; ---------------------------------------------------------------------------

loc_3E4E:				; CODE XREF: ROM:3E3Aj
		add.w	r2, r0
		cmp.w	e4, r0
		bcs	loc_3E18:8

loc_3E54:				; CODE XREF: ROM:3E2Ej	ROM:3E42j
		push.w	e1
		cmp.w	e5, e4
		beq	loc_3E60:8
		bxor	#3, @0x11:8
		bcs	loc_3E6C:8

loc_3E60:				; CODE XREF: ROM:3E58j
		bclr	#6, @4:8
		cmp.b	#0x19, r3l
		bcc	loc_3E6C:8
		bclr	#4, @0x11:8

loc_3E6C:				; CODE XREF: ROM:3E5Ej	ROM:3E66j
		mov.b	#6, r5l
		mov.b	r5l, r5h
		mov.w	#0x3900, r2

loc_3E74:				; CODE XREF: ROM:3E7Cj
		mov.w	@r2+, e0
		sub.w	e5, e0
		bcc	unk_3E7E:8
		dec.b	r5l
		bne	loc_3E74:8
; ---------------------------------------------------------------------------
unk_3E7E:	.byte 0x7A ; z		; CODE XREF: ROM:3E78j
problem32_9:	.byte	 0
		.byte 0x39 ; 9
		.byte 0x52 ; R
		.byte 0x39 ; 9
		.byte  0xC
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		mov.w	r0, r4
		sub.b	r5l, r5h
		mov.w	#0xA, r0
		mulxu.b	r5h, r0
		cmp.b	#1, r5h
		bne	loc_3E9E:8
		bld	#1, @0x11:8
		bcc	loc_3E9E:8
		add.w	#0x32, r4 ; '2'

loc_3E9E:				; CODE XREF: ROM:3E92j	ROM:3E98j
		add.w	r0, r4
		mov.w	@(2:16,r4), r0
		jsr	@@off_EA:8
		mov.w	@0xFECE:16, r3
; ---------------------------------------------------------------------------
problem32_10:	.byte 0x52 ; R
		.byte	 3
; ---------------------------------------------------------------------------
		mov.w	@0xFEC0:16, e4
		jsr	unk_2E22:16
; ---------------------------------------------------------------------------
problem32_11:	.byte  0xF
		.byte 0x85 ; 
		.byte  0xF
		.byte 0x96 ; 
; ---------------------------------------------------------------------------
		mov.w	@r4, r0
		jsr	@@off_EA:8
		mov.w	@0xFECE:16, r3
; ---------------------------------------------------------------------------
problem32_12:	.byte 0x52 ; R
		.byte	 3
; ---------------------------------------------------------------------------
		mov.w	@0xFEBE:16, e4
		jsr	unk_2E22:16
; ---------------------------------------------------------------------------
problem32_13:	.byte 0x1A
		.byte 0xA2 ; 
; ---------------------------------------------------------------------------
		mov.w	@(4:16,r4), r2
; ---------------------------------------------------------------------------
problem32_14:	.byte	 1
		.byte	 0
		.byte 0x6F ; o
		.byte 0x43 ; C
		.byte	 0
		.byte	 6
		.byte  0xA
		.byte 0xB1 ; 
; ---------------------------------------------------------------------------
		bcc	unk_3EDC:8
		adds	#1, r0
; ---------------------------------------------------------------------------
unk_3EDC:	.byte  0xA		; CODE XREF: ROM:3ED8j
problem32_15:	.byte 0xA0 ; 
		.byte 0x1A
		.byte 0xE1 ; 
; ---------------------------------------------------------------------------
		bcc	unk_3EE4:8
		subs	#1, r0
; ---------------------------------------------------------------------------
unk_3EE4:	.byte 0x1A		; CODE XREF: ROM:3EE0j
problem32_16:	.byte 0xD0 ; 
; ---------------------------------------------------------------------------
		mov.w	@0xFECC:16, e4
; ---------------------------------------------------------------------------
problem32_17:	.byte  0xF
		.byte 0x82 ; 
		.byte  0xF
		.byte 0x93 ; 
; ---------------------------------------------------------------------------
		jsr	loc_2E24:16
		pop.w	r4
		mov.w	e0, e0
		bne	loc_3F46:8
		mov.w	@0xFECC:16, r2
		cmp.w	r2, r0
		bcs	loc_3F0A:8
		add.w	r4, r2
		cmp.w	r2, r0
		bcc	unk_3F12:8
		mov.w	r0, r2
		bra	unk_3F12:8
; ---------------------------------------------------------------------------

loc_3F0A:				; CODE XREF: ROM:3EFEj
		sub.w	r4, r2
		cmp.w	r2, r0
		bcs	unk_3F12:8
		mov.w	r0, r2
; ---------------------------------------------------------------------------
unk_3F12:	.byte 0x7A ; z		; CODE XREF: ROM:loc_3E28j ROM:3F04j ...
problem32_19:	.byte	 0
		.byte 0x11
		.byte 0x56 ; V
		.byte 0x14
		.byte	 5
; ---------------------------------------------------------------------------
		jsr	@@off_6E:8
		cmp.w	e7, r2
		bcc	loc_3F34:8
		mov.w	e7, r2
		bclr	#3, @0x11:8
		btst	#0, @0x12:8
		bne	loc_3F34:8
		mov.b	@0xFE37:16, r1l
		bne	loc_3F34:8
		bset	#0, @0x11:8

loc_3F34:				; CODE XREF: ROM:3F1Cj	ROM:3F28j ...
		cmp.w	r0, r2
		bcs	loc_3F3A:8
		mov.w	r0, r2

loc_3F3A:				; CODE XREF: ROM:3F36j
		mov.w	@0xFECC:16, r0
		mov.w	r2, @0xFECC:16
		mov.w	r0, @0xFECA:16

loc_3F46:				; CODE XREF: ROM:3EF6j
		mov.w	@0xFEC0:16, r0
		mov.w	r0, @0xFEBE:16
		rts

; =============== S U B	R O U T	I N E =======================================


sub_3F50:				; CODE XREF: ROM:3AAEp	ROM:3EA4p ...
		mov.b	@0xFD80:16, r1l
		jsr	sub_2DCA:16
		rotxl.b	r0l
		rotxl.b	r0h
		rotxl.b	r1l
		mov.b	r0h, r0l
		mov.b	r1l, r0h
		rts
; End of function sub_3F50

; ---------------------------------------------------------------------------
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
		.word 0, 0, 0, 0, 0, 0,	0
		.byte 0x40 ; @
		.byte 0xFE ; 

		; end
