  /****************************
   *    LCD     *
   * MT10T7        *
   ***************************/
#include "header.h"  //     .

#define WR  (1 << 5)
#define A0 (1 << 4)
#define set_WR() (PORTB |= WR)
#define set_A0() (PORTB |= A0)
#define clear_WR() (PORTB &= ~WR)
#define clear_A0() (PORTB &= ~A0)

unsigned int point = 10;//     
unsigned char __flash MT10T7 [] [2] = {//    10T7
  0xee,'0', 
  0x60,'1', 
  0x2f,'2', 
  0x6d,'3',
  0xe1,'4', 
  0xcd,'5',//'S'
  0xcf,'6', 
  0x68,'7',
  0xef,'8',
  0xed,'9',
  //0xeb,'A',
  //0xc7,'b',
  //0x8e,'C',
  //0x67,'d',
  0x8f,'E',
  0x8b,'F',
  0x00,' ',
  //0x04,'_',
  //0x01,'-', 
  //0x08,'~',
  //0xA9,'G',
  //0xE3,'H',
  //0x60,'I',
  0x86,'L',
  //0x06,'l',
  //0x43,'n',
  //0x47,'o',
  //0xAB,'P',
  //0x8A,'R',
  //0x03,'r',
  0x87,'t',
  0xE6,'U',
  //0x46,'u',
  //0xE5,'Y',
  0x10,'.',
  0xFF,'!',
  0,0
 };
  
  void delay(unsigned int ticks) // 
{
  while(ticks--);
}

void write_LCD_adres(unsigned int adres)//     
{
        clear_WR(); 
         PORTB = ((PORTB | 0x0F) & ((unsigned char) adres | 0xF0));// 4    
         clear_A0();
         // delay(1); 
	   set_WR();
	   // delay(1); 
	     clear_WR();
	    //  delay(1); 
	set_A0();	
	//delay(10);	
}

void write_LCD_data(unsigned char data)//          
 {	
	 //clear_WR();
    //set_A0();	 
      PORTB = ((PORTB | 0x0F) & (data | 0xF0));
    set_WR();
	//delay(1); 
	  clear_WR();
	  //  delay(1);
	PORTB = ((PORTB | 0x0F) & ( (data >> 4) | 0xF0));
      set_WR();
	//delay(1);
	  clear_WR();
            //delay(10); 	
	      clear_A0();
}

void write_LCD(unsigned int adres,unsigned char data,unsigned int point)
  //  LCD, 
  // adres -        0  9 ( 10)
  //          data -     LCD,  ,  
  //          point -       . ,    10  
{
  unsigned int i;
  //   
  for (i = 0; MT10T7[i][1]!= data && MT10T7[i][1]; i++);//   i,
      if (MT10T7[i][1] == data) //     ,   
 	 data = MT10T7[i][0];
 	 
 	 if (adres == point)//     ,  
 	 data = (data | 0x10);
 	       
 write_LCD_adres(adres);//    
    
 write_LCD_data(data);//    

}



 void unblok_LCD(void)// !!!
{
  write_LCD(15,'!',10);// 1   FF
}

  void clear_LCD(void)// LCD 
{
  unsigned char i;
  
    for (i=0; i<10 ; i++)//   
    write_LCD(i,' ',10);
}
  
void test_LCD(void) // LCD 
{
 unsigned int i;
 
    for (i=0; i<10 ; i++)//   
    write_LCD(i,'8',i);
} 

//***************************
// Convert int to 5?( ) ASCII digits and LCD
//***************************

void Int_to_Char( unsigned int i, unsigned int adres, unsigned char clear_null)
   // i -  , ,
   // adres -         
   // j -        0  
   //    =1 , =0  .  
{
  
    unsigned char digit;
    if (i > 10000) i = 8888;    
 
    digit = '0';
    while( i >= 1000 )                 // ,  
    {
        digit++;                    
        i -= 1000;
    }
    if ((digit == '0') && (clear_null == 1)) 
    {
      digit = ' '; 
    }else 
     {
      clear_null = 0;
     }
    write_LCD(adres,digit,point);
      
    digit = '0';
    while( i >= 100 )                
    {
        digit++;                         
        i -= 100;
    }
    if ((digit == '0') && (clear_null == 1))  
    {
      digit = ' ';
    } else 
     {
      clear_null = 0;
     } 
    write_LCD(adres + 1,digit,point);
            
    digit = '0';
    while( i >= 10 )                 // Still larger than 10 ?
    {
        digit++;                         // Increment second digit
        i -= 10;
    }
    if ((digit == '0') && (clear_null == 1))
    {
      digit = ' '; 
    }else 
     {
      clear_null = 0;
     }  
    write_LCD(adres + 2,digit,point); 
    write_LCD(adres + 3,(unsigned char)i + '0',point);//     i  
}

