/*---------------------------------------------------------------------------*
 * File: ATtiny26.C                                                          *
 * Author: Oleg Kuzmin - NETA Company                                        *
 * Copyright (c) 1999 Company All Rights Reserved.                           * 
 *                                                                           *
 * (MOSI/DI/SDA/OC1A) PB0 (pin1) -->  pin7 LCD (DB0).                        *
 * (MISO/DO/OC1A)     PB1 (pin2) -->  pin6 LCD (DB1).                        *
 * (SCK/SCL/OC1B)     PB2 (pin3) -->  pin5 LCD (DB2).                        *
 * (OC1B)             PB3 (pin4) -->  pin4 LCD (DB3).   
 *                    VCC (pin5)
 *                    GND (pin6)
 * (ADC7/XTAL1)       PB4 (pin7) -->  pin1 LCD (A0).                         *
 * (ADC8/XTAL2)       PB5 (pin8) -->  pin2 LCD (WR).                         *
 * (ADC9/INT0/T0)     PB6 (pin9) 
 * (ADC10/RESET)      PB7 (pin10) --> RESET
 * (ADC0)             PA0 (pin20) -->  AIN0.                                 *
 * (ADC1)             PA1 (pin19) -->  AIN1. 
 * (ADC2)             PA2 (pin18) -->  AIN2. .
 * (AREF)             PA3 (pin17) -->  S1.    
 *                    GND (pin16)
 *                   AVCC (pin15)
 * (ADC3)             PA4 (pin14)
 * (ADC4)             PA5 (pin13) -->  K3.
 * (ADC5/AIN0)        PA6 (pin12) -->  K4,DATCHIK.
 *                    PA7 (pin11) -->  K1.                           
 * Resonator int, frequency = 1 MHz                                          *
 * REF ADC U.
 
 
 * Last update  05/05/2004;  2.1
 *---------------------------------------------------------------------------*/
 
#include "header.h"  //     .
#include "Convert.h"//    .

#define kor_datchik 32


//int nul_provodim = 24;  //     
//int nul_kabel = 148;  //      
//int nul_datchik = 292;  //        

__no_init  unsigned int __eeprom nul_provodim_e;  //     
//unsigned char nul_pribor = 1;  //         
__no_init  unsigned int __eeprom nul_kabel_e;  //      
__no_init  unsigned int __eeprom nul_datchik_e;  //        
__no_init  unsigned int __eeprom nul_temp_e;  //        

unsigned int nul_provodim;
unsigned int nul_kabel;
unsigned int nul_datchik;
unsigned int nul_temp;

//int kor_datchik = 20;//          !!! 
unsigned char test = 1 ;          // 1 , 0 -  .
unsigned char period = 1;//     
unsigned char out = 0; //     
unsigned char flag;  //     
                     //flag = 0   
                     //flag = 1  
                     //flag = 2     
unsigned char point = 10;//     

unsigned int mas_1;//    ADC (!!)   0 
unsigned int mas_2;//    ADC (!!)   1 
unsigned int mas_3;//    ADC (!!)   2 
//unsigned int mas_4;//    ADC (!!)   3   

unsigned int mas_1_temp;//         
unsigned int mas_2_temp;//         
unsigned int mas_3_temp;//         
//unsigned int mas_4_temp;//          



unsigned long mas_1_1;//   32 mas_1_temp   0 
unsigned long mas_2_1;//   32 mas_2_temp   1 
unsigned long mas_3_1;//   32 mas_2_temp   2   

//unsigned int mas_1_out;// ???   4 mas_1_1    
//unsigned int mas_2_out;// ???   4 mas_2_1    
//unsigned int mas_3_out;// ???   4 mas_2_1    



//  
void port_init(void) //  
{
 PORTB = 0xE0;//11100000;     LCD
 DDRB  = 0x3F;//00111111,   1-,0-
 PORTA = 0xFF;//11111111;       ADC
 DDRA  = 0xE0;//11100000,   1-,0-
}

void timer_init(void) //  
{
  TCCR0 = 0x00;     // 
  TCNT0 = 0x7F;     //       128 = 7F
  TCCR0 = div_1;     //  0 ,(   !!!)
                    //     1
  TIMSK = 0x02;     //    0 
}

void adc_init(void) //  
{                    //   !!!           
   clearbit(ADCSR,ADIE);//    
    //setbit(ADCSR,ADIE);//    
   setbit(ADCSR,ADIF);//        
                      //       
                      //   
   clearbit(ADCSR,ADFR);//    
    //ADMUX |=0x80; //REFS1,REFS0 10,    2,56 .
                   //ADLAR,    .  
   ADMUX |=0x00;     //REFS1,REFS0 00,   -- + .
                   //ADLAR,    .   
   //ADMUX |=0x9E;  //MUX4..MUX0 11110   1.8  ,  2,56 .
    set_AIN0();     //     
    
  clearbit(ADCSR,ADPS2);//011    ADC /8 ~ 125kHz
  setbit(ADCSR,ADPS1);
  setbit(ADCSR,ADPS0);
  
  setbit(ADCSR,ADEN);//ADC Enable  
  setbit(ADCSR,ADIF);//     
  setbit(ADCSR,ADIE);//    
}

void init_devices(void) //  
{
  __disable_interrupt(); // 
    port_init();    //  
    timer_init();   //  
    adc_init();     //     
    //MCUCR = 0x00;       //      
   //clearbit(MCUCR,PUD); // PUD -0,    
   clearbit(MCUCR,SM1); //     Sleep 
   setbit(MCUCR,SM0); //      .    
   //TIMSK = 0x00;    //timer interrupt sources
    GIMSK = 0x00;      //???interrupt sources
    PLLCSR = 0x00;     //  
 //WDTCR = 0x0F;     //  Watchdog Timer
  __enable_interrupt();  //  
}
 
  void delay(unsigned int ticks) // 
{
  while(ticks--);
}
//  LCD
void write_LCD_adres(unsigned char adres)//     
{
  __disable_interrupt(); // 
        clear_WR(); 
         PORTB = ((PORTB | 0x0F) & (adres | 0xF0));// 4    
         clear_A0();
         // delay(1); 
	   set_WR();
	   // delay(1); 
	     clear_WR();
	    //  delay(1); 
	set_A0();	
	//delay(10);	
        __enable_interrupt();  //  
}

void write_LCD_data(unsigned char data)//          
 {	
	__disable_interrupt(); // 
   //clear_WR();
    //set_A0();	 
      PORTB = ((PORTB | 0x0F) & (data | 0xF0));
    set_WR();
	//delay(1); 
	  clear_WR();
	  //  delay(1);
	PORTB = ((PORTB | 0x0F) & ( (data >> 4) | 0xF0));
      set_WR();
	//delay(1);
	  clear_WR();
            //delay(10); 	
	      clear_A0();
          __enable_interrupt();  //      
}

void write_LCD(unsigned char adres,unsigned char data,unsigned char point)
  //  LCD, 
  // adres -        0  9 ( 10)
  //          data -     LCD,  ,  
  //          point -       . ,    10  
{
  unsigned char i;
  //   
  
  //for (i = 0; MT10T7[i][1]!= data && MT10T7[i][1]; i++);//   i,
   //   if (MT10T7[i][1] == data) //     ,   
 	// data = MT10T7[i][0];
 	for (i = 0;  i<MT10T7_Len; i++)//   i,
      if (MT10T7[i][1] == data){ //     ,   
         data = MT10T7[i][0];
         break;
      } 
 	 if (adres == point)//     ,  
 	 data = (data | 0x10);
 	       
 write_LCD_adres(adres);//    
    
 write_LCD_data(data);//    

}

//    LCD
void write_LCD_n(char address,char *data,int point,char len){
   for(char i=0;i<len;i++)
      write_LCD(address+i,data[i],point);
}

void unblok_LCD(void)// !!!
{
  write_LCD(15,'!',10);// 1   FF
}

void clear_LCD(void)// LCD 
{
  //unsigned char i;
  
  //  for (i=0; i<10 ; i++)//   
  //  write_LCD(i,' ',10);
  write_LCD_n(0,"          ",10,10);
}
  
void test_LCD(void) // LCD 
{
 //unsigned char i;
 
   // for (i=0; i<10 ; i++)//   
   // write_LCD(i,'8',i);
  write_LCD_n(0,"8888888888",10,10);
} 

//***************************
// Convert int to 5?( ) ASCII digits and LCD
//***************************

void Int_to_Char( int i, unsigned char adres, unsigned char clear_null)
   // i -  , ,
   // adres -         
   // j -        0  
   //    =1 , =0  .  
{
  
    unsigned char digit;
     if (i < 0) i = 7777; 
    if (i > 10000) i = 8888;    
 
    digit = '0';
    while( i >= 1000 )                 // ,  
    {
        digit++;                    
        i -= 1000;
    }
    if ((digit == '0') && (clear_null == 1)) 
    {
      digit = ' '; 
    }else 
     {
      clear_null = 0;
     }
    write_LCD(adres,digit,point);
      
    digit = '0';
    while( i >= 100 )                
    {
        digit++;                         
        i -= 100;
    }
    if ((digit == '0') && (clear_null == 1))  
    {
      digit = ' ';
    } else 
     {
      clear_null = 0;
     } 
    write_LCD(adres + 1,digit,point);
            
    digit = '0';
    while( i >= 10 )                 // Still larger than 10 ?
    {
        digit++;                         // Increment second digit
        i -= 10;
    }
    if ((digit == '0') && (clear_null == 1))
    {
      digit = ' '; 
    }else 
     {
      clear_null = 0;
     }  
    write_LCD(adres + 2,digit,point); 
    write_LCD(adres + 3,'0'+ i,point);//     i  

 /* 
char buffer[4],v;
   if (i>10000)
      i = 8888;
   for(char j=3;j>0;j--){
      if(v=i%10)
         v+='0';
      else if(clear_null)
         v=' ';
      buffer[j]=v;
      i/=10;
   }

//   for(char j=0;j<3;j++)
//      write_LCD(adres+j,buffer[j],point);
   write_LCD_n(adres,&buffer[0],point,4);
*/
}


//    - 0 
#pragma vector = TIMER0_OVF0_vect
__interrupt  void TIMER0_OVF0 (void)
  {
    //__watchdog_reset(); //   
     period++;//   
     if (period > max_period)//        
     { 
      period = 1;//   0
      out = 0;  //      3  
     }
        switch (period)
        {
          case 1 : //   
            //      , -   
            set_AIN0();// 0 
            set_K3();//   
            set_K1();//   
            clear_K4();//     
          break;
      
          case 2 : //   
            set_AIN0();//   
            set_AIN1();
            set_K1();//  
            set_K4();//         
            clear_K3();//      
          break;
      
          case 3 : //    
            set_AIN0();//   
            set_AIN2();
            set_K4();//        
            set_K3();//   
            clear_K1();// 
          break;
          
          case 4 : //     
          set_AIN0();//   
          set_AIN3(); 
          mas_1_temp = mas_1;// 
          mas_2_temp = mas_2; 
          mas_3_temp = mas_3;// 
          //mas_4_temp = mas_4;
          out = 1; //  ,      
          break;
       }   
        timer_init();     //      
       __enable_interrupt();  //  
       clearbit(MCUCR,SE);
       setbit(MCUCR,SE);//       .
       __sleep();//           .    
 } 
 //    ADC 
#pragma vector = ADC_vect
__interrupt  void ADC_convert (void)

{
 unsigned int temp;
   //num_ADC++; //     ADC
   temp = ADC;//   
   switch (period)//         
    {              //    1 ,    
      case 1 : 
       mas_1 = temp;//  1 
      break;
      
      case 2 : 
       mas_2 = temp;//  2 
      break;
    
      case 3 : 
       mas_3 = temp;//  3 
      break;
      
       case 4 : //      
      // mas_4 = temp; 
             //out = 1; //  ,      
       break;
    }
}
  
  
__C_task void main(void) //   
{
   unsigned char i = 0;      
   unsigned char j = 0;   
   int temp_int; //  
   long temp_long;
   unsigned int counter = 0;   //  (    ) 
 // static unsigned int counter_1 = 0; //   1
  
   nul_provodim = nul_provodim_e;
   nul_kabel = nul_kabel_e;//    
   nul_datchik = nul_datchik_e;
   nul_temp = nul_temp_e;
   nul_kabel += 24;//32;//kor_datchik; //kor_datchik;//    
   
   init_devices();          // 
   unblok_LCD();           //  
   clear_LCD();            //  
   
   if( !checbit(PINA,PA3) )
   {
     test = 0;    
   }
  
while (1) //    
 {        
  if (out == 1 ) //  
   { 
     out = 0;//     (  3 )
     counter ++;//      
     
      mas_1_1 += (unsigned long)(mas_1_temp); //         261120 
      mas_2_1 += (unsigned long)(mas_2_temp); //      .   .    
      mas_3_1 += (unsigned long)(mas_3_temp);
      
       if (counter == 255)//  32  
       {
          
        counter = 0;//   
        //   
       // mas_1_out = (unsigned int)(mas_1_1 >> 8);
       // mas_2_out = (unsigned int)(mas_2_1 >> 8);
       // mas_3_out = (unsigned int)(mas_3_1 >> 8);
          if (test == 1) //    
          {
            point = 10;  
           // temp_long = ((unsigned long)nul_kabel << 8) - ((unsigned long)nul_temp * 76);//  0.3= 1*76/256
            // temp_long = (mas_1_1  - temp_long) / (unsigned long)(nul_datchik - nul_kabel);
           
  temp_long = (mas_1_1 + ((unsigned long)nul_temp * 76) - ((unsigned long)nul_kabel << 8) - ((mas_3_1 * 76)>>8) ) / (unsigned long)(nul_datchik - nul_kabel);
             
          //Int_to_Char ((int)(temp_long/10),0,1);
            temp_int = (int)temp_long - 473;
             
            if( temp_int < 0 ) flag = 0;
            if( temp_int > 0 ) flag = 1; 
            if( temp_int > 127 ) flag = 2;
            //flag = 1;
               
            switch (flag)//      
            {     
              case 1 :  
             
               //Int_to_Char (temp_int,0,1);  
               Int_to_Char (convert[temp_int],0,1); //         
             break;
              
             case 0 : 
             write_LCD_n(0,"0FF ",10,4);  
             break;

             case 2 : 
             write_LCD_n(0,"FULL",10,4); 
             break;
            }                                                           
           //   
             temp_int = (int)(mas_2_1 >> 8) - nul_provodim;
              if (temp_int < 0) temp_int = 0;//       0
               
             Int_to_Char ((temp_int >> 1), 6, 1);
            //Int_to_Char ((int)(((long)mas_2_out * 287) >> 9), 6, 1);
           // temp_long = ((long)mas_2_out * 287) >> 9;// !!!    0.559662276 = 287/512
           // Int_to_Char ((int)temp_long, 6, 1);//     ,                                        
            
            
           }else
           {//  
             i++;
              if( !checbit(PINA,PA3) )
                 {
                   if( i > 50 )
                   {  
                     i = 0; 
                    switch (j)
                     {             
                      case 0 : 
                        j++;
                        nul_kabel_e = (unsigned int)(mas_1_1 >> 8); 
                       
                         test_LCD();
                        //write_LCD_n(adres,&buffer[0],point,4);
                        //write_LCD_n(0,"tE5t     1",10,10);
                         delay(60000); 
                         clear_LCD();  
                      break;
    
                      case 1 : 
                        j++;
                        nul_datchik_e = (unsigned int)(mas_1_1 >> 8);  
                        nul_provodim_e = (unsigned int)(mas_2_1 >> 8); 
                        nul_temp_e = (unsigned int)(mas_3_1 >> 8);
                        test_LCD();
                        delay(60000); 
                        clear_LCD();
                      break;
                     }      
                   }
                      
                  }else
                  {
                   i = 0;       
                  }
              //50 
            Int_to_Char ((unsigned int)(mas_1_1 >> 8),0,0);//    0-
            //Int_to_Char ((unsigned int)(mas_2_1 >> 8),6,0); //    1-
            Int_to_Char ((unsigned int)(mas_3_1 >> 8),6,0); //    2-
           }
            mas_1_1 = 0;//    
            mas_2_1 = 0;//   
            mas_3_1 = 0;//   
            //__enable_interrupt();  //  
          }//   if (counter == 255)     
    }//  if(out = 1); 
  }//  while(1),  
} //  main

