unit AboutForm;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
     Dialogs, StdCtrls, ExtCtrls, ShellAPI;

 type
  TAbout = class (TForm)
   BTN     : TButton;
   Img1    : TImage;
   Label1  : TLabel;
   Label9  : TLabel;
   Img2    : TImage;
   Label8  : TLabel;
   Label3  : TLabel;
   Label10 : TLabel;
   Bevel1  : TBevel;
   Label5  : TLabel;
   MyEMail : TLabel;
   Version : TLabel;

   procedure OKClick (Sender: TObject);
   procedure MyEMailClick(Sender: TObject);
   procedure FormCreate(Sender: TObject);
  end;

 var
  About : TAbout;

implementation

uses MainForm;

{$R *.dfm}

//------------------------------

procedure TAbout.OKClick (Sender: TObject);
 begin
  Close;
 end;

//------------------------------

procedure TAbout.MyEMailClick(Sender: TObject);
 begin
  ShellExecute(Handle,'Open',PChar('mailto:' + MyEMail.Caption),nil,nil,SW_SHOW);
 end;

//------------------------------

function CurrentFileInfo (NameApp : string): string;
 var
  dump            : DWORD;
  size            : Integer;
  buf             : PChar;
  VersionPointer  : PChar;
  TransBuffer     : PChar;
  Temp            : Integer;
  CalcLangCharSet : string;

 begin
  size := GetFileVersionInfoSize(PChar(NameApp),dump);
  buf  := StrAlloc(size + 1);

  try
   GetFileVersionInfo(PChar(NameApp),0,size,buf);

   VerQueryValue(buf,'\VarFileInfo\Translation',Pointer(TransBuffer),dump);

   if dump >= 4 then
    begin
     temp := 0;
     StrLCopy(@temp,TransBuffer,2);
     CalcLangCharSet := IntToHex(temp,4);
     StrLCopy(@temp,TransBuffer + 2,2);
     CalcLangCharSet := CalcLangCharSet + IntToHex(temp,4);
    end;

    VerQueryValue(buf,PChar('\StringFileInfo\' + CalcLangCharSet +
                            '\FileVersion'),Pointer(VersionPointer),dump);
    if dump > 1 then
     begin
      SetLength(Result,dump);
      StrLCopy(PChar(Result),VersionPointer,dump);
     end
    else
     Result := '0.0.0.0';
  finally
   StrDispose(buf);
  end;
end;

//------------------------------

procedure TAbout.FormCreate(Sender: TObject);
 var
  s : string;
  n : Byte;

 begin
  s := CurrentFileInfo(ParamStr(0));

  n := 0;

  while (n < 2) and (s <> '') do
   begin
    if s [Length(s)] = '.' then Inc(n);
    Delete(s,Length(s),1);
   end;

  Version.Caption := ': ' + s;
 end;

end.
