unit ParamsForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TParams = class(TForm)
    ColorDlg: TColorDialog;
    GB1: TGroupBox;
    Label1: TLabel;
    UpT: TPanel;
    Label7: TLabel;
    DownT: TPanel;
    Label8: TLabel;
    GB2: TGroupBox;
    NormalT: TPanel;
    Label2: TLabel;
    LowerT: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    UpperT: TPanel;
    PassiveT: TPanel;
    Label9: TLabel;
    ErrorT: TPanel;
    Label5: TLabel;
    SensorCOD: TGroupBox;
    BTN_OK: TButton;
    BTN_Cancel: TButton;
    ValueT: TPanel;
    Label6: TLabel;
    EditSN: TEdit;
    Label10: TLabel;
    Temp: TPanel;
    procedure TDblClick(Sender: TObject);
    procedure EditCODKeyPress(Sender: TObject; var Key: Char);
    procedure BTN_CancelClick(Sender: TObject);
    procedure BTN_OKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  end;

var
  Params: TParams;

implementation

uses MainForm, DS1820;

{$R *.dfm}

procedure TParams.TDblClick(Sender: TObject);
 begin
  with ColorDlg do
   begin
    Color := (Sender as TPanel).Color;

    if Execute then
     (Sender as TPanel).Color := Color;
   end;
 end;

procedure TParams.EditCODKeyPress(Sender: TObject; var Key: Char);
 begin
  Key := UpCase(Key);
  if not (Key in [#0..#31,'0'..'9','A'..'F']) then Key := #0;
 end;

procedure TParams.BTN_CancelClick(Sender: TObject);
 begin
  Close;
 end;

procedure TParams.BTN_OKClick(Sender: TObject);
 begin
  TempColor   := Temp.Color;
  HPTColor    := UpT.Color;
  LPTColor    := DownT.Color;

  MainForm.Temp.FontColor := ValueT.Color;

  NormalColor := NormalT.Color;
  LoTColor    := LowerT.Color;
  HiTColor    := UpperT.Color;
  StopColor   := PassiveT.Color;
  ErrorColor  := ErrorT.Color;

  Close;
 end;

procedure TParams.FormCreate(Sender: TObject);
 begin
  Temp.Color     := TempColor;
  UpT.Color      := HPTColor;
  DownT.Color    := LPTColor;
  ValueT.Color   := MainForm.Temp.FontColor;
  NormalT.Color  := NormalColor;
  LowerT.Color   := LoTColor;
  UpperT.Color   := HiTColor;
  PassiveT.Color := StopColor;
  ErrorT.Color   := ErrorColor;

  case NameS of
   __DS1820        : SensorCOD.Caption := ' DS1820';
   __DS18S20       : SensorCOD.Caption := ' DS18S20';
   __DS18B20       : SensorCOD.Caption := ' DS18B20';
   __UnknownDevice : SensorCOD.Caption := ' ';
  end;

  EditSN.Text  := IntToHex(Int64(COD1),8) + IntToHex(Int64(COD2),8);
 end;

procedure UpdateColor (p : TPanel; g : TGroupBox);
 var
  x,y : Integer;

 begin
  x := g.Left + p. Left;
  y := g.Top + p. Top;

  Params.Canvas.Brush.Color := p.Color;
  Params.Canvas.FillRect(Rect(x + 2,y + 2,x + p.Width - 2,y + p.Height - 2));
 end;

procedure TParams.FormPaint(Sender: TObject);
 begin
  if not WinNT then Exit;

  UpdateColor(Temp,GB1);
  UpdateColor(UpT,GB1);
  UpdateColor(DownT,GB1);

  UpdateColor(ValueT,GB2);
  UpdateColor(NormalT,GB2);
  UpdateColor(LowerT,GB2);
  UpdateColor(UpperT,GB2);
  UpdateColor(PassiveT,GB2);
  UpdateColor(ErrorT,GB2);
 end;

end.
