/*8x8 Dot matrix clock*/
#include <REGX51.H>
#include <intrins.h>
unsigned char timecount=0,oldP1=0xff,setting=0;
unsigned char sec=0,min=0,hou=12;
sbit  SET=P2^2;  
sbit  UP=P2^4;
unsigned char code tab[]={0xfe,0xfd,0xfb,0xf7,0xef,0xdf,0xbf,0x7f};
unsigned char code dis_code[40]={0x07c,0x082,0x082,0x07c,0x000,0x084,0x0fe,0x080, //0 and 1
								 0x0c4,0x0a2,0x092,0x08c,0x044,0x082,0x092,0x06c, //2 and 3
								 0x078,0x044,0x0fe,0x040,0x04e,0x08a,0x08a,0x072, //4 and 5
								 0x07c,0x092,0x092,0x064,0x006,0x002,0x0f2,0x00e, //6 and 7
								 0x06c,0x092,0x092,0x06c,0x04c,0x092,0x092,0x07c, //8 and 9
								
								};

bit	set_old;
bit up_old;
bit	date_flag=1;
void time50ms(void);
void delay2ms(void);
void timedeal(void);

void main(void)
{
unsigned char offset=0,dis_p,scantimes=0;
unsigned char xian,disnum,x,y;	
	IE=0x82;     //Enable interrupts
	TMOD=0x01;   //timer0 in mode 1
	TR0=1;       //start timer
	TH0 = 0x3c;
	TL0 = 0x0b;
	do
	{
		if(setting==0){   //display clock
		for(x=0;x<8;x++){
			dis_p=x+offset;
			if(dis_p>26)
				dis_p-=27;
			if(dis_p==0 || dis_p==5 || dis_p==10 || dis_p==12 || dis_p==17 || dis_p>21){    //row
				y=0;
			}else if(dis_p<=4){					
				xian=hou/10;
				if(xian>0)
					y=dis_code[xian*4+dis_p-1];
				else
					y=0;
			 }else if(dis_p<=9){			
			 	xian=hou%10;
				y=dis_code[xian*4+dis_p-6];
			 }else if(dis_p==11){				
			 	if(date_flag)
					y=0x24;
				else
					y=0;
			 }else if(dis_p<=16){				
			 	xian=min/10;
				y=dis_code[xian*4+dis_p-13];
			 }else{								
			 	xian=min%10;
				y=dis_code[xian*4+dis_p-18];
			 }
			P0=0;
			P1=tab[x];
			 P0=y;
			delay2ms();
			
		}
		scantimes++;
		if(scantimes>=8){
			scantimes=0;
			offset++;
			if(offset>26)
				offset=0;
		}}
	  	else{			//display time to change
                for(x=0;x<8;x++)
				{
				if(setting==1)
					disnum=min;
				else
					disnum=hou;
			
				if(x<4)					
				{	 xian=disnum/10;
					 y=dis_code[xian*4+x];	 }
				else 
				 {		
				    xian=disnum%10;	
					y=dis_code[xian*4+x-4];	 
					 
				}
					
				P0=0;
				P1=tab[x];
				P0=y;
				delay2ms();
			}
		
		}
	}while(1);
	
}

void delay2ms(void)
{
	unsigned char i,j;
	for(i=0;i<4;i++)
		for(j=0;j<120;j++);
}


void time50ms(void) interrupt 1
{
	TH0 = 0x3c;
	TL0 = 0x0b;
	timecount++;
	if(timecount==10)
	{
		timecount=0;
		date_flag=!date_flag;
		if(date_flag)
		{
			sec++;
			timedeal();
		}

	}

	if(!SET && SET!=set_old)    //check the set key
	{
		setting++;
		if(setting==3)
			setting=0;
	}

	if(!UP && UP!=up_old)   //check the up key
		{
			if(setting==1)
			{
				min++;
				sec=0;
				timedeal();
			}else if(setting==2)
			{
				hou++;
				timedeal();
			}
		 }
	set_old=SET;
	up_old=UP;

}

void timedeal(void)
{
	if(sec>=60)
	{
		sec=0;
		min++;
	}
	if(min>=60)
	{
		min=0;
		hou++;
	}
	if(hou>=24)
		hou=0;
}                                                                          