;*********************************************************************
;   .   . 20.08.08
;*********************************************************************
.INCLUDE"M8DEF.INC"
.DEF RDI=R17             ;Register Data Source of current
.EQU LT=120              ;Constants 
.EQU HT=236              ;for
.EQU ADR=197             ;Frequency
.EQU DZ=32               ;5 120 000 Hz
.ORG 000
     RJMP  RESET
.ORG 0x008               ;The interrupt on overflow t/c1 
     IN    R3,SREG
	 INC   R22
	 SBRS  R22,0
	 RJMP  IMP
	 CBI   PORTC,4       ;Off Led
	 OUT   TCNT1L,R7
	 OUT   TCNT1H,R8
	 RJMP  KZ
IMP: SBI   PORTC,4       ;On Led
	 OUT   TCNT1L,R7
	 OUT   TCNT1H,R8
     DEC   XL
	 BRNE  KZ            ;6 minutes Interval have expired?
	 LDI   XL,180        ;If Yes - Save Value - 0xB4 in  register XL
	 INC   XH            ;and increment XH register;If no - exit Interrupt
KZ:  OUT   SREG,R3
     RETI
RESET:
     CLR   R10
     LDI   R16,95        ;Initialization
	 OUT   SPL,R16       ;Stack(Low)
	 LDI   R16,4         ;Initialization
	 OUT   SPH,R16       ;Stack(High)
	 LDI   R16,105       ;PWM Mode Out- 
	 OUT   TCCR2,R16     ;-timer/counter 2
	 LDI   R16,8         ;PB3-Out PWM Source of current controlled
	 OUT   DDRB,R16      ;by a voltage,  PB0-PB2,PB3-PB7 -Input
	 LDI   R16,55        ;PB0-PB2-High(Internal resistors),PB3-Low
	 OUT   PORTB,R16     ;PB4,PB5-High(Internal resistors)
     SER   R16           ;PD0-PD7 - Outputs for Segments Indicator-
	 OUT   DDRD,R16      ;(PD0 - PD4 - A - E, PD5-H ,PD6-F, PD7-G)
	 LDI   R16,LT        ;Constant for TCNT1L
	 MOV   R7,R16        ;Save in register R7
	 LDI   R16,HT        ;Constant for TCNT1H 
	 MOV   R8,R16        ;Save in register R8
	 LDI   R16,31        ;PC0-PC3- Outputs Binary code(Strob)
	 OUT   DDRC,R16      ;PB4-Out(Led) PC5 - Input (ADC)
	 LDI   R16,45        ;In Ram (Adress 0x70) Constant for 
	 STS   0x70,R16      ;quantity of cycles the  indications
     LDI   R16,ADR       ;Initialization and start ADC
	 OUT   ADCSR,R16
	 LDI   R16,229       ;Internal source of basic voltageADC(2,56V)
	 OUT   ADMUX,R16     ;and input ADC - PC5 (DATA_ADC= 8 bit)
	 LDI   R16,5      
	 OUT   TCCR1B,R16    ;Frequency T/C1 = (Fgen\1024)
	 MOV   R5,R16
	 LDI   R16,4
	 OUT   TIMSK,R16
	 OUT   TCNT1L,R7     ;Load constant 
	 OUT   TCNT1H,R8     ;in TCNT1L and TCNT1H
	 SBI   PORTC,4       ;On Led
	 LDI   R21,10        ;Setup of initial meanings basic Voltage
	 CLR   RDI           ;Setup of initial meanings basic Current
	 CLR   R0            ;Clearing of the registers of given 
	 CLR   R1            ;capacity of accumulator
	 LDI   ZL,180
	 CLR   ZH
START:
     IN    R16,ADCSR
     SBRS  R16,4
	 RJMP  START
	 IN    R18,ADCH
     SBIS  PINB,1        ;If button"+I" is pressed,
	 RJMP  PL            ;go to the label "PL"
	 SBIS  PINB,2        ;If button"-I" is pressed,
	 RJMP  MIN           ;go to the label "MIN"
	 RJMP  EX
PL:  CPI   R19,10
     BRSH  P15
	 INC   R19
     CPI   RDI,255
	 BREQ  EX
	 SUBI  RDI,-3        ;Plus 3 Value the Current 
	 RJMP  END
P15: CPI   RDI,246
     BRSH  EX
	 SUBI  RDI,-15       ;Plus 15 Units Value the Current
	 RJMP  END
MIN: CPI   R19,10
     BRSH  M15
	 INC   R19
	 CPSE  RDI,R10
	 SUBI  RDI,3         ;Minus 3 Value the Current
	 RJMP  END
M15: CPI   RDI,15
     BRLO  DM
	 SUBI  RDI,15        ;Minus 15 Units Value the Current
	 RJMP  END
DM:  CPSE  RDI,R10
     SUBI  RDI,3
	 RJMP  END
EX:  CLR   R19
END: OUT   OCR2,RDI      ;Setup Value Source of current
SC:  SBIS  PINB,4        ;If button "+U" is pressed
     RJMP  PP            ;go to the label "PP"
	 SBIS  PINB,5        ;If button "-U" is pressed 
	 RJMP  MM            ;go to the label "MM" 
	 RJMP  CL
PP:  CPI   R20,10
     BRSH  PP10
	 INC   R20
	 CPI   R21,255
	 BREQ  CL
	 INC   R21           ;Increment Basic Setup Voltage
	 RJMP  CPD
PP10:CPI   R21,246
     BRSH  CL
	 SUBI  R21,-10       ;Plus 10 Unit (Basic setup Voltage)
	 RJMP  CPD
MM:  CPI   R20,10
     BRSH  MM10
	 INC   R20
	 CPI   R21,11
	 BRLO  CPD
	 DEC   R21           ;Decrement Basic Setup Voltage
	 RJMP  CPD
MM10:CPI   R21,20
     BRLO  CL
	 SUBI  R21,10        ;Minus 10 Unit (Basic setup Voltage)
     RJMP  CPD
CL:  CLR   R20
CPD: CP    R18,R21       ;If Batarey Voltage > Basic Setup Voltage
     BRSH  UMN           ;go to the label "UMN"
     CLI
	 LDI   XL,180
	 CLR   XH
	 SBI   PORTC,4       ;Out PortC,4 - High
     RJMP  DD
UMN: SEI             
     MUL   XH,RDI        ;Teim * Current Value (Save in R0(low),R1)
DD:  CLR   ZH
     CLR   YH
     MOV   ZL,RDI
	 LDI   YL,100
     RCALL DIV
	 RCALL DECOD
	 STS   0x60,R23      ;In RAM (Adress 0x60) - Digit Units(I)
	 LDI   YL,10
	 RCALL DIV
	 RCALL DECOD
     STS   0x61,R23      ;In RAM (Adr 0x61)-Digit the tenth shares(I)
	 MOV   R25,ZL
	 RCALL DECOD
	 STS   0x62,R23      ;In RAM (Adr 0x62)-Digit the 100-th shares(I)
	 SBIS  PINB,0        ;If button "U Select" is pressed
	 RJMP  V1            ;Indication Batarey Voltage 
	 MOV   ZL,R21        ;Else no pressed- basic setup voltage
	 RJMP  V2
V1:	 MOV   ZL,R18
V2:	 LDI   YL,100
	 RCALL DIV
	 RCALL DECOD
	 CPSE  R25,R10
	 RJMP  V3
	 CLR   R23
V3:	 STS   0x63,R23      ;In RAM (Adress 0x63)- Digit (Tens Volt)
	 LDI   YL,10
	 RCALL DIV
	 RCALL DECOD
     STS   0x64,R23      ;In RAM (Adress 0x64)- Digit (Units Volt)
	 MOV   R25,ZL
	 RCALL DECOD
	 STS   0x65,R23      ;In RAM (Adr 0x65)-Digit (tenth shares (V))
;*********************************************************************
	 MOV   ZL,R0
	 MOV   ZH,R1
	 LDI   YL,16
	 LDI   YH,39
	 RCALL DIV
	 RCALL DECOD
	 CPSE  R25,R10
	 RJMP  V4
	 CLR   R23
V4:  STS   0x66,R23      ;In RAM (Adress 0x66)- Digit
	 LDI   YL,232
	 LDI   YH,3
     RCALL DIV
	 RCALL DECOD
	 STS   0x67,R23      ;In RAM (Adress 0x67)- Digit
	 LDI   YL,100
	 CLR   YH
	 RCALL DIV
	 RCALL DECOD
	 STS   0x68,R23      ;In RAM (Adress 0x68)- Digit.
	 LDI   YL,10
	 RCALL DIV
	 RCALL DECOD
	 STS   0x69,R23      ;In RAM (Adress 0x69)- Digit.
	 MOV   R25,ZL
	 RCALL DECOD
	 STS   0x6A,R23      ;In RAM (Adress 0x6A)- Digit.
	 LDS   R2,0x70 
     MOVW  ZL,R10
STROB:
     LDI   YL,0x60
	 SBI   PORTC,2
	 SBI   PORTC,3
ZD:  SBIW  ZL,DZ
     BRNE  ZD
	 CBI   PORTC,2
	 CBI   PORTC,3
STR:
	 LD    R12,Y+
	 OUT   PORTD,R12
	 CPI   R24,12
	 BREQ  SD5
     CPI   R24,4
	 BREQ  SD5
	 CPI   R24,7
	 BRNE  ZZ
SD5: SBI   PORTD,5
ZZ:  SBIW  ZL,DZ
     BRNE  ZZ
	 OUT   TCCR1B,R10
	 IN    R24,PORTC
	 INC   R24
	 OUT   PORTC,R24
	 OUT   TCCR1B,R5
     ANDI  R24,15
	 CPI   R24,12
     BRLO  STR
     DEC   R2
	 BRNE  STROB
	 SBI   ADCSR,6
	 RJMP  START 
;*********************************************************************
DIV: CLR   R25
LOOP:CP    ZL,YL
     CPC   ZH,YH
	 BRLO  SS
A1:  INC   R25
     SUB   ZL,YL
	 SBC   ZH,YH
	 RJMP  LOOP
SS:  RET
;*********************************************************************
DECOD:
     CPI   R25,0
	 BREQ  S0
	 CPI   R25,1
	 BREQ  S1
	 CPI   R25,2
	 BREQ  S2
     CPI   R25,3
	 BREQ  S3
	 CPI   R25,4
	 BREQ  S4
	 CPI   R25,5
	 BREQ  S5
     CPI   R25,6
	 BREQ  S6
	 CPI   R25,7
	 BREQ  S7
	 CPI   R25,8
	 BREQ  S8
	 CPI   R25,9
	 BREQ  S9
S0:  LDI   R23,95
     RJMP  CZ
S1:  LDI   R23,6
     RJMP  CZ
S2:  LDI   R23,155
     RJMP  CZ
S3:  LDI   R23,143
     RJMP  CZ
S4:  LDI   R23,198
     RJMP  CZ
S5:  LDI   R23,205
     RJMP  CZ
S6:  LDI   R23,221
     RJMP  CZ
S7:  LDI   R23,71
     RJMP  CZ
S8:  LDI   R23,223
     RJMP  CZ
S9:  LDI   R23,207
CZ:  RET


