/*****************************************************
Date    : 28.10.2010
Chip type               : ATtiny26
AVR Core Clock frequency: 4,000000 MHz
Memory model            : Tiny
External RAM size       : 0
Data Stack size         : 32
*****************************************************/
typedef  unsigned char byte ;
typedef  unsigned int  real ;
#include <tiny26.h>
#include <delay.h>

#define a 1
#define b 2
#define c 4
#define d 8               //     
#define e 16
#define f 32
#define g 64
#define en dig[10]    // H
#define pe  dig[11]   // 
#define er dig[12]    // P
#define we dig[13]          // B
#define ye    dig[14]             // E
#define de   dig[15]                // d

#define show_enpeer 1   //     
#define show_wepeer 2     //      
#define show_weerye 3       //       
#define show_enwek  4         //        d
#define show_wewek  5           //         d
#define show_depewe  6                  //  d
#define show_umin   7            //            
#define show_umax   8               //         
#define show_ondelay 9                       //   
#define show_dumin_on 10                 //         
#define show_dumax_on 11                  //     
#define show_osccal    12                //   .
#define show_timer   13                 //     
#define show_uadc      14                 //   
#define  show_temp      15                // 

#define  min_up    (PINA.2==1 )       //          
#define  min_down ( PINA.2==0)          //

#define  plus_up  ( PINA.4==1    )        //      
#define  plus_down  (PINA.4==0     )         //

byte
      ind[3] ,         //  
       morg ,      //    0-no mig 1-mig
       rele=252 ,  //    off=252 on=253
         meny    ,                //  ,    ,    show_enpeer  show_uadc
         zahvat_meny , //1  0 - 0      ,    
                        // 1    in , 0-    .
          tik,          //  ++  0.2 
          on_tik,       //  tik
          zap_timer=0 ; // 1- 0-


byte dig[] = {
  (a+b+c+d+e+f),   //       
  (b+c),
  (a+b+g+e+d),
  (a+b+g+c+d),
  (f+g+b+c) ,
  (a+f+g+c+d) ,
   (a+f+g+c+d+e) ,
  (a+b+c)       ,
 (a+b+c+d+e+f+g),
  (a+b+c+d+f+g)  ,
   (b+c+e+f+g)   ,                 // H
 (a+b+c+e+f) ,                // 
 (a+b+e+f+g)   ,              // P
  (a+b+c+d+e+f+g)   ,                // B
   (a+d+e+f+g)    ,              // E
   (b+c+d+e+g)  ,            // d
    0      } ;                 //



 byte number_razr[] = {
  ~128  ,   // 
   ~64  ,    // 
  ~32  } ; //  

 byte blink=0,n=0,i=0,k=0;       //      , -     Static
 byte otschet=0,per=0;      //   ,   

real
    temp,
     umax,
       umax_on,                          //            
         uadc ;    //                           
 byte
      var_dig,     //   
            bud_timer,   //  
            ondelay,        //    
              umin,          //      
             dumin_on,        //                 
                dumax_on,       //                      
              cal,          //                            
                 umin_on,      //     
            crash=0;          // counter crash
real
      u_tmp ,                    //    50 
     uadc_tmp;                   //   8 

eeprom byte
          ust_umin=190,          //      
            ust_osccal =176 ,           //              
                 ust_dumin_on=5,        //                 
                   ust_dumax_on=3,       //                      
                     ust_ondelay=10;    //
eeprom real ust_umax=230 ;


   void eeprom_to_ram ()
      {
        umin=ust_umin ;          //      
           umax=ust_umax;              //            
             dumin_on=ust_dumin_on ;        //                 
                dumax_on=ust_dumax_on ;        //                      
                ondelay = ust_ondelay   ;     //       
             umin_on = umin + dumin_on ;
             umax_on=umax - dumax_on ;
        OSCCAL =ust_osccal ;       //   

      }


#define ADC_VREF_TYPE 0xC0

// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{ ADMUX=adc_input|0xc0;

// Delay needed for the stabilization of the ADC input voltage
delay_us(10);
// Start the AD conversion
ADCSR|=0x40;
// Wait for the AD conversion to complete
while ((ADCSR & 0x10)==0);
ADCSR|=0x10;
return ADCW;
}

  void bcd ( real num )       //              
  { byte i=0;

     if (num>999 ) num=999;
     while (num>99)
       { num=num-100;
          i++;
       }

     if(i==0) ind[2]=dig[16];
          else
           ind[2]=dig[i];
      i=0;
     while (num>9)
       { num=num-10;
          i++;
       }
     if((i==0)& (ind[2]==dig[16])) ind[1]=dig[16]; else ind[1]=dig[i];
      ind[0]=dig[(byte) num];
     if (cal==1) ind[2]= de;
  }

 void show (byte name_bookmark)         //   =   

 {  switch (name_bookmark)
     {case show_enpeer : {ind[2]=en;ind[1]=pe;ind[0]=er;break;}
      case show_wepeer : {ind[2]=we;ind[1]=pe;ind[0]=er;break;}
      case show_weerye : {ind[2]=we;ind[1]=er;ind[0]=ye;break;}
      case show_enwek  : {ind[2]=de;ind[1]=en;ind[0]=pe;break;}
      case show_wewek  : {ind[2]=de;ind[1]=we;ind[0]=pe;break;}
      case show_depewe :  {ind[2]=de;ind[1]=pe;ind[0]=we;break;}
      case show_umin     :  {bcd(umin);break; }
      case show_umax     :  {bcd(umax);break; }
   //   case show_dumin_on : {bcd(dumin_on);break;}
   //   case show_dumax_on : {bcd(dumax_on);break;}
   //   case show_ondelay  : {bcd(ondelay);break; }
      case show_timer    : {bcd(bud_timer ); break;  }
      case show_uadc     : {bcd(uadc ); break;  }
   //   case show_osccal   : {bcd(osccal);break;}
      case show_temp      :     {bcd(temp);break;}
      default :;}
}

 void control ()
 {
  if (zahvat_meny==0){if
                        ((zap_timer==1)&&(rele==254)){meny=show_timer;morg=0;}
                     else
                         { meny=show_uadc;} }
 if (uadc<umin) crash++;
  if ((crash==5)||(uadc>umax))
   {
     rele=254;morg=1;
      zap_timer=0;
     bud_timer=ondelay; crash=0;
      return;
    }
if ((umin_on <uadc)&& (uadc< umax_on) && (zap_timer==0))
   {  rele=254; morg=0;
      bud_timer=ondelay;zap_timer=1 ; crash=0;
      return;
    }
if ( (umin_on <uadc)&& (uadc< umax_on)&& (bud_timer==0))
    {  rele=255;morg=0; crash=0;
    return;}
return;
}
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
   TCNT0=0xD7;      //      
         read_adc (1);

 u_tmp=u_tmp+ADCW; otschet++;
      if (otschet==31){
             per++;
             otschet=0;

           /*  if(u_tmp>(270<<5)) {rele=254;           //     -   20 .
                                   morg=1;
                                       zap_timer=0;
                                              bud_timer=ondelay;}    */
         uadc_tmp=uadc_tmp +(u_tmp>>5); u_tmp=0;
              if(per==7){uadc=uadc_tmp>>3;
               control ();    //     8   = 160
              per=0;
              uadc_tmp=0;}

         }

}

// Timer 1 overflow interrupt service routine
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
   TCNT1=0xEB;                       //Reinitial timer
 #asm  ( "wdr")               // Watchdog reset
    n++;
  if (n<40 )
              blink=0;
    if (n>40)
              blink =255;
   if (n==80)
               { n=0; if(on_tik==1) tik++;  //  0.4       meny
                     show(meny); }     //  
 if  (morg==1)
             PORTB=ind[i]&blink;
 else
             PORTB=ind[i] ;
 PORTA=  (number_razr [i]&rele)& 245;
                                      i++ ;
 if (i==3)
           i=0;

 if (zap_timer==1)
 {
    if  (k<150) k++ ;
     if  (k>149 )
        {  k=0;                           //    zap_timer=1   bud_timer ,   0
         if (bud_timer!=0)
                          bud_timer -- ;
       }
 }
}

void var_key  (real digit,real low_lim,real high_lim)
  { temp=digit;
   if (meny==6) {cal=1;meny=show_uadc;}
   else
           {meny=show_temp;}

    tik=0;zahvat_meny=1; var_dig=0;
     while (plus_down){;}
     delay_ms(200);                    //   +
    while ((tik<40))
    { if(min_down && plus_up)
     {  tik=0;
        if(digit>low_lim){digit--;var_dig=1;}
     }
     if(min_up && plus_down)
     { tik=0;
        if(digit<high_lim){digit++;var_dig=1;}
     }
      temp =  digit;
      if (cal==1)OSCCAL=temp;//meny=show_temp;
    delay_ms(150);
     }
     cal=0;
    }


void main(void)
{

// Func7=Out Func6=Out Func5=Out Func4=In Func3=In Func2=In Func1=In Func0=Out
// State7=1 State6=1 State5=1 State4=P State3=P State2=P State1=T State0=0
PORTA=0xFC;
DDRA=0xE1+8;
PORTB=0x80;
DDRB=0x7F;

// Timer/Counter 0 initialization
// Clock value: 3,906 kHz
//TCCR0=0x05;
//TCNT0=0xEB;
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 62,5 kHz/217=1.6khz = 625 mks
TCCR0=0x03;
TCNT0=0xD9;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 3,906 kHz
// Mode: Normal top=FFh
// OC1A output: Disconnected
// OC1B output: Disconnected
// Timer 1 Overflow Interrupt: On
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
PLLCSR=0x00;
TCCR1A=0x00;
TCCR1B=0x0B;
TCNT1=0xEB;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x06;

// ADC initialization
// ADC Clock frequency: 500,000 kHz
// ADC Voltage Reference: Int., AREF discon.
ADCSR=0x83;

// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/512k
WDTCR=0x0D;

    eeprom_to_ram ();

 //osccal=OSCCAL;      //  . .
    zap_timer=0;
    bud_timer=ondelay;
    #asm("sei")

    while (1)      // 68.3% flash   
    {   tik=0;
        on_tik=1;
         zahvat_meny=0;

        while (min_down && (tik<20))
        {
            zahvat_meny=1;
            if ( (tik<10) ) meny=show_umin;
            else {
                for (meny=1;(meny<7);meny++)      //      5  ,   +   30
                {
                    tik=0;
                    while((tik<5))
                    {
                        if(plus_down) {tik=0;break;}
                    }

                    if(plus_down) {tik=0;break;}
                }

            }
        }

      /*  switch (meny)
        {
            case(1):{var_key(umin,100,195);umin=temp;if(var_dig==1)ust_umin=umin;break;}
            case(2):{var_key(umax,220,270);umax=temp;if(var_dig==1)ust_umax=umax; break;}
            case(3):{var_key(ondelay,1,255);ondelay=temp;bud_timer=ondelay;if(var_dig==1)ust_ondelay=ondelay;break;}
           case(4):{var_key(dumin_on,1,12);dumin_on=temp;if(var_dig==1)ust_dumin_on=dumin_on;umin_on=umin+dumin_on;break;}
            case(5):{var_key(dumax_on,1,12);dumax_on=temp;if(var_dig==1)ust_dumax_on= dumax_on;umax_on=umax-dumax_on;break;}
           case(6):{var_key(d_uadc,100,220);d_uadc=temp;if(var_dig==1){OSCCAL=d_uadc;ust_d_uadc = d_uadc;break;}
            default:;
        } */

        var_dig=0;
        switch (meny)
        {
            case(1):{var_key(umin,100,195);ust_umin=temp;break;}
            case(2):{var_key(umax,220,270);ust_umax=temp; break;}
            case(3):{var_key(ondelay,1,255);ust_ondelay=temp;break;}
           case(4):{var_key(dumin_on,1,12);ust_dumin_on=temp;break;}
            case(5):{var_key(dumax_on,1,12);ust_dumax_on=temp;break;}
           case(6):{var_key(OSCCAL,100,220);ust_osccal =temp;break;}
            default:;
        }

         if (var_dig==1)
                            eeprom_to_ram ();
        tik=0;
        on_tik=1;
        if(plus_down )
        {
            while(tik<2) { zahvat_meny=1; meny=show_umax;}
        }
        zahvat_meny=0;


    }

}































