
;CodeVisionAVR C Compiler V2.03.4 Standard
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATtiny26
;Clock frequency        : 4,000000 MHz
;Memory model           : Tiny
;Optimize for           : Size
;(s)printf features     : int
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 34 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;global const stored in FLASH  : Yes
;8 bit enums            : Yes
;Smart register allocation : Off
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATtiny26
	#pragma AVRPART MEMORY PROG_FLASH 2048
	#pragma AVRPART MEMORY EEPROM 128
	#pragma AVRPART MEMORY INT_SRAM SIZE 128
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E

	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOV  R30,R0
	MOV  R31,R1
	.ENDM

	.MACRO __GETB2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOV  R26,R0
	MOV  R27,R1
	.ENDM

	.MACRO __GETBRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _morg=R4
	.DEF _rele=R5
	.DEF _meny=R6
	.DEF _zahvat_meny=R7
	.DEF _tik=R8
	.DEF _on_tik=R9
	.DEF _zap_timer=R10
	.DEF _blink=R11
	.DEF _n=R12
	.DEF _i=R13
	.DEF _k=R14

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer1_ovf_isr
	RJMP _timer0_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_0x3:
	.DB  0x3F,0x6,0x5B,0x4F,0x66,0x6D,0x7D,0x7
	.DB  0x7F,0x6F,0x76,0x37,0x73,0x7F,0x79,0x5E
	.DB  0x0
_0x4:
	.DB  0x7F,0xBF,0xDF
_0x5:
	.DB  0x0
_0x6:
	.DB  0x0
_0x7:
	.DB  0x0
_0x7A:
	.DB  0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x11
	.DW  _dig
	.DW  _0x3*2

	.DW  0x03
	.DW  _number_razr
	.DW  _0x4*2

	.DW  0x01
	.DW  _otschet
	.DW  _0x5*2

	.DW  0x01
	.DW  _per
	.DW  _0x6*2

	.DW  0x01
	.DW  _crash
	.DW  _0x7*2

	.DW  0x0A
	.DW  0x05
	.DW  _0x7A*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM
	ADIW R30,1
	MOV  R24,R0
	LPM
	ADIW R30,1
	MOV  R25,R0
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM
	ADIW R30,1
	MOV  R26,R0
	LPM
	ADIW R30,1
	MOV  R27,R0
	LPM
	ADIW R30,1
	MOV  R1,R0
	LPM
	ADIW R30,1
	MOV  R22,R30
	MOV  R23,R31
	MOV  R31,R0
	MOV  R30,R1
__GLOBAL_INI_LOOP:
	LPM
	ADIW R30,1
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOV  R30,R22
	MOV  R31,R23
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0xDF)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x82)
	LDI  R29,HIGH(0x82)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x82

	.CSEG
;/*****************************************************
;Date    : 28.10.2010
;Chip type               : ATtiny26
;AVR Core Clock frequency: 4,000000 MHz
;Memory model            : Tiny
;External RAM size       : 0
;Data Stack size         : 32
;*****************************************************/
;typedef  unsigned char byte ;
;typedef  unsigned int  real ;
;#include <tiny26.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_mask=0x18
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x18
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;#define a 1
;#define b 2
;#define c 4
;#define d 8               //     
;#define e 16
;#define f 32
;#define g 64
;#define en dig[10]    // H
;#define pe  dig[11]   // 
;#define er dig[12]    // P
;#define we dig[13]          // B
;#define ye    dig[14]             // E
;#define de   dig[15]                // d
;
;#define show_enpeer 1   //     
;#define show_wepeer 2     //      
;#define show_weerye 3       //       
;#define show_enwek  4         //        d
;#define show_wewek  5           //         d
;#define show_depewe  6                  //  d
;#define show_umin   7            //            
;#define show_umax   8               //         
;#define show_ondelay 9                       //   
;#define show_dumin_on 10                 //         
;#define show_dumax_on 11                  //     
;#define show_osccal    12                //   .
;#define show_timer   13                 //     
;#define show_uadc      14                 //   
;#define  show_temp      15                // 
;
;#define  min_up    (PINA.2==1 )       //          
;#define  min_down ( PINA.2==0)          //
;
;#define  plus_up  ( PINA.4==1    )        //      
;#define  plus_down  (PINA.4==0     )         //
;
;byte
;      ind[3] ,         //  
;       morg ,      //    0-no mig 1-mig
;       rele=252 ,  //    off=252 on=253
;         meny    ,                //  ,    ,    show_enpeer  show_uadc
;         zahvat_meny , //1  0 - 0      ,    
;                        // 1    in , 0-    .
;          tik,          //  ++  0.2 
;          on_tik,       //  tik
;          zap_timer=0 ; // 1- 0-
;
;
;byte dig[] = {
;  (a+b+c+d+e+f),   //       
;  (b+c),
;  (a+b+g+e+d),
;  (a+b+g+c+d),
;  (f+g+b+c) ,
;  (a+f+g+c+d) ,
;   (a+f+g+c+d+e) ,
;  (a+b+c)       ,
; (a+b+c+d+e+f+g),
;  (a+b+c+d+f+g)  ,
;   (b+c+e+f+g)   ,                 // H
; (a+b+c+e+f) ,                // 
; (a+b+e+f+g)   ,              // P
;  (a+b+c+d+e+f+g)   ,                // B
;   (a+d+e+f+g)    ,              // E
;   (b+c+d+e+g)  ,            // d
;    0      } ;                 //

	.DSEG
;
;
;
; byte number_razr[] = {
;  ~128  ,   // 
;   ~64  ,    // 
;  ~32  } ; //  
;
; byte blink=0,n=0,i=0,k=0;       //      , -     Static
; byte otschet=0,per=0;      //   ,   
;
;real
;    temp,
;     umax,
;       umax_on,                          //            
;         uadc ;    //                           
; byte
;      var_dig,     //   
;            bud_timer,   //  
;            ondelay,        //    
;              umin,          //      
;             dumin_on,        //                 
;                dumax_on,       //                      
;              cal,          //                            
;                 umin_on,      //     
;            crash=0;          // counter crash
;real
;      u_tmp ,                    //    50 
;     uadc_tmp;                   //   8 
;
;eeprom byte
;          ust_umin=190,          //      
;            ust_osccal =176 ,           //              
;                 ust_dumin_on=5,        //                 
;                   ust_dumax_on=3,       //                      
;                     ust_ondelay=10;    //
;eeprom real ust_umax=230 ;
;
;
;   void eeprom_to_ram ()
; 0000 0078       {

	.CSEG
_eeprom_to_ram:
; 0000 0079         umin=ust_umin ;          //      
	LDI  R26,LOW(_ust_umin)
	LDI  R27,HIGH(_ust_umin)
	RCALL __EEPROMRDB
	STS  _umin,R30
; 0000 007A            umax=ust_umax;              //            
	LDI  R26,LOW(_ust_umax)
	LDI  R27,HIGH(_ust_umax)
	RCALL __EEPROMRDW
	STS  _umax,R30
	STS  _umax+1,R31
; 0000 007B              dumin_on=ust_dumin_on ;        //                 
	LDI  R26,LOW(_ust_dumin_on)
	LDI  R27,HIGH(_ust_dumin_on)
	RCALL __EEPROMRDB
	STS  _dumin_on,R30
; 0000 007C                 dumax_on=ust_dumax_on ;        //                      
	LDI  R26,LOW(_ust_dumax_on)
	LDI  R27,HIGH(_ust_dumax_on)
	RCALL __EEPROMRDB
	STS  _dumax_on,R30
; 0000 007D                 ondelay = ust_ondelay   ;     //       
	LDI  R26,LOW(_ust_ondelay)
	LDI  R27,HIGH(_ust_ondelay)
	RCALL __EEPROMRDB
	STS  _ondelay,R30
; 0000 007E              umin_on = umin + dumin_on ;
	LDS  R30,_dumin_on
	LDS  R26,_umin
	ADD  R30,R26
	STS  _umin_on,R30
; 0000 007F              umax_on=umax - dumax_on ;
	LDS  R30,_dumax_on
	LDS  R26,_umax
	LDS  R27,_umax+1
	RCALL SUBOPT_0x0
	SUB  R26,R30
	SBC  R27,R31
	STS  _umax_on,R26
	STS  _umax_on+1,R27
; 0000 0080         OSCCAL =ust_osccal ;       //   
	LDI  R26,LOW(_ust_osccal)
	LDI  R27,HIGH(_ust_osccal)
	RCALL __EEPROMRDB
	OUT  0x31,R30
; 0000 0081 
; 0000 0082       }
	RET
;
;
;#define ADC_VREF_TYPE 0xC0
;
;// Read the AD conversion result
;unsigned int read_adc(unsigned char adc_input)
; 0000 0089 { ADMUX=adc_input|0xc0;
_read_adc:
;	adc_input -> Y+0
	LD   R30,Y
	ORI  R30,LOW(0xC0)
	OUT  0x7,R30
; 0000 008A 
; 0000 008B // Delay needed for the stabilization of the ADC input voltage
; 0000 008C delay_us(10);
	__DELAY_USB 13
; 0000 008D // Start the AD conversion
; 0000 008E ADCSR|=0x40;
	SBI  0x6,6
; 0000 008F // Wait for the AD conversion to complete
; 0000 0090 while ((ADCSR & 0x10)==0);
_0x8:
	SBIS 0x6,4
	RJMP _0x8
; 0000 0091 ADCSR|=0x10;
	SBI  0x6,4
; 0000 0092 return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	RJMP _0x2000002
; 0000 0093 }
;
;  void bcd ( real num )       //              
; 0000 0096   { byte i=0;
_bcd:
; 0000 0097 
; 0000 0098      if (num>999 ) num=999;
	ST   -Y,R16
;	num -> Y+1
;	i -> R16
	LDI  R16,0
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	CPI  R26,LOW(0x3E8)
	LDI  R30,HIGH(0x3E8)
	CPC  R27,R30
	BRLO _0xB
	LDI  R30,LOW(999)
	LDI  R31,HIGH(999)
	STD  Y+1,R30
	STD  Y+1+1,R31
; 0000 0099      while (num>99)
_0xB:
_0xC:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	CPI  R26,LOW(0x64)
	LDI  R30,HIGH(0x64)
	CPC  R27,R30
	BRLO _0xE
; 0000 009A        { num=num-100;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	SUBI R30,LOW(100)
	SBCI R31,HIGH(100)
	STD  Y+1,R30
	STD  Y+1+1,R31
; 0000 009B           i++;
	SUBI R16,-1
; 0000 009C        }
	RJMP _0xC
_0xE:
; 0000 009D 
; 0000 009E      if(i==0) ind[2]=dig[16];
	CPI  R16,0
	BRNE _0xF
	__GETB1MN _dig,16
	RJMP _0x75
; 0000 009F           else
_0xF:
; 0000 00A0            ind[2]=dig[i];
	LDI  R26,LOW(_dig)
	ADD  R26,R16
	LD   R30,X
_0x75:
	__PUTB1MN _ind,2
; 0000 00A1       i=0;
	LDI  R16,LOW(0)
; 0000 00A2      while (num>9)
_0x11:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	SBIW R26,10
	BRLO _0x13
; 0000 00A3        { num=num-10;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	SBIW R30,10
	STD  Y+1,R30
	STD  Y+1+1,R31
; 0000 00A4           i++;
	SUBI R16,-1
; 0000 00A5        }
	RJMP _0x11
_0x13:
; 0000 00A6      if((i==0)& (ind[2]==dig[16])) ind[1]=dig[16]; else ind[1]=dig[i];
	MOV  R26,R16
	LDI  R30,LOW(0)
	RCALL __EQB12
	MOV  R0,R30
	__GETB2MN _ind,2
	__GETB1MN _dig,16
	RCALL __EQB12
	AND  R30,R0
	BREQ _0x14
	__GETB1MN _dig,16
	RJMP _0x76
_0x14:
	LDI  R26,LOW(_dig)
	ADD  R26,R16
	LD   R30,X
_0x76:
	__PUTB1MN _ind,1
; 0000 00A7       ind[0]=dig[(byte) num];
	LDD  R30,Y+1
	SUBI R30,-LOW(_dig)
	LD   R30,Z
	RCALL SUBOPT_0x1
; 0000 00A8      if (cal==1) ind[2]= de;
	LDS  R26,_cal
	CPI  R26,LOW(0x1)
	BRNE _0x16
	RCALL SUBOPT_0x2
; 0000 00A9   }
_0x16:
	LDD  R16,Y+0
	ADIW R28,3
	RET
;
; void show (byte name_bookmark)         //   =   
; 0000 00AC 
; 0000 00AD  {  switch (name_bookmark)
_show:
;	name_bookmark -> Y+0
	LD   R30,Y
; 0000 00AE      {case show_enpeer : {ind[2]=en;ind[1]=pe;ind[0]=er;break;}
	CPI  R30,LOW(0x1)
	BRNE _0x1A
	__GETB1MN _dig,10
	RCALL SUBOPT_0x3
	RJMP _0x19
; 0000 00AF       case show_wepeer : {ind[2]=we;ind[1]=pe;ind[0]=er;break;}
_0x1A:
	CPI  R30,LOW(0x2)
	BRNE _0x1B
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x3
	RJMP _0x19
; 0000 00B0       case show_weerye : {ind[2]=we;ind[1]=er;ind[0]=ye;break;}
_0x1B:
	CPI  R30,LOW(0x3)
	BRNE _0x1C
	RCALL SUBOPT_0x4
	__PUTB1MN _ind,2
	__GETB1MN _dig,12
	RCALL SUBOPT_0x5
	__GETB1MN _dig,14
	RCALL SUBOPT_0x1
	RJMP _0x19
; 0000 00B1       case show_enwek  : {ind[2]=de;ind[1]=en;ind[0]=pe;break;}
_0x1C:
	CPI  R30,LOW(0x4)
	BRNE _0x1D
	RCALL SUBOPT_0x2
	__GETB1MN _dig,10
	RCALL SUBOPT_0x5
	__GETB1MN _dig,11
	RCALL SUBOPT_0x1
	RJMP _0x19
; 0000 00B2       case show_wewek  : {ind[2]=de;ind[1]=we;ind[0]=pe;break;}
_0x1D:
	CPI  R30,LOW(0x5)
	BRNE _0x1E
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x5
	__GETB1MN _dig,11
	RCALL SUBOPT_0x1
	RJMP _0x19
; 0000 00B3       case show_depewe :  {ind[2]=de;ind[1]=pe;ind[0]=we;break;}
_0x1E:
	CPI  R30,LOW(0x6)
	BRNE _0x1F
	RCALL SUBOPT_0x2
	__GETB1MN _dig,11
	RCALL SUBOPT_0x5
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x1
	RJMP _0x19
; 0000 00B4       case show_umin     :  {bcd(umin);break; }
_0x1F:
	CPI  R30,LOW(0x7)
	BRNE _0x20
	LDS  R30,_umin
	RCALL SUBOPT_0x6
	RJMP _0x19
; 0000 00B5       case show_umax     :  {bcd(umax);break; }
_0x20:
	CPI  R30,LOW(0x8)
	BRNE _0x21
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x8
	RJMP _0x19
; 0000 00B6    //   case show_dumin_on : {bcd(dumin_on);break;}
; 0000 00B7    //   case show_dumax_on : {bcd(dumax_on);break;}
; 0000 00B8    //   case show_ondelay  : {bcd(ondelay);break; }
; 0000 00B9       case show_timer    : {bcd(bud_timer ); break;  }
_0x21:
	CPI  R30,LOW(0xD)
	BRNE _0x22
	LDS  R30,_bud_timer
	RCALL SUBOPT_0x6
	RJMP _0x19
; 0000 00BA       case show_uadc     : {bcd(uadc ); break;  }
_0x22:
	CPI  R30,LOW(0xE)
	BRNE _0x23
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0x8
	RJMP _0x19
; 0000 00BB    //   case show_osccal   : {bcd(osccal);break;}
; 0000 00BC       case show_temp      :     {bcd(temp);break;}
_0x23:
	CPI  R30,LOW(0xF)
	BRNE _0x25
	RCALL SUBOPT_0xA
	RCALL SUBOPT_0x8
; 0000 00BD       default :;}
_0x25:
_0x19:
; 0000 00BE }
_0x2000002:
	ADIW R28,1
	RET
;
; void control ()
; 0000 00C1  {
_control:
; 0000 00C2   if (zahvat_meny==0){if
	TST  R7
	BRNE _0x26
; 0000 00C3                         ((zap_timer==1)&&(rele==254)){meny=show_timer;morg=0;}
	LDI  R30,LOW(1)
	CP   R30,R10
	BRNE _0x28
	LDI  R30,LOW(254)
	CP   R30,R5
	BREQ _0x29
_0x28:
	RJMP _0x27
_0x29:
	LDI  R30,LOW(13)
	MOV  R6,R30
	CLR  R4
; 0000 00C4                      else
	RJMP _0x2A
_0x27:
; 0000 00C5                          { meny=show_uadc;} }
	LDI  R30,LOW(14)
	MOV  R6,R30
_0x2A:
; 0000 00C6  if (uadc<umin) crash++;
_0x26:
	LDS  R30,_umin
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0xC
	BRSH _0x2B
	LDS  R30,_crash
	SUBI R30,-LOW(1)
	STS  _crash,R30
; 0000 00C7   if ((crash==5)||(uadc>umax))
_0x2B:
	LDS  R26,_crash
	CPI  R26,LOW(0x5)
	BREQ _0x2D
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0xB
	CP   R30,R26
	CPC  R31,R27
	BRSH _0x2C
_0x2D:
; 0000 00C8    {
; 0000 00C9      rele=254;morg=1;
	LDI  R30,LOW(254)
	MOV  R5,R30
	LDI  R30,LOW(1)
	MOV  R4,R30
; 0000 00CA       zap_timer=0;
	RCALL SUBOPT_0xD
; 0000 00CB      bud_timer=ondelay; crash=0;
	RJMP _0x2000001
; 0000 00CC       return;
; 0000 00CD     }
; 0000 00CE if ((umin_on <uadc)&& (uadc< umax_on) && (zap_timer==0))
_0x2C:
	RCALL SUBOPT_0xE
	BRSH _0x30
	RCALL SUBOPT_0xF
	BRSH _0x30
	LDI  R30,LOW(0)
	CP   R30,R10
	BREQ _0x31
_0x30:
	RJMP _0x2F
_0x31:
; 0000 00CF    {  rele=254; morg=0;
	LDI  R30,LOW(254)
	MOV  R5,R30
	CLR  R4
; 0000 00D0       bud_timer=ondelay;zap_timer=1 ; crash=0;
	LDS  R30,_ondelay
	STS  _bud_timer,R30
	LDI  R30,LOW(1)
	MOV  R10,R30
	RJMP _0x2000001
; 0000 00D1       return;
; 0000 00D2     }
; 0000 00D3 if ( (umin_on <uadc)&& (uadc< umax_on)&& (bud_timer==0))
_0x2F:
	RCALL SUBOPT_0xE
	BRSH _0x33
	RCALL SUBOPT_0xF
	BRSH _0x33
	LDS  R26,_bud_timer
	CPI  R26,LOW(0x0)
	BREQ _0x34
_0x33:
	RJMP _0x32
_0x34:
; 0000 00D4     {  rele=255;morg=0; crash=0;
	LDI  R30,LOW(255)
	MOV  R5,R30
	CLR  R4
_0x2000001:
	LDI  R30,LOW(0)
	STS  _crash,R30
; 0000 00D5     return;}
	RET
; 0000 00D6 return;
_0x32:
	RET
; 0000 00D7 }
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 00D9 {
_timer0_ovf_isr:
	RCALL SUBOPT_0x10
; 0000 00DA    TCNT0=0xD7;      //      
	LDI  R30,LOW(215)
	OUT  0x32,R30
; 0000 00DB          read_adc (1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _read_adc
; 0000 00DC 
; 0000 00DD  u_tmp=u_tmp+ADCW; otschet++;
	IN   R30,0x4
	IN   R31,0x4+1
	RCALL SUBOPT_0x11
	ADD  R30,R26
	ADC  R31,R27
	RCALL SUBOPT_0x12
	LDS  R30,_otschet
	SUBI R30,-LOW(1)
	STS  _otschet,R30
; 0000 00DE       if (otschet==31){
	LDS  R26,_otschet
	CPI  R26,LOW(0x1F)
	BRNE _0x35
; 0000 00DF              per++;
	LDS  R30,_per
	SUBI R30,-LOW(1)
	STS  _per,R30
; 0000 00E0              otschet=0;
	LDI  R30,LOW(0)
	STS  _otschet,R30
; 0000 00E1 
; 0000 00E2            /*  if(u_tmp>(270<<5)) {rele=254;           //     -   20 .
; 0000 00E3                                    morg=1;
; 0000 00E4                                        zap_timer=0;
; 0000 00E5                                               bud_timer=ondelay;}    */
; 0000 00E6          uadc_tmp=uadc_tmp +(u_tmp>>5); u_tmp=0;
	RCALL SUBOPT_0x11
	LDI  R30,LOW(5)
	RCALL __LSRW12
	LDS  R26,_uadc_tmp
	LDS  R27,_uadc_tmp+1
	ADD  R30,R26
	ADC  R31,R27
	RCALL SUBOPT_0x13
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RCALL SUBOPT_0x12
; 0000 00E7               if(per==7){uadc=uadc_tmp>>3;
	LDS  R26,_per
	CPI  R26,LOW(0x7)
	BRNE _0x36
	LDS  R30,_uadc_tmp
	LDS  R31,_uadc_tmp+1
	RCALL __LSRW3
	STS  _uadc,R30
	STS  _uadc+1,R31
; 0000 00E8                control ();    //     8   = 160
	RCALL _control
; 0000 00E9               per=0;
	LDI  R30,LOW(0)
	STS  _per,R30
; 0000 00EA               uadc_tmp=0;}
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RCALL SUBOPT_0x13
; 0000 00EB 
; 0000 00EC          }
_0x36:
; 0000 00ED 
; 0000 00EE }
_0x35:
	RJMP _0x79
;
;// Timer 1 overflow interrupt service routine
;interrupt [TIM1_OVF] void timer1_ovf_isr(void)
; 0000 00F2 {
_timer1_ovf_isr:
	RCALL SUBOPT_0x10
; 0000 00F3    TCNT1=0xEB;                       //Reinitial timer
	LDI  R30,LOW(235)
	OUT  0x2E,R30
; 0000 00F4  #asm  ( "wdr")               // Watchdog reset
	wdr
; 0000 00F5     n++;
	INC  R12
; 0000 00F6   if (n<40 )
	LDI  R30,LOW(40)
	CP   R12,R30
	BRSH _0x37
; 0000 00F7               blink=0;
	CLR  R11
; 0000 00F8     if (n>40)
_0x37:
	LDI  R30,LOW(40)
	CP   R30,R12
	BRSH _0x38
; 0000 00F9               blink =255;
	LDI  R30,LOW(255)
	MOV  R11,R30
; 0000 00FA    if (n==80)
_0x38:
	LDI  R30,LOW(80)
	CP   R30,R12
	BRNE _0x39
; 0000 00FB                { n=0; if(on_tik==1) tik++;  //  0.4       meny
	CLR  R12
	LDI  R30,LOW(1)
	CP   R30,R9
	BRNE _0x3A
	INC  R8
; 0000 00FC                      show(meny); }     //  
_0x3A:
	ST   -Y,R6
	RCALL _show
; 0000 00FD  if  (morg==1)
_0x39:
	LDI  R30,LOW(1)
	CP   R30,R4
	BRNE _0x3B
; 0000 00FE              PORTB=ind[i]&blink;
	LDI  R26,LOW(_ind)
	ADD  R26,R13
	LD   R30,X
	AND  R30,R11
	RJMP _0x77
; 0000 00FF  else
_0x3B:
; 0000 0100              PORTB=ind[i] ;
	LDI  R26,LOW(_ind)
	ADD  R26,R13
	LD   R30,X
_0x77:
	OUT  0x18,R30
; 0000 0101  PORTA=  (number_razr [i]&rele)& 245;
	LDI  R26,LOW(_number_razr)
	ADD  R26,R13
	LD   R30,X
	AND  R30,R5
	ANDI R30,LOW(0xF5)
	OUT  0x1B,R30
; 0000 0102                                       i++ ;
	INC  R13
; 0000 0103  if (i==3)
	LDI  R30,LOW(3)
	CP   R30,R13
	BRNE _0x3D
; 0000 0104            i=0;
	CLR  R13
; 0000 0105 
; 0000 0106  if (zap_timer==1)
_0x3D:
	LDI  R30,LOW(1)
	CP   R30,R10
	BRNE _0x3E
; 0000 0107  {
; 0000 0108     if  (k<150) k++ ;
	LDI  R30,LOW(150)
	CP   R14,R30
	BRSH _0x3F
	INC  R14
; 0000 0109      if  (k>149 )
_0x3F:
	LDI  R30,LOW(149)
	CP   R30,R14
	BRSH _0x40
; 0000 010A         {  k=0;                           //    zap_timer=1   bud_timer ,   0
	CLR  R14
; 0000 010B          if (bud_timer!=0)
	LDS  R30,_bud_timer
	CPI  R30,0
	BREQ _0x41
; 0000 010C                           bud_timer -- ;
	SUBI R30,LOW(1)
	STS  _bud_timer,R30
; 0000 010D        }
_0x41:
; 0000 010E  }
_0x40:
; 0000 010F }
_0x3E:
_0x79:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;void var_key  (real digit,real low_lim,real high_lim)
; 0000 0112   { temp=digit;
_var_key:
;	digit -> Y+4
;	low_lim -> Y+2
;	high_lim -> Y+0
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x15
; 0000 0113    if (meny==6) {cal=1;meny=show_uadc;}
	LDI  R30,LOW(6)
	CP   R30,R6
	BRNE _0x42
	LDI  R30,LOW(1)
	STS  _cal,R30
	LDI  R30,LOW(14)
	RJMP _0x78
; 0000 0114    else
_0x42:
; 0000 0115            {meny=show_temp;}
	LDI  R30,LOW(15)
_0x78:
	MOV  R6,R30
; 0000 0116 
; 0000 0117     tik=0;zahvat_meny=1; var_dig=0;
	CLR  R8
	LDI  R30,LOW(1)
	MOV  R7,R30
	LDI  R30,LOW(0)
	RCALL SUBOPT_0x16
; 0000 0118      while (plus_down){;}
_0x44:
	SBIS 0x19,4
	RJMP _0x44
; 0000 0119      delay_ms(200);                    //   +
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
; 0000 011A     while ((tik<60))
_0x47:
	LDI  R30,LOW(60)
	CP   R8,R30
	BRSH _0x49
; 0000 011B     { if(min_down && plus_up)
	RCALL SUBOPT_0x17
	CPI  R26,LOW(0x0)
	BRNE _0x4B
	LDI  R26,0
	SBIC 0x19,4
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BREQ _0x4C
_0x4B:
	RJMP _0x4A
_0x4C:
; 0000 011C      {
; 0000 011D         if(digit>low_lim){digit--;var_dig=1;tik=0;}
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	CP   R30,R26
	CPC  R31,R27
	BRSH _0x4D
	RCALL SUBOPT_0x14
	SBIW R30,1
	RCALL SUBOPT_0x18
; 0000 011E      }
_0x4D:
; 0000 011F      if(min_up && plus_down)
_0x4A:
	RCALL SUBOPT_0x17
	CPI  R26,LOW(0x1)
	BRNE _0x4F
	LDI  R26,0
	SBIC 0x19,4
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x50
_0x4F:
	RJMP _0x4E
_0x50:
; 0000 0120      {
; 0000 0121         if(digit<high_lim){digit++;var_dig=1;tik=0;}
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	RCALL SUBOPT_0xC
	BRSH _0x51
	RCALL SUBOPT_0x14
	ADIW R30,1
	RCALL SUBOPT_0x18
; 0000 0122      }
_0x51:
; 0000 0123       temp =  digit;
_0x4E:
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x15
; 0000 0124       if (cal==1)OSCCAL=temp;//meny=show_temp;
	LDS  R26,_cal
	CPI  R26,LOW(0x1)
	BRNE _0x52
	RCALL SUBOPT_0xA
	OUT  0x31,R30
; 0000 0125     delay_ms(150);
_0x52:
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	RCALL SUBOPT_0x19
	RCALL _delay_ms
; 0000 0126      }
	RJMP _0x47
_0x49:
; 0000 0127      cal=0;
	LDI  R30,LOW(0)
	STS  _cal,R30
; 0000 0128     }
	ADIW R28,6
	RET
;
;
;void main(void)
; 0000 012C {
_main:
; 0000 012D 
; 0000 012E // Func7=Out Func6=Out Func5=Out Func4=In Func3=In Func2=In Func1=In Func0=Out
; 0000 012F // State7=1 State6=1 State5=1 State4=P State3=P State2=P State1=T State0=0
; 0000 0130 PORTA=0xFC;
	LDI  R30,LOW(252)
	OUT  0x1B,R30
; 0000 0131 DDRA=0xE1+8;
	LDI  R30,LOW(233)
	OUT  0x1A,R30
; 0000 0132 PORTB=0x80;
	LDI  R30,LOW(128)
	OUT  0x18,R30
; 0000 0133 DDRB=0x7F;
	LDI  R30,LOW(127)
	OUT  0x17,R30
; 0000 0134 
; 0000 0135 // Timer/Counter 0 initialization
; 0000 0136 // Clock value: 3,906 kHz
; 0000 0137 //TCCR0=0x05;
; 0000 0138 //TCNT0=0xEB;
; 0000 0139 // Timer/Counter 0 initialization
; 0000 013A // Clock source: System Clock
; 0000 013B // Clock value: 62,5 kHz/217=1.6khz = 625 mks
; 0000 013C TCCR0=0x03;
	LDI  R30,LOW(3)
	OUT  0x33,R30
; 0000 013D TCNT0=0xD9;
	LDI  R30,LOW(217)
	OUT  0x32,R30
; 0000 013E 
; 0000 013F // Timer/Counter 1 initialization
; 0000 0140 // Clock source: System Clock
; 0000 0141 // Clock value: 3,906 kHz
; 0000 0142 // Mode: Normal top=FFh
; 0000 0143 // OC1A output: Disconnected
; 0000 0144 // OC1B output: Disconnected
; 0000 0145 // Timer 1 Overflow Interrupt: On
; 0000 0146 // Compare A Match Interrupt: Off
; 0000 0147 // Compare B Match Interrupt: Off
; 0000 0148 PLLCSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 0000 0149 TCCR1A=0x00;
	OUT  0x30,R30
; 0000 014A TCCR1B=0x0B;
	LDI  R30,LOW(11)
	OUT  0x2F,R30
; 0000 014B TCNT1=0xEB;
	LDI  R30,LOW(235)
	OUT  0x2E,R30
; 0000 014C 
; 0000 014D // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 014E TIMSK=0x06;
	LDI  R30,LOW(6)
	OUT  0x39,R30
; 0000 014F 
; 0000 0150 // ADC initialization
; 0000 0151 // ADC Clock frequency: 500,000 kHz
; 0000 0152 // ADC Voltage Reference: Int., AREF discon.
; 0000 0153 ADCSR=0x83;
	LDI  R30,LOW(131)
	OUT  0x6,R30
; 0000 0154 
; 0000 0155 // Watchdog Timer initialization
; 0000 0156 // Watchdog Timer Prescaler: OSC/512k
; 0000 0157 WDTCR=0x0D;
	LDI  R30,LOW(13)
	OUT  0x21,R30
; 0000 0158 
; 0000 0159     eeprom_to_ram ();
	RCALL _eeprom_to_ram
; 0000 015A 
; 0000 015B  //osccal=OSCCAL;      //  . .
; 0000 015C     zap_timer=0;
	RCALL SUBOPT_0xD
; 0000 015D     bud_timer=ondelay;
; 0000 015E     #asm("sei")
	sei
; 0000 015F 
; 0000 0160     while (1)      // 68.3% flash   
_0x53:
; 0000 0161     {   tik=0;
	CLR  R8
; 0000 0162         on_tik=1;
	LDI  R30,LOW(1)
	MOV  R9,R30
; 0000 0163          zahvat_meny=0;
	CLR  R7
; 0000 0164 
; 0000 0165         while (min_down && (tik<20))
_0x56:
	RCALL SUBOPT_0x17
	CPI  R26,LOW(0x0)
	BRNE _0x59
	LDI  R30,LOW(20)
	CP   R8,R30
	BRLO _0x5A
_0x59:
	RJMP _0x58
_0x5A:
; 0000 0166         {
; 0000 0167             zahvat_meny=1;
	LDI  R30,LOW(1)
	MOV  R7,R30
; 0000 0168             if ( (tik<10) ) meny=show_umin;
	LDI  R30,LOW(10)
	CP   R8,R30
	BRSH _0x5B
	LDI  R30,LOW(7)
	MOV  R6,R30
; 0000 0169             else {
	RJMP _0x5C
_0x5B:
; 0000 016A                 for (meny=1;(meny<7);meny++)      //      5  ,   +   30
	LDI  R30,LOW(1)
	MOV  R6,R30
_0x5E:
	LDI  R30,LOW(7)
	CP   R6,R30
	BRSH _0x5F
; 0000 016B                 {
; 0000 016C                     tik=0;
	CLR  R8
; 0000 016D                     while((tik<5))
_0x60:
	LDI  R30,LOW(5)
	CP   R8,R30
	BRSH _0x62
; 0000 016E                     {
; 0000 016F                         if(plus_down) {tik=0;break;}
	SBIC 0x19,4
	RJMP _0x63
	CLR  R8
	RJMP _0x62
; 0000 0170                     }
_0x63:
	RJMP _0x60
_0x62:
; 0000 0171 
; 0000 0172                     if(plus_down) {tik=0;break;}
	SBIC 0x19,4
	RJMP _0x64
	CLR  R8
	RJMP _0x5F
; 0000 0173                 }
_0x64:
	INC  R6
	RJMP _0x5E
_0x5F:
; 0000 0174 
; 0000 0175             }
_0x5C:
; 0000 0176         }
	RJMP _0x56
_0x58:
; 0000 0177 
; 0000 0178       /*  switch (meny)
; 0000 0179         {
; 0000 017A             case(1):{var_key(umin,100,195);umin=temp;if(var_dig==1)ust_umin=umin;break;}
; 0000 017B             case(2):{var_key(umax,220,270);umax=temp;if(var_dig==1)ust_umax=umax; break;}
; 0000 017C             case(3):{var_key(ondelay,1,255);ondelay=temp;bud_timer=ondelay;if(var_dig==1)ust_ondelay=ondelay;break;}
; 0000 017D            case(4):{var_key(dumin_on,1,12);dumin_on=temp;if(var_dig==1)ust_dumin_on=dumin_on;umin_on=umin+dumin_on;break;}
; 0000 017E             case(5):{var_key(dumax_on,1,12);dumax_on=temp;if(var_dig==1)ust_dumax_on= dumax_on;umax_on=umax-dumax_on;break;}
; 0000 017F            case(6):{var_key(d_uadc,100,220);d_uadc=temp;if(var_dig==1){OSCCAL=d_uadc;ust_d_uadc = d_uadc;break;}
; 0000 0180             default:;
; 0000 0181         } */
; 0000 0182 
; 0000 0183         var_dig=0;
	LDI  R30,LOW(0)
	RCALL SUBOPT_0x16
; 0000 0184         switch (meny)
	MOV  R30,R6
; 0000 0185         {
; 0000 0186             case(1):{var_key(umin,100,195);ust_umin=temp;break;}
	CPI  R30,LOW(0x1)
	BRNE _0x68
	LDS  R30,_umin
	RCALL SUBOPT_0x1A
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RCALL SUBOPT_0x19
	LDI  R30,LOW(195)
	LDI  R31,HIGH(195)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1C
	LDI  R26,LOW(_ust_umin)
	LDI  R27,HIGH(_ust_umin)
	RCALL __EEPROMWRB
	RJMP _0x67
; 0000 0187             case(2):{var_key(umax,220,270);ust_umax=temp; break;}
_0x68:
	CPI  R30,LOW(0x2)
	BRNE _0x69
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x19
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	RCALL SUBOPT_0x19
	LDI  R30,LOW(270)
	LDI  R31,HIGH(270)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0xA
	LDI  R26,LOW(_ust_umax)
	LDI  R27,HIGH(_ust_umax)
	RCALL __EEPROMWRW
	RJMP _0x67
; 0000 0188             case(3):{var_key(ondelay,1,255);ust_ondelay=temp;break;}
_0x69:
	CPI  R30,LOW(0x3)
	BRNE _0x6A
	LDS  R30,_ondelay
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1D
	LDI  R30,LOW(255)
	LDI  R31,HIGH(255)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1C
	LDI  R26,LOW(_ust_ondelay)
	LDI  R27,HIGH(_ust_ondelay)
	RCALL __EEPROMWRB
	RJMP _0x67
; 0000 0189            case(4):{var_key(dumin_on,1,12);ust_dumin_on=temp;break;}
_0x6A:
	CPI  R30,LOW(0x4)
	BRNE _0x6B
	LDS  R30,_dumin_on
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1D
	LDI  R30,LOW(12)
	LDI  R31,HIGH(12)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1C
	LDI  R26,LOW(_ust_dumin_on)
	LDI  R27,HIGH(_ust_dumin_on)
	RCALL __EEPROMWRB
	RJMP _0x67
; 0000 018A             case(5):{var_key(dumax_on,1,12);ust_dumax_on=temp;break;}
_0x6B:
	CPI  R30,LOW(0x5)
	BRNE _0x6C
	LDS  R30,_dumax_on
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1D
	LDI  R30,LOW(12)
	LDI  R31,HIGH(12)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1C
	LDI  R26,LOW(_ust_dumax_on)
	LDI  R27,HIGH(_ust_dumax_on)
	RCALL __EEPROMWRB
	RJMP _0x67
; 0000 018B            case(6):{var_key(OSCCAL,100,220);ust_osccal =temp;break;}
_0x6C:
	CPI  R30,LOW(0x6)
	BRNE _0x6E
	IN   R30,0x31
	RCALL SUBOPT_0x1A
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RCALL SUBOPT_0x19
	LDI  R30,LOW(220)
	LDI  R31,HIGH(220)
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1C
	LDI  R26,LOW(_ust_osccal)
	LDI  R27,HIGH(_ust_osccal)
	RCALL __EEPROMWRB
; 0000 018C             default:;
_0x6E:
; 0000 018D         }
_0x67:
; 0000 018E 
; 0000 018F          if (var_dig==1)
	LDS  R26,_var_dig
	CPI  R26,LOW(0x1)
	BRNE _0x6F
; 0000 0190                             eeprom_to_ram ();
	RCALL _eeprom_to_ram
; 0000 0191         tik=0;
_0x6F:
	CLR  R8
; 0000 0192         on_tik=1;
	LDI  R30,LOW(1)
	MOV  R9,R30
; 0000 0193         if(plus_down )
	SBIC 0x19,4
	RJMP _0x70
; 0000 0194         {
; 0000 0195             while(tik<2) { zahvat_meny=1; meny=show_umax;}
_0x71:
	LDI  R30,LOW(2)
	CP   R8,R30
	BRSH _0x73
	LDI  R30,LOW(1)
	MOV  R7,R30
	LDI  R30,LOW(8)
	MOV  R6,R30
	RJMP _0x71
_0x73:
; 0000 0196         }
; 0000 0197         zahvat_meny=0;
_0x70:
	CLR  R7
; 0000 0198 
; 0000 0199 
; 0000 019A     }
	RJMP _0x53
; 0000 019B 
; 0000 019C }
_0x74:
	RJMP _0x74
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;

	.DSEG
_ind:
	.BYTE 0x3
_dig:
	.BYTE 0x11
_number_razr:
	.BYTE 0x3
_otschet:
	.BYTE 0x1
_per:
	.BYTE 0x1
_temp:
	.BYTE 0x2
_umax:
	.BYTE 0x2
_umax_on:
	.BYTE 0x2
_uadc:
	.BYTE 0x2
_var_dig:
	.BYTE 0x1
_bud_timer:
	.BYTE 0x1
_ondelay:
	.BYTE 0x1
_umin:
	.BYTE 0x1
_dumin_on:
	.BYTE 0x1
_dumax_on:
	.BYTE 0x1
_cal:
	.BYTE 0x1
_umin_on:
	.BYTE 0x1
_crash:
	.BYTE 0x1
_u_tmp:
	.BYTE 0x2
_uadc_tmp:
	.BYTE 0x2

	.ESEG
_ust_umin:
	.DB  0xBE
_ust_osccal:
	.DB  0xB0
_ust_dumin_on:
	.DB  0x5
_ust_dumax_on:
	.DB  0x3
_ust_ondelay:
	.DB  0xA
_ust_umax:
	.DW  0xE6

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x0:
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1:
	STS  _ind,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x2:
	__GETB1MN _dig,15
	__PUTB1MN _ind,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x3:
	__PUTB1MN _ind,2
	__GETB1MN _dig,11
	__PUTB1MN _ind,1
	__GETB1MN _dig,12
	RJMP SUBOPT_0x1

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	__GETB1MN _dig,13
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5:
	__PUTB1MN _ind,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6:
	RCALL SUBOPT_0x0
	ST   -Y,R31
	ST   -Y,R30
	RJMP _bcd

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x7:
	LDS  R30,_umax
	LDS  R31,_umax+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x8:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _bcd

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x9:
	LDS  R30,_uadc
	LDS  R31,_uadc+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xA:
	LDS  R30,_temp
	LDS  R31,_temp+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xB:
	LDS  R26,_uadc
	LDS  R27,_uadc+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xC:
	CP   R26,R30
	CPC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xD:
	CLR  R10
	LDS  R30,_ondelay
	STS  _bud_timer,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xE:
	RCALL SUBOPT_0x9
	LDS  R26,_umin_on
	LDI  R27,0
	RJMP SUBOPT_0xC

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xF:
	LDS  R30,_umax_on
	LDS  R31,_umax_on+1
	RCALL SUBOPT_0xB
	RJMP SUBOPT_0xC

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x10:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x11:
	LDS  R26,_u_tmp
	LDS  R27,_u_tmp+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x12:
	STS  _u_tmp,R30
	STS  _u_tmp+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x13:
	STS  _uadc_tmp,R30
	STS  _uadc_tmp+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x14:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x15:
	STS  _temp,R30
	STS  _temp+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x16:
	STS  _var_dig,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x17:
	LDI  R26,0
	SBIC 0x19,2
	LDI  R26,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x18:
	STD  Y+4,R30
	STD  Y+4+1,R31
	LDI  R30,LOW(1)
	RCALL SUBOPT_0x16
	CLR  R8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 19 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x19:
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1A:
	RCALL SUBOPT_0x0
	RJMP SUBOPT_0x19

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1B:
	RCALL SUBOPT_0x19
	RJMP _var_key

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1C:
	LDS  R30,_temp
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1D:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	RJMP SUBOPT_0x19


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x3E8
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__LSRW12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	MOV  R31,R27
	BREQ __LSRW12R
__LSRW12L:
	LSR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRW12L
__LSRW12R:
	RET

__LSRW3:
	LSR  R31
	ROR  R30
__LSRW2:
	LSR  R31
	ROR  R30
	LSR  R31
	ROR  R30
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__EEPROMRDW:
	ADIW R26,1
	RCALL __EEPROMRDB
	MOV  R31,R30
	SBIW R26,1

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRW:
	RCALL __EEPROMWRB
	ADIW R26,1
	PUSH R30
	MOV  R30,R31
	RCALL __EEPROMWRB
	POP  R30
	SBIW R26,1
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

;END OF CODE MARKER
__END_OF_CODE:
