.include "tn26def.inc"
.def 	temp	=r16
.def 	temp1	=r17
.def 	counter1=r18
.def 	count 	=r18
.def 	count1	=r19
.def 	count2	=r20
.def 	dataEE	=r20
.def	adrEE 	=r25
.equ	adr_con1=$20	;   EEPROM
.equ	RAM_con1=$a0	;   RAM
.equ	fl_ee	=$21

;---for mul32u(4x4bytes=8bytes)
;              r7 -r8 -r9 -r10
;            x
;              r11-r12-r13-r14
;            -----------------
; r3-r4-r5-r6- r7 -r8 -r9 -r10
.def 	var17=r3
.def 	var16=r4
.def 	var15=r5
.def 	var14=r6
.def 	var13=r7
.def 	var12=r8
.def 	var11=r9
.def 	var10=r10
.def 	var23=r11
.def 	var22=r12
.def 	var21=r13
.def 	var20=r14
.def 	mod0=r3
.def 	mod1=r4
.def 	mod2=r5
.def 	mod3=r6
;---------for bin-dec----------------------
.def 	binh=r19	;high byte before bin-dec 
.def 	binl=r20	;low byte
.def 	d3=r21
.def 	d2=r22
.def 	d1=r23		;out data-> r21-r22-r23
;------------------------------------------
;----for LCD(symbols for output)-----------
.equ 	dig1=$80    ;dig1- 
.equ 	dig2=$81	;    
.equ 	dig3=$82
.equ 	dig4=$83
.equ 	dig5=$84
.equ 	dig6=$85
.equ 	dig7=$86
.equ 	dig8=$87
.equ 	dig9=$88    ;dig9- 
;--   -dat1...dat5
.equ dat1=$90		; 12 34 56 78 90->123456789
.equ dat2=$91
.equ dat3=$92
.equ dat4=$93
.equ dat5=$94			; . dat5  .
.equ dat6=$95
.equ dat7=$96
.equ dat8=$97
.equ dat9=$98
;------------------------------------------
.equ poff		=$a2	;   
;------------------------------------------
.equ flags		=$a1	;( $a1)
.equ c_only		=0		;  
.equ e_only		=1		;  
.equ auto		=2		;. -
.equ short		=3		; 
.equ l_batt		=4		; 
;------------LCD pins----------------------
.equ dclk=		pb5 	;clock LCD (pin 8)
.equ din=		pb4  	;data LCD  (pin 7)
.equ load=		pb6     ;strob LCD (pin 9)
;------- -----------------
.equ ch=		pa5		; ( 0)-pin13
.equ disch=		pa4		;( 1)-pin14
.equ lev=		pb3		; 
.equ but=		pa3		; pin17
.equ pow=		pa2		;.
;------------------------------------------
.def lev1_l= 	r10		; t1  U1
.def lev1_m= 	r9
.def lev1_h=	r8		;   (R8-R9-R10)
.def tmr_h1=   	r22		;  t0( )
.def tmr_h2=   	r21		;  t0( )

.equ con1=		50	; ( *5)(50  1)
.equ con2=		100	;              100
.equ con_sh=	$1e	;   0.2V, short!
.equ off_time=	25	;   
;------------------------------------------------------

.org $0	rjmp reset
;------------------------------------------------------
.org $02
		rjmp reset

.org $6 rjmp t0ovf
;------------------------------------------------------
.org $0a reti
;------------------------------------------------------
.org $20		;THE MAIN BLOCK

reset:;	cli
		ldi temp,low(ramend) 			 ; Stack init
		out sp,temp
;--------- ------------------------------
		ldi temp,(1<<ch)+(1<<disch)+(1<<pow)
		out ddra,temp	
		ldi temp,(1<<dclk)+(1<<din)+(1<<load)+(1<<lev)
		out ddrb,temp
		sbi porta,pow		; 
;------- - .  -----------------
		ldi temp,fl_ee
		mov adrEE,temp
		rcall EEread
		sts flags,dataEE
;---------out-OC1B, mode - PWM1 -----------------
		ldi temp,(1<<com1b1)+(1<<pwm1b)
		out tccr1a,temp
;---------enable PLL-----------------------------
		ldi temp,(1<<plle)+(1<<plock)+(1<<pcke)
		out pllcsr,temp
;---------Load constants for t1 255 - overflow ----------
		ldi temp,198
		out ocr1c,temp
;-----------initial values for comparing -----
		ldi temp,12	;10-0.2V, 20-0.4V
		out ocr1b,temp
;------Use OC1B as output,/OC1b - disconnected---
		ldi temp,1
		out tccr1b,temp		;start tmr1
;********** ...********************************
;		rcall blank
		rcall hello			;...
		sbis pina,but		; ? 
		rcall chng_con1		;,  
		rcall show_batt
		ldi temp,adr_con1	;,    EEPROM
		mov adrEE,temp
		rcall EEread
		sts RAM_con1,dataEE	; con1  
		ldi temp,fl_ee		;   EEPROM
		mov adrEE,temp
		rcall EEread
		sts flags,dataEE	; flags  
		lds temp,flags
		andi temp,0b11110111	;reset flag "short"
		sts flags,temp
		ldi temp,off_time
		sts poff,temp		;   
go:		sbis pina,but		; ? 
		rcall change_fl		; 
		clr tmr_h1			;  
		clr tmr_h2
	;	rjmp go				;  
		rcall measure		; t1 & t2
		lds temp,flags
		andi temp,0b11110111	;reset flag "short"
		sts flags,temp
	;	rjmp go				;  
;----------------------------------------------
		rcall solve_c		; 
		rcall solve_e		; 
;---------    !-------
		lds temp,flags
		andi temp,0b00000111;   3 
		cpi temp, 0b00000010; ?
		breq ind_e			;  ,   
		rcall show_c		; 
		lds temp,flags
		andi temp,0b00000111
		cpi temp, 0b00000001; ?
		breq ind_c			;  C, E  
ind_e:	rcall show_e		; E
ind_c:	ldi adrEE,fl_ee		;   EEPROM
		lds temp,flags
		mov dataEE,temp
		rcall EEwrite
		lds temp,poff
		cpi temp,0
		brne go
		rcall gosleep
		rjmp go				;next cycle
;--------- (.)---------------
chng_con1:
		
		ldi temp,50
wait_b:	sbic pina,but		; ?
		rjmp gomain			; 50   
		dec temp			;  .
		brne wait_b
		rcall show_const	; "SEt ConSt"
		rcall delay1
		ldi temp,adr_con1	;   EEPROM
		mov adrEE,temp
		rcall EEread
		cpi dataEE,30		; .
		brge gt60			;>40->  <60
wr50:	ldi dataEE,con1		; <40  >60  con1=50
		rcall EEwrite
		ldi adrEE,fl_ee		; -   EEPROM
		ldi dataEE,0b00000100
		rcall EEwrite
		rjmp con_ok			; !  	
gt60:	cpi dataEE,71		;.>=61?
		brlo con_ok			;,   
		rjmp wr50			;, =50
con_ok:	rcall sh_con1		; "nSt-xx"
		ldi temp,(1<<cs00)+(1<<cs01);  =/64
		out tccr0,temp		; t0
		ldi count,120		;  0(  )
		ldi temp,50
wait_b1:sbic pina,but		; ?
		rjmp wait_t			; 50   
		dec temp			;  .
		brne wait_b1
unhold1:sbis pina,but		; 
		rjmp unhold1
		lds dataEE,RAM_con1	;  
		inc dataEE			; +1
		cpi dataEE,71		;   60?
		brne okey			;,  
		ldi dataEE,30		; 60,  =40
okey:	ldi temp,adr_con1
		mov adrEE,temp
		rcall EEwrite		;   EEPROM
		clr temp
		out tccr0,temp		; 
		rcall sh_con1		; 		
		ldi temp,(1<<cs00)+(1<<cs01);  =/64
		out tccr0,temp		;  t0
		ldi count,220		; 
		clr temp			;  
		out tcnt0,temp
wait_t:	in temp,tifr		;  
		sbrs temp,1
		rjmp wait_t			;  , ...
		ldi temp,(1<<tov0)	;, ,   
		out tifr,temp
		dec count			;. 
		brne wait_b1		;  0?  . 
gomain:	rcall show_stored	;!."StorEd"
		rcall delay1
		rcall delay1
		
		ret					;    
;--------------------------------------------
t0ovf:	push temp
		push temp1
		ldi temp,1
		add tmr_h1,temp
		clr temp
		adc tmr_h2,temp
		cpi r21,con_sh		;  con_sh?
		brne noshrt			; 
		lds temp,flags		;,  !
		ori temp, 0b00001000;set flag "short"
		sts flags,temp
		rjmp shrt
noshrt:	lds temp,flags		; 
		andi temp,0b11110111;clear flag "short"
		sts flags,temp
shrt:	pop temp1
		pop temp			;(tmr_h1-tmr_h2-tcnt0)-3bytes data
		reti
;********************************************************	
measure:ldi xl,$60
		ldi temp,12			;10-0.2V  
		out ocr1b,temp
me1:	rcall meas1			; t1
		lds temp,flags		; "short"
		sbrs temp,short
		rjmp gonext			; , .  
		rcall show_short	;!  "-short-"
		lds temp,flags
		andi temp,0b11110111
		sts flags,temp
		rjmp me1			; ,    
gonext:	ldi temp,24			;20-0.4V  
		out ocr1b,temp
		rcall meas1			; t2
		ret
;----      8 -
meas1:	clr r19
		clr r20
		clr r18
		ldi r28,4			;r29-counter
ms:		clr temp
		out tcnt0,temp
		clr tmr_h2
		clr tmr_h1
		sbi porta,disch 	;discharge the cap.
		sbi porta,ch		;current off
		rcall delay			;delay for discharge completely
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay			;delay for discharge completely
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay	
		rcall delay
		rcall delay	
		rcall delay			;delay for discharge completely
		rcall delay	
	;	sbi porta,ch		;current off
		ldi temp,(1<<toie0)
		out timsk,temp		;.  t0
		cbi porta,ch		;begin to charge
		clr temp
		out acsr,temp		;..
		sei					; 
		cbi porta,disch		; 
		ldi temp,(1<<cs00)	;  =
		out tccr0,temp		; t0
		clr temp
wait:	sbic acsr,aco
		rjmp goout
		lds temp,flags		;  "short"
		sbrc temp,short		;      3 
		rjmp goout			;       
		rjmp wait			;  -
goout:	cli					; 
		clr temp
		out tccr0,temp		;T0 STOP!
		ldi temp,(1<<acd)	;.(U(in0)>U(in1))
		out acsr,temp		; -.
;-------  t1  ---------
		in r23,tcnt0
		mov r24,tmr_h1
		mov r25,tmr_h2
;-----------------  4 ------
		rcall ad2_3			; r20-r19-r18->
		dec r28
		brne ms
		ldi r28,2
shft:	lsr r20				;   4(2  )
		ror r19
		ror r18
		dec r28
		brne shft
		mov lev1_l,r18		; (r20-r19-r18)->lev1
		mov lev1_m,r19
		mov lev1_h,r20
;-----------------------------------------------
		rcall loadram		;.t ->$60-$61-$62
		clr temp
		out tcnt0,temp
		clr tmr_h2
		clr tmr_h1
		ret
;**************************************************
show_batt:
		ldi temp,(1<<refs1)+(1<<mux0)
		out admux,temp	;ADC1 - on (0...1)
		sbi adcsr,aden	;start convertion
		sbi adcsr,adsc
w:		sbis adcsr,adif	;wait for complete
		rjmp w
		in r20,adcl		;result->r20-r19
		in r19,adch
		mov var10,r20
		mov var11,r19
		sub var13,var13
		sub var12,var12
		ldi temp,68		; u_ind=0.068*adc_data(0...7V)
		mov var20,temp
		sub var21,var21
		sub var22,var22
		sub var23,var23
		rcall mul32u	;u=adc*68
		ldi temp,low(1000)
		mov var20,temp
		ldi temp,high(1000)
		mov var21,temp
		sub var22,var22
		sub var23,var23
		rcall div32u	;u=adc*68/1000 ->in volts!
		mov r20,var10
		mov r19,var11
		rcall bindes		;recalculate ->(r21-r22-r23)
		sts dat2,r21
		sts dat3,r22
		sts dat4,r23
		rcall lcdout		;convert to LCD symbols
		clr temp
		sts dig1,temp
		ldi temp,$3e
		sts dig2,temp
		ldi temp,$77
		sts dig3,temp
		ldi temp,$2e
		sts dig4,temp
		ldi temp,$2e
		sts dig5,temp
		ldi temp,$20
		sts dig6,temp
		lds temp,dig7
		ori temp,$80
		sts dig7,temp
		clr temp
		sts dig9,temp
		rcall outsym		;show "bAtt-x.x" 
		rcall delay1		;yeah, of course!
;		rcall delay1
		ret

loadram:clr xh				;  
		st x+,lev1_h		;   
		st x+,lev1_m
		st x+,lev1_l
		ret
;**************************************************
gosleep:
		ldi zl,low(_sleep*2)
		ldi zh,high(_sleep*2)
		rcall show
		rcall delay1
		rcall blank
		cbi porta,pow		; 
		ret
;-- =con1*(t2-t1)/100 con1=40...60------
solve_c:ldi xl,$60
		clr xh
		ld r24,x+		
		ld r23,x+
		ld r22,x+			;here t1(r24-r23-r22)
;--------------------------------------------
		ld r21,x+		
		ld r20,x+
		ld r19,x+			;here t2(r21-r20-r19)
;--------------------------------------------
		rcall su2_3			;  (t2-t1)
		brcc good			;() ? (  <0?) 
		clr r21				;<0,  =0
		clr r20
		ldi r19,1			; =0, =1(    0!)
good:	st x+,r21
		st x+,r20
		st x+,r19			;(t2-t1)->$66-$67-$68
		clr var13		
		mov var12,r21
		mov var11,r20
		mov var10,r19
		lds r23,RAM_con1	;   con1
		ldi r22,0
		clr var23
		clr var22
		mov var21,r22
		mov var20,r23
		rcall mul32u		;r3-r4-r5-r6-r7-r8-r9-r10<-(t2-t1)*con1
		ldi temp,low(con2)
		mov var20,temp
		ldi temp,high(con2)	;con2=100
		mov var21,temp
		sub var22,var22
		sub var23,var23
		rcall div32u		;(t2-t1)*con1/100=C(mkF/100)
		rcall loadram		;store ->($69-$6a-$6b)
		ret
;******************************************************
solve_e:ldi xl,$60			;((t2-2*t1)*10000/con1)/(t2-t1)=ESR(ohms/100)
		clr xh
		ld r24,x+		
		ld r23,x+
		ld r22,x+			;here t1(r24-r23-r22)
		ldi xl,$66
		ld r21,x+		
		ld r20,x+
		ld r19,x+			;here t2-t1(r21-r20-r19)
		rcall su2_3			;  (t2-t1)-t1==t2-2*t1
		brcc good1			; ? (  <0?) 
		clr r21				;<0,  =0
		clr r20
		clr r19
good1:	clr var13			                    
		mov var12,r21
		mov var11,r20
		mov var10,r19
		ldi r22,$01			;10000=(01 86 a0)h 
		ldi r23,$86			;..ESR   
		ldi r24,$a0
		clr var23
		mov var22,r22
		mov var21,r23
		mov var20,r24
		rcall mul32u		;r3-r4-r5-r6-r7-r8-r9-r10<-(t2-2*t1)*10000			
		lds temp,RAM_con1	;low(con1)
		mov var20,temp
		ldi temp,0			;high(con1)=0
		mov var21,temp
		sub var22,var22
		sub var23,var23
		rcall div32u		;(t2-2*t1)*con2/con1=ESR(ohms)
		sub var23,var23		;var23=0
		ldi xl,$66
		ld var22,x+		
		ld var21,x+
		ld var20,x+			;here t2-t1(r22-r21-r20)
		rcall div32u		;and calculate ESR
		ldi xl,$6c
		st x+,var12
		st x+,var11
		st x+,var10			;ESR->$6c-$6d-$6e
		ret
;----------------------------------------------
datamove:	;build ->dat1-dat2-dat3-dat4-dat5
			;        (0x) (yx) (yx) (y0) (00)
			;         |-r21--r22--r23-|
		mov temp,r21		;xxxxyyyy
		swap temp
		andi temp,$0f
		sts dat1,temp		;dat1->(0000xxxx(r21))
		mov temp,r21		;xxxxyyyy
		swap temp			;yyyyxxxx
		andi temp,$f0		;temp->yyyy0000
		mov r21,temp		;r21->yyyy0000
		mov temp,r22
		swap temp			;temp->yyyyxxxx(r22)
		andi temp,$0f		;temp->0000xxxx(r22)
		or temp,r21			;temp->yyyy(r21)xxxx(r22)
		sts dat2,temp		;dat2->(yyyy(r21)xxxx(r22))
		mov temp,r22		;temp->xxxxyyyy(r22)
		swap temp
		andi temp,$f0		;temp->yyyy0000(r22)
		mov r22,r23			;r22->xxxxyyyy(r23)
		swap r22			;r22->yyyyxxxx(r23)
		andi r22,$0f		;r22->0000xxxx(r23)
		or temp,r22			;temp->yyyy(r22)xxxx(r23)
		sts dat3,temp		;dat3->yyyy(r22)xxxx(r23)
		swap r23			;r23->yyyyxxxx(r23)
		andi r23,$f0		;r23->yyyy0000(r23)
		sts dat4,r23		;dat4->yyyy0000(r23)
		ret
;---------deleting unsignificant zeroes---------	
zeroes:	ldi temp1,4			;temp1-counter
		ldi xl,dig2			;x->pointer to dats
		clr xh
getnext:ld temp,x			;temp<-dat(n)
		cpi temp,$5f		;if it "0"?
		brne getd3
		clr temp			;yes,then blanking
		st x+,temp	
		dec temp1
		brne getnext
getd3:	ret
;------------ -------------------
show_c:	lds temp,$69		;   
		cpi temp,1
		brlo c_good			; >6553.5, 
		rcall show_gt6		; "  ---   "
		rcall delay1
		rjmp end
c_good:	clr xh
		ldi xl,$6a			;read C($6a-$6b- )
		ld r19,x+
		ld r20,x
		rcall bindes		;resolve ->(r21-r22-r23)
		rcall datamove		;  co 2  
		rcall lcdout		;convert to LCD symbols
		rcall zeroes		;  
		ldi temp,$0f		;"C"->dig1
		sts dig1,temp
		lds temp,dig6		; 0b1xxxxxxx - c !
		ori temp,$80		;dec point like C00000.0uF
		sts dig6,temp		;    (dig6 with point)
		ldi temp,$27		;dig9 - "F"
		sts dig9,temp
		ldi temp,$1C		;dig8 - "u"(mju)
		sts dig8,temp
		rcall outsym		;show  like"C.xxxxx.x uF"
		rcall delay1		;yeah, of course!
		rcall delay1
end:	ret
;------------ ESR-----------------------
show_e:	clr xh
		ldi xl,$6d			;read esr($6d-$6e- )
		ld r19,x+
		ld r20,x
		cpi r19,8			;.>8?(esr>20.48?)
		brlo show_en		; >20,  ---
		rcall show_esr_ovl	; "ESr --- "
		lds temp,poff		;  .
		dec temp
		sts poff,temp		;    
		rjmp esrmore		;  
show_en:rcall bindes		;resolve ->(r21-r22-r23)
		rcall datamove		;  co 2 
		rcall lcdout		;convert to LCD symbols
		ldi temp,$2f		;"E"->dig1
		sts dig1,temp
		ldi temp,$3b		;"S"
		sts dig2,temp
		ldi temp,$24
		sts dig3,temp		;"r"
		lds temp,dig4
		cpi temp,$5f		; 4   0
		brne nozero			; , 
		clr temp
		sts dig4,temp		;if dig4 "0" - blank it!
nozero:	lds temp,dig5		; 0b1xxxxxxx - c !
		ori temp,$80		;dec point like "Esr00.00oh"
		sts dig5,temp		;    (dig5 with point)
		ldi temp,$3c		;dig8 - "o"
		sts dig8,temp
		ldi temp,$36		;dig9 - "h"(mju)
		sts dig9,temp
		rcall outsym		;show ESR like"Esrxx.xxoh"
		rcall delay1		;yeah, of course!
		ldi temp,off_time
		sts poff,temp		; . ..
esrmore:ret
;--------------------------------------------------
sh_con1:ldi temp,adr_con1
		mov adrEE,temp
		rcall EEread
		sts RAM_con1,dataEE	; con1  
		clr xh
		ldi temp,RAM_con1
		mov xl,temp
		clr r19
		ld r20,x
		rcall bindes		;recalculate ->(r21-r22-r23)
		sts dat4,r23
		rcall lcdout		;convert to LCD symbols
		ldi temp,$0f		;"C"->dig1
		sts dig1,temp
		ldi temp,$3c		;"O"
		sts dig2,temp
		ldi temp,$34		;"n"
		sts dig3,temp
		ldi temp,$3b		;"S"
		sts dig4,temp
		ldi temp,$2e		;"t"
		sts dig5,temp
		ldi temp,$20		;"-"
		sts dig6,temp
		clr temp
		sts dig9,temp
		rcall outsym		;show "COnSt-xx "
		ret
;-----    --------------
change_fl:
		lds temp,flags
		sbrc temp,c_only	;if not c_only
		rjmp set_e			; ,   
		sbrc temp,e_only
		rjmp set_a			; ,  AUTO
		sbrc temp,auto
		rjmp set_c			; -,  
		rjmp mode_over		; 
set_c:	ldi temp,(1<<c_only)
		sts flags,temp
		rcall show__c
		rjmp mode_over
set_e:	ldi temp,(1<<e_only)
		sts flags,temp
		rcall show_esr
		rjmp mode_over
set_a:	ldi temp,(1<<auto)
		sts flags,temp
		rcall show_c_esr
mode_over:
		lds dataEE,flags
		ldi adrEE,fl_ee
		rcall EEwrite
		ret
;-------------------------------------------

;------------------------------------------------------
;--------clear LCD-----
blank:	ldi temp1,9
		ldi zl,dig1
		ldi zh,$00
kkk:	clr temp
		st z+,temp
		dec temp1
		brne kkk 
		rcall outsym
		ret

hello:	ldi zl,low(_hello*2)
		ldi zh,high(_hello*2)
		rcall show
		ret
show_esr:
		ldi zl,low(_esr*2)
		ldi zh,high(_esr*2)
		rcall show
		ret
show__c:ldi zl,low(_c*2)
		ldi zh,high(_c*2)
		rcall show
		ret
show_c_esr:
		ldi zl,low(_c_esr*2)
		ldi zh,high(_c_esr*2)
		rcall show
		ret
show_short:
		ldi zl,low(_short*2)
		ldi zh,high(_short*2)
		rcall show
		ret
show_const:
		ldi zl,low(_con1*2)
		ldi zh,high(_con1*2)
		rcall show
		ret
show_esr_ovl:
		ldi zl,low(_e_ovl*2)
		ldi zh,high(_e_ovl*2)
		rcall show
		ret
show_stored:
		ldi zl,low(_stor*2)
		ldi zh,high(_stor*2)
		rcall show
		ret
show_gt6:
		ldi zl,low(_gt6*2)
		ldi zh,high(_gt6*2)
		rcall show
		ret
;-----------------------------------------
_hello: .db $20,$20,$76,$2f,$0e,$0e,$5f,$20,$20
;                -   -   E   S   r   -   -    
_esr:	.db $00,$20,$20,$2f,$3b,$24,$20,$20,$00
;                        -   C   -   
_c:		.db $00,$00,$00,$20,$0f,$20,$00,$00,$00
;                -   C   -   E   S   r   -
_c_esr:	.db $00,$20,$0f,$20,$2f,$3b,$24,$20,$00
;                -   S   H   O   R   T   -
_short:	.db $00,$20,$3b,$36,$3c,$24,$2e,$20,$00
;	         S   E   t       C   o   n   S   t
_con1:	.db $3b,$2f,$2e,$00,$0f,$3c,$34,$3b,$2e
;            E   S   r       -   -   -      
_e_ovl:	.db $2f,$3b,$24,$00,$20,$20,$20,$00,$00 
;                S   t   o   r   E   d
_stor:	.db $00,$3b,$2e,$3c,$24,$2f,$7c,$00,$00
;            C               -   -   -
_gt6:	.db $0f,$00,$00,$00,$20,$20,$20,$00,$00	
;
_sleep:	.db $20,$20,$3b,$0e,$2f,$2f,$67,$20,$20
;------     Z------
show:	ldi temp1,9
		ldi xl,dig1;dig1- 1 
		clr xh
kk1:	lpm
		st x+,r0
		inc zl
		dec temp1
		brne kk1 
		rcall outsym
		rcall delay1
		ret
EEwrite:	cli
			sbic eecr,eewe;used r20(dataEE),r25(adrEE)
			rjmp EEwrite
			out eear,adrEE
			out eedr,dataEE
			sbi eecr,eemwe
			sbi eecr,eewe
			sei			
			ret
;------------------------------------------------------
EEread:		sbic eecr,eewe;used r20(dataEE),r25(adrEE)
			rjmp EEread
			out eear,adrEE
			sbi eecr,eere
			in dataEE,eedr
			ret
;-----------------------------------------------			
delay:	ldi temp,10
_dd4:	ldi temp1,$ff
_dd3:	dec temp1
		brne _dd3
		dec temp
		brne _dd4
		ret
;----------------------------------------
delay1: ldi count,70
dd5:	rcall delay
		dec count
		brne dd5
		ret

;--------------------------------------------------:
; 32bit/32bit Unsigned Division
;
; Register Variables
;  Call:  var1[3:0] = dividend (0x00000000..0xffffffff)
;         var2[3:0] = divisor (0x00000001..0x7fffffff)
;         mod[3:0]  = <don't care>
;         lc        = <don't care> (high register must be allocated)
;
;  Result:var1[3:0] = var1[3:0] / var2[3:0]
;         var2[3:0] = <not changed>
;         mod[3:0]  = var1[3:0] % var2[3:0]
;         lc        = 0
;
; Size  = 26 words
; Clock = 549..677 cycles (+ret)
; Stack = 0 bytes


div32u:	clr	mod0		;initialize variables
		clr	mod1		;  mod = 0;
		clr	mod2		;  lc = 32;
		clr	mod3		;
		ldi	temp,32		;/
					;---- calcurating loop
		lsl	var10		;var1 = var1 << 1;
		rol	var11		;
		rol	var12		;
		rol	var13		;/
		rol	mod0		;mod = mod << 1 + carry;
		rol	mod1		;
		rol	mod2		;
		rol	mod3		;/
		cp	mod0,var20	;if (mod => var2) {
		cpc	mod1,var21	; mod -= var2; var1++;
		cpc	mod2,var22	; }
		cpc	mod3,var23	;
		brcs	PC+6	;
		inc	var10		;
		sub	mod0,var20	;
		sbc	mod1,var21	;
		sbc	mod2,var22	;
		sbc	mod3,var23	;/
		dec	temp		;if (--lc > 0)
		brne	PC-19	; continue loop;
		ret
;---------------------------------------
mul32u:	sub	var17,var17	;initialize variables
		sub	var16,var16	;
		sub	var15,var15	;
		sub	var14,var14	;
		ldi	temp,33		; 
		brcc	PC+5	;
		add	var14,var20	;
		adc	var15,var21	;
		adc	var16,var22	;
		adc	var17,var23	;
		ror	var17		;
		ror	var16		;
		ror	var15		;
		ror	var14		;
		ror	var13		;
		ror	var12		;
		ror	var11		;
		ror	var10		;
		dec	temp		;if (temp > 0)
		brne	PC-14	; continue loop;
		ret	
;addition 2 3-bytes numbers(don't see at carry)--|
	;                                            | 
	; r20-r19-r18 -the first one             |
	;+                                           |
	; r25-r24-r23 -the second one            |
	; ----------------                           |
	;=r20-r19-r18 -result                    |
ad2_3:	clc        ;                             |
		add r18,r23;                             |
		adc r19,r24;                             |
		adc r20,r25;                             |
		clc        ;                             |
		ret        ;                             |
;------------------------------------------------
;----substraction 2 3-bytes numbers--------------
;     r21-r20-r19                                       
; -                                              
;     r24-r23-r22                                       
;   ------------                                
; =   r21-r20-r19                                       
su2_3:	clc                                     
		sbc r19,r22                             
		sbc r20,r23                             
		sbc r21,r24
		ret                                     
;******Convert BIN->BIN/DEC*********************
;used (r9,r10,r16,r17,r18,r19,r20,r21,r22,r23)
;in->          binh-binl(r19-r20)
;out-> d3-d2-d1(dec)(r21-r22-r23)
bindes:	ldi temp,low(10000)
		ldi temp1,high(10000)
		rcall digit
		mov d3,count
		ldi temp,low(1000)
		ldi temp1,high(1000)
		rcall digit
		mov d2,count
		swap d2
		ldi temp,low(100)
		ldi temp1,high(100)
		rcall digit
		mov d1,count
		or d2,d1
		ldi temp,low(10)
		ldi temp1,high(10)
		rcall digit
		mov d1,count
		swap d1
		or d1,binl
		ret
digit:  ldi count,-1
digit1: inc count
		sub binl,temp
		sbc binh,temp1
		brsh digit1
		add binl,temp
		adc binh,temp1
		ret
;--------   dig1...dig9-----
; are used r16,r17,r18,r24,r26,r27
outsym:	ldi count,9
		ldi xl,dig1	;  dig1
		clr xh
k2:		ld temp,x+
		rcall outlcd; 1 (.)
		dec count   ;   9(dig9)
		brne k2
		sbi portb,load;  
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		cbi portb,load
		ret
;---------  (r16,r17,r24)-------------
outlcd:	ldi temp1,8
out_sym:lsr temp ;    temp     							 
		brcs n1      							 
		cbi portb,din
		rjmp m1      							 
n1:		sbi portb,din
m1:		sbi portb,dclk
		nop
		nop
		nop
		cbi portb,dclk						     
		dec temp1
		brne out_sym
		ret
;----------->  ----------------
LCDout:	ldi count,5;  12-34-56-78-90-ff-ff-ff-ff
		lds temp,dat5
		andi temp,$f0
		swap temp
		sts dat9,temp
		ldi yl,dat9;Y-pointer dataout
		ldi zl,dat5;Z-pointer datain
		clr zh
		clr yh
k3:		ld temp,-z
		andi temp,$0f
		st -y,temp
		ld temp,z
		andi temp,$f0
		swap temp
		st -y,temp
		dec count
		brne k3;    01-02-03-04-05-06-07-08-09
		ldi count1,9; 
		ldi xl,dig1;, .   .
		clr xh     ;X-  .
		clr yh
		ldi yl,dat1;take 1st data Y-  .
k6:		ldi zl,low(sym_tab*2-1);Z-   
		ldi zh,high(sym_tab*2)
		ldi count,11;10   0  9
		ld temp,y+
		ldi temp1,-1
k4:		dec count
		inc temp1
		cpi count,0
		breq k5
		adiw zl,1
		cp temp,temp1
		brne k4
k5:		lpm
		st x+,r0
		dec count1
		brne k6
		ret
;---------- -------------------------
sym_tab: .db $5f,$50,$6d,$79,$72,$3b,$3f,$51,$7f,$7b,$77,$3e,$0f,$7c,$2f,$27
;             0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
; HELLO
;                    H   E   L   L   O
	