// Title:  BiDiPro DLL module
// Desc:   Flash 29F (p)
// Ver:    0.991
// Found:  01-04-2000
// Last:   08-01-2002
// CPU:    386+
// Model:  Tiny
// Compil: Borland C++ 3.1 (DOS)
// Author: Konstantin Samoylov, Alex Plusov

// Based on Atmel datasheets

#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include "..\dlldata.h"
#include "..\errors.h"
#include "..\bidi.h"

//#define CMDLINE

#ifndef CMDLINE
 #define dlp ((DLLDATA *) NULL)        /* ⥫    */
#else
 extern DLLDATA far * dlp;
#endif //CMDLINE

#define bdport dlp->bdprt            /* 㪠⥫  hardware ࠩ */

//롮  
#define adrbyte(bn) *((byte*)&adr+bn)
// 29F040 A18 ᤢ  A19:
#define adrbyte2    ( (adrbyte(2)&0x3) | ((adrbyte(2)<<1)&0x8) )

#define DataPortIn()  bdport(PFORCE|PWR1|PBIN)
#define DataPortOut() bdport(PFORCE|PWR1)

struct  CHDEFS
{
   dword size;   // 
   byte  dpins;  //   dip 
   byte  rA2;    // ॣ  ⥭ //WE=1,CE=0,OE=0
   byte  rC1;    // use only for 256
   byte  rwB2;   // 殮
   byte  wC1h;   // :
   byte  wC1l;   //
   byte  wA2h;   // WE=1,CE=1,OE=1
   byte  wA2l;   // WE=0,CE=0,OE=1
};

CHDEFS chd[]={
//   size    pins  rA2   rC1  rwB2  wC1h  wC1l  wA2h  wA2l
  {0x008000L, 28, 0x80, 0x80, 0x42, 0x80, 0x00, 0x70, 0x60},  //256
  {0x010000L, 32, 0x8F, 0x00, 0x81, 0x00, 0x00, 0x7F, 0x68},  //512
  {0x020000L, 32, 0x8E, 0x00, 0x81, 0x00, 0x00, 0x7E, 0x68},  //010
  {0x040000L, 32, 0x8C, 0x00, 0x81, 0x00, 0x00, 0x7C, 0x68},  //020
  {0x080000L, 32, 0x84, 0x00, 0x81, 0x00, 0x00, 0x74, 0x60},  //040
};

// ७   CFG:
static struct CFGKEY cfgkeys[]={
{'D', "Vccp",  50,50},   //殮 ⠭  ணࠬ஢  0
{'D', "Vccv",  50,50},   //殮 ⠭  䨪樨       1
{'D', "MaxWT", 100,100},   //max ⥫쭮 ppp        2
{'D', "ErTime",10000000,10000000},  //p 横 p          3
{'H', "Adr1",  0x05555,0x05555},  //                                4
{'H', "Adr2",  0x02AAA,0x02AAA},  //                                5
//{'D', "DataP", 1, 1},             //Data Polling mode?              6
//{'D', "Reset",0,0},      //reset on/off                             7
{0,    NULL,   0,0},     //End of table
};

#define cfg_Vccp   cfgkeys[0].data
#define cfg_Vccv   cfgkeys[1].data
#define cfg_MaxWT  cfgkeys[2].data
#define cfg_ETime  cfgkeys[3].data
#define cfg_Adr1   cfgkeys[4].data
#define cfg_Adr2   cfgkeys[5].data
//#define cfg_Reset  cfgkeys[6].data

static char* copyright="29F module (c) Konstantin Samoylov, Alex Plusov ["__DATE__"]";
static word chtype=0xFFFF;           //  ROM
static CHDEFS * pchd;

#define power_off breset

void breset (void)
{
   bdport (PRST);
}

void write_code (word adr,byte dat)
{
// 1  :
     bdport (PWA1 | adrbyte(0) );
// 2  :
     bdport (PWA2 | pchd->wA2h);
     bdport (PWC1 | adrbyte(1) | pchd->wC1h);
// 3    ᨣ CE, OE, WE:
     bdport (PWC1 | adrbyte(1) | pchd->wC1l);
     bdport (PWA2 | pchd->wA2l);
     bdport (PWB1 | dat);   // 
     bdport (PWA2 | pchd->wA2h);
     bdport (PWC1 | adrbyte(1) | pchd->wC1h);
}

int power_on (byte mode)
{
   word vmask=pchd->rwB2;

   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   if (mode=='R')
    {
     DataPortIn();              // DD1:OIO
     bdport (PFORCE|PWR2);      // DD4:OOO
     bdport (PWA2 | pchd->rA2); //ce,oe,pe
//⠭ 殮
     dlp->voltage (dlp->Vcc,dlp->Vpp,140);
     bdport (PWB2 | (vmask & 0xE0) ); //Vcc pins
    }
   else //'W' or other
    {
     bdport (PFORCE|PWR2);       // DD4:OOO
     bdport (PWA2 | pchd->wA2h); //ce,oe,pe
     DataPortOut();              // DD1:OOO
//⠭ 殮
     if ( (dlp->Vpp==0) || (mode!='W') ) vmask&=0xE0; //Vpp disable
     if ( (dlp->Vid>0)  && (mode=='I') ) vmask|=0x10; //Vid enable
     dlp->voltage (dlp->Vcc,dlp->Vpp,dlp->Vid);
     bdport (PWB2 | vmask ); //Vcc,Vpp on
    }
   dlp->mcsdelay(100000);
/*   switch (cfg_Reset)
    {
     case 1:
       write_code(0,0xF0);
       dlp->mcsdelay(2);
       break;
     case 2:
       bdport (PWA2 | (pchd->wA2h & 0xF7)); //reset=0 (A18)
       dlp->mcsdelay(2);
       bdport (PWA2 | pchd->wA2h);          //reset=1 (A18)
       dlp->mcsdelay(2);
       break;
     default: break;
    }*/
   return 0;
}

// ⥭ 
inline byte read_one (dword adr)
{
     byte db;
// 1  :
     bdport (PWA1 | adrbyte(0) );
// 2  :
     bdport (PWC1 | adrbyte(1) | pchd->rC1);
// 3    ᨣ CE, OE, WE:
     bdport (PWA2 | adrbyte2 | pchd->rA2);
// DATA
     db=(byte) bdport(PRB1);
     bdport (PWA2 | adrbyte2 | (pchd->wA2h & 0x3F));
     return db;
}

// 
void write_one (dword adr,byte dat)
{
// 1  :
     bdport (PWA1 | adrbyte(0) );
// 2  :
     bdport (PWC1 | adrbyte(1) | pchd->wC1h);
// 3    ᨣ CE, OE, WE:
     bdport (PWA2 | adrbyte2   | pchd->wA2h);  //।⥫쭠 ⠭ adr2!!!
     bdport (PWC1 | adrbyte(1) | pchd->wC1l);
     bdport (PWA2 | adrbyte2   | pchd->wA2l);  //CE=0,WE=0,OE=1
     bdport (PWB1 | dat);   // 
     bdport (PWC1 | adrbyte(1) | pchd->wC1h);
     bdport (PWA2 | adrbyte2   | pchd->wA2h);  //CE=1,WE=1,OE=1
}

int read_all (void)
{
   dword adr;
   dword istep=pchd->size/64L;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   power_on('R');
   for (adr=0;adr<pchd->size;adr++)
    {
      dlp->setbytebuf (adr,read_one(adr));
      if (adr%istep == 0)
       if (dlp->iprogress(adr,2)) break;
    }
   power_off();
   return 0;
}

int write_all (void)
{
   dword adr;
   dword istep=pchd->size/64L;
   byte  db,t;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   power_on('W');
   for (adr=0; adr < pchd->size; adr++)
    {
      DataPortOut();
      //⮢ 
      disable();      // 뢠  ६  ࠭
      db=dlp->getbytebuf(adr);
      write_code(cfg_Adr1,0xAA);
      write_code(cfg_Adr2,0x55);
      write_code(cfg_Adr1,0xA0);
      write_one(adr,db);
      enable();
      dlp->mcsdelay(2);
      DataPortIn();
      for (t=0;t<cfg_MaxWT;t++)
       {
         dlp->mcsdelay(1);
         if ((read_one(adr)&0x80) == (db&0x80))
          break; //right data
       }
      if (read_one(adr)!=db) //compare error?
       {
         dlp->adr=adr;
         (byte) dlp->edata=tdr;
         power_off();
         return ERC_WRITE;
       }
      if ((adr+1)%istep == 0)
       if (dlp->iprogress(adr,2)) break;
    }
   power_off();
   return 0;
}

int erase (void)
{
#define DISCRETE cfg_ETime/32

   dword i;
   byte tdr;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   dlp->iprogress(DISCRETE,0); //init
   power_on('W');
   disable();
   write_code(cfg_Adr1,0x0AA);
   write_code(cfg_Adr2,0x055);
   write_code(cfg_Adr1,0x080);
   write_code(cfg_Adr1,0x0AA);
   write_code(cfg_Adr2,0x055);
   write_code(cfg_Adr1,0x010);
   enable();
   DataPortIn();
   for (i=1;i<=cfg_ETime;i++)
    {
      dlp->mcsdelay(1);
      tdr=read_one(pchd->size-1);
      if (tdr & 0x80) break; //right data
      if (!(cfg_ETime % DISCRETE)) if (dlp->iprogress(i,2)) break;
    }
   power_off();
   dlp->iprogress(0,1); //close
   if (!tdr) return ERC_BLANK;
   return 0;
}

// Product Identification:
inline int read_id(void)
{
   dword id1,id2;
   dlp->edata=0;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;

   power_on('I');

   if (dlp->Vid<120)  //Intelligent ID (software)
    {
     disable();      // 뢠  ६ . ०. ⥭ ID
     write_code(cfg_Adr1,0x0AA);
     write_code(cfg_Adr2,0x055);
     write_code(cfg_Adr1,0x090);
     enable();
     dlp->mcsdelay(10);
    }
   DataPortIn();               // DD1:OIO
   if (dlp->Vid>=120)          //Hardware ID
    {
      bdport (PWA2 | pchd->rA2 | 0x40); //PE ON
      dlp->mcsdelay(10);
    }
   else
    bdport (PWA2 | pchd->rA2 );//PE Off
   bdport (PWA1 | 0 );         // 1   = 0
   bdport (PWC1 | pchd->rC1);  // 2  
// 
   id1= (byte) bdport(PRB1);
   bdport (PWA1 | 1 );         // 1   = 1
// 
   id2= (byte) bdport(PRB1);
   dlp->edata = id1 | (id2<<16L);
   power_off();
   return 0;
}

// ⠢  ஬
int compare_all(void)
{
   dword adr;
   dword errors=0;
   dword istep=pchd->size/64L;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   power_on('R');
   for (adr=0;adr<pchd->size;adr++)
    {
      if (dlp->getbytebuf(adr) != read_one(adr) ) //ࠢ  ஬
       {
         dlp->setbmark(adr,1);  //⬥ ᮢ
         errors++;
       }
      if (adr%istep == 0)
       {
         if (dlp->iprogress(adr,2)) break;
       }
    }
   power_off();
   dlp->edata=errors;
   return 0;
}

int blank_chk(void)
{
   dword adr;
   dword istep=pchd->size/64L;
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
   power_on('R');
   for (adr=0;adr<pchd->size;adr++)
    {
      if (read_one(adr) != 0xFF ) //ࠢ  FF
       {
         dlp->adr=adr;
         power_off();
         return 1;
        }
       if (adr%istep == 0)
        if (dlp->iprogress(adr,2)) break;
    }
   power_off();
   return 0;
}

int test(void)
{
   return 0;
}

int _lock(void)
{
   if (chtype == 0xFFFF) return ERC_CHIPUNSP;
//   dlp->iprogress(DISCRETE,0); //init
   power_on('W');
   disable();
   write_code(cfg_Adr1,0x0AA);
   write_code(cfg_Adr2,0x055);
   write_code(cfg_Adr1,0x080);
   write_code(cfg_Adr1,0x0AA);
   write_code(cfg_Adr2,0x055);
   write_code(cfg_Adr1,0x040);
   enable();
   dlp->mcsdelay(1000000); // at49f002
   power_off();
   return 0;
}

int _unlock(void)
{
   return 0;
}

// ⠭ ⨯ ROM
word settype (void)
{
   for (word i=0;i<sizeof(chd)/sizeof(CHDEFS);i++)
    {
      if (chd[i].size == dlp->esize)
       return chtype=i;
    }
   return chtype=0xFFFF;
}

// main code
extern "C" int dmain(void)
{
   switch (dlp->funcode)
    {
      case DFN_LOAD:
// ⨢஢ 㯭 㭪樨:
       dlp->funmask[DFN_FREAD]=1;
       dlp->funmask[DFN_FWRITE]=1;
       dlp->funmask[DFN_READID]=1;
       dlp->funmask[DFN_ERASE]=1;
       dlp->funmask[DFN_FCOMPARE]=1;
       dlp->funmask[DFN_FBLANK]=1;
//       dlp->funmask[DFN_TEST]=1;
       dlp->funmask[DFN_LOCK]=1;
//       dlp->funmask[DFN_UNLOCK]=1;
       dlp->defstate=0xFF;
       dlp->copyright=copyright;
       dlp->version=DLLVERSION;
       dlp->cfgkeys=cfgkeys;
       return 0;
      case DFN_INIT:
       if (settype() == 0xFFFF) return ERC_CHIPUNSP;
       pchd=&chd[chtype];
       dlp->dippins=pchd->dpins;
       return 0;

      case DFN_FREAD:
       return read_all();

      case DFN_FWRITE:
       return write_all();

      case DFN_FCOMPARE:
       return compare_all();

      case DFN_FBLANK:
       return blank_chk();

      case DFN_READID:
       return read_id();

      case DFN_ERASE:
       return erase();

      case DFN_TEST:
       return test();

      case DFN_LOCK:
       return _lock();

      case DFN_UNLOCK:
       return _unlock();

      default:
       return ERC_FUNUNSP;
    }
}
