/*
 * config.h
 *
 *  Created on: Mar 4, 2012
 *      Author: qwer1
 */

#ifndef CONFIG_H_
#define CONFIG_H_

#include "adc.h"
#include "process.h"
#include "pt.h"
#include "ul_ptx.h"

#define CONFIG_PAGE_SIZE       1024
#define CONFIG_PAGES           16
#define CONFIG_START_ADDR      (0x08000000UL + ((CONFIG_PAGES - 1) * CONFIG_PAGE_SIZE))

//delay before config write (ms)
#define CONFIG_UPDATE_DELAY  10000

//number of extended configuration parameters
#define CONFIG_PARAMS_NUM (T_TC_NUM + 1 + (5 * T_TC_NUM))

struct config_pid_struct {
	S16 kp;
	S16 ki;
	S16 kd;
	S16 ni;
	S16 nd;
};

struct config_struct {
	U8 current_program; //number of current program
	U8 current_step;    //number of current step
	
	//extended configuration parameters
	union {
		S16 params[CONFIG_PARAMS_NUM];
		struct {
			S16 t_tc_corr[T_TC_NUM];
			S16 t_cold_corr;
			struct config_pid_struct pid_c[T_TC_NUM];
		};
	};
	
	//profiles parameters
	struct program_step_struct programs[PROGRAMS_NUM][PROGRAM_STEPS_NUM];

	U16 crc; //CRC
};

//parameter description structure
struct param_info_struct {
	char *name;  //displayed name
	S16 min;     //minimum
	S16 max;     //maximum
	S16 def;     //default
	U8  options; //indication  options (size, point, bcd, zeroes)
};

//parameters descriptors
extern const struct param_info_struct params_info[CONFIG_PARAMS_NUM];

//number of current parameter
extern U8 param_num;

void config_data_init(void);
void config_data_copy(void);
void setup_config1(void);

#include "ul_config.h"

#endif /* CONFIG_H_ */
