/*
 * heaters.h
 *
 *  Created on: Mar 11, 2012
 *      Author: qwer1
 */

#ifndef HEATERS_H_
#define HEATERS_H_

#include "pt.h"
#include "ul_ptx.h"

//number of connected heaters
#define HEATERS 4

//heaters PWM period ticks
#define HEATERS_PWM_TICKS 200

//heaters PWM values
extern U8 heaters_pwm_set[T_TC_NUM];
//heaters PWM counter
extern U8 heaters_pwm_cnt;

//checks if heater N enabled
U8 heater_enabled(U8 n);

//initialize heaters ports and states
void setup_heaters(void);

//set heater n (0..3) to state 0 (off) / 1 (on)
void heater_set(U8 n, U8 state);

//set all heaters to state
void heaters_set(U8 state);

//heaters control thread
PT_THREAD( pt_heaters( struct pt *pt, struct ptx *ptx ) );

#endif /* HEATERS_H_ */

