/*
 * ind.h
 *
 *  Created on: Oct 10, 2011
 *      Author: qwer1
 */

#ifndef IND_H_
#define IND_H_

//LCD
#define LCD_WIRES 6
#define LCD_COLS  16
#define LCD_ROWS  4

#define lcd_d4(level) *BITP(&GPIOB->ODR, 4)  = ((level) != 0)
#define lcd_d5(level) *BITP(&GPIOB->ODR, 3)  = ((level) != 0)
#define lcd_d6(level) *BITP(&GPIOA->ODR, 15) = ((level) != 0)
#define lcd_d7(level) *BITP(&GPIOB->ODR, 5)  = ((level) != 0)
#define lcd_rs(level) *BITP(&GPIOC->ODR, 13) = ((level) != 0)
#define lcd_e(level)  *BITP(&GPIOB->ODR, 8)  = ((level) != 0)
#define lcd_vo(level)  lcd_d6(level)
#define lcd_led(level) lcd_d7(level)

#include "pt.h"
#include "ul_ptx.h"

//indication modes
#define IND_MO_STARTUP   0
#define IND_MO_NORMAL    1
#define IND_MO_CONFIG    2
#define IND_MO_CONFIG_ED 3

//startup screen time, sec
#define IND_STARTUP_TIME 4

//current indication mode
extern  U8 ind_mode;

#define EDIT_PARAMS 7
#define EDIT_PARAM_NONE      0
#define EDIT_PARAM_PROGRAM   1
#define EDIT_PARAM_STEP      2
#define EDIT_PARAM_STEP_TIME 3
#define EDIT_PARAM_STEP_T1   4
#define EDIT_PARAM_STEP_T2   5
#define EDIT_PARAM_STEP_T3   6
#define EDIT_PARAM_STEP_T4   7
extern  U8 edit_param;

//indication update period
#define IND_UPDATE_PERIOD 100

//инициализация
void setup_ind( void );
PT_THREAD( pt_ind( struct pt *pt, struct ptx *ptx ) );

#endif /* IND_H_ */
