/*
 * process.h
 *
 *  Created on: Mar 4, 2012
 *      Author: qwer1
 */

#ifndef PROCESS_H_
#define PROCESS_H_

#include "pt.h"
#include "ul_ptx.h"
#include "adc.h"

//maximum step time (seconds)
#define PROGRAM_STEP_TIME_MAX 999
//maximum set temperature (deg.celsius)
#define PROGRAM_STEP_T_MAX    700

//number of programs
#define PROGRAMS_NUM      8
//number of steps per program
#define PROGRAM_STEPS_NUM 10

//program step parameters
struct program_step_struct {
	S16 t_set[T_TC_NUM]; //sensors temperatures
	U16 time;            //step duration, sec
};

//current work mode
#define WORK_STOP 0
#define WORK_RUN  1

//work process parameters structure
struct process_struct {
	U8  run;   //work mode (0=stop, 1=run)
	U8  pause; //pause mode (0=normal, 1=pause)
	struct program_step_struct *step; //pointer to current step struct
	U16 step_timer;              //step timer counter
	U32 program_time;            //program time counter
	S32 t_set_last[T_TC_NUM];    //last set temperatures for step (0.001 precision)
	S32 t_set_current[T_TC_NUM]; //current temperatures set points (0.001 precision)
	S32 t_step[T_TC_NUM];        //temperatures delta (0.001 precision)
};
extern struct process_struct process;

//setup program process
void setup_process(void);

//restart regulator process (restart task, clear regulator parameters etc)
void process_restart(void);

//work process thread
extern struct ptx *ptx_process;

//program flow processing thread
PT_THREAD( pt_process( struct pt *pt, struct ptx *ptx ) );

#endif /* PROCESS_H_ */
