/*
 * ul_crc.c
 *
 *  Created on: Sep 11, 2011
 *      Author: qwer1
 */


#include "ul_crc.h"

//CRC////////////////////////////////////////////////////////////////////////////////////////////////////////


/*CRC8 Dallas*/
U8 crc8_ds_upd(U8 data, U8 crc_prev) {
    inc_crc8_ds_upd(data, crc_prev);
    return(crc_prev);
}

U16 crc8_ds_buf(U8 *buf, U16 buf_size, U8 crc_prev) {
    while (buf_size) {
        crc_prev = crc8_ds_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}



/*CRC16 Dallas*/
U16 crc16_ds_upd(U8 data, U16 crc_prev) {
    inc_crc16_ds_upd(data, crc_prev);
    return(crc_prev);
}

U16 crc16_ds_buf(U8 *buf, U16 buf_size, U16 crc_prev) {
    while (buf_size) {
        crc_prev = crc16_ds_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}



/*CRC16 Modbus*/
U16 crc16_modbus_upd(U8 data, U16 crc_prev) {
    inc_crc16_modbus_upd(data, crc_prev);
    return(crc_prev);
}

U16 crc16_modbus_buf(U8 *buf, U16 buf_size, U16 crc_prev) {
    while (buf_size) {
        crc_prev = crc16_modbus_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}



/*CRC16 CCIT (right method)*/
U16 crc16_ccit_upd(U8 data, U16 crc_prev) {
    inc_crc16_ccit_upd(data, crc_prev);
    return(crc_prev);
}

U16 crc16_ccit_augment(U16 crc_prev) {
    inc_crc16_ccit_augment(crc_prev);
    return(crc_prev);
}

U16 crc16_ccit_buf(U8 *buf, U16 buf_size, U16 crc_prev) {
    while (buf_size) {
        crc_prev = crc16_ccit_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}



/*CRC7 MMC*/
U8 crc7_mmc_upd(U8 data, U8 crc_prev) {
    inc_crc7_mmc_upd(data, crc_prev);
    return(crc_prev & 0x7f);
}

U16 crc7_mmc_buf(U8 *buf, U16 buf_size, U8 crc_prev) {
    while (buf_size) {
        crc_prev = crc7_mmc_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}



/*CRC16 MMC (sort of CRC16 CCIT)*/
U16 crc16_mmc_upd(U8 data, U16 crc_prev) {
    inc_crc16_mmc_upd(data, crc_prev);
    return(crc_prev);
}

U16 crc16_mmc_buf(U8 *buf, U16 buf_size, U16 crc_prev) {
    while (buf_size) {
        crc_prev = crc16_mmc_upd(*buf, crc_prev);
        buf++;
        buf_size--;
    }
    return(crc_prev);
}
