#ifndef UL_KBD_H_
#define UL_KBD_H_

#include "ul_other.h"


// determine keyboard buffer size
#if (KBD_KEYS <= 8)
    #define KBD_BUF_TYPE U8  // type of keyboard buffer (depends on number of keys - 8/16/32/64)
#elif (KBD_KEYS <= 16)
    #define KBD_BUF_TYPE U16
#elif (KBD_KEYS <= 32)
    #define KBD_BUF_TYPE U32
#elif (KBD_KEYS <= 64)
    #define KBD_BUF_TYPE U64
#endif

#if !defined(KBD_PR_MAX)
    #define KBD_PR_MAX 255
#endif

// determine key press counter size
#if (KBD_PR_MAX <= 255)
    #define KBD_PR_TYPE     U8  // up to 8 keys
#elif (KBD_PR_MAX <= 65535)
    #define KBD_PR_TYPE     U16 // up to 16 keys
#elif (KBD_PR_MAX <= 4294967295UL)
    #define KBD_PR_TYPE     U32 // up to 32 keys
#elif (KBD_PR_MAX <= 18446744073709551615ULL)
    #define KBD_PR_TYPE     U64 // up to 64 keys
#endif

extern KBD_BUF_TYPE kbd_buf[3];
extern U8 kbd_scan_cnt;
extern KBD_PR_TYPE kbd_cnt;

#define kbd_update() \
	if (kbd_buf[2] != kbd_buf[1]) { \
		kbd_buf[2] = kbd_buf[1]; \
		kbd_cnt = 0; \
	} else if (kbd_cnt < KBD_PR_MAX) kbd_cnt++;

#define kbd_code kbd_buf[2]

#define kbd_press(code, press) ((kbd_code == code)&&(kbd_cnt == press))
#define kbd_press2(code, press1, press2) ((kbd_code == code)&&((kbd_cnt == press1)||(kbd_cnt == press2)))

#endif
