/*
 * ul_pid.h
 *
 *  Created on: Mar 26, 2012
 *      Author: qwer1
 */

#ifndef UL_PID_H_
#define UL_PID_H_

struct pid_struct {
	S16 kp; //proportional gain
	S16 ki; //integral gain
	S16 kd; //derivative gain

	U8  i_n;   //number of integration samples
	U8  i_cnt; //current integration sample counter
	S32 i_sum; //integration running sum
	S32 i_buf[PID_I_N]; //integration buffer

	S32 val; //current value
	S32 set; //current set value
	S32 e;   //current error
	S32 de;  //current derivative error

	S32 out;     //output value
	S32 out_min; //minimal output value
	S32 out_max; //maximal output value
	S16 out_div; //output divider
	S16 out_mul; //output multiplier
};

//reset PID structure with new value
void pid_reset(struct pid_struct *pid, S32 val);

//initialize PID structure with new parameters
void pid_init(
	struct pid_struct *pid, S16 kp, S16 ki, S16 kd,
	U8 i_n, S32 out_min, S32 out_max,
	S16 out_div, S16 out_mul,
	S32 set, S32 val
);

//update PID structure with new value. Returns new control value.
S32 pid_update(struct pid_struct *pid, S32 val);

#endif /* UL_PID_H_ */
