/*
 * usart.h
 *
 *  Created on: Sep 29, 2011
 *      Author: qwer1
 */

#ifndef USART_H_
#define USART_H_

#include "ul_rbuf.h"
#include "pt.h"
#include "ul_ptx.h"

#define USART_NUM         0     //number of used USART
#define USART_RX_BUF_SIZE 128   //size of RX buffer
#define USART_TX_BUF_SIZE 128   //size of TX buffer
#define USART_BAUD        38400 //baud rate

//declare RX/TX buffers
RBUF_DECL( usart_tx_buf, U8, USART_TX_BUF_SIZE);
RBUF_DECL( usart_rx_buf, U8, USART_RX_BUF_SIZE);

//temporary buffer
extern U8 usart_tmp_buf[32];
//=1 to switch to Modbus mode (no CSV logging)
extern U8 usart_modbus_mode;

//check if next byte received
#define usart_rx_empty(num) \
	(USART_GetFlagStatus(USART1, USART_FLAG_RXNE) == RESET)

//RX byte
#define usart_rx_U8(num) \
	(USART_ReceiveData(USART1))

//check if TX buffer empty
#define usart_tx_empty(num) \
	(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == SET)

//TX byte
#define usart_tx_U8( num, data ) \
	USART_SendData( USART1, data )


// setup USART
void setup_usart(void);

//USART RX/TX thread
PT_THREAD( pt_usart( struct pt *pt, struct ptx *ptx ) );

#endif /* USART_H_ */
