/*
 * main.c
 *
 *  Created on: Feb 17, 2012
 *      Author: qwer1
 */

#include <string.h>
#include "setup.h"
#include "ul_ptx.h"
#include "ul_lcda.h"
#include "ul_timing.h"
#include "ul_bcd.h"
#include "adc.h"
#include "ind.h"
#include "process.h"
#include "kbd.h"
#include "config.h"
#include "heaters.h"
#include "usart.h"
#include "sound.h"
#include "modbus.h"

U16 project_signature = 0xA500;
U16 project_version   = 0x0001;

PT_THREAD( pt_main( struct pt *pt, struct ptx *ptx ) ) {
	PT_BEGIN(pt);
	while (1) {
//		*BITP(&GPIOB->ODR, 6)  = 0;
//		PTX_DELAY_MS(500);
//		*BITP(&GPIOB->ODR, 6)  = 1;
//		usart_tx_U8(USART_NUM, 'U');
//		debug_led1 ^= 1;
		PTX_DELAY_MS(500);
	}
	PT_END(pt);
}

int main( void ) {

	//startup delay
	delay_ms(100);

    //global setup
	setup(0);
	ptx_add(pt_main, NULL, PTX_FLAG_RUN);

//	snd_buf_add(SND_STEP_END);

//	log_U8('U');
//	log_U8('0');
//	log_U8((sizeof(modbus) + 48));

/*
	config.programs[0][0].t_set[0] = 60;
	config.programs[0][0].time     = 100;
	config.programs[0][1].t_set[0] = 90;
	config.programs[0][1].time     = 150;
	config.kp = 30;
	config.ki = 15;
	config.kd = 10;
	config.ni = 10;
*/
	
    //main loop
	while (1) {

		//sys.timer tick
		t_sync(); //synchronize timing flags
		if (SysTick->CTRL & SysTick_CTRL_COUNTFLAG) {
//			SysTick->CTRL &= ~SysTick_CTRL_COUNTFLAG;
			t_update(); //update timing flags
		}

		//run proto threads
		ptx_dispatch();

	}

	return 1;
}

