;**********************************************************************
;                                                                     *
;    Filename:	    carstart.asm                                      *
;    Date:          27.01.99                                          *
;    File Version:  1.01                                              *
;                                                                     *
;    Author:        Dmitriy Salikov                                   *
;    Company:       My flat                                           *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes: Unit car starter special for autostart SAAB 9000I engine. *
;    Used automative transmission!                                                                 *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

	list      p=12c509            ; list directive to define processor
	#include <p12c509.inc>        ; processor specific variable definitions

	__CONFIG   _CP_OFF & _WDT_ON & _MCLRE_OFF & _IntRC_OSC 

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.

FALSE		EQU	0
TRUE		EQU	1
low_level	equ	0
high_level	equ	1


; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; This variables may be change car from car.
;            

;      !
;park_level	 EQU high_level	;     -  
park_level	 EQU low_level	;     -  	     

;      !
;startup		equ TRUE	;        
startup	equ FALSE	;         

;      !
sirena		equ TRUE	;    +
;sirena		equ FALSE	;    -

;    
time_sir	equ .5		;  * 10 ( 0.1 )

;    ignition    +----------------------------------+
;                |                                  |
; -----|---------+                                  +---------
;
;    starter               +------------------------+ 
;                          |                        |
; -----|-------------------+                        +---------
;
;

;  time_xxx      1  255
;         
time_wait	equ .30		;  * 10
	
;       
time_ignition	equ .20		;  * 10

;    
time_starter	equ .12		;  * 2

;      
time_attempt	equ .150	;  * 10

;    
time_engine	equ .250	; 

;           
time_next	equ .20		;  * 10


;       
round_start	equ .200	; /

;        
round_acs	equ .1500	; /

;        
; (        
;  2     )
round_min	equ .300	; / 

; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



;      ()
; (   2    )
; /	/		\0.5	/
; 400		6		6		12
; 2000		33		33		66			
;
	
round_start1	equ round_start/.60
round_acs1	equ round_acs/.30
round_min1	equ round_min/.30



;
;****************** PORTS
in1		equ 1		; input 1 (command on start engine) alarm
in2		equ 0		; input 2 (command on start engine) timer or key
sir		equ 0		; output sirena (if used)
tach		equ 2		; tachometr
parking		equ 3		; set automative transmission on parking
rele_ignit	equ 4		; rele ignition
rele_start	equ 5		; rele starter


; Port input/output
; pin port
;  1  	Vdd (+)	
;  2	GP5
;  3	GP4
;  4	GP3
;  5	GP2
;  6	GP1
;  7	GP0
;  8	Vss (-)



port		equ GPIO	; anather name of GPIO


;***** VARIABLE DEFINITIONS
 cblock 0x7
	temp
	count0
	count1
	count2
	count3
	count_tmp
	limit			; limit of cycles start engine
;	turnovers_l		; an amount of turnovers of the engine low byte
;	turnovers_h		; an amount of turnovers of the engine high byte
	sdn
 endc







;**********************************************************************
		ORG     0x3FF             ; processor reset vector
	movlw	0x40
; Internal RC calibration value is placed at location 0x3FF by Microchip
; as a movlw k, where the k is a literal value.

        ORG     0x000             ; coding begins here
        movwf   OSCCAL            ; update register with factory cal value 
	goto	main

; subroutine code goes here

; subroutine delay 256*3 cycles ---------
delay_256
	clrf count_tmp
delay_256a
	clrwdt
	decfsz count_tmp,f
	goto delay_256a
	return


; subroutine delay for sirena output
delay_sir
	movlw time_sir
	movwf count2
	call delay_all
	return

; subroutine for programming delay
delay_all
delay3r
	movlw .100
	movwf count1
delay2r
	movlw .200
	movwf count0
delay1r
	clrwdt
	nop
	nop
	decfsz count0,f
	goto delay1r
	decfsz count1,f
	goto delay2r
	decfsz count2,f
	goto delay_all
	return
	


; subroutine delay 1 sec
delay_1sec
	movlw .10
	movwf count2
	call delay_all
	return




; THE MAIN CODE IS BEGIN -------------------------------------------------
main
	bcf STATUS,PA0		; initialization chip
	movlw b'11111100'
	OPTION
	clrf TMR0
	clrwdt
	clrf GPIO
	
	if startup		; initiazation port I/o
	movlw b'11001111'
	else
	movlw b'11001110'
	endif

	tris GPIO






begin				; begin work with clear all  

;   .
 if !startup
  if sirena
	bsf port,sir
	call delay_sir
	bcf port,sir
  else
	bcf port,sir
	call delay_sir
	bsf port,sir
  endif
 endif	




	clrwdt
	clrf port
	nop
	nop

 if !startup && !sirena
	bsf port,sir
 endif

	movlw 0x08		; clear RAM
	movwf FSR
ram_clr	clrf INDF
	incf FSR,f
	btfss FSR,4
	goto ram_clr
	clrwdt


; WAIT START ------------------
wait_start
	clrwdt
	btfss port,in1		; are IN1 is high (normal)?
	goto wait_start
	clrwdt

	if startup
	btfss port,in2		; are IN2 is high (normal)?
	goto wait_start
	endif



wait_command			; if IN1 or IN2 low - have command
	clrwdt
	call delay_256
	btfss port,in1
	goto have_command
	clrwdt

	if startup
	btfss port,in2
	goto have_command
	endif

	goto wait_command
 
have_command
	clrwdt
	call delay_256			; wait end of command on start engine
	btfss port,in1
	goto have_command
	clrwdt

	if startup
	btfss port,in2
	goto have_command
	endif

;     ( )
 if !startup
  if sirena
	bsf port,sir
	call delay_sir
	bcf port,sir
  else
	bcf port,sir
	call delay_sir
	bsf port,sir
  endif
 endif	


next_attempt
	clrwdt			; is tachometr=0?
	clrf TMR0		; measure tachometr 
	movlw time_wait
	movwf count2		; cycle 30
measure2
	movlw .100		; cycle 100
	movwf count1
measure1
	movlw .62		; cycle 1000
	movwf count0
measure0
	clrwdt
	movf TMR0,w
	btfss STATUS,Z		; out if tach<>0
	goto begin
	btfss port,in1
	goto begin
	clrwdt
	clrwdt
	
 if startup
	btfss port,in2
	goto begin
 else
	nop
	nop
 endif

	clrwdt
	clrwdt

 if park_level
	btfss port,parking
 else
	btfsc port,parking	; to repeat transmission check
 endif

	goto begin
	decfsz count0,f
	goto measure0
	decfsz count1,f
	goto measure1
	decfsz count2,f
	goto measure2



; THE START ENGINE IS SOLVED ----
; STEP ONE: IGNITION IS 'ON'
	bsf port,rele_ignit	; rele ignition is ON
	clrwdt
	clrwdt
	call delay_1sec
	clrf TMR0

	movlw time_ignition	; cycle by 2 sec 
	movwf count2		; cycle 20
measure5
	movlw .100		; cycle 100
	movwf count1
measure4
	movlw .62		; cycle 1000
	movwf count0
measure3
	clrwdt
	nop
	nop
	nop

 if park_level
	btfss port,parking
 else
	btfsc port,parking	; to repeat transmission check
 endif

	goto begin
	clrwdt
	clrwdt
	btfss port,in1		; check IN1
	goto begin
	clrwdt
	clrwdt

 if startup
	btfss port,in2		; check IN2
	goto begin
 else
	nop
	nop
 endif

	decfsz count0,f
	goto measure3
	decfsz count1,f
	goto measure4
	decfsz count2,f
	goto measure5


; last check tachometr
last_cleck
	movf TMR0,w		; check tahometr
	movwf temp
	btfsc STATUS,Z
	goto enable_start
	decfsz temp,f
	goto $+2
	goto enable_start
	decfsz temp,f
	goto $+2
	goto enable_start
	goto begin





; STEP TWO: STARTER IS 'ON'
enable_start
	bsf port,rele_start
	clrwdt
	clrwdt

				; cycle 6 sec for starter is on (120*50msec inside cycles)
	movlw time_starter
	movwf count3

measure8	
	clrf TMR0		; cycle 0,5 sec for measure tachometr frec
	movlw .125		; 125 cycles
	movwf count1
measure7
	movlw .200		; 4000 cycles
	movwf count0
measure6
	clrwdt
	clrwdt
	clrwdt
	clrwdt
	clrwdt
	clrwdt

; if park_level
;	btfss port,parking
; else
;	btfsc port,parking	; to repeat transmission check
; endif
;	goto begin

	clrwdt
	clrwdt
	clrwdt
	clrwdt
	btfss port,in1
	goto begin
	clrwdt
	clrwdt

 if startup
	btfss port,in2
	goto begin
 else
	nop
	nop
 endif

	clrwdt
	clrwdt
	decfsz count0,f
	goto measure6
	decfsz count1,f
	goto measure7


	movf TMR0,w		; over 400 round/min?
	movwf temp
	movlw round_start1	; x impulse by 0,5 sec
	subwf temp,w
	btfsc STATUS,Z
	goto engine_on
	btfsc STATUS,C
	goto engine_on
	decfsz count3,f
	goto measure8

	
; THE ENGINE WAS NOT STARTED
	incf limit,f
	movlw .3		; 3 attempt?
	subwf limit,w	
	btfsc STATUS,Z
	goto full_limit
	bcf port,rele_ignit	; the all relay is OFF
	nop
	nop
	clrwdt
	clrwdt
	bcf port,rele_start
	clrwdt
	clrwdt

				; delay 10 sec for waiting
	movlw time_attempt	; 100
	movwf count2
delay2
	movlw .100		; 100
	movwf count1
delay1
	movlw .166		; 1000
	movwf count0	
delay0	
	clrwdt
	btfss port,in1 
	goto begin
;	nop
;	nop
	nop
	decfsz count0,f
	goto delay0
	decfsz count1,f
	goto delay1
	decfsz count2,f
	goto delay2
	goto next_attempt



; URA! ENGINE WAS STARTED ------------
engine_on
	movlw .20		; 10     
	movwf sdn
	bcf port,rele_start	; the starter is OFF
	nop
	nop
	clrwdt
	clrwdt
	
	call delay_1sec
;	call delay_1sec
	call delay_1sec

	movlw time_engine	; cycle 3 min for engine work (180 * 1 sec inside cycles)
	movwf count2

measure12	

	decf sdn,f		;      

	clrf TMR0		; cycle 1 sec for measure tachometr frec
	movlw .250		; 250 cycles
	movwf count1
measure11
	movlw .200		; 4000 cycles
	movwf count0
measure10
	clrwdt
	clrwdt
	clrwdt
	clrwdt
	clrwdt
;	clrwdt
;	clrwdt
;	clrwdt
;	clrwdt


	movf sdn,f
	btfss STATUS,Z
	goto jamp_over
	incf sdn,f
	
 if park_level
	btfss port,parking
 else
	btfsc port,parking	; to repeat transmission check
 endif
	goto begin

jamp_over
	clrwdt
	clrwdt
	btfss port,in1
	goto begin
	clrwdt
	clrwdt

 if startup
	btfss port,in2
	goto begin
 else
	nop
	nop
 endif

	decfsz count0,f
	goto measure10
	decfsz count1,f
	goto measure11

	movf TMR0,w		; over 2000 round/min?
	movwf temp
	movlw round_acs1
	subwf temp,w
	btfsc STATUS,Z
	goto begin
	btfsc STATUS,C
	goto begin

	movlw round_min1	; down 400 round/min?
	subwf temp,w
	btfss STATUS,C	
	goto begin

	decfsz count2,f
	goto measure12




; UFF, ALL OK ------------------------
full_limit
	bcf port,rele_start
	nop
	nop
	clrwdt
	clrwdt

	bcf port,rele_ignit
	nop
	nop
	clrwdt
	clrwdt


				; delay 2 sec for waiting (for example)
	movlw time_next		; 20
	movwf count2
delay5
	movlw .100		; 100
	movwf count1
delay4
	movlw .166		; 1000
	movwf count0	
delay3	
	clrwdt
	nop
	nop
	nop
	decfsz count0,f
	goto delay3
	decfsz count1,f
	goto delay4
	decfsz count2,f
	goto delay5
	goto begin

	


	END                    ; directive 'end of program'

